/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ProfReportProcessUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ReportWorktableUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.WebRptReportProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.TmplNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.TmplQueryDataCache;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.UserOrgPermissionInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractRptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WebWktbContextFactory;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.newrpt.web.ReportOperateEnum;
import com.kingdee.eas.fi.newrpt.web.ReportTaskFactory;
import com.kingdee.eas.fi.newrpt.web.ReportTaskInfo;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.template.TemplateProvider;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class WebReportProcessProxyUI
extends CoreUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(WebReportProcessProxyUI.class);
    private BOSUIContext uiContext = new BOSUIContext();
    private TemplateProvider tmplProvider;
    private OrgType orgType = OrgType.Company;

    public void onShow() throws Exception {
        String json = this.getUIContext().get("UIClassParam").toString();
        final Map<Object, Object> map = this.getParamByJson(json);
        this.checkHasOpenDifferentTask(map);
        this.initWorkContext(map);
        final UIContext uiContext = new UIContext((Object)this);
        final IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        final ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        final ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        final ITemplate iTemplate = TemplateFactory.getRemoteInstance();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"report batch open start");
                    WebReportProcessProxyUI.this.openReports(map, uiContext, iFullOrgUnit, iCompanyOrgUnit, iCurrency, iTemplate);
                    WebReportProcessProxyUI.this.destroyWindow();
                    logger.info((Object)"report batch open end");
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        });
        t.setName("report batch open");
        t.start();
    }

    private void checkHasOpenDifferentTask(Map<Object, Object> map) {
        if (!StringUtils.isEmpty((String)this.getWktbContext().getTaskid()) && !this.getWktbContext().getTaskid().equals((String)map.get("taskid"))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"OnlyOpenOneTaskRptTheSameTime"));
            this.abort();
            this.destroyWindow();
        }
    }

    private void initWorkContext(Map<Object, Object> paramMap) throws Exception {
        String year = (String)paramMap.get("year");
        String period = (String)paramMap.get("period");
        String periodType = (String)paramMap.get("periodType");
        String taskId = (String)paramMap.get("taskid");
        Date date = RPTDateUtil.getPeriodLastDate((int)Integer.valueOf(year), (int)Integer.valueOf(period), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Integer.valueOf(periodType)));
        this.getWktbContext().setQueryPeriodType(RptPeriodTypeEnum.getEnum((int)Integer.valueOf(periodType)));
        this.getWktbContext().setQueryYear(Integer.valueOf(year));
        this.getWktbContext().setQueryPeriod(Integer.valueOf(period));
        this.getWktbContext().setQueryDate(date);
        this.getWktbContext().setTaskid(taskId);
        this.initDefaultOrgUnit(paramMap);
        this.initOrgNodeMap(paramMap);
    }

    private void initDefaultOrgUnit(Map<Object, Object> paramMap) throws Exception {
        List companyIds = (List)paramMap.get("companyids");
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select * where id='" + companyIds.get(0).toString() + "'");
        this.getWktbContext().setOrgUnitInfo(orgUnitInfo);
        int orgType = Integer.valueOf(paramMap.get("orgType").toString());
        WktbContextFactory.getInstance().getRptContext(OrgType.getEnum((int)orgType)).setOrgUnitInfo(orgUnitInfo);
    }

    private void initOrgNodeMap(Map<Object, Object> paramMap) throws Exception {
        String taskId = (String)paramMap.get("taskid");
        StringBuffer oql = new StringBuffer();
        oql.append(" select reportOperate,entries.unitid.id,entries.unitid.name,entries.unitid.number,").append(" entries.unitid.longnumber,entries.templateid.versionnumber,entries.templateid.templatetype,").append(" entries.templateid.periodtype,").append(" entries.templateid.id,entries.templateid.group,entries.templateid.name,entries.templateid.number ").append(" where id = '" + taskId + "'");
        ReportTaskInfo task = (ReportTaskInfo)ReportTaskFactory.getRemoteInstance().getValue(oql.toString());
        this.getWktbContext().setWebRptOperate(task.getReportOperate());
        HashMap<String, OrgNodeUserDefineInfo> orgNodeMap = new HashMap<String, OrgNodeUserDefineInfo>();
        HashMap<String, Map<TmplQueryDataCache.CacheState, List<TmplNodeUserDefineInfo>>> tmplCache = new HashMap<String, Map<TmplQueryDataCache.CacheState, List<TmplNodeUserDefineInfo>>>();
        TmplQueryDataCache cacheHelp = new TmplQueryDataCache();
        if (task.getEntries() != null) {
            int size = task.getEntries().size();
            for (int i = 0; i < size; ++i) {
                FullOrgUnitInfo orgUnitInfo = task.getEntries().get(i).getUnitid();
                TemplateInfo templateInfo = task.getEntries().get(i).getTemplateid();
                if (!orgNodeMap.containsKey(orgUnitInfo.getId().toString())) {
                    orgNodeMap.put(orgUnitInfo.getId().toString(), this.constructureOrgNode(task.getReportOperate(), (OrgUnitInfo)orgUnitInfo));
                }
                if (!tmplCache.containsKey(orgUnitInfo.getId().toString())) {
                    tmplCache.put(orgUnitInfo.getId().toString(), new HashMap());
                }
                this.constructureTmplNodeCache((Map)tmplCache.get(orgUnitInfo.getId().toString()), templateInfo, cacheHelp);
            }
        }
        this.getWktbContext().setOrgNodeMap(orgNodeMap);
        this.getWktbContext().setTmplCache(tmplCache);
    }

    private void constructureTmplNodeCache(Map<TmplQueryDataCache.CacheState, List<TmplNodeUserDefineInfo>> cache, TemplateInfo info, TmplQueryDataCache cacheHelp) {
        String cacheKey = this.wrappedKey(ReportTypeEnum.TEMPLATE.getAlias()) + this.wrappedKey(ReportTypeEnum.GROUPDISPENSETEMPLATE.getAlias());
        TmplQueryDataCache.CacheState state = new TmplQueryDataCache.CacheState(cacheKey, true);
        if (cache.size() == 0) {
            ArrayList cacheLst = new ArrayList();
            cache.put(state, cacheLst);
        }
        cacheHelp.setCache(cache);
        TmplNodeUserDefineInfo tmplNodeInfo = new TmplNodeUserDefineInfo();
        tmplNodeInfo.setPeriodType(info.getPeriodType());
        tmplNodeInfo.setTmplGroup(info.getGroup());
        tmplNodeInfo.setTmplID(info.getId().toString());
        tmplNodeInfo.setTmplName(info.getName());
        tmplNodeInfo.setTmplNumber(info.getNumber());
        tmplNodeInfo.setTmplType(info.getTemplateType());
        tmplNodeInfo.setTmplVersionNum(info.getVersionNumber());
        cacheHelp.getDataFromCache(cacheKey).add(tmplNodeInfo);
    }

    private String wrappedKey(String key) {
        return "[" + key + "]";
    }

    private OrgNodeUserDefineInfo constructureOrgNode(ReportOperateEnum operate, OrgUnitInfo orgUnitInfo) {
        OrgNodeUserDefineInfo orgNode = new OrgNodeUserDefineInfo();
        orgNode.setOrgPK(orgUnitInfo.getId().toString());
        orgNode.setLongNum(orgUnitInfo.getLongNumber());
        orgNode.setName(orgUnitInfo.getName());
        orgNode.setNumber(orgUnitInfo.getNumber());
        orgNode.setOrgType(this.getOrgType());
        UserOrgPermissionInfo orgPermInfo = new UserOrgPermissionInfo();
        if (ReportOperateEnum.VIEW.equals((Object)operate)) {
            orgPermInfo.setHasViewPerm(true);
        } else if (ReportOperateEnum.AUDIT.equals((Object)operate)) {
            orgPermInfo.setHasViewPerm(true);
            orgPermInfo.setHasAuditedPerm(true);
        } else if (ReportOperateEnum.EDIT.equals((Object)operate)) {
            orgPermInfo.setHasViewPerm(true);
            orgPermInfo.setHasAddNewPerm(true);
            orgPermInfo.setHasEditPerm(true);
            orgPermInfo.setHasRemovePerm(true);
        }
        orgNode.setOrgPermInfo(orgPermInfo);
        return orgNode;
    }

    protected AbstractRptWktbContext getWktbContext() {
        try {
            return WebWktbContextFactory.getInstance().getRptContext(this.getOrgType());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)null, (Throwable)e);
            return null;
        }
    }

    private Map<Object, Object> getParamByJson(String json) {
        Map<Object, Object> map = new HashMap();
        String[] array = json.split("\\$");
        String type = array[0];
        if ("0".equals(type)) {
            map = this.excuteParamForReport(array, "0");
        } else if ("1".equals(type)) {
            map = this.excuteParamForReport(array, "1");
        } else if ("2".equals(type)) {
            map = this.excuteParamForEditReport(array);
        }
        return map;
    }

    private Map<Object, Object> excuteParamForReport(String[] array, String type) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<String> tmplList = new ArrayList<String>();
        ArrayList<String> companyList = new ArrayList<String>();
        ArrayList<String> tmplCompanyList = new ArrayList<String>();
        String tmplStr = array[1];
        String[] tmplArray = tmplStr.split("#");
        int length = tmplArray.length;
        for (int i = 0; i < length; ++i) {
            tmplList.add(tmplArray[i]);
        }
        map.put("tmplids", tmplList);
        String companyStr = array[2];
        String[] companyArray = companyStr.split("#");
        int size = companyArray.length;
        for (int j = 0; j < size; ++j) {
            companyList.add(companyArray[j]);
        }
        map.put("companyids", companyList);
        String year = array[3];
        String period = array[4];
        String periodType = array[5];
        String currencyId = array[6];
        String orgType = array[7];
        String taskid = array[8];
        String tmplCompanyStr = array[9];
        String[] tmplCompanyArray = tmplCompanyStr.split("#");
        int m = tmplCompanyArray.length;
        for (int k = 0; k < m; ++k) {
            tmplCompanyList.add(tmplCompanyArray[k]);
        }
        map.put("tmplCompanyids", tmplCompanyList);
        map.put("year", year);
        map.put("period", period);
        map.put("periodType", periodType);
        map.put("currencyId", currencyId);
        map.put("orgType", orgType);
        map.put("taskid", taskid);
        if ("0".equals(type)) {
            ArrayList<String> reportList = new ArrayList<String>();
            String reportStr = array[10];
            String[] reportArray = reportStr.split("#");
            int z = reportArray.length;
            for (int k = 0; k < z; ++k) {
                reportList.add(reportArray[k]);
            }
            map.put("reportids", reportList);
        }
        return map;
    }

    private Map<Object, Object> excuteParamForEditReport(String[] array) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<String> reportList = new ArrayList<String>();
        ArrayList<String> companyList = new ArrayList<String>();
        String reportStr = array[1];
        String[] reportArray = reportStr.split("#");
        int z = reportArray.length;
        for (int k = 0; k < z; ++k) {
            reportList.add(reportArray[k]);
        }
        map.put("reportids", reportList);
        String year = array[2];
        String period = array[3];
        String periodType = array[4];
        String orgType = array[5];
        String taskid = array[6];
        String companyStr = array[7];
        String[] comapnyArray = companyStr.split("#");
        int size = comapnyArray.length;
        for (int j = 0; j < size; ++j) {
            companyList.add(comapnyArray[j]);
        }
        map.put("year", year);
        map.put("period", period);
        map.put("periodType", periodType);
        map.put("orgType", orgType);
        map.put("taskid", taskid);
        map.put("companyids", companyList);
        this.setOrgType(OrgType.getEnum((int)Integer.parseInt(orgType)));
        return map;
    }

    private void openReports(Map<Object, Object> map, UIContext uiContext, IFullOrgUnit iFullOrgUnit, ICompanyOrgUnit iCompanyOrgUnit, ICurrency iCurrency, ITemplate iTemplate) throws Exception {
        if (map.containsKey("tmplids")) {
            List tmplList = (List)map.get("tmplids");
            List companyids = (List)map.get("tmplCompanyids");
            OrgUnitCollection orgUnitCollection = this.getOrgUnitCollection(companyids, iFullOrgUnit);
            if (tmplList != null && tmplList.size() > 0) {
                int size = tmplList.size();
                for (int i = 0; i < size; ++i) {
                    String tmplId = tmplList.get(i).toString();
                    String companyId = companyids.get(i).toString();
                    OrgUnitInfo orgInfo = null;
                    int size1 = orgUnitCollection.size();
                    for (int j = 0; j < size1; ++j) {
                        String orgUnitid = orgUnitCollection.get(j).getId().toString();
                        if (!companyId.equals(orgUnitid)) continue;
                        orgInfo = orgUnitCollection.get(j);
                    }
                    this.createReportAndOpenItForWeb(tmplId, map, orgInfo, iCompanyOrgUnit, iCurrency, iTemplate);
                }
            }
        }
        if (map.containsKey("reportids")) {
            List reportids = (List)map.get("reportids");
            int orgType = Integer.valueOf(map.get("orgType").toString());
            boolean isFromWeb = true;
            this.openReportForWeb(reportids, uiContext, orgType, isFromWeb);
        }
    }

    private OrgUnitCollection getOrgUnitCollection(List<Object> ids, IFullOrgUnit iFullOrgUnit) throws Exception {
        HashSet<Object> set = new HashSet<Object>(ids);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgUnitCollection orgUnitCollection = iFullOrgUnit.getOrgUnitCollection(view);
        return orgUnitCollection;
    }

    private void createReportAndOpenItForWeb(String tmplId, Map map, OrgUnitInfo orgInfo, ICompanyOrgUnit iCompanyOrgUnit, ICurrency iCurrency, ITemplate iTemplate) throws EASBizException, BOSException {
        int orgType = Integer.valueOf(map.get("orgType").toString());
        int year = Integer.valueOf(map.get("year").toString());
        Integer period = Integer.valueOf(map.get("period").toString());
        int periodType = Integer.valueOf(map.get("periodType").toString());
        String currencyId = map.get("currencyId").toString();
        if (!StringUtils.isEmpty((String)currencyId) && "all".equals(currencyId)) {
            String companyid = orgInfo.getId().toString();
            CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo("select baseCurrency where id='" + companyid + "'");
            currencyId = companyInfo.getBaseCurrency().getId().toString();
        }
        CurrencyInfo currency = (CurrencyInfo)iCurrency.getValue((IObjectPK)new ObjectUuidPK(currencyId));
        if (this.tmplProvider == null) {
            this.tmplProvider = new TemplateProvider();
        }
        try {
            TemplateInfo templateInfo = iTemplate.getTemplateInfo((IObjectPK)new ObjectUuidPK(tmplId));
            ReportInfo report = RptNewUIUtil.constructReportInfoByTemplateInfo(templateInfo);
            report.setCurrency(currency);
            report.setSourceCurrency(currency);
            report.setYear(year);
            report.setPeriod(period.shortValue());
            report.setStartDate(RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType)));
            report.setEndDate(RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType)));
            report.setOrgType(orgType == 1 ? OrgType.Company : OrgType.ProfitCenter);
            report.setCompany(orgInfo);
            report.setPublicStatus(PublicStatusEnum.PUBLIC);
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"InitDataObject", (Object)report);
            boolean isFromWeb = true;
            RptNewUIUtil.openReportUIAllInOne(ctx, this.getEditUIName(), OprtState.ADDNEW, isFromWeb);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)null, (Throwable)e);
        }
    }

    protected String getEditUIName() {
        return OrgType.Company.equals((Object)this.orgType) ? WebRptReportProcessNewUI.class.getName() : ProfReportProcessUI.class.getName();
    }

    private void openReportForWeb(List reportids, UIContext uiContext, int orgType, boolean isFromWeb) throws UIException {
        final UIContext context = uiContext;
        final List ids = reportids;
        uiContext.put((Object)"ID", reportids.get(0));
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"isView", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"OrgType", (Object)(orgType == 1 ? OrgType.Company : OrgType.ProfitCenter));
        IUIObject uiObject = this.findEditUI(uiContext);
        if (uiObject != null) {
            ReportWorktableUI.openReportUsedExistFrame(reportids, uiObject, true);
            return;
        }
        SystemEntry.instance.closingWindow(SystemEntry.instance.getMainUIObject().getUIContainer(), true);
        String id = (String)reportids.remove(0);
        boolean hasEditPerm = RptNewUIUtil.hasMutexLock(null, id);
        this.openTheFirstReport(uiContext, hasEditPerm ? OprtState.EDIT : OprtState.VIEW);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IUIObject uiObject = null;
                if (ids.size() > 0) {
                    try {
                        uiObject = WebReportProcessProxyUI.this.findEditUI(context);
                    }
                    catch (UIException e) {
                        ExceptionHandler.handle((Component)null, (Throwable)e);
                    }
                    if (uiObject != null) {
                        ReportWorktableUI.openReportUsedExistFrame(ids, uiObject, false);
                    }
                }
            }
        });
    }

    private void openTheFirstReport(UIContext uiContext, String Oprt) throws UIException {
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getEditUIName(), (Map)uiContext, null, Oprt);
        window2.show();
    }

    private IUIObject findEditUI(UIContext uiContext) throws UIException {
        return RptNewUIUtil.findUI(uiContext, this.getEditUIName());
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }
}

