/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop;

import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OtherComponent;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OtherComponentManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class IRptPopMenuManager {
    protected SpreadContext _context;
    protected OtherComponentManager _otherMenu;
    protected JPopupMenu _popMenu;
    protected List<List<JMenuItem>> _groupMenuItems = new ArrayList<List<JMenuItem>>(5);

    public IRptPopMenuManager(SpreadContext context, OtherComponentManager otherMenu) {
        this._context = context;
        this._otherMenu = otherMenu;
        this.initRptSpreadDefaultPopMenu();
    }

    private void initRptSpreadDefaultPopMenu() {
        PopMenuManager pop = this._context.getPopMenuManager();
        ArrayList<JMenuItem> groupCopyPaste = new ArrayList<JMenuItem>();
        groupCopyPaste.add(pop.getItem("MenuItem_Cut"));
        groupCopyPaste.add(pop.getItem("MenuItem_Copy"));
        groupCopyPaste.add(pop.getItem("MenuItem_Paste"));
        groupCopyPaste.add(pop.getItem("MenuItem_SelectablePaste"));
        this._groupMenuItems.add(groupCopyPaste);
        ArrayList<JMenuItem> groupInsDel = new ArrayList<JMenuItem>();
        groupInsDel.add(pop.getItem("MenuItem_InsertPaste"));
        groupInsDel.add(pop.getItem("MenuItem_InsertCutPaste"));
        groupInsDel.add(pop.getItem("MenuItem_Insert"));
        groupInsDel.add(pop.getItem("MenuItem_Delete"));
        groupInsDel.add(pop.getItem("MenuItem_InsertRow"));
        groupInsDel.add(pop.getItem("MenuItem_DeleteRow"));
        groupInsDel.add(pop.getItem("MenuItem_InsertCol"));
        groupInsDel.add(pop.getItem("MenuItem_DeleteCol"));
        this._groupMenuItems.add(groupInsDel);
        ArrayList<JMenuItem> groupComment = new ArrayList<JMenuItem>();
        groupComment.add(pop.getItem("MenuItem_Comment"));
        this._groupMenuItems.add(groupComment);
        ArrayList<JMenuItem> groupStyle = new ArrayList<JMenuItem>();
        groupStyle.add(pop.getItem("MenuItem_Style"));
        groupStyle.add(pop.getItem("MenuItem_ColumWidth"));
        groupStyle.add(pop.getItem("MenuItem_RowHeight"));
        groupStyle.add(pop.getItem("MenuItem_Hide"));
        groupStyle.add(pop.getItem("MenuItem_Unhide"));
        groupStyle.add(pop.getItem("MenuItem_HyperLink"));
        this._groupMenuItems.add(groupStyle);
    }

    protected void initPopMenu(JPopupMenu menu) {
        boolean hasPrefixGroup = false;
        int size = this._groupMenuItems.size();
        for (int i = 0; i < size; ++i) {
            List<JMenuItem> agroup = this._groupMenuItems.get(i);
            if (agroup == null || agroup.size() <= 0) continue;
            if (hasPrefixGroup) {
                menu.addSeparator();
            }
            int gsize = agroup.size();
            for (int j = 0; j < gsize; ++j) {
                JMenuItem o = agroup.get(j);
                if (o instanceof Component) {
                    menu.add((Component)o);
                    continue;
                }
                if (!(o instanceof Action)) continue;
                menu.add((Action)((Object)o));
            }
            hasPrefixGroup = true;
        }
    }

    private void combinePopMenu(OtherComponentManager otherMenu) {
        if (otherMenu != null) {
            Iterator<OtherComponent> it = otherMenu.Iterator();
            while (it.hasNext()) {
                OtherComponent popmenu = it.next();
                if (popmenu._comps == null) continue;
                for (int k = 0; k < popmenu._comps.length; ++k) {
                    this.addGroupItemImpl(popmenu._comps[k], popmenu._groupMenuIndex, -1);
                }
            }
        }
    }

    private void addGroupItemImpl(Object menuItem, int groupIndex, int index) {
        ArrayList<Object> group;
        if (groupIndex == -1) {
            groupIndex = this._groupMenuItems.size() - 1;
        }
        if ((group = (ArrayList<Object>)this._groupMenuItems.get(groupIndex)) == null) {
            group = new ArrayList<Object>();
        }
        if (index < 0 || index > group.size()) {
            group.add(menuItem);
        } else {
            group.add(index, menuItem);
        }
    }

    public Component enableVisibleMenu(String path, boolean visibleMenu, boolean enableAction) {
        Component comp = this.findMenuUsingPath(path);
        if (comp == null) {
            return null;
        }
        if (comp instanceof AbstractButton) {
            this.enableMenu(comp, enableAction);
        }
        if (comp.isVisible() != visibleMenu) {
            comp.setVisible(visibleMenu);
        }
        return comp;
    }

    private void enableMenu(Component menu, boolean enableAction) {
        Action action = ((AbstractButton)menu).getAction();
        if (action != null && action.isEnabled() != enableAction) {
            action.setEnabled(enableAction);
        } else if (menu.isEnabled() != enableAction && !(menu instanceof JMenu)) {
            menu.setEnabled(enableAction);
        }
    }

    public Component findMenuUsingPath(String path) {
        Component menu = null;
        String[] paths = path.split("/");
        for (int x = 0; x < this._popMenu.getComponentCount(); ++x) {
            menu = this._popMenu.getComponent(x);
            for (int i = 0; i < paths.length; ++i) {
                menu = this.match(paths[i], menu);
            }
            if (menu != null) break;
        }
        return menu;
    }

    private Component match(String name, Component menu) {
        try {
            if (menu == null) {
                return null;
            }
            if (menu instanceof JMenuBar) {
                JMenuBar menuBar = (JMenuBar)menu;
                for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                    if (!name.equalsIgnoreCase(menuBar.getMenu(i).getName())) continue;
                    return menuBar.getMenu(i);
                }
            } else if (menu instanceof JMenu) {
                JMenu m = (JMenu)menu;
                for (int i = 0; i < m.getMenuComponentCount(); ++i) {
                    if (!name.equalsIgnoreCase(m.getMenuComponent(i).getName())) continue;
                    return m.getMenuComponent(i);
                }
                if (name.equalsIgnoreCase(menu.getName())) {
                    return menu;
                }
            } else if (name.equalsIgnoreCase(menu.getName())) {
                return menu;
            }
            return null;
        }
        catch (Throwable a) {
            return null;
        }
    }

    public void refresh(ReportMenuState state) {
        this.rebuildPopMenu();
        this.refreshPopMenu(state);
    }

    private void rebuildPopMenu() {
        JPopupMenu popMenu = this._context.getPopMenuManager().getPopMenu();
        popMenu.removeAll();
        this.combinePopMenu(this._otherMenu);
        this.initPopMenu(popMenu);
        this.setPopMenu(popMenu);
    }

    public JPopupMenu getPopMenu() {
        return this._popMenu;
    }

    public void setPopMenu(JPopupMenu menu) {
        this._popMenu = menu;
    }

    protected abstract void refreshPopMenu(ReportMenuState var1);
}

