/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop;

import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.ReportCondition;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.SingleRptProperties;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslReportCondition;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MultiRptPropertiesManager {
    private Map<String, SingleRptProperties> multiRptPro = new HashMap<String, SingleRptProperties>();
    public static final String NOTFOUND = "NOTFOUND";
    static final Object LOCK = new Lock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRptPro(String ctxid, SingleRptProperties prop) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.multiRptPro.put(ctxid, prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRptPro(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            SingleRptProperties rptpro = this.multiRptPro.remove(ctxid);
            if (rptpro != null) {
                rptpro.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleRptProperties getRptProperties(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.multiRptPro.get(ctxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRptProperties(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.multiRptPro.containsKey(ctxid);
        }
    }

    public boolean hasModify(String ctxid) {
        return this.getRptProperties(ctxid).getManager().getModifyManager().isDirty();
    }

    public String getMofidyReportDetail() {
        StringBuffer detail = new StringBuffer();
        if (this.multiRptPro.size() > 0) {
            for (SingleRptProperties rptprop : this.multiRptPro.values()) {
                if (!rptprop.getManager().getModifyManager().isDirty() || OprtState.VIEW.equalsIgnoreCase(rptprop.getOprtState()) || AuditedStatusEnum.AUDITED.equals((Object)((ReportInfo)rptprop.getBookProvider().getEditValue()).getAuditedStatus())) continue;
                detail.append(this.getReportDetailMsg((ReportInfo)rptprop.getBookProvider().getEditValue()));
                detail.append("\n");
            }
        }
        return detail.toString();
    }

    public boolean hasRptInRunBack(int state) {
        for (SingleRptProperties rptprop : this.multiRptPro.values()) {
            if (rptprop.getReportState() != state) continue;
            return true;
        }
        return false;
    }

    public void discardAllEdits() {
        if (this.multiRptPro.size() > 0) {
            for (SingleRptProperties rptprop : this.multiRptPro.values()) {
                rptprop.getManager().getModifyManager().discardAllEdits();
            }
        }
    }

    private String getReportDetailMsg(ReportInfo reportinfo) {
        StringBuffer msg = new StringBuffer();
        msg.append(reportinfo.getCompany().getName()).append("(").append(reportinfo.getCompany().getNumber()).append(")-");
        msg.append(reportinfo.getSourceType().getAlias()).append("-");
        msg.append(StringUtils.isEmpty((String)reportinfo.getName()) ? EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.new") : reportinfo.getName()).append("-");
        if (RptPeriodTypeEnum.DAILY.equals((Object)reportinfo.getPeriodType())) {
            msg.append(reportinfo.getStartDate());
        } else {
            msg.append(reportinfo.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Year"));
            msg.append(reportinfo.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Period"));
            msg.append("-");
        }
        msg.append(reportinfo.getCurrency().getName());
        return msg.toString();
    }

    public String findReport(ReportCondition condition) {
        for (Map.Entry<String, SingleRptProperties> entry : this.multiRptPro.entrySet()) {
            if (!this.hasFound(entry.getValue(), condition)) continue;
            return entry.getKey();
        }
        return NOTFOUND;
    }

    public String findReportByID(String reportId) {
        for (Map.Entry<String, SingleRptProperties> entry : this.multiRptPro.entrySet()) {
            if (!this.hasFound(entry.getValue(), reportId)) continue;
            return entry.getKey();
        }
        return NOTFOUND;
    }

    public int size() {
        return this.multiRptPro.size();
    }

    private boolean hasFound(SingleRptProperties rptprop, ReportCondition condition) {
        if (rptprop == null || condition == null) {
            return false;
        }
        String condtionKey = this.combineRptCondtionKey(condition);
        ReportInfo report = (ReportInfo)rptprop.getBookProvider().getEditValue();
        return this.combineReportKey(report).equals(condtionKey) || report.getId().toString().equals(condition.getTmplNodeInfo().getReportID());
    }

    private boolean hasFound(SingleRptProperties rptprop, String reportId) {
        if (rptprop == null || StringUtils.isEmpty((String)reportId)) {
            return false;
        }
        ReportInfo report = (ReportInfo)rptprop.getBookProvider().getEditValue();
        return reportId.equals(report.getId().toString());
    }

    public void clearAll() {
        for (SingleRptProperties rptprop : this.multiRptPro.values()) {
            rptprop.clear();
        }
        this.multiRptPro.clear();
    }

    private String combineReportKey(ReportInfo report) {
        return RptNewUIUtil.combineReportKey(report);
    }

    private String combineRptCondtionKey(ReportCondition condition) {
        return RptNewUIUtil.combineRptCondtionKey(condition);
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public String getMofidyCslReportDetail() {
        StringBuffer detail = new StringBuffer();
        if (this.multiRptPro.size() > 0) {
            for (SingleRptProperties rptprop : this.multiRptPro.values()) {
                if (rptprop.getManager().getModifyManager().isDirty() && !OprtState.VIEW.equalsIgnoreCase(rptprop.getOprtState()) && !AuditedStatusEnum.AUDITED.equals((Object)((CslReportInfo)rptprop.getBookProvider().getEditValue()).getAuditedStatus())) {
                    detail.append(this.getCslReportDetailMsg((CslReportInfo)rptprop.getBookProvider().getEditValue()));
                    detail.append("\n");
                    continue;
                }
                if (!rptprop.getManager().getModifyManager().isDirty() || !AuditedStatusEnum.AUDITED.equals((Object)((CslReportInfo)rptprop.getBookProvider().getEditValue()).getAuditedStatus())) continue;
                this.discardSingleRptEdit(rptprop);
            }
        }
        return detail.toString();
    }

    public String getModifyCslReportDetailBySingleRpt(SingleRptProperties rptprop) {
        StringBuffer detail = new StringBuffer();
        if (rptprop.getManager().getModifyManager().isDirty() && !OprtState.VIEW.equalsIgnoreCase(rptprop.getOprtState()) && !AuditedStatusEnum.AUDITED.equals((Object)((CslReportInfo)rptprop.getBookProvider().getEditValue()).getAuditedStatus())) {
            detail.append(this.getCslReportDetailMsg((CslReportInfo)rptprop.getBookProvider().getEditValue()));
            detail.append("\n");
        }
        return detail.toString();
    }

    public boolean hasRptInRunBackBySinglRpt(int state, SingleRptProperties rptprop) {
        return rptprop.getReportState() == state;
    }

    public void discardSingleRptEdit(SingleRptProperties rptprop) {
        rptprop.getManager().getModifyManager().discardAllEdits();
    }

    private String getCslReportDetailMsg(CslReportInfo reportinfo) {
        StringBuffer msg = new StringBuffer();
        String id = reportinfo.getId().toString();
        int version = 1;
        FullOrgUnitInfo fullOrgUnitinfo = null;
        CurrencyInfo currency = null;
        try {
            if (42 != reportinfo.getSourceType().getValue()) {
                SumRptAddedPerportyInfo sumRptAddedPerportyInfo = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo("select version where report = '" + id + "'");
                version = sumRptAddedPerportyInfo.getVersion();
            }
            String OrgUnitid = reportinfo.getOrgUnit().getId().toString();
            fullOrgUnitinfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select name,number where id ='" + OrgUnitid + "'");
            String currencyid = reportinfo.getCurrency().getId().toString();
            currency = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select name where id = '" + currencyid + "'").get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        msg.append(fullOrgUnitinfo.getName()).append("(").append(fullOrgUnitinfo.getNumber()).append(")-");
        msg.append(reportinfo.getSourceType().getAlias()).append("-");
        String reportName = "V" + version + ".0-" + reportinfo.getName();
        msg.append(StringUtils.isEmpty((String)reportinfo.getName()) ? EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.new") : reportName).append("-");
        if (RptPeriodTypeEnum.DAILY.equals((Object)reportinfo.getPeriodType())) {
            msg.append(reportinfo.getStartDate());
        } else {
            msg.append(reportinfo.getYear()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Year"));
            msg.append(reportinfo.getPeriod()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Period"));
            msg.append("-");
        }
        msg.append(currency.getName());
        return msg.toString();
    }

    public String findReport(CslReportCondition condition) {
        for (Map.Entry<String, SingleRptProperties> entry : this.multiRptPro.entrySet()) {
            if (!this.hasFound(entry.getValue(), condition)) continue;
            return entry.getKey();
        }
        return NOTFOUND;
    }

    public String findCslReportByID(String reportId) {
        for (Map.Entry<String, SingleRptProperties> entry : this.multiRptPro.entrySet()) {
            if (!this.hasFoundCsl(entry.getValue(), reportId)) continue;
            return entry.getKey();
        }
        return NOTFOUND;
    }

    public Map<String, CslReportInfo> getOpenedRpts() {
        HashMap<String, CslReportInfo> rpts = new HashMap<String, CslReportInfo>();
        Iterator<Map.Entry<String, SingleRptProperties>> it = this.multiRptPro.entrySet().iterator();
        while (it.hasNext()) {
            CslReportInfo report;
            SingleRptProperties rptprop = it.next().getValue();
            if (rptprop == null || (report = (CslReportInfo)rptprop.getBookProvider().getEditValue()) == null) continue;
            rpts.put(report.getId().toString(), report);
        }
        return rpts;
    }

    private boolean hasFound(SingleRptProperties rptprop, CslReportCondition condition) {
        if (rptprop == null || condition == null) {
            return false;
        }
        String condtionKey = this.combineCslRptCondtionKey(condition);
        boolean isTemplate = condition.getTmplNodeInfo().isTemplate();
        CslReportInfo report = (CslReportInfo)rptprop.getBookProvider().getEditValue();
        return this.combineCslReportKey(report, isTemplate).equals(condtionKey);
    }

    private boolean hasFoundCsl(SingleRptProperties rptprop, String reportId) {
        if (rptprop == null || StringUtils.isEmpty((String)reportId)) {
            return false;
        }
        CslReportInfo report = (CslReportInfo)rptprop.getBookProvider().getEditValue();
        return reportId.equals(report.getId().toString());
    }

    private String combineCslReportKey(CslReportInfo report, boolean isTemplate) {
        return RptNewUIUtil.combineCslReportKey(report, isTemplate);
    }

    private String combineCslRptCondtionKey(CslReportCondition condition) {
        return RptNewUIUtil.combineCslRptCondtionKey(condition);
    }

    static class Lock {
        Lock() {
        }
    }
}

