/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.ReportCondition;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.TmplNodeUserDefineInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TmplQueryDataCache {
    private Map<CacheState, List<TmplNodeUserDefineInfo>> cache = new HashMap<CacheState, List<TmplNodeUserDefineInfo>>();

    public boolean hasCache(String cacheKey) {
        if (StringUtil.isEmpty((String)cacheKey)) {
            return false;
        }
        CacheState state = this.find(cacheKey);
        if (state == null) {
            return false;
        }
        return state._isCache;
    }

    public void cacheQueryData(String cacheKey, IRowSet rs) throws SQLException {
        CacheState cachestate;
        ArrayList<TmplNodeUserDefineInfo> cacheLst = new ArrayList<TmplNodeUserDefineInfo>();
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                TmplNodeUserDefineInfo info = new TmplNodeUserDefineInfo();
                info.setTmplID(rs.getString("TEMPLATE.ID"));
                info.setTmplName(rs.getString("TEMPLATE.NAME"));
                info.setTmplNumber(rs.getString("TEMPLATE.NUMBER"));
                info.setTmplVersionNum(rs.getString("VERSIONNUMBER"));
                info.setPeriodType(this.convt2PeriodTypeEnum(rs.getObject("TEMPLATE.PERIODTYPE")));
                info.setTmplType(this.convt2RptTmpTypeEnum(rs.getString("TEMPLATE.TEMPLATETYPE")));
                info.setTmplGroup(rs.getString("TEMPLATE.GROUP"));
                cacheLst.add(info);
            }
        }
        if ((cachestate = this.find(cacheKey)) != null) {
            cacheLst.addAll((Collection)this.cache.get(cachestate));
            Collections.sort(cacheLst, new TmplComparator());
            this.cache.put(cachestate, cacheLst);
        } else {
            Collections.sort(cacheLst, new TmplComparator());
            this.cache.put(new CacheState(cacheKey, true), cacheLst);
        }
    }

    public void cacheQueryData(String cacheKey, ReportCollection coll) throws SQLException {
        CacheState cachestate;
        ArrayList<TmplNodeUserDefineInfo> cacheLst = new ArrayList<TmplNodeUserDefineInfo>();
        if (coll != null && coll.size() > 0) {
            int collSize = coll.size();
            for (int i = 0; i < collSize; ++i) {
                ReportInfo reportInfo = coll.get(i);
                TmplNodeUserDefineInfo info = new TmplNodeUserDefineInfo();
                info.setTmplID(reportInfo.getTemplate().getId().toString());
                info.setTmplName(reportInfo.getTemplate().getName());
                info.setTmplNumber(reportInfo.getTemplate().getNumber());
                info.setTmplVersionNum(reportInfo.getTemplate().getVersionNumber());
                info.setPeriodType(reportInfo.getTemplate().getPeriodType());
                info.setTmplType(reportInfo.getTemplate().getTemplateType());
                info.setTmplGroup(reportInfo.getTemplate().getGroup());
                cacheLst.add(info);
            }
        }
        if ((cachestate = this.find(cacheKey)) != null) {
            cacheLst.addAll((Collection)this.cache.get(cachestate));
            Collections.sort(cacheLst, new TmplComparator());
            this.cache.put(cachestate, cacheLst);
        } else {
            Collections.sort(cacheLst, new TmplComparator());
            this.cache.put(new CacheState(cacheKey, true), cacheLst);
        }
    }

    public void loadReport2TmplNode(String cacheKey, ReportCondition condition) throws BOSException {
        RptPeriodTypeEnum periodType = condition.getPeriodType();
        List<TmplNodeUserDefineInfo> lst = this.getDataFromCache(cacheKey, periodType);
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.loadTmplNode(lst, condition);
    }

    public void loadReport2TmplNode(String cacheKey, ReportCollection coll) throws BOSException {
        if (coll.size() < 0 || coll.get(0) == null || coll.get(0).getTemplate() == null) {
            return;
        }
        RptPeriodTypeEnum periodType = coll.get(0).getTemplate().getPeriodType();
        List<TmplNodeUserDefineInfo> lst = this.getDataFromCache(cacheKey, periodType);
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.loadTmplNode(lst, coll);
    }

    private void loadTmplNode(List<TmplNodeUserDefineInfo> lst, ReportCollection coll) throws BOSException {
        if (lst == null || lst.size() == 0) {
            return;
        }
        HashSet<String> grpIDs = new HashSet<String>(lst.size());
        this.collectTmplGroupIDs(lst, grpIDs);
        Map<String, String> tmpl2rptMap = this.getTmpl2ReportMap(grpIDs, coll);
        this.setExistRepotIDToTmplate(lst, tmpl2rptMap);
    }

    private void setExistRepotIDToTmplate(List<TmplNodeUserDefineInfo> lst, Map<String, String> tmpl2rptMap) {
        for (TmplNodeUserDefineInfo defineInfo : lst) {
            defineInfo.setReportID(tmpl2rptMap.get(defineInfo.getTmplGroup()));
        }
    }

    private Map<String, String> getTmpl2ReportMap(Set<String> grpIDs, ReportCollection coll) throws BOSException {
        HashMap<String, String> tmpl2rptMap = new HashMap<String, String>();
        ReportCollection rptcol = coll;
        this.buildGroupMap(tmpl2rptMap, rptcol);
        return tmpl2rptMap;
    }

    public void loadReport2AllTmplNode(ReportCondition condition) throws BOSException {
        if (this.cache.size() == 0) {
            return;
        }
        ArrayList<TmplNodeUserDefineInfo> col = new ArrayList<TmplNodeUserDefineInfo>();
        Iterator<List<TmplNodeUserDefineInfo>> it = this.cache.values().iterator();
        while (it.hasNext()) {
            col.addAll(this.getHasNodeOfTmplLst(it.next(), condition.getPeriodType()));
        }
        this.loadTmplNode(col, condition);
    }

    private void loadTmplNode(List<TmplNodeUserDefineInfo> lst, ReportCondition condition) throws BOSException {
        if (lst == null || lst.size() == 0) {
            return;
        }
        HashSet<String> grpIDs = new HashSet<String>(lst.size());
        this.collectTmplGroupIDs(lst, grpIDs);
        Map<String, String> tmpl2rptMap = this.getTmpl2ReportMap(grpIDs, condition);
        this.setExistRepotIDToTmplate(lst, tmpl2rptMap);
    }

    private Map<String, String> getTmpl2ReportMap(Set<String> grpIDs, ReportCondition condition) throws BOSException {
        HashMap<String, String> tmpl2rptMap = new HashMap<String, String>();
        ReportCollection rptcol = RptNewUIUtil.getReportCollByCondition(grpIDs, condition);
        this.buildGroupMap(tmpl2rptMap, rptcol);
        return tmpl2rptMap;
    }

    private void buildGroupMap(Map<String, String> tmpl2rptMap, ReportCollection rptcol) {
        if (rptcol != null && rptcol.size() > 0) {
            int size = rptcol.size();
            for (int i = 0; i < size; ++i) {
                ReportInfo info = rptcol.get(i);
                String group = info.getK3Template() != null ? info.getK3Template().getGroup() : info.getTemplate().getGroup();
                tmpl2rptMap.put(group, info.getId().toString());
            }
        }
    }

    private void collectTmplGroupIDs(List<TmplNodeUserDefineInfo> lst, Set<String> grpIDs) {
        if (lst == null) {
            return;
        }
        Iterator<TmplNodeUserDefineInfo> it = lst.iterator();
        while (it.hasNext()) {
            grpIDs.add(it.next().getTmplGroup());
        }
    }

    private RptPeriodTypeEnum convt2PeriodTypeEnum(Object periodTypeAlias) {
        if (periodTypeAlias instanceof String) {
            Iterator it = RptPeriodTypeEnum.iterator();
            while (it.hasNext()) {
                RptPeriodTypeEnum periodtype = (RptPeriodTypeEnum)it.next();
                if (!periodtype.getAlias().equals(periodTypeAlias)) continue;
                return periodtype;
            }
        } else {
            if (periodTypeAlias instanceof BizEnumValueDTO) {
                return RptPeriodTypeEnum.getEnum((int)((BizEnumValueDTO)periodTypeAlias).getInt());
            }
            if (periodTypeAlias instanceof Integer) {
                return RptPeriodTypeEnum.getEnum((int)((Integer)periodTypeAlias));
            }
            if (periodTypeAlias instanceof BigDecimal) {
                return RptPeriodTypeEnum.getEnum((int)((BigDecimal)periodTypeAlias).intValue());
            }
            if (periodTypeAlias instanceof Long) {
                return RptPeriodTypeEnum.getEnum((int)((Long)periodTypeAlias).intValue());
            }
            if (periodTypeAlias instanceof Double) {
                return RptPeriodTypeEnum.getEnum((int)((Double)periodTypeAlias).intValue());
            }
        }
        return null;
    }

    private RptTmpTypeEnum convt2RptTmpTypeEnum(String periodTypeAlias) {
        Iterator it = RptTmpTypeEnum.iterator();
        while (it.hasNext()) {
            RptTmpTypeEnum periodtype = (RptTmpTypeEnum)it.next();
            if (!periodtype.getAlias().equals(periodTypeAlias)) continue;
            return periodtype;
        }
        return null;
    }

    public List<TmplNodeUserDefineInfo> getDataFromCache(String cacheKey, RptPeriodTypeEnum periodType) {
        List<TmplNodeUserDefineInfo> rstLst = this.getDataFromCache(cacheKey);
        return this.filterTmplByPeriodType(rstLst, periodType);
    }

    public List<TmplNodeUserDefineInfo> getDataFromCache(String cacheKey) {
        CacheState state = this.find(cacheKey);
        return this.cache.get(state);
    }

    private List<TmplNodeUserDefineInfo> getHasNodeOfTmplLst(List<TmplNodeUserDefineInfo> lst, RptPeriodTypeEnum periodType) {
        ArrayList<TmplNodeUserDefineInfo> result = new ArrayList<TmplNodeUserDefineInfo>(0);
        if (lst == null || lst.size() == 0) {
            return result;
        }
        List<TmplNodeUserDefineInfo> filtlst = this.filterTmplByPeriodType(lst, periodType);
        for (TmplNodeUserDefineInfo info : filtlst) {
            if (info.getNode() == null) continue;
            result.add(info);
        }
        return result;
    }

    private List<TmplNodeUserDefineInfo> filterTmplByPeriodType(List<TmplNodeUserDefineInfo> lst, RptPeriodTypeEnum periodType) {
        if (lst == null || lst.size() == 0) {
            return new ArrayList<TmplNodeUserDefineInfo>(0);
        }
        ArrayList<TmplNodeUserDefineInfo> filtlst = new ArrayList<TmplNodeUserDefineInfo>(0);
        for (TmplNodeUserDefineInfo info : lst) {
            if (!periodType.equals((Object)info.getPeriodType())) continue;
            filtlst.add(info);
        }
        return filtlst;
    }

    private CacheState find(String cacheKey) {
        for (CacheState state : this.cache.keySet()) {
            if (!cacheKey.equals(state._cacheKey)) continue;
            return state;
        }
        return null;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Map<CacheState, List<TmplNodeUserDefineInfo>> getCache() {
        return this.cache;
    }

    public void setCache(Map<CacheState, List<TmplNodeUserDefineInfo>> cache) {
        this.cache = cache;
    }

    public class TmplComparator
    implements Comparator<TmplNodeUserDefineInfo> {
        @Override
        public int compare(TmplNodeUserDefineInfo o1, TmplNodeUserDefineInfo o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getTmplNumber().compareTo(o2.getTmplNumber());
        }
    }

    public static class CacheState {
        public boolean _isCache = false;
        public String _cacheKey = "";

        public CacheState(String cacheKey, boolean isCache) {
            this._isCache = isCache;
            this._cacheKey = cacheKey;
        }
    }
}

