/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserOrgPermissionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean hasViewPerm = false;
    private boolean hasAddNewPerm = false;
    private boolean hasEditPerm = false;
    private boolean hasRemovePerm = false;
    private boolean hasAuditedPerm = false;
    static final Set<String> viewSet = new HashSet<String>();
    static final Set<String> editSet = new HashSet<String>();
    static final Set<String> addSet = new HashSet<String>();
    static final Set<String> removeSet = new HashSet<String>();
    static final Set<String> auditSet = new HashSet<String>();

    public boolean hasViewPerm() {
        return this.hasViewPerm;
    }

    public void setHasViewPerm(boolean hasViewPerm) {
        this.hasViewPerm = hasViewPerm;
    }

    public boolean hasAddNewPerm() {
        return this.hasAddNewPerm;
    }

    public void setHasAddNewPerm(boolean hasAddNewPerm) {
        this.hasAddNewPerm = hasAddNewPerm;
        if (hasAddNewPerm) {
            this.hasViewPerm = true;
        }
    }

    public boolean hasEditPerm() {
        return this.hasEditPerm;
    }

    public boolean isHasAuditedPerm() {
        return this.hasAuditedPerm;
    }

    public void setHasAuditedPerm(boolean hasAuditedPerm) {
        this.hasAuditedPerm = hasAuditedPerm;
        if (this.hasRemovePerm) {
            this.hasViewPerm = true;
        }
    }

    public void setHasEditPerm(boolean hasEditPerm) {
        this.hasEditPerm = hasEditPerm;
        if (hasEditPerm) {
            this.hasViewPerm = true;
        }
    }

    public void handlePermission(String permItemName) {
        if (StringUtils.isEmpty((String)permItemName)) {
            return;
        }
        if (viewSet.contains(permItemName)) {
            this.setHasViewPerm(true);
        }
        if (addSet.contains(permItemName)) {
            this.setHasAddNewPerm(true);
        }
        if (editSet.contains(permItemName)) {
            this.setHasEditPerm(true);
        }
        if (auditSet.contains(permItemName)) {
            this.setHasAuditedPerm(true);
        }
        if (removeSet.contains(permItemName)) {
            this.setHasRemovePerm(true);
        }
    }

    public static void registerViewPerm(String permName) {
        viewSet.add(permName);
    }

    public static void registerAddPerm(String permName) {
        addSet.add(permName);
    }

    public static void registerEditPerm(String permName) {
        editSet.add(permName);
    }

    public static void registerRemovePerm(String permName) {
        removeSet.add(permName);
    }

    public static void registerAuditPerm(String permName) {
        auditSet.add(permName);
    }

    public boolean hasRemovePerm() {
        return this.hasRemovePerm;
    }

    public void setHasRemovePerm(boolean hasRemovePerm) {
        this.hasRemovePerm = hasRemovePerm;
        if (hasRemovePerm) {
            this.hasViewPerm = true;
        }
    }

    static {
        UserOrgPermissionInfo.registerViewPerm("rpt_report_view");
        UserOrgPermissionInfo.registerViewPerm("rpt_template_view");
        UserOrgPermissionInfo.registerViewPerm("prof_rpt_view");
        UserOrgPermissionInfo.registerViewPerm("prof_tmpl_view");
        UserOrgPermissionInfo.registerEditPerm("rpt_report_update");
        UserOrgPermissionInfo.registerEditPerm("rpt_template_update");
        UserOrgPermissionInfo.registerEditPerm("prof_rpt_update");
        UserOrgPermissionInfo.registerEditPerm("prof_tmpl_update");
        UserOrgPermissionInfo.registerAddPerm("rpt_report_addnew");
        UserOrgPermissionInfo.registerAddPerm("rpt_template_addnew");
        UserOrgPermissionInfo.registerAddPerm("prof_rpt_update");
        UserOrgPermissionInfo.registerAddPerm("prof_tmpl_update");
        UserOrgPermissionInfo.registerRemovePerm("rpt_report_delete");
        UserOrgPermissionInfo.registerRemovePerm("prof_rpt_update");
        UserOrgPermissionInfo.registerAuditPerm("rpt_report_audit");
        UserOrgPermissionInfo.registerAuditPerm("prof_rpt_audit");
    }
}

