/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.util;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class BizDataSortHelper {
    private String _mainTableAlias;
    private SorterItemInfo _currSorterItemInfo;
    private String splitSign = "\\.";
    private String[] _currSplitArr;
    private BizDataComparetor cpm;
    private SortStrComparator sortStrCpm;
    private String[] _multColumnSortArr;

    public BizDataSortHelper(String mainTableAlias) {
        this._mainTableAlias = mainTableAlias;
        this.cpm = new BizDataComparetor();
        this.sortStrCpm = new SortStrComparator();
    }

    public List sort(AbstractObjectCollection coll, SorterItemInfo sorterItemInfo) {
        this._currSorterItemInfo = sorterItemInfo;
        if (coll == null) {
            return null;
        }
        if (this._currSorterItemInfo == null) {
            return Arrays.asList(coll.toArray());
        }
        this._currSplitArr = this.split();
        List<Object> sortLst = Arrays.asList(coll.toArray());
        Collections.sort(sortLst, this.cpm);
        return sortLst;
    }

    public List sort(AbstractObjectCollection coll, SorterItemInfo sorterItemInfo, String[] multColumnSortArr) {
        if (sorterItemInfo != null) {
            return this.sort(coll, sorterItemInfo);
        }
        if (multColumnSortArr != null) {
            return this.sort(coll, multColumnSortArr);
        }
        if (coll == null) {
            return null;
        }
        return Arrays.asList(coll.toArray());
    }

    public List sort(AbstractObjectCollection coll, String[] multColumnSortArr) {
        this._multColumnSortArr = multColumnSortArr;
        if (coll == null) {
            return null;
        }
        if (this._multColumnSortArr == null) {
            return Arrays.asList(coll.toArray());
        }
        List<Object> sortLst = Arrays.asList(coll.toArray());
        Collections.sort(sortLst, new BizDataMultColumnComparetor());
        return sortLst;
    }

    private String getSortColumnName() {
        return this._currSorterItemInfo.getPropertyName();
    }

    private SortType getSortType() {
        return this._currSorterItemInfo.getSortType();
    }

    private String[] split() {
        String[] splitArr = this.getSortColumnName().split(this.splitSign);
        if (splitArr == null || splitArr.length <= 0) {
            return null;
        }
        if (this._mainTableAlias.equalsIgnoreCase(splitArr[0])) {
            String[] copy = new String[splitArr.length - 1];
            System.arraycopy(splitArr, 1, copy, 0, splitArr.length - 1);
            return copy;
        }
        return splitArr;
    }

    private int compareValue(Object o1, Object o2) {
        if (o1 instanceof Number) {
            return ((Number)o1).intValue() - ((Number)o2).intValue();
        }
        if (o1 instanceof String) {
            return o2 == null ? 1 : this.sortStrCpm.compare(o1, o2);
        }
        if (o1 instanceof IntEnum) {
            return o2 == null ? 1 : ((IntEnum)o1).compareTo((Object)((IntEnum)o2));
        }
        if (o1 instanceof StringEnum) {
            return o2 == null ? 1 : ((StringEnum)o1).compareTo((Object)((StringEnum)o2));
        }
        if (o1 instanceof Date) {
            return o2 == null ? 1 : ((Date)o1).compareTo((Date)o2);
        }
        if (o1 instanceof Boolean) {
            return o2 == null ? 1 : ((Boolean)o1).compareTo((Boolean)o2);
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        return 0;
    }

    public class SortStrComparator
    implements Comparator {
        Comparator cmp = (RuleBasedCollator)Collator.getInstance(Locale.CHINA);

        public int compare(Object o1, Object o2) {
            return this.cmp == null ? ((String)o1).compareTo((String)o2) : this.cmp.compare(o1, o2);
        }
    }

    class BizDataMultColumnComparetor
    implements Comparator<IObjectValue> {
        BizDataMultColumnComparetor() {
        }

        @Override
        public int compare(IObjectValue o1, IObjectValue o2) {
            int compareVal = 0;
            for (int i = 0; i < BizDataSortHelper.this._multColumnSortArr.length; ++i) {
                compareVal = BizDataSortHelper.this.compareValue(o1.get(BizDataSortHelper.this._multColumnSortArr[i]), o2.get(BizDataSortHelper.this._multColumnSortArr[i]));
                if (compareVal == 0) continue;
                return compareVal;
            }
            return compareVal;
        }
    }

    class BizDataComparetor
    implements Comparator<IObjectValue> {
        BizDataComparetor() {
        }

        @Override
        public int compare(IObjectValue o1, IObjectValue o2) {
            if (StringUtils.isEmpty((String)BizDataSortHelper.this.getSortColumnName()) || BizDataSortHelper.this.getSortType() == null || BizDataSortHelper.this._currSplitArr == null || BizDataSortHelper.this._currSplitArr.length == 0) {
                return 0;
            }
            int compareVal = this.compareParser(o1, o2, 0);
            return SortType.ASCEND.equals((Object)BizDataSortHelper.this.getSortType()) ? compareVal : -compareVal;
        }

        private int compareParser(Object o1, Object o2, int index) {
            if (index > BizDataSortHelper.this._currSplitArr.length) {
                return 0;
            }
            if (o1 instanceof IObjectValue && o2 instanceof IObjectValue) {
                return this.compareParser(((IObjectValue)o1).get(BizDataSortHelper.this._currSplitArr[index]), ((IObjectValue)o2).get(BizDataSortHelper.this._currSplitArr[index]), ++index);
            }
            return BizDataSortHelper.this.compareValue(o1, o2);
        }
    }
}

