/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.util.context;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.BatchPermHandle;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.IBatchPermHandle;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.PermTypeView;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.IWktbContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractWktbContext
extends RptProperties
implements IWktbContext {
    private static final long serialVersionUID = 1L;
    private OrgUnitInfo _currOrgUnitInfo = null;
    private Map<String, OrgNodeUserDefineInfo> _OrgNodeMap = null;
    private OrgType _orgType;
    private Map<PermTypeView, IBatchPermHandle> permManage;

    protected AbstractWktbContext(OrgType orgType) {
        this._orgType = orgType;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this._currOrgUnitInfo = orgUnitInfo;
    }

    @Override
    public Map<String, OrgNodeUserDefineInfo> getMapOfOrgTreeBuilder(boolean force) throws Exception {
        if (!force && this._OrgNodeMap != null) {
            return this._OrgNodeMap;
        }
        if (force || this._OrgNodeMap == null) {
            this.initAuthorizedOrg();
        }
        return this._OrgNodeMap;
    }

    public Map<String, OrgNodeUserDefineInfo> getMapOfOrgTreeBuilder(boolean force, RptProperties pros) throws Exception {
        this.initAuthorizedOrg(pros);
        return this._OrgNodeMap;
    }

    public void setOrgNodeMap(Map<String, OrgNodeUserDefineInfo> orgNodeMap) {
        this._OrgNodeMap = orgNodeMap;
    }

    public void clear() {
        if (this._OrgNodeMap != null) {
            this._OrgNodeMap.clear();
            this._OrgNodeMap = null;
        }
        if (this.permManage != null) {
            this.permManage.clear();
            this.permManage = null;
        }
        this._currOrgUnitInfo = null;
    }

    private void initAuthorizedOrg() throws Exception {
        this._OrgNodeMap = RptNewUIUtil.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getOrgPermItemNames(), this.getOrgType());
        if (this._OrgNodeMap == null || this._OrgNodeMap.size() == 0) {
            // empty if block
        }
    }

    private void initAuthorizedOrg(RptProperties pros) throws Exception {
        this._OrgNodeMap = RptNewUIUtil.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getOrgPermItemNames(), this.getOrgType(), pros);
        if (this._OrgNodeMap == null || this._OrgNodeMap.size() == 0) {
            // empty if block
        }
    }

    @Override
    public OrgUnitInfo getOrgUnitInfo() {
        if (this.getCurrOrgUnitInfo() != null) {
            return this.getCurrOrgUnitInfo();
        }
        return this.getCurrDefaultOrgUnitInfo();
    }

    public OrgUnitInfo getCurrOrgUnitInfo() {
        return this._currOrgUnitInfo == null ? this.getCurrDefaultOrgUnitInfo() : this._currOrgUnitInfo;
    }

    public OrgUnitInfo getCurrOrgUnitInfoIncloudNull() {
        return this._currOrgUnitInfo;
    }

    public void setCurrOrgUnitInfo(OrgUnitInfo OrgUnitInfo2) {
        this._currOrgUnitInfo = OrgUnitInfo2;
    }

    @Override
    public OrgType getOrgType() {
        return this._orgType;
    }

    @Override
    public OrgUnitInfo getCurrDefaultOrgUnitInfo() {
        return SysContext.getSysContext().getCurrentOrgUnit();
    }

    private IBatchPermHandle getNoPermOrgIDs(PermTypeView permTypeView) {
        if (this.permManage == null) {
            this.permManage = new HashMap<PermTypeView, IBatchPermHandle>(2);
        }
        if (!this.permManage.containsKey((Object)permTypeView)) {
            this.permManage.put(permTypeView, new BatchPermHandle(this.collectNoPermOrgIDs(permTypeView)));
        }
        return this.permManage.get((Object)permTypeView);
    }

    private Set<String> collectNoPermOrgIDs(PermTypeView permTypeView) {
        HashSet<String> noPermOrgIDs = new HashSet<String>();
        try {
            for (Map.Entry<String, OrgNodeUserDefineInfo> entry : this.getMapOfOrgTreeBuilder(false).entrySet()) {
                if (PermTypeView.REMOVE_PERM.equals((Object)permTypeView)) {
                    if (entry.getValue().getOrgPermInfo().hasRemovePerm()) continue;
                    noPermOrgIDs.add(entry.getKey());
                    continue;
                }
                if (PermTypeView.EDIT_PERM.equals((Object)permTypeView)) {
                    if (entry.getValue().getOrgPermInfo().hasEditPerm()) continue;
                    noPermOrgIDs.add(entry.getKey());
                    continue;
                }
                if (!PermTypeView.AUDIT_PERM.equals((Object)permTypeView) || entry.getValue().getOrgPermInfo().isHasAuditedPerm()) continue;
                noPermOrgIDs.add(entry.getKey());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return noPermOrgIDs;
    }

    public Set<String> noPermissionOrgIds4Given(Set<String> rptOrgIDs, PermTypeView permTypeView) {
        IBatchPermHandle handle = this.getNoPermOrgIDs(permTypeView);
        return handle.noPermissionOrgIds4Given(rptOrgIDs);
    }
}

