/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.util.context;

import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractRptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.IWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.RptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.TemplateWktbContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WebWktbContextFactory {
    private static WebWktbContextFactory factory = null;
    private static Map<String, Map<OrgType, IWktbContext>> cache;
    private static final String REPORT = "report";
    private static final String TEMPLATE = "template";

    private WebWktbContextFactory() {
    }

    public static WebWktbContextFactory getInstance() {
        if (factory == null) {
            factory = new WebWktbContextFactory();
            cache = new HashMap<String, Map<OrgType, IWktbContext>>(2);
        }
        return factory;
    }

    public AbstractRptWktbContext getRptContext(OrgType orgType) throws Exception {
        this.initContext(orgType, REPORT);
        return (AbstractRptWktbContext)cache.get(REPORT).get(orgType);
    }

    public AbstractWktbContext getTemplateContext(OrgType orgType) throws Exception {
        this.initContext(orgType, TEMPLATE);
        return (AbstractWktbContext)cache.get(TEMPLATE).get(orgType);
    }

    private void initContext(OrgType orgType, String key) throws Exception {
        if (!cache.containsKey(key)) {
            cache.put(key, this.createConMap());
        }
        if (!cache.get(key).containsKey(orgType)) {
            cache.get(key).put(orgType, this.createContext(orgType, key));
        }
    }

    private IWktbContext createContext(OrgType orgType, String key) throws Exception {
        return REPORT.equals(key) ? RptWktbContext.getContext(orgType) : TemplateWktbContext.getContext(orgType);
    }

    private Map<OrgType, IWktbContext> createConMap() {
        return new ConcurrentHashMap<OrgType, IWktbContext>();
    }
}

