/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.rptnewui.util.context;

import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractRptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AbstractWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.AdjustWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.IWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.RptWktbContext;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.TemplateWktbContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WktbContextFactory {
    private static WktbContextFactory factory = null;
    private static Map<String, Map<OrgType, IWktbContext>> cache;
    private static final String REPORT = "report";
    private static final String TEMPLATE = "template";
    private static final String Adjust = "adjust";

    private WktbContextFactory() {
    }

    public static WktbContextFactory getInstance() {
        if (factory == null) {
            factory = new WktbContextFactory();
            cache = new HashMap<String, Map<OrgType, IWktbContext>>(2);
        }
        return factory;
    }

    public AbstractRptWktbContext getRptContext(OrgType orgType) throws Exception {
        this.initContext(orgType, REPORT);
        return (AbstractRptWktbContext)cache.get(REPORT).get(orgType);
    }

    public AbstractWktbContext getTemplateContext(OrgType orgType) throws Exception {
        this.initContext(orgType, TEMPLATE);
        return (AbstractWktbContext)cache.get(TEMPLATE).get(orgType);
    }

    public AbstractRptWktbContext getAdjustContext(OrgType orgType) throws Exception {
        this.initContext(orgType, Adjust);
        return (AbstractRptWktbContext)cache.get(Adjust).get(orgType);
    }

    private void initContext(OrgType orgType, String key) throws Exception {
        if (!cache.containsKey(key)) {
            cache.put(key, this.createConMap());
        }
        if (!cache.get(key).containsKey(orgType)) {
            cache.get(key).put(orgType, this.createContext(orgType, key));
        }
    }

    private IWktbContext createContext(OrgType orgType, String key) throws Exception {
        switch (key) {
            case "report": {
                return RptWktbContext.getContext(orgType);
            }
            case "template": {
                return TemplateWktbContext.getContext(orgType);
            }
            case "adjust": {
                return AdjustWktbContext.getContext(orgType);
            }
        }
        return null;
    }

    private Map<OrgType, IWktbContext> createConMap() {
        return new ConcurrentHashMap<OrgType, IWktbContext>();
    }
}

