/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.sheet.notify;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class CellContentChangedListener
implements SheetChangeListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_Content)) {
            Sheet sheet = e.getSheet();
            try {
                sheet.getBook().getUndoManager().startGroup();
                sheet.getBook().getUndoManager().enable(false);
                SortedCellBlockArray cells = e.getChangedBlocks();
                sheet.getBook().setSkipListeners(true);
                for (int i = 0; i < cells.size(); ++i) {
                    CellBlock block = cells.getBlock(i);
                    if (block.isRow() || block.isCol()) continue;
                    int top = block.getRow();
                    int bottom = block.getRow2();
                    int left = block.getCol();
                    int right = block.getCol2();
                    for (int row = top; row <= bottom; ++row) {
                        for (int col = left; col <= right; ++col) {
                            Cell cell = sheet.getCell(row, col, false);
                            if (cell != null && cell.hasFormula()) continue;
                            CellContentChangedListener.roundHalfUpBigDecimal4Cell(cell);
                        }
                    }
                }
            }
            finally {
                sheet.getBook().setSkipListeners(false);
                sheet.getBook().getUndoManager().endGroup();
                sheet.getBook().getUndoManager().enable(true);
            }
        }
    }

    public static void roundHalfUpBigDecimal4Cell(Cell cell) {
        Variant var;
        if (cell != null && (var = cell.getValue()) != null && var.getVt() == 10 && !var.isEmpty()) {
            StyleAttributes sa = Styles.getEmptySA();
            sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
            String numberFormat = sa.getNumberFormat();
            if (!(StringUtils.isEmpty((String)numberFormat) || numberFormat.indexOf("0.") <= 0 && numberFormat.indexOf("#.") <= 0)) {
                int formatScale = numberFormat.substring(numberFormat.lastIndexOf(".") + 1).length();
                BigDecimal bg = null;
                try {
                    bg = var.toBigDecimal();
                }
                catch (SyntaxErrorException e1) {
                    e1.printStackTrace();
                }
                if (bg != null && formatScale < bg.scale()) {
                    bg = bg.setScale(formatScale, 4);
                    cell.setValue(new Variant((Object)bg));
                }
            }
        }
    }
}

