/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingFactory;
import com.kingdee.eas.fi.rpt.CompanyF7Helper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CslGradeManageUtilClient {
    public static final String TABLENAME = "tableName";
    public static final String SELECTEDIDLIST = "selectedIDList";
    public static final String ORGID = "orgID";
    public static final String ORGCOLNAME = "orgColName";

    public void updateMaintainOrgLocal(String tableName, String orgColName, ArrayList selectedIDList) throws EASBizException, BOSException {
        this.checkIsSelectedEmpty(selectedIDList);
        NewOrgViewF7PromptDialog f7 = this.getSingleSelectedFinancOrg();
        FullOrgUnitInfo orgInfo = this.getSelectedOrgIDCollsToCopy(f7);
        if (orgInfo == null) {
            return;
        }
        String orgID = orgInfo.getId().toString();
        Map paramMap = this.buildMap(tableName, orgColName, orgID, selectedIDList);
        CslGradeManageSettingFactory.getRemoteInstance().updateMaintainOrg(paramMap);
    }

    public void updateMaintainTowOrgLocal(String tableName, String orgColName1, String orgColName2, ArrayList selectedIDList) throws EASBizException, BOSException {
        this.checkIsSelectedEmpty(selectedIDList);
        NewOrgViewF7PromptDialog f7 = this.getSingleSelectedFinancOrg();
        FullOrgUnitInfo orgInfo = this.getSelectedOrgIDCollsToCopy(f7);
        if (orgInfo == null) {
            return;
        }
        String orgID = orgInfo.getId().toString();
        Map paramMap1 = this.buildMap(tableName, orgColName1, orgID, selectedIDList);
        Map paramMap2 = this.buildMap(tableName, orgColName2, orgID, selectedIDList);
        CslGradeManageSettingFactory.getRemoteInstance().updateMaintainOrg(paramMap1);
        CslGradeManageSettingFactory.getRemoteInstance().updateMaintainOrg(paramMap2);
    }

    private void checkIsSelectedEmpty(ArrayList selectedIDList) {
        if (selectedIDList.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public NewOrgViewF7PromptDialog getSingleSelectedFinancOrg() {
        NewCompanyF7 f7 = CompanyF7Helper.getMultiOrgViewTypeUnitF7WithoutFilter(null, (OrgViewType[])new OrgViewType[]{OrgViewType.COMPANY});
        f7.setCurrentCUID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        f7.setIsCUFilter(true, true);
        f7.setMultiSelect(false);
        f7.setNeedAddOrgRange(false);
        f7.setPermissionItem(null);
        f7.show();
        f7.getData();
        return f7;
    }

    public FullOrgUnitInfo getSelectedOrgIDCollsToCopy(NewOrgViewF7PromptDialog f7) {
        Object data = f7.getData();
        if (data == null) {
            return null;
        }
        if (data instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)data;
        }
        if (data instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)data).castToFullOrgUnitInfo();
        }
        return null;
    }

    private Map buildMap(String tableName, String orgColName, String orgID, ArrayList selectedIDList) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(TABLENAME, tableName);
        paramMap.put(ORGCOLNAME, orgColName);
        paramMap.put(ORGID, orgID);
        paramMap.put(SELECTEDIDLIST, selectedIDList);
        return paramMap;
    }

    public static void judgeAndPromptSelectedRow(KDTable tblMain, int[] selectRows, String colName, String compareValue, String promptMsg, String promptType) {
        int size = selectRows.length;
        for (int i = 0; i < size; ++i) {
            ICell cell = tblMain.getCell(selectRows[i], colName);
            if (cell.getValue().toString().equals(compareValue)) continue;
            CslGradeManageUtilClient.showPromptByType(promptMsg, promptType);
            SysUtil.abort();
        }
    }

    private static void showPromptByType(String promptMsg, String promptType) {
        if (promptType != null && ("noeqCreateOrgRemove".equals(promptType) || "noeqCreateOrgCanntForbid".equals(promptType) || "noeqCreateOrgCanntUnForbid".equals(promptType) || "notCreateOrgCanntDistribute".equals(promptType) || "notCreateOrgCanntUnDistribute".equals(promptType) || "notCreateOrgCanntAudit".equals(promptType) || "notCreateOrgCanntUnAudit".equals(promptType))) {
            MsgBox.showInfo((String)promptMsg);
        }
    }
}

