/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.client.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementCollection;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.accountcheck.client.RowColChangeGuideUI;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.util.RowColChangeBasePoint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RowColChangeUtils {
    private static Logger logger = Logger.getLogger(RowColChangeUtils.class);
    public static final String rowColChangePoint = "rowColChangePoint";
    public static final String rowColChangeItem = "rowColChangeItem";
    public static final String rowColDataElement = "rowColDataElement";
    public static final String rowColDirectCompany = "rowColDirectCompany";
    public static final String rowColOwnCompany = "rowColOwnCompany";
    public static final String rowColDyCompany = "rowColDyCompany";
    public static final String isRowColChangeSheet = "isRowColChangeSheet";

    public static void showGuide(IUIObject owner, SpreadManager spreadManager, Book book) throws Exception {
        RowColChangeUtils.showGuide(owner, spreadManager, book, owner.getOprtState());
    }

    public static void showGuide(IUIObject owner, SpreadManager spreadManager, Book book, String oprt) throws Exception {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"KEY_BOOK", (Object)book);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RowColChangeGuideUI.class.getName(), (Map)uiContext, null, StringUtils.isEmpty((CharSequence)oprt) ? owner.getOprtState() : oprt);
        window.show();
        RowColChangeGuideUI wizardUI = (RowColChangeGuideUI)window.getUIObject();
        if (!wizardUI.isCancel()) {
            spreadManager.getModifyManager().setModified();
            spreadManager.getSpreadContainer().repaint();
        }
    }

    public static void beforeCalc(ReportBaseInfo info, Book book) throws Exception {
        if (RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)info.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)info.getSourceType())) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                if (!sheet.isEnableCalculation()) continue;
                RowColChangeUtils.beforeCalc(sheet);
            }
        }
    }

    public static void beforeCalc(Sheet sheet) throws Exception {
        Cell basePointCell = RowColChangeUtils.getBasePoint(sheet);
        if (basePointCell != null) {
            RowColChangeBasePoint pointInfo = RowColChangeUtils.getPointInfo(basePointCell);
            int srcBasePoint = pointInfo.getSrcBasePoint();
            Sheet srcSheet = sheet.getBook().getSheetByName(pointInfo.getSrcSheetName());
            ArrayList srcPoints = DynamicTemplateUtility.getBasePointList((Sheet)srcSheet);
            Point srcPoint = (Point)srcPoints.get(srcBasePoint);
            basePointCell.setUserObject("srcPoint", (Object)srcPoint.y);
            for (int i = basePointCell.getCol() + 1; i <= sheet.getMaxColIndex(); ++i) {
                Cell firstCell = sheet.getCell(basePointCell.getRow() + 1, i, false);
                Cell hearCell = sheet.getCell(basePointCell.getRow(), i, false);
                if (hearCell == null) continue;
                String formula = null;
                if (firstCell == null || StringUtils.isEmpty((CharSequence)(formula = firstCell.getFormula())) || !formula.trim().startsWith("=")) continue;
                hearCell.setUserObject("formula", (Object)formula);
            }
            int dataElementIndex = -1;
            int endCol = sheet.getMaxRowIndex();
            for (int i = basePointCell.getCol() + 1; i <= endCol; ++i) {
                Cell cell = sheet.getCell(basePointCell.getRow(), i, false);
                if (cell == null || cell.getUserObjectValue(rowColDataElement) == null) continue;
                if (dataElementIndex >= 0) {
                    UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(i, i)).delete();
                    --i;
                    --endCol;
                    continue;
                }
                dataElementIndex = cell.getCol();
            }
            sheet.getRange(basePointCell.getRow() + 1, basePointCell.getCol(), sheet.getMaxRowIndex() + 1, sheet.getMaxColIndex() + 1).clear(true, true, false, true);
        }
    }

    public static void afterCalc(ReportBaseInfo info, Book book) throws Exception {
        if (RptSrcTypeEnum.DYNAMICSUMREPORT.equals((Object)info.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)info.getSourceType())) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                if (!sheet.isEnableCalculation()) continue;
                RowColChangeUtils.afterCalc(sheet);
            }
        }
    }

    public static void afterCalc(Sheet sheet) throws Exception {
        Cell basePointCell = RowColChangeUtils.getBasePoint(sheet);
        if (basePointCell != null) {
            RowColChangeUtils.beforeCalc(sheet);
            RowColChangeBasePoint pointInfo = RowColChangeUtils.getPointInfo(basePointCell);
            int srcBasePoint = pointInfo.getSrcBasePoint();
            Sheet srcSheet = sheet.getBook().getSheetByName(pointInfo.getSrcSheetName());
            ArrayList srcPoints = DynamicTemplateUtility.getBasePointList((Sheet)srcSheet);
            Point srcPoint = (Point)srcPoints.get(srcBasePoint);
            DynaParameters srcParam = DynamicTemplateUtility.getDynaParameters((Sheet)srcSheet, (Point)srcPoint);
            RowColChangeUtils.setFormulaToFirstRow(sheet, srcSheet, basePointCell, srcPoint);
            RowColChangeUtils.handleFormula(sheet, basePointCell, srcParam);
            RowColChangeUtils.handleRowData(sheet, basePointCell, pointInfo, srcSheet, srcPoint, srcParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleRowData(Sheet sheet, Cell basePointCell, RowColChangeBasePoint pointInfo, Sheet srcSheet, Point srcPoint, DynaParameters srcParam) throws Exception {
        int[] colIndex = RowColChangeUtils.getColIndex(sheet, basePointCell);
        int dataElementCol = colIndex[4];
        List<Integer[]> itemCols = RowColChangeUtils.getItemCols(srcSheet, pointInfo);
        ArrayList<String> dataElementNumbers = new ArrayList<String>();
        Map itemDataElementInfos = RowColChangeUtils.getItemDataElementMap(srcSheet, srcPoint, itemCols, dataElementNumbers);
        Map<String, Integer> dataElementColMap = RowColChangeUtils.insertDataElementCol(sheet, basePointCell, dataElementNumbers, dataElementCol);
        colIndex = RowColChangeUtils.getColIndex(sheet, basePointCell);
        int directCompanyCol = colIndex[0];
        int ownCompanyCol = colIndex[1];
        int dyCompanyCol = colIndex[2];
        int itemCol = colIndex[3];
        int rowIndex = basePointCell.getRow();
        int srcRowIndex = srcParam.isIncludeSum() && srcParam.getPosition() == 1 ? srcPoint.y + 1 : srcPoint.y;
        int lastDataElementCol = dataElementCol;
        for (int i = 0; i < srcParam.getDefaultCounter(); ++i) {
            Row srcRow;
            Variant dyItemName;
            ++rowIndex;
            if ((dyItemName = (srcRow = srcSheet.getRow(++srcRowIndex, true)).getCell(srcPoint.x, true).getValue()) != null) {
                String dyItemNameStr = dyItemName.toString().trim();
                Object dyCompany = null;
                if (dyItemNameStr.indexOf("[") >= 0 && dyItemNameStr.indexOf("]") >= 0) {
                    dyCompany = dyItemNameStr.substring(dyItemNameStr.lastIndexOf("]") + 1);
                    if (directCompanyCol >= 0) {
                        sheet.getCell(rowIndex, directCompanyCol, true).setValue(new Variant((Object)dyItemNameStr.substring(dyItemNameStr.indexOf("[") + 1, dyItemNameStr.indexOf("]"))));
                    }
                    if (ownCompanyCol >= 0) {
                        sheet.getCell(rowIndex, ownCompanyCol, true).setValue(new Variant((Object)dyItemNameStr.substring(dyItemNameStr.lastIndexOf("[") + 1, dyItemNameStr.lastIndexOf("]"))));
                    }
                } else {
                    dyCompany = dyItemNameStr;
                }
                if (dyCompanyCol >= 0) {
                    sheet.getCell(rowIndex, dyCompanyCol, true).setValue(new Variant(dyCompany));
                }
            }
            int itemIndex = 0;
            for (Object itemName : itemDataElementInfos.keySet()) {
                List infos = (List)itemDataElementInfos.get(itemName);
                if (itemIndex != 0) {
                    UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(rowIndex + 1, rowIndex + 1)).insert(true, InsertType.FLLOW_UP_STYLE);
                    RowColChangeUtils.copyTo(sheet, basePointCell, rowIndex, rowIndex + 1);
                    ++rowIndex;
                }
                sheet.getCell(rowIndex, itemCol, true).setValue(new Variant(itemName));
                for (ItemDataElementInfo info : infos) {
                    int curDataElementColIndex = dataElementColMap.get(info.dataElementNumber);
                    if (curDataElementColIndex < 0) continue;
                    sheet.getCell(basePointCell.getRow(), curDataElementColIndex, true).setValue(new Variant((Object)info.dataElementName));
                    sheet.getCell(rowIndex, curDataElementColIndex, true).setValue(srcSheet.getCell(srcRowIndex, info.col, true).getValue());
                }
                ++itemIndex;
            }
        }
        int endRow = rowIndex;
        int startRow = basePointCell.getRow() + 1;
        if (endRow < startRow) {
            endRow = startRow;
        }
        ArrayList<Integer> sortKey = new ArrayList<Integer>();
        if (directCompanyCol >= 0) {
            sortKey.add(directCompanyCol);
        }
        if (ownCompanyCol >= 0) {
            sortKey.add(ownCompanyCol);
        }
        if (itemCol >= 0) {
            sortKey.add(itemCol);
        }
        if (dyCompanyCol >= 0) {
            sortKey.add(dyCompanyCol);
        }
        int[] sort = new int[sortKey.size()];
        boolean[] orders = new boolean[sortKey.size()];
        for (int i = 0; i < sortKey.size(); ++i) {
            sort[i] = (Integer)sortKey.get(i);
            orders[i] = true;
        }
        Sheet activeSheet = sheet.getBook().getActiveSheet();
        try {
            sheet.getBook().setActiveSheet(sheet);
            UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(startRow, basePointCell.getCol(), endRow, sheet.getMaxColIndex())).sort(sort, orders, true, false);
        }
        finally {
            sheet.getBook().setActiveSheet(activeSheet);
        }
        RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
        styleParam.setInsertInherit(true);
        styleParam.setStandardPoint(new Point(basePointCell.getCol(), basePointCell.getRow()));
        styleParam.setStartRow(startRow);
        styleParam.setEndRow(endRow);
        styleParam.setStartColumn(basePointCell.getCol());
        styleParam.setEndColumn(sheet.getCols().getMaxIntMark());
        StyleDecoratorHeightOrWidth sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
        sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
        sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
    }

    public static int[] getColIndex(Sheet sheet, Cell basePointCell) {
        int dyCompanyCol = -1;
        int ownCompanyCol = -1;
        int directCompanyCol = -1;
        int itemCol = -1;
        int dataElementCol = -1;
        for (int i = basePointCell.getCol(); i <= sheet.getMaxColIndex() && (directCompanyCol < 0 || ownCompanyCol < 0 || dyCompanyCol < 0 || itemCol < 0 || dataElementCol < 0); ++i) {
            Cell cell = sheet.getCell(basePointCell.getRow(), i, false);
            if (cell == null) continue;
            if (cell.getUserObjectValue(rowColDirectCompany) != null) {
                directCompanyCol = cell.getCol();
                continue;
            }
            if (cell.getUserObjectValue(rowColOwnCompany) != null) {
                ownCompanyCol = cell.getCol();
                continue;
            }
            if (cell.getUserObjectValue(rowColDyCompany) != null) {
                dyCompanyCol = cell.getCol();
                continue;
            }
            if (cell.getUserObjectValue(rowColChangeItem) != null) {
                itemCol = cell.getCol();
                continue;
            }
            if (cell.getUserObjectValue(rowColDataElement) == null) continue;
            dataElementCol = cell.getCol();
        }
        return new int[]{directCompanyCol, ownCompanyCol, dyCompanyCol, itemCol, dataElementCol};
    }

    public static Map<String, Integer> insertDataElementCol(Sheet sheet, Cell basePointCell, List<String> dataElementNumbers, int dataElementCol) throws Exception {
        HashMap<String, Integer> dataElementColMap = new HashMap<String, Integer>();
        int lastDataElementCol = -1;
        for (String dataElementNumber : dataElementNumbers) {
            if (dataElementColMap.isEmpty()) {
                lastDataElementCol = dataElementCol;
                dataElementColMap.put(dataElementNumber, dataElementCol);
                continue;
            }
            if (dataElementColMap.containsKey(dataElementNumber)) continue;
            UserObjectHelper.getUnprotectedRange((Range)sheet.getColRange(lastDataElementCol + 1, lastDataElementCol + 1)).insert(true, InsertType.FLLOW_UP_STYLE);
            sheet.getRange(basePointCell.getRow(), lastDataElementCol, basePointCell.getRow() + 1, lastDataElementCol).copyTo(sheet, sheet.getRange(basePointCell.getRow(), lastDataElementCol + 1, basePointCell.getRow() + 1, lastDataElementCol + 1), new PasteMode(PasteMode.Formats));
            Cell headCell = sheet.getCell(basePointCell.getRow(), ++lastDataElementCol, true);
            headCell.setUserObject(rowColDataElement, (Object)"1");
            dataElementColMap.put(dataElementNumber, lastDataElementCol);
        }
        return dataElementColMap;
    }

    public static void copyTo(Sheet sheet, Cell basePointCell, int srcRow, int toRow) throws Exception {
        for (int i = 0; i <= sheet.getMaxColIndex(); ++i) {
            Cell srcCell = sheet.getCell(srcRow, i, false);
            if (srcCell == null || sheet.getCell(basePointCell.getRow(), i, true).getUserObjectValue(rowColDataElement) != null) continue;
            sheet.getCell(toRow, i, true).setValue(srcCell.getValue());
        }
    }

    public static Map getItemDataElementMap(Sheet srcSheet, Point srcPoint, List<Integer[]> itemCols, List<String> dataElementNumbers) throws Exception {
        int i;
        HashMap<Integer, String[]> itemsMap = new HashMap<Integer, String[]>();
        HashMap<String, String> items = new HashMap<String, String>();
        HashMap<String, String> dataElements = new HashMap<String, String>();
        for (Integer[] cols : itemCols) {
            for (i = cols[0].intValue(); i <= cols[1]; ++i) {
                Object obj;
                Cell cell = srcSheet.getCell(srcPoint.y, i, false);
                if (cell == null || (obj = cell.getUserObjectValue("ITEM")) == null || !(obj instanceof ItemFormula)) continue;
                ItemFormula f = (ItemFormula)obj;
                itemsMap.put(i, new String[]{f.getItemNumber(), f.getDataElementNumber()});
                items.put(f.getItemNumber(), null);
                dataElements.put(f.getDataElementNumber(), null);
                if (dataElementNumbers.contains(f.getDataElementNumber())) continue;
                dataElementNumbers.add(f.getDataElementNumber());
            }
        }
        RPTItemCollection itemColl = RPTItemFactory.getRemoteInstance().getRPTItemCollection(" select number,name where number in(" + CslRptUtil.collection2String(items.keySet(), (String)",", (boolean)true) + ")");
        items.clear();
        for (int i2 = 0; i2 < itemColl.size(); ++i2) {
            items.put(itemColl.get(i2).getNumber(), itemColl.get(i2).getName());
        }
        DataElementCollection coll = DataElementFactory.getRemoteInstance().getDataElementCollection(" select number,name where number in(" + CslRptUtil.collection2String(dataElements.keySet(), (String)",", (boolean)true) + ")");
        dataElements.clear();
        for (i = 0; i < coll.size(); ++i) {
            dataElements.put(coll.get(i).getNumber(), coll.get(i).getName());
        }
        OneToManyMap itemDataElementMap = new OneToManyMap();
        RowColChangeUtils utils = new RowColChangeUtils();
        for (Integer col : itemsMap.keySet()) {
            String[] itemDataElement = (String[])itemsMap.get(col);
            ItemDataElementInfo info = utils.new ItemDataElementInfo();
            info.col = col;
            info.dataElementName = (String)dataElements.get(itemDataElement[1]);
            info.itemName = (String)items.get(itemDataElement[0]);
            info.dataElementNumber = itemDataElement[1];
            itemDataElementMap.put(info.itemName, info);
        }
        items.clear();
        dataElements.clear();
        return itemDataElementMap;
    }

    public static List<Integer[]> getItemCols(Sheet srcSheet, RowColChangeBasePoint pointInfo) throws Exception {
        String[] cells;
        ArrayList<Integer[]> itemCols = new ArrayList<Integer[]>();
        for (String cell : cells = pointInfo.getSrcChangeCols().split(";")) {
            Range range = srcSheet.getRange(cell);
            itemCols.add(new Integer[]{range.getBlock(0).getCol(), range.getBlock(0).getCol2()});
        }
        return itemCols;
    }

    public static void handleFormula(Sheet sheet, Cell basePointCell, DynaParameters srcParam) throws Exception {
        RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
        styleParam.setInsertInherit(true);
        styleParam.setStandardPoint(new Point(basePointCell.getCol(), basePointCell.getRow()));
        styleParam.setStartRow(basePointCell.getRow() + 1);
        styleParam.setEndRow(basePointCell.getRow() + srcParam.getDefaultCounter() + 1);
        styleParam.setStartColumn(basePointCell.getCol());
        styleParam.setEndColumn(sheet.getCols().getMaxIntMark());
        StyleDecoratorFormula sytleInherit = new StyleDecoratorFormula((IRptSheetSytleInherit)new RptSheetSytleInherit());
        sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
        sheet.calc();
        for (int r = basePointCell.getRow() + 2; r <= sheet.getMaxRowIndex(); ++r) {
            for (int c = basePointCell.getCol(); c <= sheet.getMaxColIndex(); ++c) {
                Cell cell = sheet.getCell(r, c, false);
                if (cell == null || cell.getFormula() == null || !cell.getFormula().trim().startsWith("=")) continue;
                Variant value = cell.getValue();
                cell.setFormula(null);
                cell.setValue(value);
            }
        }
    }

    public static void setFormulaToFirstRow(Sheet sheet, Sheet srcSheet, Cell basePointCell, Point srcPoint) throws Exception {
        int srcPointRow = (Integer)basePointCell.getUserObjectValue("srcPoint");
        for (int c = basePointCell.getCol() + 1; c <= sheet.getMaxColIndex(); ++c) {
            Cell headCell = sheet.getCell(basePointCell.getRow(), c, false);
            if (headCell == null || headCell.getUserObjectValue("formula") == null || !headCell.getUserObjectValue("formula").toString().trim().startsWith("=")) continue;
            String formula = headCell.getUserObjectValue("formula").toString();
            sheet.getCell(basePointCell.getRow() + 1, c, true).setFormula(formula);
        }
    }

    public static RowColChangeBasePoint getPointInfo(Cell basePoint) throws Exception {
        Object obj;
        if (basePoint != null && (obj = basePoint.getUserObjectValue(rowColChangePoint)) != null) {
            RowColChangeBasePoint pointInfo = new RowColChangeBasePoint();
            pointInfo.fromSerialString(obj.toString());
            return pointInfo;
        }
        return null;
    }

    public static Cell getBasePoint(Sheet sheet) {
        if (sheet.getUserObjectValue(isRowColChangeSheet) != null) {
            int rowCount = sheet.getRows().getMaxIntMark() + 1;
            int columnCount = sheet.getCols().getMaxIntMark() + 1;
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    Cell cell = sheet.getCell(i, j, false);
                    if (!RowColChangeUtils.isRowColChangeBasePoint(cell)) continue;
                    return cell;
                }
            }
        }
        return null;
    }

    public static boolean isRowColChangeBasePoint(Cell cell) {
        Object Obj;
        return cell != null && (Obj = cell.getUserObjectValue(rowColChangePoint)) != null;
    }

    public class ItemDataElementInfo {
        public int col = -1;
        public String itemName = null;
        public String dataElementName = null;
        public String dataElementNumber = null;
    }
}

