/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.CslMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.cslworktable.CslTemplateTypeEnum;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.AbstractCslReportQueryPanel;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWkTbReportProcessUI;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.AbstractCslRptWktbContext;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslReportCondition;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslRptWktbContext;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslTmplNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslTmplQueryDataCache;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.RptComboBoxModel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class CslReportQueryPanel
extends AbstractCslReportQueryPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CslReportQueryPanel.class);
    private MnsUnionF7 orgUnionf7 = null;
    private OrgTreeCollection orgTreeColl = null;
    private CurrencyCollection currencyCol = null;
    private OrgTreeInfo curOrgTreeInfo = null;
    private FullOrgUnitInfo curOrgUnitInfo = null;
    private OrgStructureInfo orgStructureInfo = null;
    private CslTmplQueryDataCache cslTmpCache = null;
    private String cacheKey = null;
    private CslMergeSoluInfo curSoluInfo = null;
    private boolean isFire = true;
    private boolean isLoaded = false;
    private ChangeListener[] spnyearChgLstn;
    private ChangeListener[] spnperiodChgLstn;
    private DefaultTreeModel tmplTreeModel;
    private KDTreeNode tmplTreeNodeRoot = new KDTreeNode((Object)ReportTypeEnum.TEMPLATE);
    private int[] preYearAndPeriod = new int[]{0, 0};
    private boolean isOrgTreeCollInited = false;

    public CslReportQueryPanel(CoreUI ui) throws Exception {
        super(ui);
        this.initSelfListener();
        this.collectChangeListener();
        this.cslTmpCache = new CslTmplQueryDataCache();
        this.onLoad();
        this.isLoaded = true;
        this.setTreeTitle();
    }

    protected void onLoad() throws Exception {
        try {
            this.tmplTreeModel = (DefaultTreeModel)this.tmplTree.getModel();
            this.initSelfUI();
            this.initPrmtOrgBound();
            this.curOrgTreeInfo = this.getCslRptWktbContext().getOrgTreeInfo();
            this.curOrgUnitInfo = this.getCslRptWktbContext().getFullOrgUnitInfo();
            this.orgStructureInfo = this.getCslRptWktbContext().getOrgStructureInfo();
            this.initSolution();
            while (this.prmtCslSolution.getValue() == null && !this.isOrgTreeCollInited) {
                Thread.sleep(10L);
            }
            this.prmtOrgBound.setData((Object)this.curOrgTreeInfo);
            if (this.prmtCslSolution.getValue() == null) {
                this.refreshOrgTree();
            }
            this.selectedOrgNodeByGivenCompany(this.orgStructureInfo);
            this.tabTree.setSelectedIndex(1);
            this.orgTree.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void selectedOrgNodeByGivenCompany(Object company) {
        String orgPK = null;
        if (company instanceof String) {
            orgPK = (String)company;
        } else if (company instanceof OrgStructureInfo) {
            orgPK = ((OrgStructureInfo)company).getId().toString();
        }
        KDTreeNode findedNode = this.findOrgNode(orgPK);
        if (findedNode != null) {
            this.orgTree.setSelectionNode((DefaultKingdeeTreeNode)findedNode);
            this.orgTree.scrollPathToVisible(this.orgTree.getLeadSelectionPath());
        }
    }

    private KDTreeNode findOrgNode(String orgPK) {
        KDTreeNode childrenNode = null;
        if (this.orgTree.getLastSelectedPathComponent() != null) {
            Enumeration enumt = ((KDTreeNode)this.orgTree.getLastSelectedPathComponent()).children();
            childrenNode = this.findOrgNode(enumt, orgPK);
        }
        return childrenNode;
    }

    private KDTreeNode findOrgNode(Enumeration enumt, String orgPK) {
        KDTreeNode childrenNode = null;
        while (enumt.hasMoreElements()) {
            childrenNode = (KDTreeNode)enumt.nextElement();
            OrgStructureInfo defineInfo = (OrgStructureInfo)childrenNode.getUserObject();
            if (orgPK.equals(defineInfo.getId().toString())) {
                return childrenNode;
            }
            Enumeration childEnumt = childrenNode.children();
            if (!childEnumt.hasMoreElements() || (childrenNode = this.findOrgNode(childEnumt, orgPK)) == null) continue;
            return childrenNode;
        }
        return null;
    }

    public void handleException(Exception e) {
        this.rptEditUI.handUIException((Throwable)e);
        SysUtil.abort();
    }

    private void collectChangeListener() {
        this.spnyearChgLstn = this.spnyear.getChangeListeners();
        this.spnperiodChgLstn = this.spnperiod.getChangeListeners();
    }

    private void setTreeTitle() {
        if (!this.isLoaded) {
            return;
        }
        if (this.orgTree.getLastSelectedPathComponent() != null) {
            OrgStructureInfo orgInfo = (OrgStructureInfo)this.getSelectedOrgNode().getUserObject();
            String companyName = orgInfo.getUnit().getName();
            this.tmplTreeView.setTitle(companyName);
            this.orgTreeView.setTitle(companyName);
        }
    }

    private void clearTreeView() {
        this.tmplTreeView.setTitle(null);
        this.orgTreeView.setTitle(null);
    }

    private KDTreeNode getSelectedOrgNode() {
        return (KDTreeNode)this.orgTree.getLastSelectedPathComponent();
    }

    private void initSolution() {
        EntityViewInfo view = this.prmtCslSolution.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            this.prmtCslSolution.setEntityViewInfo(view);
            view.getFilter().appendFilterItem("trackRecordCreator.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            view.getFilter().appendFilterItem("isFreezed", (Object)0);
        }
        this.curSoluInfo = this.getCslRptWktbContext().getCslMergeSoluInfo();
        if (this.curSoluInfo != null) {
            this.prmtCslSolution.setData((Object)this.curSoluInfo);
        }
    }

    private void initPrmtOrgBound() {
        if (this.prmtCslSolution.getValue() != null) {
            this.prmtOrgBound.setEnabled(false);
            this.orgTreeColl = this.getCslRptWktbContext().getOrgTreeCollection();
        } else {
            if (this.orgUnionf7 == null) {
                this.orgUnionf7 = new MnsUnionF7();
                if (this.orgTreeColl == null) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                CslReportQueryPanel.this.orgUnionf7.setCanStart(false);
                                CslReportQueryPanel.this.orgTreeColl = CslWorkTableUIUtil.getAllOrgTreeColl();
                                CslReportQueryPanel.this.isOrgTreeCollInited = true;
                                CslReportQueryPanel.this.orgUnionf7.setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl(CslReportQueryPanel.this.orgTreeColl, (Date)CslReportQueryPanel.this.datepicker.getValue()));
                                CslReportQueryPanel.this.orgUnionf7.initUI();
                                CslReportQueryPanel.this.orgUnionf7.reRoadOrgTree();
                            }
                            catch (Exception e) {
                                logger.error((Object)"getOrgTreeCollection error", (Throwable)e);
                            }
                            finally {
                                CslReportQueryPanel.this.isOrgTreeCollInited = true;
                                CslReportQueryPanel.this.orgUnionf7.setCanStart(true);
                            }
                        }
                    }.start();
                }
                this.orgUnionf7.setShowAssistantOrg(true);
                this.orgUnionf7.setCheckedAssistantOrgChkBox(true);
                this.orgUnionf7.setEnableCurOrgTreeRootNode(true);
                this.orgUnionf7.setMultiSelect(false);
                this.orgUnionf7.setSelectMode(2);
                this.orgUnionf7.setCascadingSelection(false);
                HashSet selectOrgIdSet = new HashSet();
                this.orgUnionf7.setCheckedOrgIDs(selectOrgIdSet);
                this.orgUnionf7.setUnChangeableOrgIDs(selectOrgIdSet);
            }
            this.prmtOrgBound.setSelector((KDPromptSelector)this.orgUnionf7);
            this.prmtOrgBound.setEditable(false);
        }
    }

    public void refreshOrgBound() {
        try {
            while (!this.isOrgTreeCollInited) {
                Thread.sleep(10L);
            }
            CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(this.curSoluInfo, this.prmtOrgBound, this.orgTree, null, this.orgTreeColl, (Date)this.datepicker.getValue(), this.curOrgUnitInfo != null ? this.curOrgUnitInfo.getNumber() : null, null, false);
        }
        catch (Exception e) {
            logger.error((Object)"period.addChangeListener", (Throwable)e);
        }
    }

    protected void initSelfUI() throws Exception {
        if (this.isLoaded) {
            this.preYearAndPeriod[0] = this.spnyear.getIntegerVlaue();
            this.preYearAndPeriod[1] = this.spnperiod.getIntegerVlaue();
        }
        if (!this.isLoaded) {
            this.initOnlyOne();
            CurrencyInfo currCurrency = this.getCslRptWktbContext().getQueryCurrencyInfo();
            this.setCurrencySelect(currCurrency);
        }
        int[] yearPeriod = this.getCurrentPeriod();
        CslRptUIUtil.setSpineRange((KDSpinner)this.spnyear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        CslWorkTableUIUtil.setSpineRangeByPeriodType(this.spnperiod, (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem(), yearPeriod[0], true, true);
        this.spnyear.setValue((Object)yearPeriod[0]);
        this.spnperiod.setValue((Object)yearPeriod[1]);
        this.datepicker.setValue((Object)RPTDateUtil.getPeriodLastDate((int)yearPeriod[0], (int)yearPeriod[1], (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())));
        this.setComponentVisable();
    }

    private void setComponentVisable() {
        RptPeriodTypeEnum periodType = this.getSelectedPeriodType();
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType) || RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            this.kDLabelContainer2.setVisible(true);
            this.kDLabelContainer3.setVisible(false);
            this.kDLabelContainer4.setVisible(false);
            this.kDLabelContainer5.setVisible(false);
        } else {
            this.kDLabelContainer2.setVisible(false);
            this.kDLabelContainer3.setVisible(true);
            this.kDLabelContainer4.setVisible(true);
            this.kDLabelContainer5.setVisible(true);
        }
    }

    private RptPeriodTypeEnum getSelectedPeriodType() {
        return (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
    }

    private void setCurrencySelect(CurrencyInfo currency) throws Exception {
        if (currency != null) {
            for (int i = 0; i < this.cmbcurrency.getItemCount(); ++i) {
                if (!((CurrencyInfo)this.cmbcurrency.getItemAt(i)).getId().toString().equals(currency.getId().toString())) continue;
                this.cmbcurrency.setSelectedIndex(i);
                return;
            }
        }
    }

    private void initOnlyOne() throws BOSException {
        this.cmbPeriodType.removeAllItems();
        this.cmbPeriodType.addItems(RptPeriodTypeEnum.getEnumList().toArray());
        RptPeriodTypeEnum defaultPeriodType = this.getCslRptPeriodTypeFromContext() == null ? RptPeriodTypeEnum.MONTHLY : this.getCslRptPeriodTypeFromContext();
        this.cmbPeriodType.setSelectedItem((Object)defaultPeriodType);
        this.currencyCol = this.getCslRptWktbContext().getCurrencyCol();
        this.cmbcurrency.setModel((ComboBoxModel)new RptComboBoxModel((IObjectCollection)this.currencyCol));
    }

    private RptPeriodTypeEnum getCslRptPeriodTypeFromContext() {
        try {
            return this.getCslRptWktbContext().getQueryPeriodType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int[] getCurrentPeriod() throws EASBizException, BOSException {
        int[] yearperiod;
        if (!this.isLoaded && (yearperiod = this.getYearPeriodFromContext()) != null) {
            return yearperiod;
        }
        boolean isTrue = this.preYearAndPeriod == null ? false : this.preYearAndPeriod[0] > 0 && this.preYearAndPeriod[1] > 0;
        return isTrue ? this.preYearAndPeriod : RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem()));
    }

    private int[] getYearPeriodFromContext() {
        try {
            int year = this.getCslRptWktbContext().getQueryYear();
            int period = this.getCslRptWktbContext().getQueryPeriod();
            if (year <= 0 || period <= 0) {
                return null;
            }
            return new int[]{year, period};
        }
        catch (Exception e) {
            return null;
        }
    }

    private AbstractCslRptWktbContext getCslRptWktbContext() {
        try {
            return CslRptWktbContext.getContext();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void refreshOrgTree() {
        try {
            CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(this.curSoluInfo, this.prmtOrgBound, this.orgTree, null, this.orgTreeColl, (Date)this.datepicker.getValue(), this.curOrgUnitInfo != null ? this.curOrgUnitInfo.getNumber() : null, null, true);
            this.orgTree.setSelectionRow(0);
        }
        catch (Exception e1) {
            logger.error((Object)"year.addChangeListener", (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    private void initSelfListener() {
        this.prmtCslSolution.addDataChangeListener(new DataChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataChanged(DataChangeEvent eventObj) {
                if (CslReportQueryPanel.this.isFire) {
                    if (CslReportQueryPanel.this.prmtCslSolution.getData() == null) {
                        CslReportQueryPanel.this.initPrmtOrgBound();
                        CslReportQueryPanel.this.cmbPeriodType.setEnabled(true);
                        CslReportQueryPanel.this.prmtOrgBound.setEnabled(true);
                        CslReportQueryPanel.this.cmbcurrency.setEnabled(true);
                        CslReportQueryPanel.this.curSoluInfo = null;
                        CslReportQueryPanel.this.prmtOrgBound.setData(null);
                        ((DefaultTreeModel)CslReportQueryPanel.this.orgTree.getModel()).setRoot(null);
                        ((DefaultTreeModel)CslReportQueryPanel.this.tmplTree.getModel()).setRoot(null);
                        CslReportQueryPanel.this.clearTreeView();
                    } else {
                        CslReportQueryPanel.this.cmbPeriodType.setEnabled(false);
                        CslReportQueryPanel.this.prmtOrgBound.setEnabled(false);
                        CslMergeSoluInfo soluInfo = (CslMergeSoluInfo)CslReportQueryPanel.this.prmtCslSolution.getData();
                        try {
                            CslReportQueryPanel.this.isFire = false;
                            soluInfo = CslWorkTableFacadeFactory.getRemoteInstance().getCslSoluInfo(soluInfo.getId().toString());
                            CslReportQueryPanel.this.curSoluInfo = soluInfo;
                            CslReportQueryPanel.this.cmbPeriodType.setSelectedItem((Object)soluInfo.getPeriodType());
                            CslReportQueryPanel.this.orgTreeColl = CslReportQueryPanel.this.getCslRptWktbContext().getOrgTreeCollection();
                            CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(soluInfo, CslReportQueryPanel.this.prmtOrgBound, CslReportQueryPanel.this.orgTree, null, CslReportQueryPanel.this.orgTreeColl, (Date)CslReportQueryPanel.this.datepicker.getValue(), null, null, true);
                            CslReportQueryPanel.this.curOrgTreeInfo = (OrgTreeInfo)CslReportQueryPanel.this.prmtOrgBound.getData();
                        }
                        catch (Exception e) {
                            logger.error((Object)"solutionF7.addDataChangeListener error", (Throwable)e);
                            ExceptionHandler.handle((Throwable)e);
                        }
                        finally {
                            CslReportQueryPanel.this.isFire = true;
                        }
                    }
                }
            }
        });
        this.prmtOrgBound.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (!CslReportQueryPanel.this.isLoaded) {
                    return;
                }
                if (CslReportQueryPanel.this.prmtOrgBound.getValue() != null) {
                    if (CslReportQueryPanel.this.prmtOrgBound.getData() instanceof FullOrgUnitInfo) {
                        CslReportQueryPanel.this.curOrgUnitInfo = (FullOrgUnitInfo)CslReportQueryPanel.this.prmtOrgBound.getData();
                        CslReportQueryPanel.this.curOrgTreeInfo = CslReportQueryPanel.this.orgUnionf7.getSelectedTree();
                        CslReportQueryPanel.this.prmtOrgBound.setData((Object)CslReportQueryPanel.this.curOrgTreeInfo);
                        if (CslReportQueryPanel.this.prmtCslSolution.getData() == null) {
                            CslReportQueryPanel.this.refreshOrgTree();
                        }
                    } else if (CslReportQueryPanel.this.prmtOrgBound.getData() instanceof OrgTreeInfo) {
                        CslReportQueryPanel.this.curOrgTreeInfo = (OrgTreeInfo)CslReportQueryPanel.this.prmtOrgBound.getData();
                    }
                } else {
                    CslReportQueryPanel.this.curOrgUnitInfo = null;
                    CslReportQueryPanel.this.curOrgTreeInfo = null;
                    ((DefaultTreeModel)CslReportQueryPanel.this.orgTree.getModel()).setRoot(null);
                    ((DefaultTreeModel)CslReportQueryPanel.this.tmplTree.getModel()).setRoot(null);
                    CslReportQueryPanel.this.clearTreeView();
                }
            }
        });
        this.orgTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    if (CslReportQueryPanel.this.curOrgTreeInfo != null) {
                        if (e.getNewLeadSelectionPath() != null && ((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getTextColor().equals(Color.gray)) {
                            CslReportQueryPanel.this.tmplTreeNodeRoot.removeAllChildren();
                            CslReportQueryPanel.this.tmplTreeModel.reload();
                        } else {
                            CslReportQueryPanel.this.refreshTmplTree(false);
                        }
                        CslReportQueryPanel.this.setTreeTitle();
                    }
                }
                catch (Exception e1) {
                    CslReportQueryPanel.this.handleException(e1);
                }
            }
        });
        this.orgTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CslReportQueryPanel.this.tabTree.setSelectedIndex(1);
                }
            }
        });
        this.tmplTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                KDTreeNode node = (KDTreeNode)event.getPath().getLastPathComponent();
                CslReportQueryPanel.this.tmplTree.setSelectionPath(event.getPath());
                if (node.getUserObject() == CslTemplateTypeEnum.SUMREPORT) {
                    ArrayList<Integer> sumTmpList = new ArrayList<Integer>();
                    ArrayList<Integer> sumList = new ArrayList<Integer>();
                    sumTmpList.add(3);
                    sumTmpList.add(11);
                    sumList.add(2);
                    sumList.add(11);
                    CslReportQueryPanel.this.loadTmpl(sumTmpList, sumList, node);
                } else if (node.getUserObject() == CslTemplateTypeEnum.MNSREPORT) {
                    ArrayList<Integer> mnsTmpList = new ArrayList<Integer>();
                    ArrayList<Integer> mnsList = new ArrayList<Integer>();
                    mnsTmpList.add(4);
                    mnsList.add(4);
                    CslReportQueryPanel.this.loadTmpl(mnsTmpList, mnsList, node);
                } else if (node.getUserObject() == CslTemplateTypeEnum.CSLREPORT) {
                    ArrayList<Integer> cslTmpList = new ArrayList<Integer>();
                    ArrayList<Integer> cslList = new ArrayList<Integer>();
                    cslTmpList.add(5);
                    cslTmpList.add(13);
                    cslList.add(3);
                    cslList.add(12);
                    CslReportQueryPanel.this.loadTmpl(cslTmpList, cslList, node);
                } else if (node.getUserObject() == CslTemplateTypeEnum.ELIMREPORT) {
                    ArrayList elimTmpList = new ArrayList();
                    ArrayList<Integer> elimList = new ArrayList<Integer>();
                    elimList.add(42);
                    CslReportQueryPanel.this.loadTmpl(elimTmpList, elimList, node);
                }
                if (node.isLeaf()) {
                    node.setCustomIcon(UIManager.getIcon("Tree.openIcon"));
                }
            }
        });
        this.tmplTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (CslReportQueryPanel.this.getSelectedTmplTreeNode().getUserObject() instanceof CslTmplNodeUserDefineInfo) {
                        CslReportQueryPanel.this.openReport();
                    } else {
                        if (!CslReportQueryPanel.this.getSelectedTmplTreeNode().isLeaf()) {
                            return;
                        }
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"16_ReportQueryPanel"));
                        SysUtil.abort();
                    }
                }
            }
        });
        this.cmbPeriodType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && CslReportQueryPanel.this.isLoaded) {
                    CslReportQueryPanel.this.updateTimeComponent();
                    CslReportQueryPanel.this.refreshOrgBound();
                    CslReportQueryPanel.this.refreshTmplTree(false);
                }
            }
        });
        this.datepicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (CslReportQueryPanel.this.isLoaded) {
                    CslReportQueryPanel.this.updateYearAndPeriod();
                    CslReportQueryPanel.this.refreshOrgBound();
                    CslReportQueryPanel.this.refreshTmplTree(false);
                }
            }
        });
        this.spnyear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CslReportQueryPanel.this.isLoaded) {
                    return;
                }
                CslReportQueryPanel.this.removeDatePickedLst();
                CslReportQueryPanel.this.initDatePick();
                CslReportQueryPanel.this.refreshOrgBound();
                CslReportQueryPanel.this.refreshTmplTree(false);
                CslReportQueryPanel.this.addDatePickedLst();
            }
        });
        this.spnperiod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CslReportQueryPanel.this.isLoaded) {
                    return;
                }
                CslReportQueryPanel.this.removeDatePickedLst();
                CslReportQueryPanel.this.initDatePick();
                CslReportQueryPanel.this.refreshOrgBound();
                CslReportQueryPanel.this.refreshTmplTree(false);
                CslReportQueryPanel.this.addDatePickedLst();
            }
        });
        this.cmbcurrency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CslReportQueryPanel.this.isLoaded) {
                    return;
                }
                CslReportQueryPanel.this.refreshTmplTree(false);
            }
        });
    }

    public void updateYearAndPeriod() {
        this.removeSpnYearChgLst();
        this.removeSpnPeriodChgLst();
        this.removeDatePickedLst();
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeE.equals((Object)RptPeriodTypeEnum.DAILY) || RptPeriodTypeE.equals((Object)RptPeriodTypeEnum.WEEKLY)) {
            this.setYearAndPeriod();
        } else {
            this.initDatePick();
        }
        this.addSpnPeriodChgLst();
        this.addSpnYearChgLst();
        this.addDatePickedLst();
    }

    private void setYearAndPeriod() {
        Date date;
        RptPeriodTypeEnum RptPeriodTypeE = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (RptPeriodTypeE != null && (date = (Date)this.datepicker.getValue()) != null) {
            int[] yearPeriod = RPTDateUtil.getPeriod((Date)date, (RptPeriodTypeEnum)RptPeriodTypeE);
            this.spnyear.setValue((Object)yearPeriod[0]);
            this.spnperiod.setValue((Object)yearPeriod[1]);
        }
    }

    public void initDatePick() {
        int period = this.spnperiod.getIntegerVlaue();
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)this.getSelectedPeriodType())) {
            period = period >= 13 ? 12 : period;
        }
        this.datepicker.setValue((Object)RPTDateUtil.getPeriodLastDate((int)this.spnyear.getIntegerVlaue(), (int)period, (RptPeriodTypeEnum)((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem())));
    }

    protected KDTreeNode getSelectedTmplTreeNode() {
        KDTreeNode selectedTreeNode = (KDTreeNode)this.tmplTree.getLastSelectedPathComponent();
        if (selectedTreeNode == null) {
            selectedTreeNode = new KDTreeNode((Object)new Integer(1));
        }
        return selectedTreeNode;
    }

    private void removeSpnYearChgLst() {
        if (this.spnyearChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnyearChgLstn.length; ++i) {
            this.spnyear.removeChangeListener(this.spnyearChgLstn[i]);
        }
    }

    private void removeSpnPeriodChgLst() {
        if (this.spnperiodChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnperiodChgLstn.length; ++i) {
            this.spnperiod.removeChangeListener(this.spnperiodChgLstn[i]);
        }
    }

    private void removeDatePickedLst() {
        this.datepicker.getEditor().setDataChangeListenerFired(false);
    }

    private void addSpnYearChgLst() {
        if (this.spnyearChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnyearChgLstn.length; ++i) {
            this.spnyear.addChangeListener(this.spnyearChgLstn[i]);
        }
    }

    private void addSpnPeriodChgLst() {
        if (this.spnperiodChgLstn == null) {
            return;
        }
        for (int i = 0; i < this.spnperiodChgLstn.length; ++i) {
            this.spnperiod.addChangeListener(this.spnperiodChgLstn[i]);
        }
    }

    private void addDatePickedLst() {
        this.datepicker.getEditor().setDataChangeListenerFired(true);
    }

    public CslReportCondition getCslReportCondition() throws Exception {
        CslReportCondition condition = new CslReportCondition();
        OrgStructureInfo userdefine = (OrgStructureInfo)this.getSelectedOrgNode().getUserObject();
        condition.setPeriodType((RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem());
        condition.setYear(this.spnyear.getIntegerVlaue());
        condition.setPeriod(this.spnperiod.getIntegerVlaue());
        condition.setCurrency((CurrencyInfo)this.cmbcurrency.getSelectedItem());
        condition.setOrgNodeInfo(userdefine);
        condition.setTmplNodeInfo(this.getSelectedTmplNodeInfo());
        if (this.prmtCslSolution.getData() != null) {
            condition.setSoluInfo((CslMergeSoluInfo)this.prmtCslSolution.getData());
        }
        condition.setTreeInfo((OrgTreeInfo)this.prmtOrgBound.getData());
        return condition;
    }

    private CslTmplNodeUserDefineInfo getSelectedTmplNodeInfo() {
        Object userObj = this.getSelectedTmplTreeNode().getUserObject();
        return userObj instanceof CslTmplNodeUserDefineInfo ? (CslTmplNodeUserDefineInfo)this.getSelectedTmplTreeNode().getUserObject() : null;
    }

    public boolean isTemplateNode() {
        return this.getSelectedTmplTreeNode().getUserObject() instanceof CslTmplNodeUserDefineInfo;
    }

    private void loadTmpl(List tmpTypeList, List typeList, KDTreeNode node) {
        List<CslTmplNodeUserDefineInfo> reports = this.cslTmpCache.getDataFromCache(this.cacheKey);
        if (reports != null && reports.size() > 0) {
            node.removeAllChildren();
            for (int i = reports.size() - 1; i >= 0; --i) {
                KDTreeNode newChild;
                CslTmplNodeUserDefineInfo info = reports.get(i);
                int type = info.getTmplType();
                boolean isTemplate = info.isTemplate();
                if (isTemplate) {
                    if (!tmpTypeList.contains(type)) continue;
                    newChild = new KDTreeNode((Object)info);
                    newChild.setAllowsChildren(false);
                    info.setNode(newChild);
                    info.setReportID(null);
                    newChild.setTextColor(Color.black);
                    this.tmplTreeModel.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)node, 0);
                    continue;
                }
                if (!typeList.contains(type)) continue;
                newChild = new KDTreeNode((Object)info);
                newChild.setAllowsChildren(false);
                info.setNode(newChild);
                info.setReportID(info.getTmplID());
                newChild.setTextColor(Color.blue);
                this.tmplTreeModel.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)node, 0);
            }
            this.tmplTreeModel.reload((TreeNode)node);
        }
    }

    public void refreshTmplTree(boolean isFromProcessUI) {
        this.tmplTreeNodeRoot.removeAllChildren();
        this.queryTmplTreeData(isFromProcessUI);
        this.tmplTreeModel.setAsksAllowsChildren(true);
        this.tmplTreeModel.setRoot((TreeNode)this.tmplTreeNodeRoot);
        this.tmplTree.expandAllNodes(true, (TreeNode)this.tmplTreeNodeRoot);
    }

    private void queryTmplTreeData(boolean isFromProcessUI) {
        List<CslTmplNodeUserDefineInfo> reports = null;
        if (this.orgTree.getLastSelectedPathComponent() != null) {
            if (((KDTreeNode)this.orgTree.getLastSelectedPathComponent()).getTextColor().equals(Color.gray)) {
                this.tmplTreeNodeRoot.removeAllChildren();
                return;
            }
            Map conditions = this.getCondition();
            if (this.cslTmpCache.hasCache(this.cacheKey) && !isFromProcessUI) {
                reports = this.cslTmpCache.getDataFromCache(this.cacheKey);
            } else {
                try {
                    if (!conditions.isEmpty()) {
                        reports = CslWorkTableFacadeFactory.getRemoteInstance().getReports(conditions);
                        this.cslTmpCache.cacheQueryData(this.cacheKey.toString(), reports);
                        reports = this.cslTmpCache.getDataFromCache(this.cacheKey);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"refreshTable error", (Throwable)e);
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (reports != null && !reports.isEmpty()) {
                this.buildTmplTreeBaseRoot(reports);
            }
        }
    }

    private void buildTmplTreeBaseRoot(List<CslTmplNodeUserDefineInfo> reports) {
        Color color;
        KDTreeNode sumNode = new KDTreeNode((Object)CslTemplateTypeEnum.SUMREPORT.getAlias());
        sumNode.setUserObject((Object)CslTemplateTypeEnum.SUMREPORT);
        KDTreeNode mnsNode = new KDTreeNode((Object)CslTemplateTypeEnum.MNSREPORT.getAlias());
        mnsNode.setUserObject((Object)CslTemplateTypeEnum.MNSREPORT);
        KDTreeNode cslNode = new KDTreeNode((Object)CslTemplateTypeEnum.CSLREPORT.getAlias());
        cslNode.setUserObject((Object)CslTemplateTypeEnum.CSLREPORT);
        KDTreeNode elimNode = new KDTreeNode((Object)CslTemplateTypeEnum.ELIMREPORT.getAlias());
        elimNode.setUserObject((Object)CslTemplateTypeEnum.ELIMREPORT);
        Map isExistTmpType = this.isExistTmpType(reports, (DefaultKingdeeTreeNode)sumNode, (DefaultKingdeeTreeNode)mnsNode, (DefaultKingdeeTreeNode)cslNode, (DefaultKingdeeTreeNode)elimNode);
        if (Boolean.valueOf(isExistTmpType.get(sumNode).toString()).booleanValue()) {
            color = new Color(96, 204, 249);
            sumNode.setTextColor(color);
            this.tmplTreeNodeRoot.add((MutableTreeNode)sumNode);
        }
        if (Boolean.valueOf(isExistTmpType.get(mnsNode).toString()).booleanValue()) {
            color = new Color(39, 159, 91);
            mnsNode.setTextColor(color);
            this.tmplTreeNodeRoot.add((MutableTreeNode)mnsNode);
        }
        if (Boolean.valueOf(isExistTmpType.get(cslNode).toString()).booleanValue()) {
            color = new Color(228, 108, 10);
            cslNode.setTextColor(color);
            this.tmplTreeNodeRoot.add((MutableTreeNode)cslNode);
        }
        if (Boolean.valueOf(isExistTmpType.get(elimNode).toString()).booleanValue()) {
            this.tmplTreeNodeRoot.add((MutableTreeNode)elimNode);
        }
    }

    private Map isExistTmpType(List<CslTmplNodeUserDefineInfo> reports, DefaultKingdeeTreeNode sumNode, DefaultKingdeeTreeNode mnsNode, DefaultKingdeeTreeNode cslNode, DefaultKingdeeTreeNode elimNode) {
        HashMap<DefaultKingdeeTreeNode, Boolean> map = new HashMap<DefaultKingdeeTreeNode, Boolean>();
        map.put(sumNode, Boolean.FALSE);
        map.put(mnsNode, Boolean.FALSE);
        map.put(cslNode, Boolean.FALSE);
        map.put(elimNode, Boolean.FALSE);
        for (CslTmplNodeUserDefineInfo info : reports) {
            boolean isTemplate = info.isTemplate();
            int rptType = info.getTmplType();
            if (isTemplate) {
                if (3 == rptType || 11 == rptType) {
                    map.put(sumNode, Boolean.TRUE);
                    continue;
                }
                if (4 == rptType) {
                    map.put(mnsNode, Boolean.TRUE);
                    continue;
                }
                if (5 != rptType && 13 != rptType) continue;
                map.put(cslNode, Boolean.TRUE);
                continue;
            }
            if (2 == rptType || 11 == rptType) {
                map.put(sumNode, Boolean.TRUE);
                continue;
            }
            if (4 == rptType) {
                map.put(mnsNode, Boolean.TRUE);
                continue;
            }
            if (3 == rptType || 12 == rptType) {
                map.put(cslNode, Boolean.TRUE);
                continue;
            }
            if (42 != rptType) continue;
            map.put(elimNode, Boolean.TRUE);
        }
        return map;
    }

    public Map getCondition() {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        StringBuffer cacheKey = new StringBuffer();
        String treeid = this.curOrgTreeInfo.getId().toString();
        condition.put("orgTreeId", treeid);
        cacheKey.append(treeid).append("#");
        OrgStructureInfo orgInfo = (OrgStructureInfo)((KDTreeNode)this.orgTree.getLastSelectedPathComponent()).getUserObject();
        if (orgInfo != null) {
            String orgid = orgInfo.getUnit().getId().toString();
            cacheKey.append(orgid).append("#");
            condition.put("orgUnitId", orgid);
            condition.put("orgUnitName", orgInfo.getUnit().getName());
            condition.put("orgUnitNumber", orgInfo.getUnit().getNumber());
        }
        RptPeriodTypeEnum queryPeriodType = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        cacheKey.append(queryPeriodType.getValue()).append("#");
        condition.put("periodType", queryPeriodType.getValue());
        condition.put("year", this.spnyear.getIntegerVlaue());
        cacheKey.append(this.spnyear.getIntegerVlaue()).append("#");
        condition.put("period", this.spnperiod.getIntegerVlaue());
        cacheKey.append(this.spnperiod.getIntegerVlaue()).append("#");
        cacheKey.append(((Date)this.datepicker.getValue()).getTime()).append("#");
        CurrencyInfo currency = (CurrencyInfo)this.cmbcurrency.getSelectedItem();
        String currencyid = currency.getId().toString();
        cacheKey.append(currencyid).append("#");
        condition.put("currencyId", currencyid);
        condition.put("currencyName", currency.getName());
        condition.put("rptType", 0);
        condition.put("rptStatus", new Boolean[]{true, true, true, true});
        if (this.curSoluInfo != null) {
            cacheKey.append(this.curSoluInfo.getId().toString());
            if (this.curSoluInfo.getTemplateGroupSet() != null && !this.curSoluInfo.getTemplateGroupSet().isEmpty()) {
                condition.put("templateGroups", this.curSoluInfo.getTemplateGroupSet());
            }
        }
        this.cacheKey = cacheKey.toString();
        return condition;
    }

    private void updateTimeComponent() {
        this.removeSpnYearChgLst();
        this.removeSpnPeriodChgLst();
        this.removeDatePickedLst();
        this.setComponentVisable();
        this.setYearAndPeriod();
        this.initDatePick();
        this.addSpnPeriodChgLst();
        this.addSpnYearChgLst();
        this.addDatePickedLst();
    }

    @Override
    public void jbInit() throws Exception {
        super.jbInit();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    private void openReport() {
        this.getCslRptReportProcessUI().openReport();
    }

    private CslWkTbReportProcessUI getCslRptReportProcessUI() {
        return (CslWkTbReportProcessUI)this.rptEditUI;
    }
}

