/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.newrpt.ReportProcessException;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.designer.BaseReportDesignerUI;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.ReportStyleCover;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.IShowWindow;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.client.rptnewui.KDTabbedPaneExt;
import com.kingdee.eas.fi.newrpt.client.rptnewui.KingdeeTabbedPaneExtUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.event.ITabbedPaneMouseListener;
import com.kingdee.eas.fi.newrpt.client.rptnewui.event.TabbedPaneAddNewTabListener;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.MultiRptPropertiesManager;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.SingleRptProperties;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslReportQueryPanel;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslReportCondition;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslTmplNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.stat.StatisticalResult;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.template.TemplateProvider;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CslWkTbReportProcessUI
extends BaseReportDesignerUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CslWkTbReportProcessUI.class);
    private boolean isOnLoad = false;
    private KDTabbedPaneExt tabpane = null;
    private KDSplitPane splitpane = null;
    private CslReportQueryPanel queryPanel = null;
    private final int limited = 13;
    private ICslReport iCslReport;
    private SumRptProcessUI sumRptProcessUI;
    private MnsRptProcessUI mnsRptProcessUI;
    private CslRptProcessUI cslRptProcessUI;
    private int type;
    private KDToolBar preToolBar;
    private Component[] toolCommonComps;
    private final MultiRptPropertiesManager manager = new MultiRptPropertiesManager();
    private String oprtStatus;
    private boolean isAddNewReportTab = false;
    private String cslWorkTableListUIOprtStatus = null;
    private String reportTabOprtStatus = null;

    public CslWkTbReportProcessUI() throws Exception {
        this.initJb();
        this.initEventListener();
    }

    @Override
    public void onLoad() throws Exception {
        this.btnGenVoucher.setVisible(false);
        CslReportInfo cslReportInfo = this.getCslReportInfo();
        this.initType(cslReportInfo);
        this.initProcessUI(cslReportInfo, this.getOprtState(cslReportInfo));
        this.initReoprtLayout();
        this.adjustComponentObject();
        this.removebtnCloud();
        if (!this.isOnLoad) {
            this.initRptSelfProperties(false);
        }
        this.isOnLoad = true;
    }

    @Override
    protected void calculate(StatisticalResult result) {
    }

    @Override
    protected void beforeCalculate() {
    }

    @Override
    protected void afterCalculate() {
    }

    @Override
    public void onShow() {
        if (this.type == 1) {
            this.sumRptProcessUI.onShow();
        } else if (this.type == 2) {
            this.mnsRptProcessUI.onShow();
        } else if (this.type == 3) {
            this.cslRptProcessUI.onShow();
        }
    }

    private String getOprtState(CslReportInfo cslReportInfo) {
        String adjustedOprtState;
        this.oprtStatus = adjustedOprtState = RptNewUIUtil.hasMutexLock(null, cslReportInfo.getId().toString()) || AuditedStatusEnum.AUDITED.equals((Object)cslReportInfo.getAuditedStatus()) ? OprtState.VIEW : OprtState.EDIT;
        return adjustedOprtState;
    }

    private void initType(CslReportInfo cslReportInfo) {
        int sourceType = cslReportInfo.getSourceType().getValue();
        if (sourceType == 2 || sourceType == 11) {
            this.type = 1;
        } else if (sourceType == 4) {
            this.type = 2;
        } else if (sourceType == 3 || sourceType == 12 || sourceType == 42) {
            this.type = 3;
        }
    }

    private void initProcessUI(CslReportInfo cslReportInfo, String adjustedOprtState) throws Exception {
        if (this.getUIContext().get("OprtStateForOpen") != null && OprtState.VIEW.equals(this.getUIContext().get("OprtStateForOpen")) && !this.isAddNewReportTab || this.cslWorkTableListUIOprtStatus != null && OprtState.VIEW.equals(this.cslWorkTableListUIOprtStatus) && this.isAddNewReportTab) {
            this.cslWorkTableListUIOprtStatus = null;
            adjustedOprtState = OprtState.VIEW;
            this.setOprtState(adjustedOprtState);
        }
        this.reportTabOprtStatus = adjustedOprtState;
        this.isAddNewReportTab = false;
        if (this.type == 1) {
            this.sumRptProcessUI = new SumRptProcessUI(cslReportInfo, adjustedOprtState);
            this.sumRptProcessUI.getUIContext().put("parentOwner", this);
            this.sumRptProcessUI.initUIMenuBarLayout();
            this.sumRptProcessUI.initUIToolBarLayout();
            this.sumRptProcessUI.initUIContentLayout();
            this.sumRptProcessUI.initLayout();
            this.sumRptProcessUI.onLoad();
        } else if (this.type == 2) {
            this.mnsRptProcessUI = new MnsRptProcessUI(cslReportInfo, adjustedOprtState);
            this.mnsRptProcessUI.getUIContext().put("parentOwner", this);
            this.mnsRptProcessUI.initUIMenuBarLayout();
            this.mnsRptProcessUI.initUIToolBarLayout();
            this.mnsRptProcessUI.initUIContentLayout();
            this.mnsRptProcessUI.initLayout();
            this.mnsRptProcessUI.onLoad();
        } else {
            this.cslRptProcessUI = new CslRptProcessUI(cslReportInfo, adjustedOprtState);
            this.cslRptProcessUI.getUIContext().put("parentOwner", this);
            this.cslRptProcessUI.getUIContext().put("KEY_LINKOPENRPT_PARAM", true);
            this.cslRptProcessUI.initUIMenuBarLayout();
            this.cslRptProcessUI.initUIToolBarLayout();
            this.cslRptProcessUI.initUIContentLayout();
            this.cslRptProcessUI.initLayout();
            this.cslRptProcessUI.onLoad();
        }
    }

    private void adjustComponentObject() {
        this.initCommToolBarManager();
        this.setUIMenuBar(this.createMenuBar());
        this.setUIToolBar(this.createToolBar());
        this.setStatusBar(this.createStatusBar());
        KDToolBar toolBar = this.createSpreadStyleToolBar();
        this.remove((Component)this.preToolBar);
        this.add((Component)toolBar, "North");
        toolBar.validate();
        this.preToolBar = toolBar;
    }

    private SpreadManager createSpreadManager() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getSpreadManager();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getSpreadManager();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getSpreadManager();
        }
        return null;
    }

    private IBookProvider createBookProvider() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getBookProvider();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getBookProvider();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getBookProvider();
        }
        return null;
    }

    private IReportVariableProvider createVariableProvider() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getVariableProvider();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getVariableProvider();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getVariableProvider();
        }
        return null;
    }

    private IReportPropertyAdapter createPropertyAdapter() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getReportAdapter();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getReportAdapter();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getReportAdapter();
        }
        return null;
    }

    private ReportStyleCover createReportStyleCover() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getReportStyleCover();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getReportStyleCover();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getReportStyleCover();
        }
        return null;
    }

    private IMenuStrategy createMenuStrategy() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getMenuStrategy();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getMenuStrategy();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getMenuStrategy();
        }
        return null;
    }

    private KDToolBar createToolBar() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getUIToolBar();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getUIToolBar();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getUIToolBar();
        }
        return null;
    }

    private KDMenuBar createMenuBar() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getUIMenuBar();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getUIMenuBar();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getUIMenuBar();
        }
        return null;
    }

    private KDStatusBar createStatusBar() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getStatusBar();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getStatusBar();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getStatusBar();
        }
        return null;
    }

    private Book createBook() {
        if (this.type == 1) {
            return this.sumRptProcessUI.getBook();
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI.getBook();
        }
        if (this.type == 3) {
            return this.cslRptProcessUI.getBook();
        }
        return null;
    }

    private void createOnSheetActive(Sheet sheet) {
        if (this.type == 1) {
            this.sumRptProcessUI.onSheetActive(sheet);
        } else if (this.type == 2) {
            this.mnsRptProcessUI.onSheetActive(sheet);
        } else if (this.type == 3) {
            this.cslRptProcessUI.onSheetActive(sheet);
        }
    }

    private void createOperationStatus(String oprtStatus) {
        if (this.type == 1) {
            this.sumRptProcessUI.setOprtState(oprtStatus);
        } else if (this.type == 2) {
            this.mnsRptProcessUI.setOprtState(oprtStatus);
        } else if (this.type == 3) {
            this.cslRptProcessUI.setOprtState(oprtStatus);
        }
    }

    private KDToolBar createSpreadStyleToolBar() {
        ToolBarManager toolBarManager = this.createSpreadManager().getSpreadContainer().getToolBarManager();
        return toolBarManager.getToolBar("style");
    }

    public void setTabTitle(IObjectValue editValue) throws EASBizException, BOSException {
        int seleted;
        if (editValue == null) {
            editValue = this.getCslReportInfo();
        }
        String id = editValue.getString("id");
        int version = 0;
        if (SumRptAddedPerportyFactory.getRemoteInstance().exists("where report = '" + id + "'")) {
            SumRptAddedPerportyInfo sumRptAddedPerportyInfo = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo("select version where report = '" + id + "'");
            version = sumRptAddedPerportyInfo.getVersion();
        }
        String tabTitle = "V" + version + ".0-" + editValue.getString("name");
        if (version == 0) {
            tabTitle = "V1.0-" + editValue.getString("name");
        }
        if (StringUtils.isEmpty((String)tabTitle)) {
            tabTitle = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI");
        }
        if ((seleted = this.tabpane.getSelectedIndex()) != -1) {
            this.tabpane.setTitleAt(seleted, tabTitle);
            this.tabpane.setToolTipTextAt(seleted, tabTitle);
            CslReportInfo cslReportInfo = (CslReportInfo)editValue;
            int type = cslReportInfo.getSourceType().getValue();
            Color color = Color.BLACK;
            if (type == 2 || type == 11) {
                color = new Color(96, 204, 249);
            } else if (type == 4) {
                color = new Color(39, 159, 91);
            } else if (type == 3 || type == 12) {
                color = new Color(228, 108, 10);
            }
            KingdeeTabbedPaneExtUI ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
            ui.getColorMap().put(seleted, color);
        }
    }

    private IObjectValue getCslReportInfoByReportid(String reportid) throws Exception {
        return this.getCslReportInfo(reportid);
    }

    protected CslReportInfo getCslReportInfo() {
        return (CslReportInfo)this.getUIContext().get("InitDataObject");
    }

    private void initRptSelfProperties(boolean isNewRpt) throws Exception {
        if (isNewRpt) {
            this.setBookProvider(this.createBookProvider());
            this.setVariableProvider(this.createVariableProvider());
            this.setPropertyAdapter(this.createPropertyAdapter());
            this.setReportStyleCover(this.createReportStyleCover());
            this.setMenuStrategy(this.createMenuStrategy());
            this.manageRptProperties();
        } else {
            if (!this.manager.hasRptProperties(this.tabpane.getSeletedTabCtxId())) {
                this.manageRptProperties();
            }
            SingleRptProperties rptpro = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
            this.setProcessUI(rptpro);
            this.SetSpreadManager(rptpro.getManager());
            this.setBookProvider(rptpro.getBookProvider());
            this.setVariableProvider(rptpro.getVariableProvider());
            this.setPropertyAdapter(rptpro.getPropertyAdapter());
            this.setReportStyleCover(rptpro.getReportStyleCover());
            this.setMenuStrategy(rptpro.getMenuStrategy());
            this.setOprtState(rptpro.getOprtState());
            CslReportInfo cslReportInfo = (CslReportInfo)rptpro.getBookProvider().getEditValue();
            this.initType(cslReportInfo);
            this.setUITitle(this.getTitle(cslReportInfo));
            this.setTabTitle(rptpro.getBookProvider().getEditValue());
        }
        this.createOnSheetActive(this.createBook().getActiveSheet());
    }

    private void manageRptProperties() {
        this.manager.putRptPro(this.tabpane.getSeletedTabCtxId(), this.createSingleRptProperties());
        this.rememberOprtState();
    }

    private void rememberOprtState() {
        this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId()).setOprtState(this.reportTabOprtStatus);
    }

    private SingleRptProperties createSingleRptProperties() {
        SingleRptProperties rptpro = new SingleRptProperties();
        rptpro.setManager(this.createSpreadManager());
        rptpro.setBookProvider(this.createBookProvider());
        rptpro.setPropertyAdapter(this.createPropertyAdapter());
        rptpro.setMenuStrategy(this.createMenuStrategy());
        rptpro.setVariableProvider(this.createVariableProvider());
        rptpro.setReportStyleCover(this.createReportStyleCover());
        rptpro.setProcessUI(this.getProcessUI());
        return rptpro;
    }

    private void setProcessUI(SingleRptProperties rptpro) {
        Object processui = rptpro.getProcessUI();
        if (processui instanceof SumRptProcessUI) {
            this.sumRptProcessUI = (SumRptProcessUI)processui;
        } else if (processui instanceof MnsRptProcessUI) {
            this.mnsRptProcessUI = (MnsRptProcessUI)processui;
        } else if (processui instanceof CslRptProcessUI) {
            this.cslRptProcessUI = (CslRptProcessUI)processui;
        }
    }

    private Object getProcessUI() {
        if (this.type == 1) {
            return this.sumRptProcessUI;
        }
        if (this.type == 2) {
            return this.mnsRptProcessUI;
        }
        if (this.type == 3) {
            return this.cslRptProcessUI;
        }
        return null;
    }

    private IObjectValue getCslReportInfo(String reportid) throws Exception {
        CslReportInfo reportinfo = null;
        if (!this.isExistsReport(reportid)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"134_RptNotExits");
            MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"31_RptReportProcessNewUI"), (String)msg);
            this.abort();
        } else {
            reportinfo = CslReportFactory.getRemoteInstance().getCslReportInfo("select *,company.id,company.name,company.number,currency.id,currency.number,orgUnit.id,orgUnit.name,orgUnit.number,orgTree.id,orgTree.number,orgTree.name,template.id,template.dynaRptType,template.group,template.sumType,template.templateType where id = '" + reportid + "'");
            this.setExistsReportOprtState((ReportBaseInfo)this.getReportInfo());
        }
        return reportinfo;
    }

    private boolean isExistsReport(String reportID) throws EASBizException, BOSException {
        return this.getReportInterface().exists("where id='" + reportID + "'");
    }

    private ICslReport getReportInterface() throws BOSException {
        if (this.iCslReport == null) {
            this.iCslReport = CslReportFactory.getRemoteInstance();
        }
        return this.iCslReport;
    }

    private CslReportInfo getReportInfo() {
        return (CslReportInfo)this.getBookProvider().getEditValue();
    }

    private void setExistsReportOprtState(ReportBaseInfo reportinfo) {
        if (AuditedStatusEnum.AUDITED.equals((Object)reportinfo.getAuditedStatus()) || RptNewUIUtil.hasMutexLock(null, reportinfo.getId().toString())) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        if (this.toolCommonComps == null) {
            this.toolBar.remove((Component)this.btnCloud);
            this.toolBar.remove((Component)this.kDSeparatorCloud);
            Component[] comps = this.toolBar.getToolBarComponents();
            this.toolCommonComps = new Component[comps.length];
            System.arraycopy(comps, 0, this.toolCommonComps, 0, comps.length);
        }
    }

    protected void initJb() throws Exception {
        this.tabpane = new KDTabbedPaneExt();
        this.splitpane = new KDSplitPane();
    }

    @Override
    public void initLayout() {
        try {
            this.queryPanel = new CslReportQueryPanel(this);
        }
        catch (Exception e) {
            logger.error((Object)"creatCslReportQueryPanel error.", (Throwable)e);
            this.handleException(e);
        }
    }

    protected void initEventListener() {
        this.tabpane.addAddNewTabListener(new TabbedPaneAddNewTabListener(){

            @Override
            public void addNewTab(ActionEvent e) {
                if (CslWkTbReportProcessUI.this.queryPanel.isTemplateNode()) {
                    CslWkTbReportProcessUI.this.openReport();
                } else {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"16_ReportQueryPanel"));
                    CslWkTbReportProcessUI.this.abort();
                }
            }
        });
        this.tabpane.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SingleRptProperties single = CslWkTbReportProcessUI.this.manager.getRptProperties(CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId());
                CslWkTbReportProcessUI.this.checkHasSelectedRptInRunBack(single);
                String detail = CslWkTbReportProcessUI.this.manager.getModifyCslReportDetailBySingleRpt(single);
                boolean isClose = true;
                isClose = !StringUtils.isEmpty((String)detail) ? 2 != MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableResource", (String)"29_CslWkTbReportProcessUI"), (String)detail) : true;
                if (isClose) {
                    CslWkTbReportProcessUI.this.manager.discardAllEdits();
                    CslWkTbReportProcessUI.this.closeReportTab(single);
                }
            }
        });
        this.tabpane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CslWkTbReportProcessUI.this.isOnLoad) {
                    return;
                }
                if (CslWkTbReportProcessUI.this.tabpane.getTabCount() > 0 && CslWkTbReportProcessUI.this.manager.hasRptProperties(CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId())) {
                    try {
                        CslWkTbReportProcessUI.this.initReportTab();
                        CslWkTbReportProcessUI.this.adjustComponentObject();
                    }
                    catch (Exception e1) {
                        CslWkTbReportProcessUI.this.discardFailedTab();
                        CslWkTbReportProcessUI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
        this.tabpane.addTabMouseMotionListener(new ITabbedPaneMouseListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CslWkTbReportProcessUI.this.tabpane.getSelectedIndex() != -1 && CslWkTbReportProcessUI.this.tabpane.getTabCount() > 1 && 0 == MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"29_RptReportProcessNewUI"))) {
                    CslWkTbReportProcessUI.this.openSingleReportProcessUI();
                }
            }
        });
    }

    private void releaseMutexLock(SingleRptProperties single) {
        String requestId = single.getBookProvider().getEditValue().getString("id");
        MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(requestId);
    }

    private void openSingleReportProcessUI() {
        SingleRptProperties prop = this.manager.getRptProperties(this.tabpane.getSeletedTabCtxId());
        if (prop == null || prop.getBookProvider().getEditValue() == null) {
            return;
        }
        try {
            if (this.type == 1) {
                prop.getBookProvider().restoreBook(this.sumRptProcessUI.getBook());
            } else if (this.type == 2) {
                prop.getBookProvider().restoreBook(this.mnsRptProcessUI.getBook());
            } else if (this.type == 3) {
                prop.getBookProvider().restoreBook(this.cslRptProcessUI.getBook());
            }
            UIContext context = new UIContext(this.getUIContext().get("Owner"));
            context.put((Object)"InitDataObject", (Object)prop.getBookProvider().getEditValue());
            context.put((Object)"isModify_from_newUI", (Object)prop.getManager().getModifyManager().isDirty());
            RptNewUIUtil.openProcessUI(context, this.getProcessUIByType(), prop.getOprtState());
            this.manager.removeRptPro(this.tabpane.getSeletedTabCtxId());
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
            this.initReportTab();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private String getProcessUIByType() {
        if (this.type == 1) {
            return SumRptProcessUI.class.getName();
        }
        if (this.type == 2) {
            return MnsRptProcessUI.class.getName();
        }
        if (this.type == 3) {
            return CslRptProcessUI.class.getName();
        }
        return null;
    }

    private void closeReportTab(SingleRptProperties single) {
        if (this.check()) {
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
            this.manager.removeRptPro(this.tabpane.getSeletedTabCtxId());
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
            KingdeeTabbedPaneExtUI ui = (KingdeeTabbedPaneExtUI)this.tabpane.getUI();
            ui.getColorMap().clear();
            try {
                this.initReportTab();
                this.adjustComponentObject();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.queryPanel.refreshTmplTree(true);
        }
    }

    private boolean check() {
        Object processUI = this.getProcessUI();
        if (processUI instanceof SumRptProcessUI) {
            return this.sumRptProcessUI.checkBeforeWindowClosing();
        }
        if (processUI instanceof MnsRptProcessUI) {
            return this.mnsRptProcessUI.checkBeforeWindowClosing();
        }
        if (processUI instanceof CslRptProcessUI) {
            return this.cslRptProcessUI.checkBeforeWindowClosing();
        }
        return true;
    }

    public void openReport() {
        CslReportCondition condition = null;
        try {
            condition = this.queryPanel.getCslReportCondition();
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        if (this.findHasOpenRptTab(condition)) {
            return;
        }
        this.checkGreatestLimited();
        try {
            if (condition != null) {
                this.setReportid(condition.getTmplNodeInfo());
                String reportid = condition.getTmplNodeInfo().getReportID();
                this.addNewReportTab(reportid);
            }
        }
        catch (Exception e) {
            logger.error((Object)"addNewReportTab", (Throwable)e);
        }
    }

    private CslReportInfo createReportByTmplid(Map<String, Object> map) throws Exception {
        CslReportInfo cslReportInfo = null;
        TemplateInfo template = (TemplateInfo)map.get("template");
        CurrencyInfo currency = (CurrencyInfo)map.get("currency");
        Date date = (Date)map.get("date");
        int year = (Integer)map.get("year");
        short period = (Short)map.get("period");
        OrgTreeInfo orgTree = (OrgTreeInfo)map.get("orgTree");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get("orgUnit");
        int type = (Integer)map.get("type");
        if (type == 1) {
            SumRptEditUI sumRptEditUI = new SumRptEditUI();
            cslReportInfo = sumRptEditUI.addSingleNewEditData(template, date, year, period, currency, orgTree, orgUnitInfo);
        } else if (type == 2) {
            MnsRptEditUI mnsRptEditUI = new MnsRptEditUI();
            cslReportInfo = mnsRptEditUI.addSingleEditData(template, date, year, period, currency, orgTree, orgUnitInfo);
        } else if (type == 3) {
            CslRptEditUI cslRptEditUI = new CslRptEditUI();
            cslReportInfo = cslRptEditUI.addSingleEditData(template, date, year, period, currency, orgTree, orgUnitInfo);
        }
        return cslReportInfo;
    }

    private CslReportCondition constructCondition(Map<String, Object> map) {
        CslReportCondition condition = new CslReportCondition();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get("orgUnit");
        OrgStructureInfo defineInfo = new OrgStructureInfo();
        defineInfo.setUnit(orgUnitInfo);
        condition.setOrgNodeInfo(defineInfo);
        TemplateInfo template = (TemplateInfo)map.get("template");
        RptPeriodTypeEnum periodType = template.getPeriodType();
        condition.setPeriodType(periodType);
        int year = (Integer)map.get("year");
        condition.setYear(year);
        short period = (Short)map.get("period");
        condition.setPeriod(period);
        CurrencyInfo currency = (CurrencyInfo)map.get("currency");
        condition.setCurrency(currency);
        CslTmplNodeUserDefineInfo tmplDefineInfo = new CslTmplNodeUserDefineInfo();
        tmplDefineInfo.setTmplID(template.getId().toString());
        condition.setTmplNodeInfo(tmplDefineInfo);
        tmplDefineInfo.setTemplate(true);
        OrgTreeInfo orgTree = (OrgTreeInfo)map.get("orgTree");
        condition.setTreeInfo(orgTree);
        return condition;
    }

    private void setReportid(CslTmplNodeUserDefineInfo define) {
        String reportid = null;
        boolean isTemplate = define.isTemplate();
        String tmplId = define.getTmplID();
        reportid = isTemplate ? this.createReportAndOpenIt(tmplId) : tmplId;
        define.setReportID(reportid);
    }

    private String createReportAndOpenIt(String tmplId) {
        TemplateProvider tmplProvider = new TemplateProvider();
        String reportid = null;
        try {
            TemplateInfo template = (TemplateInfo)tmplProvider.queryEditData((IObjectPK)new ObjectUuidPK(tmplId));
            CurrencyInfo currency = (CurrencyInfo)this.queryPanel.cmbcurrency.getSelectedItem();
            Date date = (Date)this.queryPanel.datepicker.getValue();
            int yearValue = this.queryPanel.spnyear.getIntegerVlaue();
            short periodValue = this.queryPanel.spnperiod.getIntegerVlaue().shortValue();
            OrgTreeInfo tree = (OrgTreeInfo)this.queryPanel.prmtOrgBound.getData();
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)this.queryPanel.orgTree.getLastSelectedPathComponent();
            FullOrgUnitInfo orgUnit = this.getOrgUnitInfo(selectNode);
            CslReportInfo report = null;
            int type = this.getType(template.getTemplateType().getValue());
            if (type == 1) {
                SumRptEditUI sumRptEditUI = new SumRptEditUI();
                report = sumRptEditUI.addSingleNewEditData(template, date, yearValue, periodValue, currency, tree, (OrgUnitInfo)orgUnit);
            } else if (type == 2) {
                MnsRptEditUI mnsRptEditUI = new MnsRptEditUI();
                report = mnsRptEditUI.addSingleEditData(template, date, yearValue, periodValue, currency, tree, (OrgUnitInfo)orgUnit);
            } else if (type == 3) {
                CslRptEditUI cslRptEditUI = new CslRptEditUI();
                report = cslRptEditUI.addSingleEditData(template, date, yearValue, periodValue, currency, tree, (OrgUnitInfo)orgUnit);
            }
            if (report != null && report.getId() != null) {
                reportid = report.getId().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"createReportAndOpenIt:", (Throwable)e);
        }
        return reportid;
    }

    private int getType(int tmplType) {
        int type = 0;
        if (tmplType == 3 || tmplType == 11) {
            type = 1;
        } else if (tmplType == 4) {
            type = 2;
        } else if (tmplType == 5 || tmplType == 13) {
            type = 3;
        }
        return type;
    }

    private FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode treeNode) {
        Object obj = null;
        FullOrgUnitInfo orgUnit = null;
        if (treeNode != null && (obj = treeNode.getUserObject()) != null && obj instanceof OrgStructureInfo) {
            orgUnit = ((OrgStructureInfo)obj).getUnit();
        }
        return orgUnit;
    }

    private void initReportTab() throws Exception {
        this.initRptSelfProperties(false);
    }

    protected OrgType getWktbOrgType() {
        return OrgType.Company;
    }

    protected boolean isOpenFromWeb() {
        return false;
    }

    protected boolean isFromCslReportQueryPanel() {
        return true;
    }

    private void initReoprtLayout() {
        this.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        KDToolBar toolBar2 = this.getSpreadStyleToolBar();
        this.add((Component)toolBar2, "North");
        this.preToolBar = toolBar2;
        this.initDefaultSpreadSize(this.createSpreadManager().getSpreadContainer());
        this.tabpane.addTab("", null, (Component)this.createSpreadManager().getSpreadContainer(), "", true);
        this.splitpane = new KDSplitPane(1, (Component)((Object)this.queryPanel), (Component)((Object)this.tabpane));
        this.splitpane.setOneTouchExpandable(true);
        this.splitpane.setArrowType(1);
        this.splitpane.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.add((Component)this.splitpane, "Center");
        this.removeClashKeyStroke();
    }

    protected void initDefaultSpreadSize(SpreadContext spreadContainer) {
        spreadContainer.setPreferredSize(new Dimension(200, 200));
        spreadContainer.setMinimumSize(new Dimension(200, 200));
    }

    public void removeClashKeyStroke() {
        this.splitpane.getInputMap(1).getParent().remove(KeyStroke.getKeyStroke("F8"));
    }

    private KDToolBar getSpreadStyleToolBar() {
        ToolBarManager toolBarManager = this.createSpreadManager().getSpreadContainer().getToolBarManager();
        return toolBarManager.getToolBar("style");
    }

    @Override
    public boolean destroyWindow() {
        this.checkHasRptInRunBack();
        String detail = this.manager.getMofidyCslReportDetail();
        if (!StringUtils.isEmpty((String)detail)) {
            if (2 == MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"45_RptReportProcessNewUI"), (String)detail)) {
                return false;
            }
            this.manager.discardAllEdits();
        }
        int size = this.tabpane.getTabCount();
        for (int i = size - 1; i >= 0; --i) {
            SingleRptProperties single = this.manager.getRptProperties(this.tabpane.getctxid(i));
            this.releaseNetControl(single);
            this.releaseMutexLock(single);
        }
        this.manager.clearAll();
        ProgressDialogHelper.destroyAllMonitorFromThreadPool();
        this.refeshListUI(new UIContext((Object)this.getUIContext()));
        return super.destroyWindow();
    }

    private void checkHasRptInRunBack() {
        if (this.manager.hasRptInRunBack(4)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"hasNotOpenRptInRunBack"));
            this.abort();
        }
        if (this.manager.hasRptInRunBack(2) && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"hasRptInRunBack")) == 2) {
            this.abort();
        }
    }

    private void checkHasSelectedRptInRunBack(SingleRptProperties single) {
        if (this.manager.hasRptInRunBackBySinglRpt(4, single)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"hasNotOpenRptInRunBack"));
            this.abort();
        }
        if (this.manager.hasRptInRunBackBySinglRpt(2, single) && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"hasRptInRunBack")) == 2) {
            this.abort();
        }
    }

    private void releaseNetControl(SingleRptProperties rptprop) {
        IVOChangeListener listener = this.getVOChangeListener();
        IObjectValue newObject = rptprop.getBookProvider().getEditValue();
        if (listener != null) {
            VOChangeEvent e = new VOChangeEvent((Object)this);
            if ((IObjectValue)this.getUIContext().get("CURRENT.VO") != null) {
                e.setCurrentObject((IObjectValue)this.getUIContext().get("CURRENT.VO"));
            }
            e.setState("RELEASEALL");
            if (newObject != null && newObject.getPKField() != null) {
                e.setCurrentObjectId(newObject.getBOSUuid(newObject.getPKField()).toString());
                try {
                    listener.change(e);
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                    this.abort();
                }
            }
        }
    }

    private void refeshListUI(final UIContext uiContext) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BOSUIContext ctx = (BOSUIContext)uiContext.get((Object)"Owner");
                    String owner = ctx.get((Object)"Owner") == null ? CslWorkTableListUI.class.getName() : ctx.get((Object)"Owner").getClass().getName();
                    IUIObject ui = RptNewUIUtil.findUI(uiContext, owner);
                    if (ui != null && ui instanceof CslWorkTableListUI) {
                        ((CslWorkTableListUI)ui).actionQueryRpt_actionPerformed(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void openReportsFromListUI(final List<String> selectedDatas, final boolean addOne, String oprt) {
        if (selectedDatas == null || selectedDatas.size() == 0) {
            return;
        }
        this.cslWorkTableListUIOprtStatus = oprt;
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), true);
        dialog.run4New(false, true, new IRunnableWithProgress(){
            boolean isGreatestLimited = false;
            int defaultSelectedIndex = CslWkTbReportProcessUI.access$200(CslWkTbReportProcessUI.this).getTabCount() - 1;
            boolean isSelectedTab = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"36_RptReportProcessNewUI"), -1);
                monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"37_RptReportProcessNewUI"));
                monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"42_RptReportProcessNewUI"));
                String ctxid = null;
                String reportid2 = null;
                try {
                    for (String reportid2 : selectedDatas) {
                        ctxid = CslWkTbReportProcessUI.this.manager.findCslReportByID(reportid2);
                        if (!"NOTFOUND".equals(ctxid)) {
                            CslWkTbReportProcessUI.this.tabpane.SetSelectedTab(ctxid);
                            this.isSelectedTab = true;
                            continue;
                        }
                        if (CslWkTbReportProcessUI.this.isGreatestLimited()) {
                            this.isGreatestLimited = true;
                            break;
                        }
                        CslWkTbReportProcessUI.this.addNewReportTab(reportid2);
                        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"110_RptReportProcessNewUI");
                        monitor.subTaskBegin(MessageFormat.format(msg, CslWkTbReportProcessUI.this.getCslReportInfo().getName()));
                    }
                    CslWkTbReportProcessUI.this.queryPanel.refreshTmplTree(true);
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"41_RptReportProcessNewUI"));
                    monitor.done();
                }
                catch (Exception e) {
                    try {
                        if (!(e instanceof NullPointerException)) {
                            CslWkTbReportProcessUI.this.handUIExceptionAndAbort(e);
                        }
                        monitor.done();
                    }
                    catch (Throwable throwable) {
                        monitor.done();
                        CslWkTbReportProcessUI.this.requestFocus();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (isGreatestLimited) {
                                    CslWkTbReportProcessUI.this.handUIExceptionAndAbort((Exception)((Object)new ReportProcessException(ReportProcessException.OPENREPORTLIMITED, new Object[]{13})));
                                } else if (defaultSelectedIndex >= 0 && defaultSelectedIndex < CslWkTbReportProcessUI.this.tabpane.getTabCount() && !isSelectedTab) {
                                    int reSelectedIndex;
                                    int n = reSelectedIndex = addOne ? defaultSelectedIndex + 1 : defaultSelectedIndex;
                                    if (reSelectedIndex < CslWkTbReportProcessUI.this.tabpane.getTabCount()) {
                                        CslWkTbReportProcessUI.this.tabpane.setSelectedIndex(reSelectedIndex);
                                    } else {
                                        CslWkTbReportProcessUI.this.tabpane.setSelectedIndex(defaultSelectedIndex);
                                    }
                                }
                            }
                        });
                        throw throwable;
                    }
                    CslWkTbReportProcessUI.this.requestFocus();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                CslWkTbReportProcessUI.this.requestFocus();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void openReportByUIContext(UIContext uiContext, String oprtState, Map<String, Object> map) {
        this.checkGreatestLimited();
        IUIWindow uiWindow = this.getUIWindow();
        if (uiWindow instanceof UINewFrame) {
            UINewFrame uiFrame = (UINewFrame)uiWindow;
            if (6 != uiFrame.getExtendedState()) {
                uiFrame.setExtendedState(6);
            }
            uiFrame.toFront();
            uiFrame.repaint();
        }
        CslReportInfo report = null;
        try {
            if (this.findHasOpenRptTab(this.constructCondition(map))) {
                return;
            }
            report = this.createReportByTmplid(map);
            this.getUIContext().put("InitDataObject", report);
            this.initType(report);
            this.initProcessUI(report, this.getOprtState(report));
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        final String adjustedOprtState = AuditedStatusEnum.AUDITED.equals((Object)report.getAuditedStatus()) ? OprtState.VIEW : oprtState;
        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)this), true);
        dialog.run4New(false, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"36_RptReportProcessNewUI"), -1);
                monitor.setTaskName(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"37_RptReportProcessNewUI"));
                try {
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"38_RptReportProcessNewUI"));
                    CslWkTbReportProcessUI.this.createNewTab();
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"39_RptReportProcessNewUI"));
                    CslWkTbReportProcessUI.this.setBookProvider(CslWkTbReportProcessUI.this.createBookProvider());
                    CslWkTbReportProcessUI.this.setVariableProvider(CslWkTbReportProcessUI.this.createVariableProvider());
                    CslWkTbReportProcessUI.this.setPropertyAdapter(CslWkTbReportProcessUI.this.createPropertyAdapter());
                    CslWkTbReportProcessUI.this.setReportStyleCover(CslWkTbReportProcessUI.this.createReportStyleCover());
                    CslWkTbReportProcessUI.this.setMenuStrategy(CslWkTbReportProcessUI.this.createMenuStrategy());
                    CslWkTbReportProcessUI.this.setOprtState(adjustedOprtState);
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"40_RptReportProcessNewUI"));
                    CslWkTbReportProcessUI.this.manageRptProperties();
                    CslWkTbReportProcessUI.this.setUITitle(CslWkTbReportProcessUI.this.getTitle(null));
                    CslWkTbReportProcessUI.this.setTabTitle(null);
                    CslWkTbReportProcessUI.this.setTemplateNodeStatus();
                    CslWkTbReportProcessUI.this.adjustComponentObject();
                    CslWkTbReportProcessUI.this.repaint();
                    CslWkTbReportProcessUI.this.onSheetActive(this.createBook().getActiveSheet());
                    CslWkTbReportProcessUI.this.onShow();
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"41_RptReportProcessNewUI"));
                }
                catch (Exception e) {
                    CslWkTbReportProcessUI.this.discardFailedTab();
                    CslWkTbReportProcessUI.this.handUIExceptionAndAbort(e);
                }
                finally {
                    monitor.done();
                    CslWkTbReportProcessUI.this.requestFocus();
                }
            }

            private Book createBook() {
                Book book = null;
                book = CslWkTbReportProcessUI.this.type == 1 ? CslWkTbReportProcessUI.this.sumRptProcessUI.getBook() : (CslWkTbReportProcessUI.this.type == 2 ? CslWkTbReportProcessUI.this.mnsRptProcessUI.getBook() : CslWkTbReportProcessUI.this.cslRptProcessUI.getBook());
                return book;
            }
        });
    }

    private boolean findHasOpenRptTab(CslReportCondition condition) {
        String ctxid = null;
        ctxid = this.manager.findReport(condition);
        if (!"NOTFOUND".equals(ctxid)) {
            this.tabpane.SetSelectedTab(ctxid);
            return true;
        }
        return false;
    }

    private void checkGreatestLimited() {
        try {
            if (this.isGreatestLimited()) {
                throw new ReportProcessException(ReportProcessException.OPENREPORTLIMITED, new Object[]{13});
            }
        }
        catch (ReportProcessException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void addNewReportTab(String reportid) throws Exception {
        CslReportInfo cslReportInfo = (CslReportInfo)this.getCslReportInfoByReportid(reportid);
        this.initType(cslReportInfo);
        this.isAddNewReportTab = true;
        this.initProcessUI(cslReportInfo, this.getOprtState(cslReportInfo));
        this.createNewTab();
        try {
            this.initRptSelfProperties(true);
        }
        catch (Exception e) {
            this.discardFailedTab();
            this.handUIExceptionAndAbort(e);
        }
        this.adjustComponentObject();
        this.repaint();
        this.setUITitle(this.getTitle(cslReportInfo));
        this.setTabTitle((IObjectValue)cslReportInfo);
        this.onShow();
    }

    private void setTemplateNodeStatus() {
        this.queryPanel.refreshTmplTree(true);
    }

    private void initCommToolBarManager() {
        Component cpt = this.toolBar.getComponent(this.toolBar.getComponentCount() - 1);
        this.createToolBar().add(cpt);
    }

    private void removebtnCloud() {
        Component cpt1 = this.createToolBar().getToolBarComponentAt(0);
        Component cpt2 = this.createToolBar().getToolBarComponentAt(1);
        if (cpt1.getName() != null && cpt1.getName().equals("btnCloud")) {
            this.createToolBar().remove(cpt1);
            this.createToolBar().remove(cpt2);
        }
    }

    private String getTitle(CslReportInfo info) {
        StringBuffer title = new StringBuffer();
        try {
            if (info == null) {
                info = this.getCslReportInfo();
            }
            String id = info.getId().toString();
            int version = 0;
            if (SumRptAddedPerportyFactory.getRemoteInstance().exists("where report = '" + id + "'")) {
                SumRptAddedPerportyInfo sumRptAddedPerportyInfo = SumRptAddedPerportyFactory.getRemoteInstance().getSumRptAddedPerportyInfo("select version where report = '" + id + "'");
                version = sumRptAddedPerportyInfo.getVersion();
            }
            String treeid = info.getOrgTree().getId().toString();
            OrgTreeInfo orgTree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo("select name where id='" + treeid + "'");
            String orgTreeName = orgTree.getName() + "-";
            String orgUnitid = info.getOrgUnit().getId().toString();
            FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select name where id = '" + orgUnitid + "'");
            String orgUnitName = orgUnit.getName() + "-";
            String rptType = info.getSourceType().getAlias() + "-";
            String reportName = "V" + version + ".0-" + info.getName() + "-";
            if (version == 0) {
                reportName = "V1.0-" + info.getName() + "-";
            }
            String periodType = info.getPeriodType().getAlias() + "-";
            int year = info.getYear();
            short period = info.getPeriod();
            String yearPeriod = year + EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Year") + period + EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51.Period") + "-";
            String currencyid = info.getCurrency().getId().toString();
            CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select name where id = '" + currencyid + "'");
            CurrencyInfo currency = coll.get(0);
            String currencyName = currency.getName();
            title.append(orgTreeName).append(orgUnitName).append(rptType).append(reportName).append(periodType).append(yearPeriod).append(currencyName);
        }
        catch (Exception e) {
            logger.error((Object)"getTitle:", (Throwable)e);
        }
        return title.toString();
    }

    protected void reloadReportTab(String ctxid) {
        SingleRptProperties rptpro = this.manager.getRptProperties(ctxid);
        String name = ((CslReportInfo)rptpro.getBookProvider().getEditValue()).getName();
        this.tabpane.addTab(name, null, (Component)this.manager.getRptProperties(ctxid).getManager().getSpreadContainer(), name, true, ctxid);
        this.tabpane.setSelectedIndex(this.tabpane.getTabCount() - 1);
    }

    @Override
    public ProgressDialogNew createProgressDialog() {
        ProgressDialogNew progDialog = super.createProgressDialog();
        progDialog.addOtherHandleEvent(new Runnable(){

            @Override
            public void run() {
                CslWkTbReportProcessUI.this.manager.getRptProperties(CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId()).setReportState(2);
                CslWkTbReportProcessUI.this.tabpane.removeTabAt(CslWkTbReportProcessUI.this.tabpane.getSelectedIndex());
            }
        });
        progDialog.setSpecialShowParentWindowModal(new IShowWindow(){
            final int tabCount;
            String modal;
            String tabctx;
            {
                this.tabCount = CslWkTbReportProcessUI.this.tabpane.getTabCount();
                this.modal = this.tabCount <= 1 ? "SHOW_WINDOW" : "SHOW_TAB";
                this.tabctx = CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId();
            }

            @Override
            public void onShow() {
                if (!CslWkTbReportProcessUI.this.isShowing()) {
                    CslWkTbReportProcessUI.this.getUIWindow().show();
                }
                CslWkTbReportProcessUI.this.reloadReportTab(this.tabctx);
                CslWkTbReportProcessUI.this.requestFocus();
                CslWkTbReportProcessUI.this.showSuccessMsg(CslWkTbReportProcessUI.this.manager.getRptProperties(CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId()).getCalculateTimeStr());
                CslWkTbReportProcessUI.this.manager.getRptProperties(CslWkTbReportProcessUI.this.tabpane.getSeletedTabCtxId()).setReportState(1);
            }

            @Override
            public boolean isShowWindow() {
                return "SHOW_WINDOW".equals(this.modal);
            }

            @Override
            public void hide() {
                if (this.isShowWindow()) {
                    CslWkTbReportProcessUI.this.getUIWindow().hide();
                }
            }
        });
        return progDialog;
    }

    private void createNewTab() {
        int count = this.tabpane.getTabCount() + 1;
        SpreadManager sm = this.createBlankSpreadManager();
        this.SetSpreadManager(sm);
        this.tabpane.addTab(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI"), null, (Component)sm.getSpreadContainer(), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"30_RptReportProcessNewUI") + count, true);
        this.tabpane.setSelectedIndex(this.tabpane.getTabCount() - 1);
    }

    private SpreadManager createBlankSpreadManager() {
        SpreadManager sm = this.createSpreadManager();
        this.initDefaultSpreadSize(sm.getSpreadContainer());
        return sm;
    }

    private void discardFailedTab() {
        if (!this.manager.hasRptProperties(this.tabpane.getSeletedTabCtxId()) && this.tabpane.getSelectedIndex() > 0) {
            this.tabpane.removeTabAt(this.tabpane.getSelectedIndex());
        }
    }

    private boolean isGreatestLimited() {
        return this.manager.size() + 1 > 13;
    }

    public IObjectValue getEditValue() {
        return this.getBookProvider().getEditValue();
    }

    @Override
    public void actionToolsRptAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolsRptAudit_actionPerformed(e);
        this.rememberOprtState();
    }

    public Map<String, CslReportInfo> getOpenedRpts() {
        if (this.manager != null) {
            return this.manager.getOpenedRpts();
        }
        return null;
    }
}

