/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.newrpt.CslMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableListUI;
import com.kingdee.eas.fi.newrpt.cslworktable.client.RptBatchHandle;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CslWorkTableUIUtil {
    private static final Logger logger = CoreUIObject.getLogger(CslWorkTableUIUtil.class);
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_DELETE = "delete";

    public static void buildTree(KDTree treeMain, OrgStructureCollection orgStructure, Set<String> filterNumbers) throws Exception {
        CslWorkTableUIUtil.buildTree(treeMain, orgStructure, filterNumbers, true);
    }

    public static void buildTree(KDTree treeMain, OrgStructureCollection orgStructure, Set<String> filterNumbers, boolean isSelectFirst) throws Exception {
        if (orgStructure != null && orgStructure.size() > 0) {
            HashMap<String, List<OrgStructureInfo>> parent_childs = new HashMap<String, List<OrgStructureInfo>>();
            OrgStructureInfo rootInfo = null;
            String parentId = null;
            ArrayList<OrgStructureInfo> orgStructures = null;
            HashMap<String, String> orgNumber_StrutLongNumber = new HashMap<String, String>();
            for (int i = 0; i < orgStructure.size(); ++i) {
                if (i == 0) {
                    rootInfo = orgStructure.get(i);
                }
                if (orgStructure.get(i).getParent() != null) {
                    parentId = orgStructure.get(i).getParent().getId().toString();
                    orgStructures = (ArrayList<OrgStructureInfo>)parent_childs.get(parentId);
                    if (orgStructures == null) {
                        orgStructures = new ArrayList<OrgStructureInfo>();
                        parent_childs.put(parentId, orgStructures);
                    }
                    orgStructures.add(orgStructure.get(i));
                } else {
                    rootInfo = orgStructure.get(i);
                }
                if (filterNumbers == null) continue;
                orgNumber_StrutLongNumber.put(orgStructure.get(i).getUnit().getNumber(), orgStructure.get(i).getLongNumber());
            }
            HashSet<String> structLongNumbers = null;
            if (filterNumbers != null) {
                structLongNumbers = new HashSet<String>();
                String curLongNumber = null;
                int startIndex = 0;
                for (String number : filterNumbers) {
                    startIndex = 0;
                    curLongNumber = (String)orgNumber_StrutLongNumber.get(number);
                    if (StringUtils.isEmpty((String)curLongNumber)) continue;
                    startIndex = curLongNumber.indexOf("!", startIndex);
                    while (startIndex > 0) {
                        structLongNumbers.add(curLongNumber.substring(0, startIndex));
                        startIndex = curLongNumber.indexOf("!", startIndex + 1);
                    }
                    structLongNumbers.add(curLongNumber);
                }
            }
            KDTreeNode curNode = new KDTreeNode((Object)rootInfo.getUnit());
            curNode.setUserObject((Object)rootInfo);
            if (structLongNumbers != null && structLongNumbers.contains(rootInfo.getLongNumber()) && !filterNumbers.contains(rootInfo.getUnit().getNumber())) {
                curNode.setTextColor(Color.gray);
                curNode.setChecked(false);
            }
            CslWorkTableUIUtil.isEnableNode(curNode);
            ((DefaultTreeModel)treeMain.getModel()).setRoot((TreeNode)curNode);
            CslWorkTableUIUtil.buildChildNode(curNode, parent_childs, filterNumbers, structLongNumbers);
            if (isSelectFirst) {
                treeMain.setSelectionRow(0);
            }
            treeMain.expandRow(0);
            if (structLongNumbers != null) {
                structLongNumbers.clear();
                orgNumber_StrutLongNumber.clear();
            }
        }
    }

    private static void isEnableNode(KDTreeNode curNode) throws Exception {
        OrgStructureInfo info = (OrgStructureInfo)curNode.getUserObject();
        if (info != null && info.get("isEnable") != null && !((Boolean)info.get("isEnable")).booleanValue()) {
            curNode.setTextColor(Color.gray);
            curNode.setChecked(false);
        }
    }

    public static void buildChildNode(KDTreeNode curNode, Map<String, List<OrgStructureInfo>> parent_childs, Set<String> filterNumbers, Set<String> structLongNumbers) throws Exception {
        if (curNode != null && curNode.getUserObject() != null && curNode.getUserObject() instanceof OrgStructureInfo) {
            KDTreeNode childNode = null;
            OrgStructureInfo unitInfo = (OrgStructureInfo)curNode.getUserObject();
            List<OrgStructureInfo> childList = parent_childs.get(unitInfo.getId().toString());
            if (childList != null && !childList.isEmpty()) {
                for (OrgStructureInfo curUnitInfo : childList) {
                    if (structLongNumbers != null) {
                        if (!structLongNumbers.contains(curUnitInfo.getLongNumber())) continue;
                        childNode = new KDTreeNode((Object)curUnitInfo.getUnit());
                        childNode.setUserObject((Object)curUnitInfo);
                        curNode.add((MutableTreeNode)childNode);
                        CslWorkTableUIUtil.isEnableNode(childNode);
                        if (!filterNumbers.contains(curUnitInfo.getUnit().getNumber())) {
                            childNode.setTextColor(Color.gray);
                        }
                        CslWorkTableUIUtil.buildChildNode(childNode, parent_childs, filterNumbers, structLongNumbers);
                        continue;
                    }
                    childNode = new KDTreeNode((Object)curUnitInfo.getUnit());
                    childNode.setUserObject((Object)curUnitInfo);
                    curNode.add((MutableTreeNode)childNode);
                    CslWorkTableUIUtil.isEnableNode(childNode);
                    CslWorkTableUIUtil.buildChildNode(childNode, parent_childs, filterNumbers, structLongNumbers);
                }
            }
        }
    }

    public static void setSpineRangeByPeriodType(KDSpinner period, RptPeriodTypeEnum periodType, int year, boolean isReset, boolean isRemoveChangeListener) {
        if (periodType == null) {
            return;
        }
        int minVal = 0;
        int maxVal = 366;
        switch (periodType.getValue()) {
            case 3: {
                minVal = 1;
                maxVal = 13;
                break;
            }
            case 4: {
                minVal = 1;
                maxVal = 4;
                break;
            }
            case 5: {
                minVal = 1;
                maxVal = 2;
                break;
            }
            case 6: {
                minVal = 1;
                maxVal = 1;
                break;
            }
            case 2: {
                minVal = 1;
                Calendar c = Calendar.getInstance();
                c.set(year, 11, 31, 23, 59, 59);
                maxVal = c.get(3) == 53 ? 53 : 52;
                break;
            }
            case 1: {
                minVal = 1;
                maxVal = 366;
                break;
            }
        }
        CslRptUIUtil.setSpineRange((KDSpinner)period, (int)minVal, (int)maxVal, (boolean)true, (boolean)true);
    }

    public static OrgTreeCollection getAllOrgTreeColl() throws Exception {
        OrgTreeCollection orgTreeColl = CslRptUIUtil.getOrgTreeCollection();
        if (orgTreeColl != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < orgTreeColl.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(orgTreeColl.get(i).getId().toString()).append("'");
            }
            sb.insert(0, "select id,startDate,endDate,name,number where id in(").append(") and startDate!= null and layerType!=6 and (ISHIDE  <> 1  or ISHIDE is null) order by number,startDate asc ");
            return OrgTreeFactory.getRemoteInstance().getOrgTreeCollection(sb.toString());
        }
        return null;
    }

    public static OrgTreeCollection getOrgTreeColl(OrgTreeCollection orgTreeColl, Date rptDate) {
        if (orgTreeColl != null && rptDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = sdf.format(rptDate);
            OrgTreeCollection curOrgTreeColl = new OrgTreeCollection();
            for (int i = 0; i < orgTreeColl.size(); ++i) {
                if (sdf.format(orgTreeColl.get(i).getStartDate()).compareTo(curDate) > 0 || orgTreeColl.get(i).getEndDate() != null && sdf.format(orgTreeColl.get(i).getEndDate()).compareTo(curDate) < 0) continue;
                curOrgTreeColl.add(orgTreeColl.get(i));
            }
            return curOrgTreeColl;
        }
        return null;
    }

    public static Enum getEnum(Class curClass, int value) throws Exception {
        RptSrcTypeEnum.class.getDeclaredMethods();
        Method method = IntEnum.class.getDeclaredMethod("getEnum", Class.class, Integer.TYPE);
        NewRptUtil.makeAccessible(method);
        Enum curEnum = (Enum)method.invoke(IntEnum.class, curClass, value);
        return curEnum;
    }

    public static void refreshOrgTreeAndOrgUnitTree(CslMergeSoluInfo soluInfo, KDBizPromptBox orgTreeF7, KDTree treeMain, KDTable tblMain, OrgTreeCollection orgTreeColl, Date rptDate, String selectOrgUnitNumber, ListUI owner, boolean isOrgF7Change, boolean isRptDataChange) throws Exception {
        CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(soluInfo, orgTreeF7, treeMain, tblMain, orgTreeColl, rptDate, selectOrgUnitNumber, owner, isOrgF7Change, isRptDataChange, true);
    }

    public static void refreshOrgTreeAndOrgUnitTree(CslMergeSoluInfo soluInfo, KDBizPromptBox orgTreeF7, KDTree treeMain, KDTable tblMain, final OrgTreeCollection orgTreeColl, final Date rptDate, String selectOrgUnitNumber, ListUI owner, boolean isOrgF7Change, boolean isRptDataChange, boolean isUnion) throws Exception {
        OrgTreeInfo orgTreeInfo = null;
        OrgStructureCollection orgStructure = null;
        if (soluInfo != null) {
            orgTreeInfo = CslWorkTableUIUtil.getOrgTreeInfo(orgTreeColl, rptDate, soluInfo.getOrgTree().getNumber());
            if (orgTreeInfo == null) {
                if (tblMain != null) {
                    tblMain.removeRows();
                }
                orgTreeF7.setData(null);
                ((DefaultTreeModel)treeMain.getModel()).setRoot(null);
                return;
            }
            if (orgTreeF7.getData() == null || !((OrgTreeInfo)orgTreeF7.getData()).getId().toString().equals(orgTreeInfo.getId().toString())) {
                orgTreeF7.setData((Object)orgTreeInfo);
            } else if (!isOrgF7Change) {
                if (tblMain != null) {
                    tblMain.removeRows();
                }
                if (owner != null) {
                    owner.refreshList();
                }
                return;
            }
            HashMap<String, String> conditions = new HashMap<String, String>();
            conditions.put("orgTreeId", orgTreeInfo.getId().toString());
            conditions.put("isForOrgTreeF7", "true");
            orgStructure = CslWorkTableFacadeFactory.getRemoteInstance().getOrgUnitTree(conditions);
            conditions.clear();
        } else {
            if (orgTreeF7.getData() != null) {
                orgTreeInfo = CslWorkTableUIUtil.getOrgTreeInfo(orgTreeColl, rptDate, ((OrgTreeInfo)orgTreeF7.getData()).getNumber());
                if (orgTreeInfo == null) {
                    if (tblMain != null) {
                        tblMain.removeRows();
                    }
                    orgTreeF7.setData(null);
                    ((DefaultTreeModel)treeMain.getModel()).setRoot(null);
                    return;
                }
                if (!isOrgF7Change && ((OrgTreeInfo)orgTreeF7.getData()).getId().toString().equals(orgTreeInfo.getId().toString())) {
                    if (tblMain != null) {
                        tblMain.removeRows();
                    }
                    if (owner != null) {
                        owner.refreshList();
                    }
                    return;
                }
                orgTreeF7.setData((Object)orgTreeInfo);
                HashMap<String, String> conditions = new HashMap<String, String>();
                conditions.put("orgTreeId", orgTreeInfo.getId().toString());
                conditions.put("orgUnitNumber", selectOrgUnitNumber);
                conditions.put("isForOrgTreeF7", "true");
                if (!isUnion) {
                    conditions.put("isUnion", "false");
                }
                orgStructure = CslWorkTableFacadeFactory.getRemoteInstance().getOrgUnitTree(conditions);
                conditions.clear();
            }
            if (isRptDataChange && orgTreeF7.getSelector() != null && orgTreeF7.getSelector() instanceof MnsUnionF7) {
                final MnsUnionF7 orgUnionf7 = (MnsUnionF7)orgTreeF7.getSelector();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            orgUnionf7.setCanStart(false);
                            orgUnionf7.setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl(orgTreeColl, rptDate));
                            orgUnionf7.reRoadOrgTree();
                        }
                        catch (Exception e) {
                            logger.error((Object)"refreshOrgTree error", (Throwable)e);
                        }
                        finally {
                            orgUnionf7.setCanStart(true);
                        }
                    }
                }.start();
            }
        }
        if (orgStructure != null) {
            CslWorkTableUIUtil.buildTree(treeMain, orgStructure, soluInfo != null ? soluInfo.getOrgUnitNumberSet() : null);
        } else {
            if (tblMain != null) {
                tblMain.removeRows();
            }
            ((DefaultTreeModel)treeMain.getModel()).setRoot(null);
        }
    }

    public static void refreshOrgTreeAndOrgUnitTree(CslMergeSoluInfo soluInfo, KDBizPromptBox orgTreeF7, KDTree treeMain, KDTable tblMain, OrgTreeCollection orgTreeColl, Date rptDate, String selectOrgUnitNumber, ListUI owner, boolean isOrgF7Change) throws Exception {
        CslWorkTableUIUtil.refreshOrgTreeAndOrgUnitTree(soluInfo, orgTreeF7, treeMain, tblMain, orgTreeColl, rptDate, selectOrgUnitNumber, owner, isOrgF7Change, true);
    }

    public static OrgTreeInfo getOrgTreeInfo(OrgTreeCollection orgTreeColl, Date rptDate, String orgTreeNumber) throws Exception {
        OrgTreeCollection curOrgTreeCol = CslWorkTableUIUtil.getOrgTreeColl(orgTreeColl, rptDate);
        for (int i = 0; i < curOrgTreeCol.size(); ++i) {
            if (!curOrgTreeCol.get(i).getNumber().equals(orgTreeNumber)) continue;
            return curOrgTreeCol.get(i);
        }
        return null;
    }

    public static boolean batchDeleteRpt(final List[] rptIds, final CoreUI owner) throws Exception {
        final int count = rptIds[0].size() + rptIds[1].size();
        if (count == 0) {
            MsgBox.showInfo((String)CslRptUtil.getString((String)"838_audit_noSelectRpt"));
            return false;
        }
        ArrayList lockedIds = new ArrayList();
        lockedIds.addAll(CslWorkTableUIUtil.moveIdFromIdsToLockRpt(rptIds[0]));
        lockedIds.addAll(CslWorkTableUIUtil.moveIdFromIdsToLockRpt(rptIds[1]));
        boolean isConfirm = false;
        if (lockedIds.size() <= 0) {
            isConfirm = MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)CslWorkTableUtil.getResourceString("14_NotAuditRpt", new Integer[]{count})));
        } else {
            if (lockedIds.size() == count) {
                MsgBox.showConfirm2((String)CslWorkTableUtil.getResourceString("30_all_MutexLock", null));
                return false;
            }
            isConfirm = CslWorkTableUIUtil.showLockRtpMsg(lockedIds, ACTION_DELETE);
        }
        if (isConfirm) {
            final RptBatchHandle batchHandle = new RptBatchHandle();
            ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(owner, true);
            try {
                progressDialog.run(false, true, new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.setTaskName(CslWorkTableUtil.getResourceString("15_batchDeleteRpt", null));
                            monitor.beginTask(CslWorkTableUtil.getResourceString("16_rptDeleteing", null), count);
                            CslWorkTableUIUtil.batchRptMonitor(monitor, batchHandle);
                            batchHandle.batchDeleteRpt(rptIds);
                        }
                        catch (Exception e) {
                            logger.error((Object)"batchAddRpt error", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                            if (batchHandle.getErrorDetailResult().length() > 0) {
                                MsgBox.showDetailAndOK((Component)owner, (String)batchHandle.getTotleResult(), (String)batchHandle.getErrorDetailResult(), (int)1);
                            } else {
                                ((CslWorkTableListUI)owner).showSuccessMsg(batchHandle.getTotleResult());
                            }
                        }
                    }
                }, progressDialog);
            }
            catch (Exception ex) {
                logger.error((Object)"batchAddRpt error", (Throwable)ex);
                throw ex;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean batchCalculatorRpt(final List[] rptIds, int year, int period, Date rptDate, CurrencyInfo currency, OrgTreeInfo orgTreeInfo, FullOrgUnitInfo orgUnitInfo, final CoreUI owner) throws Exception {
        final int count = rptIds[0].size() + rptIds[1].size() + rptIds[2].size();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)CslWorkTableUtil.getResourceString("17_noAuditRptCount", new Object[]{count})))) {
            final RptBatchHandle batchHandle = new RptBatchHandle(year, period, rptDate, currency, orgTreeInfo, orgUnitInfo);
            ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(owner, true);
            try {
                progressDialog.run(false, true, new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.setTaskName(CslWorkTableUtil.getResourceString("18_batchCalcRpt", null));
                            monitor.beginTask(CslWorkTableUtil.getResourceString("19_rptCalcing", null), count);
                            CslWorkTableUIUtil.batchRptMonitor(monitor, batchHandle);
                            batchHandle.batchCalculatorRpt(rptIds);
                        }
                        catch (Exception e) {
                            logger.error((Object)"batchAddRpt error", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                            if (batchHandle.getErrorDetailResult().length() > 0) {
                                MsgBox.showDetailAndOK((Component)owner, (String)batchHandle.getTotleResult(), (String)batchHandle.getErrorDetailResult(), (int)1);
                            } else {
                                ((CslWorkTableListUI)owner).showSuccessMsg(batchHandle.getTotleResult());
                            }
                        }
                    }
                }, progressDialog);
            }
            catch (Exception ex) {
                logger.error((Object)"batchAddRpt error", (Throwable)ex);
                throw ex;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean batchCreateCslRptByMns(final List mnsIds, int year, int period, int periodType, Date rptDate, CurrencyInfo currency, OrgTreeInfo orgTreeInfo, FullOrgUnitInfo orgUnitInfo, final CoreUI owner) throws Exception {
        final int count = mnsIds.size();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)CslWorkTableUtil.getResourceString("20_notSupportGroupMnsCount", new Integer[]{count})))) {
            final RptBatchHandle batchHandle = new RptBatchHandle(year, period, rptDate, currency, orgTreeInfo, orgUnitInfo, periodType);
            ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(owner, true);
            try {
                progressDialog.run(false, true, new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.setTaskName(CslWorkTableUtil.getResourceString("21_createCslRpt", null));
                            monitor.beginTask(CslWorkTableUtil.getResourceString("22_creating", null), count);
                            CslWorkTableUIUtil.batchRptMonitor(monitor, batchHandle);
                            batchHandle.batchCreateCslRptByMns(mnsIds);
                        }
                        catch (Exception e) {
                            logger.error((Object)"batchAddRpt error", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                            if (batchHandle.getErrorDetailResult().length() > 0) {
                                MsgBox.showDetailAndOK((Component)owner, (String)batchHandle.getTotleResult(), (String)batchHandle.getErrorDetailResult(), (int)1);
                            } else {
                                ((CslWorkTableListUI)owner).showSuccessMsg(batchHandle.getTotleResult());
                            }
                        }
                    }
                }, progressDialog);
            }
            catch (Exception ex) {
                logger.error((Object)"batchAddRpt error", (Throwable)ex);
                throw ex;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean batchAddRpt(final List[] templates, int year, int period, Date rptDate, CurrencyInfo currency, OrgTreeInfo orgTreeInfo, FullOrgUnitInfo orgUnitInfo, final CoreUI owner) throws Exception {
        final int templateCount = templates[0].size() + templates[1].size() + templates[2].size();
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)owner, (String)CslWorkTableUtil.getResourceString("11_selectTemplate", new Object[]{templateCount})))) {
            final RptBatchHandle batchHandle = new RptBatchHandle(year, period, rptDate, currency, orgTreeInfo, orgUnitInfo);
            ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(owner, true);
            try {
                progressDialog.run(false, true, new IRunnableWithProgress(){

                    @Override
                    public void run(IProgressMonitor monitor) {
                        try {
                            monitor.setTaskName(CslWorkTableUtil.getResourceString("12_batchAddRpt", null));
                            monitor.beginTask(CslWorkTableUtil.getResourceString("13_RptAdding", null), templateCount);
                            CslWorkTableUIUtil.batchRptMonitor(monitor, batchHandle);
                            batchHandle.batchAddRpt(templates);
                        }
                        catch (Exception e) {
                            logger.error((Object)"batchAddRpt error", (Throwable)e);
                        }
                        finally {
                            monitor.done();
                            if (batchHandle.getErrorDetailResult().length() > 0) {
                                MsgBox.showDetailAndOK((Component)owner, (String)batchHandle.getTotleResult(), (String)batchHandle.getErrorDetailResult(), (int)1);
                            } else {
                                ((CslWorkTableListUI)owner).showSuccessMsg(batchHandle.getTotleResult());
                            }
                        }
                    }
                }, progressDialog);
            }
            catch (Exception ex) {
                logger.error((Object)"batchAddRpt error", (Throwable)ex);
                throw ex;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void batchRptMonitor(final IProgressMonitor monitor, final RptBatchHandle batchHandle) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int preIndex = 0;
                int curWorkIndex = batchHandle.getCurWorkIndex();
                while (curWorkIndex < batchHandle.getWorkTotle() && !batchHandle.isHandleEnd()) {
                    try {
                        monitor.worked(curWorkIndex - preIndex);
                        monitor.setTaskName(batchHandle.getMonitorName());
                        preIndex = curWorkIndex;
                        Thread.sleep(20L);
                        curWorkIndex = batchHandle.getCurWorkIndex();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"getCurWorkIndex thread error", (Throwable)ex);
                    }
                }
            }
        });
        thread.start();
    }

    public static CslReportInfo constructCslReportInfoByTemplateInfo(TemplateInfo tmpl) throws IOException, Exception {
        CslReportInfo report = new CslReportInfo();
        report.setId(BOSUuid.create((BOSObjectType)report.getBOSType()));
        report.setName(tmpl.getName());
        report.setBook(tmpl.getBook());
        report.setPeriodType(tmpl.getPeriodType());
        report.setSourceType(CslWorkTableUIUtil.adjustReportSourceType(tmpl.getTemplateType()));
        report.setDataCollect(DataCollectConstant.getActualDC());
        report.setDataCollectNumber("ACTUALDATA");
        report.setHandleStatus(RptHandleStatusEnum.FINISHED);
        report.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        report.setConvertStatus(ConvertStatusEnum.BeforeConvert);
        report.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        report.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        report.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        report.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        report.setTemplate(tmpl);
        return report;
    }

    public static RptSrcTypeEnum adjustReportSourceType(RptTmpTypeEnum tmplType) {
        if (RptTmpTypeEnum.SUMREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.SUM;
        }
        if (RptTmpTypeEnum.DYNAMICSUMREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.DYNAMICSUMREPORT;
        }
        if (RptTmpTypeEnum.MANUSCRIPT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.MANUSCRIPT;
        }
        if (RptTmpTypeEnum.CSLREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.CONSOLIDATION;
        }
        if (RptTmpTypeEnum.DYNAMICCSLREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.DYNAMICCSLREPORT;
        }
        return null;
    }

    public static boolean checkSelectedMutexLock(List ids) throws BOSException {
        List lockRptIds = CslWorkTableUIUtil.moveIdFromIdsToLockRpt(ids);
        if (lockRptIds.size() == 0) {
            return true;
        }
        if (ids.size() == 0) {
            MsgBox.showConfirm2((String)CslWorkTableUtil.getResourceString("30_all_MutexLock", null));
            return false;
        }
        return CslWorkTableUIUtil.showLockRtpMsg(lockRptIds, ACTION_VIEW);
    }

    private static boolean showLockRtpMsg(List lockRptIds, String actionName) throws BOSException {
        CslReportCollection cslReports = CslWorkTableUIUtil.getLockRpt(lockRptIds);
        StringBuffer rptNameMsg = new StringBuffer();
        StringBuffer sb = new StringBuffer("MutexLock_");
        sb.append(actionName);
        rptNameMsg.append(CslWorkTableUtil.getResourceString("32_MutexLock_RptList", null));
        for (int i = 0; i < cslReports.size(); ++i) {
            if (i > 0) {
                rptNameMsg.append("\u3001");
            }
            rptNameMsg.append(cslReports.get(i).getName());
        }
        int result = MsgBox.showConfirm3a((String)CslWorkTableUtil.getResourceString(sb.toString(), null), (String)rptNameMsg.toString());
        return result == 0;
    }

    private static List moveIdFromIdsToLockRpt(List ids) {
        ArrayList lockRpt = new ArrayList();
        for (int i = ids.size() - 1; i >= 0; --i) {
            boolean isLock = RptNewUIUtil.hasMutexLock(null, ids.get(i).toString());
            if (!isLock) continue;
            lockRpt.add(ids.get(i));
            ids.remove(i);
        }
        return lockRpt;
    }

    private static CslReportCollection getLockRpt(List lockRptId) throws BOSException {
        CslReportCollection cslReport = new CslReportCollection();
        if (lockRptId != null && lockRptId.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("name"));
            view.setFilter(new FilterInfo());
            StringBuffer mask = new StringBuffer();
            for (int i = 0; i < lockRptId.size(); ++i) {
                if (i > 0) {
                    mask.append(" or ");
                }
                mask.append("#" + i);
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", lockRptId.get(i)));
            }
            view.getFilter().setMaskString(mask.toString());
            cslReport = CslReportFactory.getRemoteInstance().getCslReportCollection(view);
        }
        return cslReport;
    }
}

