/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptQuerySoluInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IItemFormulaCheckResult;
import com.kingdee.eas.fi.gr.cslrpt.IRpcHandleFacade;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RpcHandleFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.SumRptAddedPerportyInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptEditUI;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.biz.AutoCslRptExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoMnsRptExecute;
import com.kingdee.eas.fi.gr.fast.biz.AutoSumSoluExecute;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.newrpt.cslworktable.CslRptObject;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RptBatchHandle {
    private static final Logger logger = CoreUIObject.getLogger(RptBatchHandle.class);
    private int year;
    private int period;
    private Date rptDate;
    private OrgTreeInfo orgTreeInfo;
    private FullOrgUnitInfo orgUnitInfo;
    private CurrencyInfo currency;
    private int periodType;
    private String curHandleName = null;
    private int curWorkIndex = 0;
    private int workTotle = 0;
    private int successCount = 0;
    private int failedCount = 0;
    private final int BATCHSAVE_REPEAT = 1;
    private final int BATCHSAVE_FAILED = 2;
    private final int BATCHSAVE_SUCCEED = 3;
    private boolean isHandleEnd = false;
    private StringBuffer failedMsg = new StringBuffer();
    private String reapetMsg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"782_CslRptUIUtil");

    public RptBatchHandle(int year, int period, Date rptDate, CurrencyInfo currency, OrgTreeInfo orgTreeInfo, FullOrgUnitInfo orgUnitInfo) {
        this.year = year;
        this.period = period;
        this.rptDate = rptDate;
        this.orgTreeInfo = orgTreeInfo;
        this.orgUnitInfo = orgUnitInfo;
        this.currency = currency;
    }

    public RptBatchHandle(int year, int period, Date rptDate, CurrencyInfo currency, OrgTreeInfo orgTreeInfo, FullOrgUnitInfo orgUnitInfo, int periodType) {
        this(year, period, rptDate, currency, orgTreeInfo, orgUnitInfo);
        this.periodType = periodType;
    }

    public RptBatchHandle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchAddRpt(List[] templates) throws Exception {
        try {
            SumRptEditUI sumRptHandle;
            this.workTotle = templates[0].size() + templates[1].size() + templates[2].size();
            TemplateCollection templateColl = null;
            if (templates[0].size() > 0) {
                sumRptHandle = new SumRptEditUI();
                templateColl = this.getTemplateColl(templates[0]);
                this.batchAddRpt(templateColl, (EditUI)sumRptHandle, null);
            }
            if (templates[1].size() > 0) {
                sumRptHandle = new MnsRptEditUI();
                templateColl = this.getTemplateColl(templates[1]);
                ArrayList<CslReportInfo> successList = new ArrayList<CslReportInfo>();
                this.batchAddRpt(templateColl, (EditUI)sumRptHandle, successList);
                if (!successList.isEmpty()) {
                    try {
                        Map result = CslReportFactory.getRemoteInstance().batchAddDataToMnsReport(successList);
                        List repeatIDLst = (List)result.get("repeatLst");
                        List failedIDLst = (List)result.get("failedLst");
                        List successIDLst = (List)result.get("successLst");
                        this.successCount += successIDLst.size();
                        this.failedCount = this.failedCount + failedIDLst.size() + repeatIDLst.size();
                    }
                    catch (Exception e) {
                        this.failedCount += successList.size();
                        for (CslReportInfo rpt : successList) {
                            this.failedMsg.append(rpt.getName()).append("  ").append(e.getMessage()).append("\n");
                        }
                    }
                }
            }
            if (templates[2].size() > 0) {
                sumRptHandle = new CslRptEditUI();
                templateColl = this.getTemplateColl(templates[2]);
                this.batchAddRpt(templateColl, (EditUI)sumRptHandle, null);
            }
        }
        finally {
            this.isHandleEnd = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchDeleteRpt(List[] rptIds) throws Exception {
        try {
            int i;
            this.workTotle = rptIds[0].size() + rptIds[1].size();
            ICslReport cslRptInft = CslReportFactory.getRemoteInstance();
            IItemFormulaCheckResult checkInft = ItemFormulaCheckResultFactory.getRemoteInstance();
            ArrayList<String> rptIdList = new ArrayList<String>();
            CslReportCollection coll = cslRptInft.getCslReportCollection("select id,name,sourceType where id in(" + CslRptUtil.list2String((List)rptIds[1], (String)",", (boolean)true) + ") order by sourceType");
            for (i = coll.size() - 1; i >= 0; --i) {
                try {
                    rptIdList.clear();
                    ++this.curWorkIndex;
                    this.curHandleName = coll.get(i).getName() + "[" + coll.get(i).getSourceType().getAlias() + "]";
                    cslRptInft.delete((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
                    rptIdList.add(coll.get(i).getId().toString());
                    checkInft.batchDelete(rptIdList);
                    ++this.successCount;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("batchDeleteRpt error" + this.curHandleName), (Throwable)e);
                    this.failedMsg.append(this.curHandleName).append("  ").append(e.getMessage()).append("\n");
                    ++this.failedCount;
                }
            }
            coll = cslRptInft.getCslReportCollection("select id,name where id in(" + CslRptUtil.list2String((List)rptIds[0], (String)",", (boolean)true) + ")");
            for (i = 0; i < coll.size(); ++i) {
                try {
                    ++this.curWorkIndex;
                    this.curHandleName = coll.get(i).getName();
                    cslRptInft.delete((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
                    ++this.successCount;
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("batchDeleteRpt error" + this.curHandleName), (Throwable)e);
                    this.failedMsg.append(this.curHandleName).append("  ").append(e.getMessage()).append("\n");
                    ++this.failedCount;
                }
            }
        }
        finally {
            this.isHandleEnd = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchCalculatorRpt(List[] rptIds) throws Exception {
        try {
            this.workTotle = rptIds[0].size() + rptIds[1].size() + rptIds[2].size();
            CslRptQuerySoluInfo defaultQuerySoluInfo = this.getCslRptQuerySoluInfo();
            FastMergeSoluInfo soluInfo = this.getSolutInfo();
            this.batchCalculate(rptIds[0], 0, soluInfo, defaultQuerySoluInfo);
            this.batchCalculate(rptIds[1], 1, soluInfo, defaultQuerySoluInfo);
            this.batchCalculate(rptIds[2], 2, soluInfo, defaultQuerySoluInfo);
        }
        finally {
            this.isHandleEnd = true;
        }
    }

    private void batchCalculate(List rptIds, int rptType, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo defaultQuerySoluInfo) throws Exception {
        int batchSize = 15;
        HashSet<String> ids = new HashSet<String>();
        for (Object id : rptIds) {
            if (ids.size() >= batchSize) {
                this.batchCalculate(ids, rptType, soluInfo, defaultQuerySoluInfo);
                ids.clear();
            }
            ids.add((String)id);
        }
        if (ids.size() > 0) {
            this.batchCalculate(ids, rptType, soluInfo, defaultQuerySoluInfo);
            ids.clear();
        }
    }

    private void batchCalculate(Set<String> rptIds, int rptType, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo defaultQuerySoluInfo) throws Exception {
        if (rptType == 0) {
            this.sumBatchCalculate(rptIds, soluInfo, defaultQuerySoluInfo);
        } else if (rptType == 1) {
            this.mnsBatchCalculate(rptIds, soluInfo, defaultQuerySoluInfo);
        } else if (rptType == 2) {
            this.cslBatchCalculate(rptIds, soluInfo, defaultQuerySoluInfo);
        }
    }

    private void sumBatchCalculate(Set<String> rptIds, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo defaultQuerySoluInfo) throws Exception {
        CslReportInfo info = null;
        AutoSumSoluExecute sumRptExecute = new AutoSumSoluExecute();
        CslReportCollection coll = this.getCslRptCollection(rptIds);
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                ++this.curWorkIndex;
                this.curHandleName = info.getName() + "[" + info.getSourceType().getAlias() + "]";
                sumRptExecute.initForCalAndSave(info, soluInfo, defaultQuerySoluInfo, defaultQuerySoluInfo.getSumMethod(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), true);
                sumRptExecute.calcAndSave();
                ++this.successCount;
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)("mnsBatchCalculate error" + this.curHandleName), e);
                this.failedMsg.append(this.curHandleName).append("  ").append(e.getMessage()).append("\n");
                ++this.failedCount;
            }
        }
    }

    private void cslBatchCalculate(Set<String> rptIds, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo defaultQuerySoluInfo) throws Exception {
        CslReportInfo info = null;
        AutoCslRptExecute cslRptExecute = new AutoCslRptExecute();
        CslReportCollection coll = this.getCslRptCollection(rptIds);
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                ++this.curWorkIndex;
                this.curHandleName = info.getName() + "[" + info.getSourceType().getAlias() + "]";
                cslRptExecute.initForCalAndSave(info, soluInfo, defaultQuerySoluInfo, defaultQuerySoluInfo.getSumMethod(), SysContext.getSysContext().getCurrentUserInfo().getId().toString(), true);
                cslRptExecute.calcAndSave();
                ++this.successCount;
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)("mnsBatchCalculate error" + this.curHandleName), e);
                String message = StringUtils.isEmpty((String)e.getMessage()) ? "" : e.getMessage();
                this.failedMsg.append(this.curHandleName).append("  ").append(message).append("\n");
                ++this.failedCount;
            }
        }
    }

    private void mnsBatchCalculate(Set<String> rptIds, FastMergeSoluInfo soluInfo, CslRptQuerySoluInfo defaultQuerySoluInfo) throws Exception {
        CslReportInfo info = null;
        AutoMnsRptExecute mnsRptExecute = new AutoMnsRptExecute();
        CslReportCollection coll = this.getCslRptCollection(rptIds);
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                ++this.curWorkIndex;
                this.curHandleName = info.getName() + "[" + info.getSourceType().getAlias() + "]";
                Boolean isSupportCrossMerger = true;
                isSupportCrossMerger = CSLParamUtil.isSupportCrossMerger(null, (String)info.getOrgTree().getId().toString());
                mnsRptExecute.initForCalAndSave(info, soluInfo, defaultQuerySoluInfo, SysContext.getSysContext().getCurrentUserInfo().getId().toString(), isSupportCrossMerger.booleanValue(), true);
                mnsRptExecute.calcAndSave();
                ++this.successCount;
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)("mnsBatchCalculate error" + this.curHandleName), e);
                this.failedMsg.append(this.curHandleName).append("  ").append(e.getMessage()).append("\n");
                ++this.failedCount;
            }
        }
    }

    private CslReportCollection getCslRptCollection(Set<String> rptIds) throws Exception {
        SelectorItemCollection selector = new CslReportProvider().getSelectors();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", rptIds, CompareType.INCLUDE));
        view.setSelector(selector);
        return CslReportFactory.getRemoteInstance().getCslReportCollection(view);
    }

    private CslRptQuerySoluInfo getCslRptQuerySoluInfo() throws Exception {
        if (this.workTotle > 0) {
            DynaSumMethodEnum defaultDySumMethod = DynaSumMethodEnum.SUM_BY_NAME;
            Object[] dynaSumMethods = CSLParamUtil.getDynaSumMethod(null);
            if (dynaSumMethods != null && dynaSumMethods.length > 0 && dynaSumMethods[0] instanceof DynaSumMethodEnum) {
                defaultDySumMethod = (DynaSumMethodEnum)dynaSumMethods[0];
            }
            IRpcHandleFacade rpcHand = RpcHandleFacadeFactory.getRemoteInstance();
            return FastMergeUtil.getCslDefaultQuerySoluInfo((OrgTreeInfo)this.orgTreeInfo, (IRpcHandleFacade)rpcHand, (String)this.orgUnitInfo.getId().toString(), (DynaSumMethodEnum)defaultDySumMethod);
        }
        return null;
    }

    private FastMergeSoluInfo getSolutInfo() throws Exception {
        FastMergeSoluInfo soluInfo = new FastMergeSoluInfo();
        soluInfo.setIsSupportGroupReport(true);
        return soluInfo;
    }

    public void batchAddRpt(TemplateCollection templateColl, EditUI handleUI, List<CslReportInfo> successMnsRptList) throws Exception {
        int resultStatus = 3;
        String exceptionMsg = null;
        for (int i = 0; i < templateColl.size(); ++i) {
            exceptionMsg = null;
            ++this.curWorkIndex;
            this.curHandleName = templateColl.get(i).getName() + "[" + templateColl.get(i).getTemplateType().getAlias() + "]";
            try {
                if (handleUI instanceof SumRptEditUI) {
                    resultStatus = ((SumRptEditUI)handleUI).addNewSumRpt(templateColl.get(i), this.rptDate, this.year, (short)this.period, this.currency, this.orgTreeInfo, (OrgUnitInfo)this.orgUnitInfo);
                } else if (handleUI instanceof MnsRptEditUI) {
                    resultStatus = ((MnsRptEditUI)handleUI).addNewEditData(templateColl.get(i), this.rptDate, this.year, (short)this.period, this.currency, this.orgTreeInfo, (OrgUnitInfo)this.orgUnitInfo, DataCollectConstant.getActualDC(), true, 0);
                    if (resultStatus == 3) {
                        successMnsRptList.add((CslReportInfo)((MnsRptEditUI)handleUI).getEditDataObject());
                    }
                } else if (handleUI instanceof CslRptEditUI) {
                    resultStatus = ((CslRptEditUI)handleUI).addNewCslRpt(templateColl.get(i), this.rptDate, this.year, (short)this.period, this.currency, this.orgTreeInfo, (OrgUnitInfo)this.orgUnitInfo, DataCollectConstant.getActualDC());
                }
            }
            catch (Exception e) {
                exceptionMsg = e.getMessage();
                resultStatus = 2;
                logger.error((Object)("batchAddRpt error" + this.curHandleName), (Throwable)e);
            }
            if (resultStatus == 3) {
                if (handleUI instanceof MnsRptEditUI) continue;
                ++this.successCount;
                continue;
            }
            if (resultStatus == 1) {
                ++this.failedCount;
                this.failedMsg.append(this.curHandleName).append("  ").append(this.reapetMsg).append("\n");
                continue;
            }
            ++this.failedCount;
            this.failedMsg.append(this.curHandleName);
            if (exceptionMsg != null) {
                this.failedMsg.append(" ").append(exceptionMsg);
            }
            this.failedMsg.append("\n");
        }
    }

    private TemplateCollection getTemplateColl(List templateIds) throws Exception {
        return TemplateFactory.getRemoteInstance().getTemplateCollection("select id,name,number,data,periodType,templateType,sheetParam.sheetName,sheetParam.id,sheetParam.sheetId,group,dynaRptType where id in(" + CslRptUtil.list2String((List)templateIds, (String)",", (boolean)true) + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchCreateCslRptByMns(List mnsRptIds) throws Exception {
        try {
            this.workTotle = mnsRptIds.size();
            this.curHandleName = CslWorkTableUtil.getResourceString("23_getCslTemplateByMns", null);
            Map condition = this.getCondition();
            Map cslTemplates = CslWorkTableFacadeFactory.getRemoteInstance().getCslRptTemplate(mnsRptIds, condition);
            if (cslTemplates != null) {
                int batchSize = 15;
                HashMap<String, List<CslRptObject>> batchCslTmpIds = new HashMap<String, List<CslRptObject>>();
                CslRptObject cslRptObject = null;
                ArrayList<CslRptObject> cslRptObjList = null;
                HashMap<String, String> mnsGroup_cslGroup = new HashMap<String, String>();
                for (Object mnsRptId : cslTemplates.keySet()) {
                    try {
                        cslRptObject = (CslRptObject)cslTemplates.get(mnsRptId);
                        if (cslRptObject.isHasCurVersionRpt()) {
                            ++this.curWorkIndex;
                            ++this.failedCount;
                            this.curHandleName = cslRptObject.getName();
                            this.failedMsg.append(cslRptObject.getName()).append(" ").append(CslWorkTableUtil.getResourceString("24_existCslRpt", null)).append(" \n");
                            continue;
                        }
                        cslRptObjList = (ArrayList<CslRptObject>)batchCslTmpIds.get(cslRptObject.getTemplateId());
                        if (cslRptObjList == null) {
                            cslRptObjList = new ArrayList<CslRptObject>();
                            batchCslTmpIds.put(cslRptObject.getTemplateId(), cslRptObjList);
                        }
                        cslRptObjList.add(cslRptObject);
                        if (batchCslTmpIds.size() < batchSize) continue;
                        this.batchAddNewVersionCslRpt(batchCslTmpIds, mnsGroup_cslGroup);
                        batchCslTmpIds.clear();
                    }
                    catch (Exception e) {
                        logger.error((Object)"batchCreateCslRptByMns error", (Throwable)e);
                        ++this.failedCount;
                        if (cslRptObject == null) continue;
                        this.failedMsg.append(cslRptObject.getName()).append(" ").append(e.getMessage()).append("\n");
                    }
                }
                if (batchCslTmpIds.size() > 0) {
                    this.batchAddNewVersionCslRpt(batchCslTmpIds, mnsGroup_cslGroup);
                    batchCslTmpIds.clear();
                }
                cslTemplates.clear();
                mnsGroup_cslGroup.clear();
            } else {
                this.failedCount = this.workTotle;
                this.failedMsg.append(CslWorkTableUtil.getResourceString("25_noCslRpt", null)).append("\n");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"batchCreateCslRptByMns error", (Throwable)ex);
            this.failedMsg.append(this.curHandleName).append(" error.").append(ex.getMessage()).append("\n");
        }
        finally {
            this.isHandleEnd = true;
        }
    }

    private void batchAddNewVersionCslRpt(Map<String, List<CslRptObject>> batchCslTmpIds, Map<String, String> mnsGroup_cslGroup) throws Exception {
        TemplateCollection tmpColl = this.getTemplateColl(Arrays.asList(batchCslTmpIds.keySet().toArray()));
        ICslReport icslRpt = CslReportFactory.getRemoteInstance();
        CslRptEditUI cslRptHandle = new CslRptEditUI();
        List<CslRptObject> cslRptObjList = null;
        CslReportInfo cslRptInfo = null;
        String group = null;
        for (int i = 0; i < tmpColl.size(); ++i) {
            cslRptObjList = batchCslTmpIds.get(tmpColl.get(i).getId().toString());
            for (CslRptObject cslRptObject : cslRptObjList) {
                try {
                    ++this.curWorkIndex;
                    this.curHandleName = cslRptObject.getName();
                    cslRptInfo = cslRptHandle.createNewCslRptInfo(tmpColl.get(i), this.rptDate, this.year, (short)this.period, this.currency, this.orgTreeInfo, (OrgUnitInfo)this.orgUnitInfo, DataCollectConstant.getActualDC());
                    SumRptAddedPerportyInfo addPerportyInfo = new SumRptAddedPerportyInfo();
                    addPerportyInfo.setVersion(cslRptObject.getRptVersionNumber());
                    addPerportyInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
                    group = cslRptObject.getGroupId();
                    if (StringUtils.isEmpty((String)group)) {
                        if (!StringUtils.isEmpty((String)cslRptObject.getMnsGroupId())) {
                            group = mnsGroup_cslGroup.get(cslRptObject.getMnsGroupId());
                            if (StringUtils.isEmpty((String)group)) {
                                group = Uuid.create().toString();
                                mnsGroup_cslGroup.put(cslRptObject.getMnsGroupId(), group);
                            }
                        } else {
                            group = Uuid.create().toString();
                        }
                    }
                    addPerportyInfo.setGroup(group);
                    cslRptInfo.put("addedPerporty", (Object)addPerportyInfo);
                    icslRpt.submit((CoreBaseInfo)cslRptInfo);
                    ++this.successCount;
                }
                catch (Exception e) {
                    ++this.failedCount;
                    if (cslRptObject == null) continue;
                    this.failedMsg.append(cslRptObject.getName()).append("  ").append(e.getMessage()).append("\n");
                }
            }
        }
    }

    private Map getCondition() {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("orgTreeId", this.orgTreeInfo.getId().toString());
        condition.put("orgUnitId", this.orgUnitInfo.getId().toString());
        condition.put("periodType", this.periodType);
        condition.put("year", this.year);
        condition.put("period", this.period);
        condition.put("currencyId", this.currency.getId().toString());
        return condition;
    }

    public String getMonitorName() {
        if (StringUtils.isEmpty((String)this.curHandleName)) {
            return CslWorkTableUtil.getResourceString("26_startHandle", null) + " " + this.curWorkIndex + "/" + this.workTotle;
        }
        return CslWorkTableUtil.getResourceString("27_handling", null) + "[" + this.curHandleName + "]  " + this.curWorkIndex + "/" + this.workTotle;
    }

    public String getTotleResult() {
        return CslWorkTableUtil.getResourceString("28_batchHandleResult", new Object[]{this.successCount, this.failedCount});
    }

    public int getWorkTotle() {
        return this.workTotle;
    }

    public int getCurWorkIndex() {
        return this.curWorkIndex;
    }

    public String getErrorDetailResult() {
        return this.failedMsg.toString();
    }

    public boolean isHandleEnd() {
        return this.isHandleEnd;
    }
}

