/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableFacadeFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.client.AbstractVersionRptValueListUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VersionRptValueListUI
extends AbstractVersionRptValueListUI {
    private static final Logger logger = CoreUIObject.getLogger(VersionRptValueListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTblMainData();
        this.initBtn();
    }

    private void initBtn() {
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
    }

    private void initTblMainData() throws Exception {
        Map uiContext = this.getUIContext();
        List selectItemFormulas = (List)uiContext.get("selectItemFormulas");
        Map rptId_version = (Map)uiContext.get("versionRpts");
        List versions = (List)uiContext.get("versions");
        if (selectItemFormulas != null && !selectItemFormulas.isEmpty() && rptId_version != null && !rptId_version.isEmpty()) {
            CslReportInfo rptInfo = (CslReportInfo)uiContext.get("reportInfo");
            rptInfo = (CslReportInfo)rptInfo.clone();
            rptInfo.setData(null);
            int precision = 2;
            if (rptInfo.getCurrency() != null && rptInfo.getCurrency().getPrecision() > 0) {
                precision = rptInfo.getCurrency().getPrecision();
            }
            String numberFmt = CslRptUIUtil.getNumberFtm((int)precision);
            IColumn iColumn = null;
            for (String version : versions) {
                iColumn = this.tblMain.addColumn();
                iColumn.setKey(version);
                iColumn.getStyleAttributes().setNumberFormat(numberFmt);
                iColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                iColumn.setWidth(125);
                this.tblMain.getHeadRow(0).getCell(iColumn.getColumnIndex()).setValue((Object)version);
            }
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("versionRpts", rptId_version);
            condition.put("selectItemFormulas", selectItemFormulas);
            List rows = CslWorkTableFacadeFactory.getRemoteInstance().getVersionCompareValues(condition, rptInfo);
            if (rows != null && !rows.isEmpty()) {
                IRow iRow = null;
                ICell iCell = null;
                Map rowMap = null;
                for (Object row : rows) {
                    iRow = this.tblMain.addRow();
                    rowMap = (Map)row;
                    for (Object rowKey : rowMap.keySet()) {
                        iCell = iRow.getCell(rowKey.toString());
                        if (iCell == null) continue;
                        iCell.setValue(rowMap.get(rowKey));
                    }
                }
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

