/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;

public class CslWorkTableUtil {
    public static String getRptTypeInStr(Integer rptType, Map<Integer, Boolean> permissionValue, boolean isGetTemplateType) {
        HashMap<Integer, String> rptType_filter = new HashMap<Integer, String>();
        rptType_filter.put(1, isGetTemplateType ? "3,11" : "2,11");
        rptType_filter.put(2, "4");
        rptType_filter.put(3, isGetTemplateType ? "5,13" : "3,12");
        rptType_filter.put(4, isGetTemplateType ? "13" : "42");
        if (rptType == 0) {
            StringBuffer filterInStr = new StringBuffer();
            if (permissionValue != null) {
                for (Integer curRptType : permissionValue.keySet()) {
                    if (!permissionValue.get(curRptType).booleanValue()) continue;
                    if (filterInStr.length() > 0) {
                        filterInStr.append(",");
                    }
                    filterInStr.append((String)rptType_filter.get(curRptType));
                }
                if (permissionValue.get(3).booleanValue()) {
                    if (filterInStr.length() > 0) {
                        filterInStr.append(",");
                    }
                    filterInStr.append((String)rptType_filter.get(4));
                }
            } else {
                for (Integer curRptType : rptType_filter.keySet()) {
                    if (filterInStr.length() > 0) {
                        filterInStr.append(",");
                    }
                    filterInStr.append((String)rptType_filter.get(curRptType));
                }
            }
            return filterInStr.toString();
        }
        return (String)rptType_filter.get(rptType);
    }

    public static String getRptAuditedStatusInStr(Boolean[] rptStatus) {
        StringBuffer filterStr = new StringBuffer();
        if (rptStatus[1].booleanValue()) {
            filterStr.append("1");
        }
        if (rptStatus[2].booleanValue()) {
            if (filterStr.length() > 0) {
                filterStr.append(",");
            }
            filterStr.append("2");
        }
        return filterStr.toString();
    }

    public static Map<Integer, Boolean> getPermissionValue(Context ctx, String orgUnitId, Integer rptType) throws Exception {
        String[] permItems = null;
        HashMap<String, Integer> tmp = new HashMap<String, Integer>();
        if (rptType == 1) {
            permItems = new String[]{"csl_sumrpt_addnew"};
            tmp.put("csl_sumrpt_addnew", rptType);
        } else if (rptType == 2) {
            permItems = new String[]{"csl_workingrpt_addnew"};
            tmp.put("csl_workingrpt_addnew", rptType);
        } else if (rptType == 3 || rptType == 4) {
            permItems = new String[]{"csl_cslrpt_addnew"};
            tmp.put("csl_cslrpt_addnew", 3);
        } else {
            permItems = new String[]{"csl_sumrpt_addnew", "csl_workingrpt_addnew", "csl_cslrpt_addnew"};
            tmp.put("csl_sumrpt_addnew", 1);
            tmp.put("csl_workingrpt_addnew", 2);
            tmp.put("csl_cslrpt_addnew", 3);
        }
        boolean[] hasPermArr = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgUnitId), permItems);
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>();
        for (int i = 0; i < permItems.length; ++i) {
            result.put((Integer)tmp.get(permItems[i]), hasPermArr[i]);
        }
        tmp.clear();
        return result;
    }

    public static void setUIContext(OrgUnitInfo orgUnitInfo, OrgTreeInfo orgTreeInfo) throws BOSException {
        SysContext.getSysContext().setCurrentOrgUnit(OrgType.UnionDebt, orgUnitInfo);
        IContextManager imanager = ContextManagerFactory.getRemoteInstance();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(OrgType.UnionDebt, orgUnitInfo);
        map.put("KEY_ORGTREE_INFO", orgTreeInfo);
        map.put("KEY_DATACOLLECT_NUMBER", "ACTUALDATA");
        imanager.setContext(map);
    }

    public static String getResourceString(String strKey, Object[] params) {
        if (params == null || params.length <= 0) {
            return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableResource", (String)strKey);
        }
        return EASResource.getString((String)"com.kingdee.eas.fi.newrpt.cslworktable.CslWorkTableResource", (String)strKey, (Object[])params);
    }
}

