/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterException;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.DBTypeEnum;
import com.kingdee.eas.fi.newrpt.dbcenter.client.AbstractDBCenterEditUI;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class DBCenterEditUI
extends AbstractDBCenterEditUI {
    private static final long serialVersionUID = 2274377974923972434L;
    private static final Logger logger = CoreUIObject.getLogger(DBCenterEditUI.class);
    private int maxIdle = 8;
    private int minIdle = 0;
    private int maxActive = 8;
    private long maxWait = -1L;
    private final String res = "com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource";
    private static String title = null;
    private DBCenterInfo oldDbCenterInfo = null;

    public void onLoad() throws Exception {
        this.hideComponent();
        super.onLoad();
        this.setTitle();
        this.setComponentStatus();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.init();
        }
        this.txtRemark.setSelectedItemData((Object)this.getDescription());
        if ("EDIT".equals(this.getOprtState())) {
            String id = this.editData.getId().toString();
            this.oldDbCenterInfo = DBCenterFactory.getRemoteInstance().getDBCenterInfo((IObjectPK)new ObjectUuidPK(id));
        }
    }

    private String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"pooldes")).append("\n\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"maxIdleDes")).append("\n\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"maxActiveDes")).append("\n\n");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"maxWaitDescription"));
        return sb.toString();
    }

    private void hideComponent() {
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
    }

    private void init() {
        this.txtDbAddress.setText(SysContext.getSysContext().getClientIP());
        this.comboDbType.setSelectedIndex(0);
        this.txtMaxIdle.setValue((Object)this.maxIdle);
        this.txtMinIdle.setValue((Object)this.minIdle);
        this.txtMaxActive.setValue((Object)this.maxActive);
        this.txtMaxWait.setValue((Object)this.maxWait);
        this.combWhenExhausted.setSelectedIndex(2);
        this.initComboDbType();
    }

    private void initComboDbType() {
        DBTypeEnum dbType = (DBTypeEnum)((Object)this.comboDbType.getSelectedItem());
        int dbtype = dbType.getValue();
        switch (dbtype) {
            case 0: {
                this.txtDbPort.setText("1433");
                break;
            }
            case 1: {
                this.txtDbPort.setText("1521");
                break;
            }
            case 2: {
                this.txtDbPort.setText("50000");
                break;
            }
            case 3: {
                this.txtDbPort.setText("3306");
                break;
            }
            case 4: {
                this.txtDbPort.setText("5432");
                break;
            }
            case 5: {
                this.txtDbPort.setText("5236");
                break;
            }
        }
    }

    private void setTitle() {
        title = this.getUITitle();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
        } else if ("VIEW".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"View"));
        } else if ("EDIT".equals(this.getOprtState())) {
            this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
        }
    }

    private void setComponentStatus() {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.menuBiz.setVisible(false);
        } else {
            if (this.isForbit()) {
                this.actionCancelCancel.setVisible(true);
                this.actionCancelCancel.setEnabled(true);
                this.actionCancel.setVisible(true);
                this.actionCancel.setEnabled(false);
                if ("EDIT".equals(this.getOprtState())) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(true);
                }
                this.actionRemove.setEnabled(true);
            } else {
                this.actionCancel.setVisible(true);
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setVisible(true);
                this.actionCancelCancel.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            this.menuBiz.setVisible(true);
        }
    }

    private boolean isForbit() {
        boolean isForbit = true;
        try {
            DBCenterInfo info = DBCenterFactory.getRemoteInstance().getDBCenterInfo("select isEnable where id = '" + this.editData.getId().toString() + "'");
            isForbit = info.isIsEnable();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isForbit;
    }

    protected IObjectValue createNewData() {
        DBCenterInfo info = new DBCenterInfo();
        info.setIsEnable(false);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DBCenterFactory.getRemoteInstance();
    }

    @Override
    protected void comboDbType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            DBTypeEnum dbType = (DBTypeEnum)((Object)this.comboDbType.getSelectedItem());
            int dbtype = dbType.getValue();
            String dbName = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"DBName") + "\u3000\u3000";
            String dbInstance = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"DBInstance") + "\u3000\u3000";
            switch (dbtype) {
                case 0: {
                    this.txtDbPort.setText("1433");
                    this.contDbName.setBoundLabelText(dbName);
                    break;
                }
                case 1: {
                    this.txtDbPort.setText("1521");
                    this.contDbName.setBoundLabelText(dbInstance);
                    break;
                }
                case 2: {
                    this.txtDbPort.setText("50000");
                    this.contDbName.setBoundLabelText(dbName);
                    break;
                }
                case 3: {
                    this.txtDbPort.setText("3306");
                    this.contDbName.setBoundLabelText(dbName);
                    break;
                }
                case 4: {
                    this.txtDbPort.setText("5432");
                    this.contDbName.setBoundLabelText(dbName);
                    break;
                }
                case 5: {
                    this.txtDbPort.setText("5236");
                    this.contDbName.setBoundLabelText(dbName);
                    break;
                }
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.baseInfoVerifyInput();
    }

    private void baseInfoVerifyInput() throws DBCenterException {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new DBCenterException(DBCenterException.DBCENTERNUMBERISNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new DBCenterException(DBCenterException.DBCENTERNAMEISNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getDbAddress())) {
            throw new DBCenterException(DBCenterException.DBADDRESSISNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getDbPort())) {
            throw new DBCenterException(DBCenterException.DBPORTISNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getDbName())) {
            throw new DBCenterException(DBCenterException.DBNAMEISNULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getDbUser())) {
            throw new DBCenterException(DBCenterException.DBUSERISNULL);
        }
        if (!this.editData.getDbPort().matches("[\\d]+")) {
            throw new DBCenterException(DBCenterException.DBPORTISNOTINTEGER);
        }
        if (this.editData.getNumber().length() > 80) {
            throw new DBCenterException(DBCenterException.NUMBERISTOOLONG);
        }
        if (this.editData.getName().length() > 255) {
            throw new DBCenterException(DBCenterException.NAMEISTOOLONG);
        }
        if (this.editData.getDbAddress().length() > 80) {
            throw new DBCenterException(DBCenterException.DBADDRESSISTOOLONG);
        }
        if (this.editData.getDbPort().length() > 80) {
            throw new DBCenterException(DBCenterException.DBPORTISTOOLONG);
        }
        if (this.editData.getDbName().length() > 80) {
            throw new DBCenterException(DBCenterException.DBNAMEISTOOLONG);
        }
        if (this.editData.getDbUser().length() > 80) {
            throw new DBCenterException(DBCenterException.DBUSERISTOOLONG);
        }
        if (this.editData.getDbPassWord() != null && this.editData.getDbPassWord().length() > 80) {
            throw new DBCenterException(DBCenterException.DBPASSWORDISTOOLONG);
        }
        if (this.editData.getDescription() != null && this.editData.getDescription().length() > 500) {
            throw new DBCenterException(DBCenterException.DESCRIPTIONISTOOLONG);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuBiz.setVisible(false);
        this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"AddNew"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.isForbit()) {
            this.actionCancelCancel.setVisible(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setVisible(true);
            this.actionCancel.setEnabled(false);
        } else {
            this.actionCancel.setVisible(true);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setVisible(true);
            this.actionCancelCancel.setEnabled(false);
        }
        this.setUITitle(title + " " + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Edit"));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        DBCenterFactory.getRemoteInstance().forbit(ids, true);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
        if ("EDIT".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANCEL_SUCCESS"));
        this.showMessage();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        DBCenterFactory.getRemoteInstance().forbit(ids, false);
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_ENABLE_SUCCESS"));
        this.showMessage();
    }

    @Override
    public void actionConnectionTest_actionPerformed(ActionEvent e) throws Exception {
        this.ConnectionVerifyInput();
        DBCenterInfo dbCenterInfo = this.getDBCenterInfo();
        try {
            DBCenterFactory.getRemoteInstance().testConnection(dbCenterInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"connectionSuccess"));
        }
        catch (Exception ex) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"failDetail");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"connectionFail"), (String)msg, (int)8188);
        }
    }

    private void ConnectionVerifyInput() throws DBCenterException {
        if (StringUtils.isEmpty((String)this.txtDbAddress.getText())) {
            throw new DBCenterException(DBCenterException.DBADDRESSISNULL);
        }
        if (StringUtils.isEmpty((String)this.txtDbPort.getText())) {
            throw new DBCenterException(DBCenterException.DBPORTISNULL);
        }
        if (!this.txtDbPort.getText().matches("[\\d]+")) {
            throw new DBCenterException(DBCenterException.DBPORTISNOTINTEGER);
        }
        if (StringUtils.isEmpty((String)this.txtDbName.getText())) {
            throw new DBCenterException(DBCenterException.DBNAMEISNULL);
        }
        if (StringUtils.isEmpty((String)this.txtDbUser.getText())) {
            throw new DBCenterException(DBCenterException.DBUSERISNULL);
        }
    }

    private DBCenterInfo getDBCenterInfo() {
        DBCenterInfo info = new DBCenterInfo();
        info.setDbType((DBTypeEnum)((Object)this.comboDbType.getSelectedItem()));
        info.setDbAddress(this.txtDbAddress.getText());
        info.setDbPort(this.txtDbPort.getText());
        info.setDbName(this.txtDbName.getText());
        info.setDbUser(this.txtDbUser.getText());
        if ("ADDNEW".equals(this.getOprtState())) {
            char[] secret = this.txtDbPassWord.getPassword();
            StringBuffer pass = new StringBuffer();
            for (int i = 0; i < secret.length; ++i) {
                pass.append(secret[i]);
            }
            String secretEncode = new BASE64Encoder().encodeBuffer(pass.toString().getBytes());
            info.setDbPassWord(secretEncode);
            Arrays.fill(secret, ' ');
        } else {
            char[] secret = this.txtDbPassWord.getPassword();
            StringBuffer pass = new StringBuffer();
            for (int i = 0; i < secret.length; ++i) {
                pass.append(secret[i]);
            }
            info.setDbPassWord(pass.toString());
            Arrays.fill(secret, ' ');
        }
        return info;
    }

    public boolean isModify() {
        if ("EDIT".equals(this.getOprtState())) {
            return this.checkEditModify();
        }
        return super.isModify();
    }

    private boolean checkEditModify() {
        this.storeFields();
        String number = this.editData.getNumber();
        String name = this.editData.getName();
        String description = this.editData.getDescription();
        if (this.oldDbCenterInfo == null) {
            String id = this.editData.getId().toString();
            try {
                this.oldDbCenterInfo = DBCenterFactory.getRemoteInstance().getDBCenterInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (number == null && this.oldDbCenterInfo.getNumber() != null || number != null && this.oldDbCenterInfo.getNumber() == null || number != null && this.oldDbCenterInfo.getNumber() != null && !number.equals(this.oldDbCenterInfo.getNumber())) {
            return true;
        }
        if (name == null && this.oldDbCenterInfo.getName() != null || name != null && this.oldDbCenterInfo.getName() == null || name != null && this.oldDbCenterInfo.getName() != null && !name.equals(this.oldDbCenterInfo.getName())) {
            return true;
        }
        if (description == null && this.oldDbCenterInfo.getDescription() != null || description != null && this.oldDbCenterInfo.getDescription() == null || description != null && this.oldDbCenterInfo.getDescription() != null && !description.equals(this.oldDbCenterInfo.getDescription())) {
            return true;
        }
        if (this.editData.getDbType().getValue() != this.oldDbCenterInfo.getDbType().getValue()) {
            return true;
        }
        if (this.editData.getDbAddress() == null || this.editData.getDbAddress() != null && !this.editData.getDbAddress().equals(this.oldDbCenterInfo.getDbAddress())) {
            return true;
        }
        if (this.editData.getDbName() == null || this.editData.getDbName() != null && !this.editData.getDbName().equals(this.oldDbCenterInfo.getDbName())) {
            return true;
        }
        if (this.editData.getDbPort() == null || this.editData.getDbPort() != null && !this.editData.getDbPort().equals(this.oldDbCenterInfo.getDbPort())) {
            return true;
        }
        if (this.editData.getDbUser() == null || this.editData.getDbUser() != null && !this.editData.getDbUser().equals(this.oldDbCenterInfo.getDbUser())) {
            return true;
        }
        if (this.editData.getDbPassWord() == null && this.oldDbCenterInfo.getDbPassWord() != null || this.editData.getDbPassWord() != null && this.oldDbCenterInfo.getDbPassWord() == null || this.editData.getDbPassWord() != null && this.oldDbCenterInfo.getDbPassWord() != null && !new String(Base64.decode((String)this.editData.getDbPassWord())).equals(new String(Base64.decode((String)this.oldDbCenterInfo.getDbPassWord())))) {
            return true;
        }
        if (this.editData.getMaxActive() != this.oldDbCenterInfo.getMaxActive()) {
            return true;
        }
        if (this.editData.getMaxIdle() != this.oldDbCenterInfo.getMaxIdle()) {
            return true;
        }
        if (this.editData.getMaxWait() != this.oldDbCenterInfo.getMaxWait()) {
            return true;
        }
        if (this.editData.getMinIdle() != this.oldDbCenterInfo.getMinIdle()) {
            return true;
        }
        return this.editData.getWhenExhausted().getValue() != this.oldDbCenterInfo.getWhenExhausted().getValue();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if ("ADDNEW".equals(this.getOprtState()) && !StringUtils.isEmpty((String)this.editData.getDbPassWord())) {
            String secretEncode = new BASE64Encoder().encodeBuffer(this.editData.getDbPassWord().getBytes());
            this.editData.setDbPassWord(secretEncode);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
            if ("EDIT".equals(this.getOprtState()) && this.editData.getId() != null) {
                String id = this.editData.getId().toString();
                this.oldDbCenterInfo = DBCenterFactory.getRemoteInstance().getDBCenterInfo((IObjectPK)new ObjectUuidPK(id));
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLAccessException) {
                if (ex.getMessage().indexOf("FNUMBER") > 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"13_numTooLong"));
                    SysUtil.abort();
                } else if (ex.getMessage().indexOf("FNAME") > 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"14_nameTooLong"));
                    SysUtil.abort();
                } else if (ex.getMessage().indexOf("FDESCRIPTION") > 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"15_descTooLong"));
                    SysUtil.abort();
                } else {
                    this.handleException(ex);
                }
            }
            this.handleException(ex);
        }
    }

    public boolean destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        boolean b = super.destroyWindow();
        if (b && owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return b;
    }
}

