/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.client;

import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.KDTableUtilForRpt;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.client.AbstractDBCenterListUI;
import com.kingdee.eas.fi.newrpt.dbcenter.client.DBCenterEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class DBCenterListUI
extends AbstractDBCenterListUI {
    private static final long serialVersionUID = 1849267980271426482L;
    private static final Logger logger = CoreUIObject.getLogger(DBCenterListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.addSeletedChangedListener();
    }

    private void addSeletedChangedListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    DBCenterListUI.this.selectDataIsFrz();
                }
                catch (Exception exc) {
                    DBCenterListUI.this.handUIException(exc);
                }
            }
        });
    }

    private void selectDataIsFrz() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        Object obj = this.tblMain.getRow(selectRow).getCell("isEnable").getValue();
        Boolean isFrz = (Boolean)obj;
        if (isFrz.booleanValue()) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet ids = new HashSet(idList);
        DBCenterFactory.getRemoteInstance().forbit(ids, true);
        this.refreshList();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANCEL_SUCCESS"));
        this.showMessage();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet ids = new HashSet(idList);
        DBCenterFactory.getRemoteInstance().forbit(ids, false);
        this.refreshList();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_ENABLE_SUCCESS"));
        this.showMessage();
    }

    @Override
    public void actionConnectionTest_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String dbCenterId = (String)idList.get(0);
        DBCenterInfo dbCenterInfo = DBCenterFactory.getRemoteInstance().getDBCenterInfo((IObjectPK)new ObjectUuidPK(dbCenterId));
        try {
            DBCenterFactory.getRemoteInstance().testConnection(dbCenterInfo);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"connectionSuccess"));
        }
        catch (Exception ex) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"failDetail");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"connectionFail"), (String)msg, (int)8188);
        }
    }

    protected String getEditUIName() {
        return DBCenterEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DBCenterFactory.getRemoteInstance();
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List[] rows = KDTableUtilForRpt.getSelectedFieldsValueBy((KDTable)this.tblMain, (String[])new String[]{"id", "name", "isEnable", "number"});
        ArrayList<ObjectUuidPK> ids = new ArrayList<ObjectUuidPK>();
        HashMap<String, String> dbCenters = new HashMap<String, String>();
        StringBuffer msg = new StringBuffer();
        int length = rows.length;
        for (int i = 0; i < length; ++i) {
            if (!Boolean.TRUE.toString().equals(rows[i].get(2))) continue;
            String id = String.valueOf(rows[i].get(0));
            String name = String.valueOf(rows[i].get(1));
            String number = String.valueOf(rows[i].get(3));
            dbCenters.put(id, number + "-" + name);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            ids.add(pk);
            msg.append(name).append("\n");
            this.setOprtState("REMOVE");
            try {
                this.pubFireVOChangeListener(id);
                continue;
            }
            catch (Throwable e1) {
                this.handUIException(e1);
                this.abort();
            }
        }
        if (ids.size() > 0) {
            try {
                if (this.confirmRemove(msg.toString())) {
                    IObjectPK[] pks = new IObjectPK[ids.size()];
                    int size = ids.size();
                    for (int i = 0; i < size; ++i) {
                        IObjectPK pk;
                        pks[i] = pk = (IObjectPK)ids.get(i);
                    }
                    DBCenterFactory.getRemoteInstance().deleteBatchData(pks);
                }
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(this.getSelectedKeyValue());
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                }
            }
            this.refreshList();
        } else {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"canNotRemove"));
            this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
            this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
            this.showMessage();
        }
    }

    private boolean confirmRemove(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.dbcenter.DBCenterResource", (String)"confirmRemove"), (String)msg));
    }

    protected void checkTableCommonMenu(KDTable table) {
        super.checkTableCommonMenu(table);
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if ("menuMail".equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!"menuPublishReport".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }
}

