/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.pool;

import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterException;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.IDBPool;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class AbstractDBPool
implements IDBPool {
    protected static final Logger log = Logger.getLogger(AbstractDBPool.class);
    private static final String KSQL_DRIVER = "com.kingdee.bos.sql.shell.Driver";
    private static final String POOLING_DRIVER = "org.apache.commons.dbcp.PoolingDriver";
    private static final String DBCP_URL = "jdbc:apache:commons:dbcp:";
    protected String dbCenterId = null;
    protected DBCenterInfo dbCenterInfo = null;
    protected String ksqlUrl = null;
    protected String dbUser = null;
    protected String dbPwd = null;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int maxActive = 8;
    private long maxWait = -1L;
    private int whenExhaustedCode = 2;
    private ObjectPool connectionPool = null;

    public AbstractDBPool(DBCenterInfo dbCenterInfo) {
        this.dbCenterId = dbCenterInfo.getId().toString();
        this.dbCenterInfo = dbCenterInfo;
    }

    @Override
    public synchronized void init() {
        this.dbUser = this.dbCenterInfo.getDbUser();
        this.dbPwd = this.dbCenterInfo.getDbPassWord();
        this.maxIdle = this.dbCenterInfo.getMaxIdle();
        if (this.maxIdle == 0) {
            this.maxIdle = 8;
        }
        this.maxActive = this.dbCenterInfo.getMaxActive();
        if (this.maxActive == 0) {
            this.maxActive = 8;
        }
        this.maxWait = this.dbCenterInfo.getMaxWait();
        if (this.maxWait == 0L) {
            this.maxWait = -1L;
        }
        this.whenExhaustedCode = this.dbCenterInfo.getWhenExhausted().getValue();
    }

    private byte getWhenExhausted(int whenExhaustedCode) {
        if (whenExhaustedCode == 0) {
            return 0;
        }
        if (whenExhaustedCode == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public synchronized void startPool() throws Exception {
        if (this.connectionPool != null) {
            this.closePool();
        }
        this.registerKSqlDriver();
        this.connectionPool = new GenericObjectPool(null, this.maxActive, this.getWhenExhausted(this.whenExhaustedCode), this.maxWait, this.maxIdle, true, false, -1L, 3, 1800000L, false);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.ksqlUrl, this.dbUser, this.dbPwd);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, null, null, false, true);
        this.registerPoolDriver();
        PoolingDriver driver = (PoolingDriver)this.getDriver();
        driver.registerPool(this.dbCenterId, this.connectionPool);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void closePool() throws Exception {
        PoolingDriver driver = (PoolingDriver)this.getDriver();
        if (driver == null) {
            return;
        }
        if (this.connectionPool != null && this.connectionPool.getNumActive() > 0) {
            AbstractDBPool.waitTime(10000L);
        }
        try {
            if (this.connectionPool != null) {
                this.connectionPool.clear();
            }
        }
        catch (UnsupportedOperationException e) {
            try {
                log.error((Object)("Close Connection Pool Error\uff1a" + e.getMessage()));
                throw new DBCenterException(DBCenterException.CLOSEPOOLERROR, new Object[]{e.getMessage()});
                catch (Exception e2) {
                    log.error((Object)("Close Connection Pool Error\uff1a" + e2.getMessage()));
                    throw new DBCenterException(DBCenterException.CLOSEPOOLERROR, new Object[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                try {
                    driver.closePool(this.dbCenterId);
                    throw throwable;
                }
                catch (SQLException e3) {
                    log.error((Object)("Close Connection Pool Error\uff1a" + e3.getMessage()));
                    throw new DBCenterException(DBCenterException.CLOSEPOOLERROR, new Object[]{e3.getMessage()});
                }
                finally {
                    this.connectionPool = null;
                }
            }
        }
        try {
            driver.closePool(this.dbCenterId);
        }
        catch (SQLException e) {
            log.error((Object)("Close Connection Pool Error\uff1a" + e.getMessage()));
            throw new DBCenterException(DBCenterException.CLOSEPOOLERROR, new Object[]{e.getMessage()});
        }
        finally {
            this.connectionPool = null;
        }
        log.info((Object)("Close Connection Pool Successfully,DBCenterId=" + this.dbCenterId));
    }

    @Override
    public synchronized Connection getConnection() throws Exception {
        if (StringUtils.isEmpty((String)this.dbCenterId)) {
            throw new DBCenterException(DBCenterException.DBCENTERIDISNULL);
        }
        if (this.connectionPool == null) {
            this.startPool();
        }
        Connection con = null;
        try {
            con = DriverManager.getConnection(DBCP_URL + this.dbCenterId);
        }
        catch (SQLException e) {
            log.error((Object)("Get Connection from Pool Error\uff1a" + e.getMessage()));
            throw new DBCenterException(DBCenterException.GETCONNECTIONFROMPOOLERROR, new Object[]{e.getMessage()});
        }
        return con;
    }

    @Override
    public void printPoolStatus() throws Exception {
        if (this.connectionPool == null) {
            return;
        }
        StringBuffer info = new StringBuffer();
        info.append("Current DBCenterInfo : dbCenterID is ").append(this.dbCenterId).append(", dbCenterName is ").append(this.dbCenterInfo.getName());
        info.append(", NumActive/NumBorrowed is ").append(this.connectionPool.getNumActive()).append(", NumIdle/NumSleeping is ").append(this.connectionPool.getNumIdle()).append(". \n");
        log.info((Object)info.toString());
    }

    @Override
    public int getPoolNumActive() throws Exception {
        return this.connectionPool == null ? 0 : this.connectionPool.getNumActive();
    }

    private void registerKSqlDriver() throws Exception {
        this.registerDriver(KSQL_DRIVER);
    }

    private void registerPoolDriver() throws Exception {
        this.registerDriver(POOLING_DRIVER);
    }

    private void registerDriver(String driveName) throws Exception {
        try {
            Class.forName(driveName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Register Driver Error\uff0cNot Found Class\uff1a" + driveName + e.getMessage()));
            throw new DBCenterException(DBCenterException.REGISTERDRIVERERROR, new Object[]{driveName + e.getMessage()});
        }
    }

    private Driver getDriver() throws DBCenterException {
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(DBCP_URL);
        }
        catch (SQLException e) {
            log.error((Object)("Get Driver Error\uff1a" + e.getMessage()));
            throw new DBCenterException(DBCenterException.GETDRIVERERROR, new Object[]{e.getMessage()});
        }
        return driver;
    }

    private static void waitTime(long milliSeconds) throws DBCenterException {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException e) {
            log.error((Object)("Thread Wait Error\uff1a" + e.getMessage()));
            throw new DBCenterException(DBCenterException.THREADWAITERROR, new Object[]{e.getMessage()});
        }
    }
}

