/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterCollection;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.IDBCenter;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBCenterManager {
    private static final Logger logger = Logger.getLogger(DBCenterManager.class);
    private static final String ClassForName = "com.kingdee.bos.sql.shell.KDDriver";

    public static Map<String, DBCenterInfo> getAllDbCenters(Context ctx) {
        HashMap<String, DBCenterInfo> map = new HashMap<String, DBCenterInfo>();
        try {
            IDBCenter iDBCenter = null;
            iDBCenter = ctx == null ? DBCenterFactory.getRemoteInstance() : DBCenterFactory.getLocalInstance(ctx);
            DBCenterCollection coll = iDBCenter.getDBCenterCollection("where isEnable = 0");
            if (coll != null && coll.size() > 0) {
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    DBCenterInfo dBCenterInfo = (DBCenterInfo)it.next();
                    String number = dBCenterInfo.getNumber();
                    if (!StringUtils.isEmpty((String)dBCenterInfo.getDbPassWord())) {
                        String secret = new String(Base64.decode((String)dBCenterInfo.getDbPassWord()));
                        dBCenterInfo.setDbPassWord(secret);
                    }
                    map.put(number, dBCenterInfo);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getAllDbCenters: ", (Throwable)e);
        }
        return map;
    }

    public static Connection openConnection(DBCenterInfo info) throws Exception {
        String connectUrl = null;
        Connection conn = null;
        String user = null;
        String secret = null;
        try {
            connectUrl = DBCenterManager.getDriverClassName(info.getDbType().getValue()) + ":" + DBCenterManager.getJDBCUrl(info);
            DBCenterManager.loadDrive();
            user = info.getDbUser();
            secret = new String(Base64.decode((String)info.getDbPassWord()));
            conn = DriverManager.getConnection(connectUrl, user, secret);
        }
        catch (Exception e) {
            logger.error((Object)("DataCenterInfo: Connection = " + connectUrl + ", user = " + user + ", pwd = " + secret + ",fail!"));
            DBCenterManager.closeConnection(conn);
            throw e;
        }
        return conn;
    }

    private static final boolean loadDrive() {
        try {
            Class.forName(ClassForName);
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)"loadDrive: ", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String getDriverClassName(int dbType) {
        switch (dbType) {
            case 0: {
                return "jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver";
            }
            case 1: {
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle";
            }
            case 2: {
                return "jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2";
            }
            case 3: {
                return "jdbc:ksql:com.mysql.jdbc.Driver:dbtype=mysql";
            }
            case 4: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql";
            }
            case 5: {
                return "jdbc:ksql:dm.jdbc.driver.DmDriver:dbtype=dm";
            }
        }
        return null;
    }

    public static String getJDBCUrl(DBCenterInfo info) {
        int dbType = info.getDbType().getValue();
        if (dbType == 0) {
            return DBCenterManager.getSqlServerUrl(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        if (dbType == 1) {
            return DBCenterManager.getOracelServiceUrl(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        if (dbType == 2) {
            return DBCenterManager.getDb2Url(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        if (dbType == 3) {
            return DBCenterManager.getMysql(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        if (dbType == 4) {
            return DBCenterManager.getPostgreSql(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        if (dbType == 5) {
            return DBCenterManager.getDM(info.getDbAddress(), Integer.valueOf(info.getDbPort()), info.getDbName());
        }
        return null;
    }

    private static String getSqlServerUrl(String dbaddress, int dbport, String dbName) {
        String[] arr;
        String instanceName = null;
        if (dbaddress.indexOf("\\") != -1 && (arr = dbaddress.split("\\\\")).length == 2) {
            dbaddress = arr[0];
            instanceName = arr[1];
        }
        StringBuffer sb = new StringBuffer();
        if (instanceName != null && !instanceName.equals("")) {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";instance=").append(instanceName).append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        } else {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        }
        return sb.toString();
    }

    private static String getOracelUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + ":" + instanceName;
    }

    private static String getOracelServiceUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + "/" + instanceName;
    }

    private static String getDb2Url(String dbaddress, int dbport, String dbName) {
        return "jdbc:db2://" + dbaddress + ":" + dbport + "/" + dbName + ":retrieveMessagesFromServerOnGetMessage=true;";
    }

    private static String getMysql(String dbaddress, int dbport, String dbName) {
        return "jdbc:mysql://" + dbaddress + ":" + dbport + "/" + dbName + "?useUnicode=true&characterEncoding=utf-8";
    }

    private static String getPostgreSql(String dbaddress, int dbport, String dbName) {
        return "jdbc:postgresql://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    private static String getDM(String dbaddress, int dbport, String dbName) {
        return "jdbc:dm://" + dbaddress + ":" + dbport + "/" + dbName;
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"close DBConnection faile.");
        }
    }
}

