/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.FormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.convt.RptItemData;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.FillFormulaFactory;
import com.kingdee.eas.fi.gr.cslrpt.articulation.fillformula.IFillFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.gr.cslrpt.util.ParameterContext;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaRuntimeEnvCalC {
    private static Logger logger = Logger.getLogger(FormulaRuntimeEnvCalC.class);
    private Context ctx;
    private CslReportInfo reportInfo;
    private FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv;
    private CurrencyInfo currency;
    private Map itemOrgTreeRelaMap = null;

    public FormulaRuntimeEnvCalC(Context ctx, CslReportInfo reportInfo, Map itemOrgTreeRelaMap) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.reportInfo = reportInfo;
        this.currency = reportInfo.getCurrency();
        this.itemOrgTreeRelaMap = itemOrgTreeRelaMap;
    }

    public FormulaRuntimeEnvCalC(Context ctx, CslReportInfo reportInfo, CurrencyInfo currency, Map itemOrgTreeRelaMap) throws BOSException, EASBizException {
        this(ctx, reportInfo, itemOrgTreeRelaMap);
        this.currency = currency;
    }

    private void fillFormulaIntoBook(List fillFormulaList, ParameterContext parameterContext) throws BOSException, EASBizException {
        this.formulaRuntimeEnv = this.getCalculateFormulaRuntimeEnv();
        for (int i = 0; i < fillFormulaList.size(); ++i) {
            Expression stmt;
            String[] formulaArr = (String[])fillFormulaList.get(i);
            String formula = formulaArr[1];
            try {
                stmt = ExcelFormulaPaserHelper.parse((String)formula);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"125_CheckFormulaControllerBean", (Locale)this.ctx.getLocale()) + formula + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"126_CheckFormulaControllerBean", (Locale)this.ctx.getLocale())));
            }
            formulaArr[1] = this.fillFormulaExpression(this.ctx, stmt, parameterContext).toString();
        }
        Book calculateBook = this.formulaRuntimeEnv.getCalculateBook();
        FormulaUtil.putFormulaToTable((List)fillFormulaList, (Book)calculateBook, (Context)this.ctx);
        this.saveCheckFormulaBook(calculateBook);
    }

    public Map[] fillBookAndCalc(List fillFormulaList, ParameterContext parameterContext) throws BOSException, EASBizException {
        this.fillFormulaIntoBook(fillFormulaList, parameterContext);
        return this.getFormulaResult();
    }

    protected Expression fillFormulaExpression(Context ctx, Expression expression, ParameterContext parameterContext) {
        if (expression instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expression;
            IFillFormula fillFormula = FillFormulaFactory.getFillFormula((String)functionExpr.funcionName);
            FunctionExpr expr = (FunctionExpr)expression;
            String dataEle = "";
            if (!functionExpr.funcionName.equalsIgnoreCase("RptDate")) {
                if (functionExpr.funcionName.equalsIgnoreCase("If")) {
                    List curParameters = expr.parameters;
                    Expression curExpr = null;
                    ArrayList<Expression> newParameters = new ArrayList<Expression>();
                    for (Object curParam : curParameters) {
                        curExpr = this.fillFormulaExpression(ctx, (Expression)curParam, parameterContext);
                        newParameters.add(curExpr);
                    }
                    expr.parameters = newParameters;
                } else if (functionExpr.funcionName.equalsIgnoreCase("ITEM")) {
                    int dataeleIndex = 3;
                    if (expr.parameters.get(dataeleIndex) instanceof StringExpr) {
                        dataEle = ((StringExpr)expr.parameters.get((int)dataeleIndex)).value;
                    } else if (expr.parameters.get(dataeleIndex) instanceof IntExpr) {
                        dataEle = ((IntExpr)expr.parameters.get((int)dataeleIndex)).value.toString();
                    }
                    RptItemData itemdat = new RptItemData(((StringExpr)expr.parameters.get((int)0)).value, dataEle);
                    if (this.itemOrgTreeRelaMap != null && this.itemOrgTreeRelaMap.get(itemdat) != null) {
                        parameterContext.setAttribute("orgTreeInfo", this.itemOrgTreeRelaMap.get(itemdat));
                    }
                } else if (functionExpr.funcionName.equalsIgnoreCase("DITEM")) {
                    int dataeleIndex = 4;
                    if (expr.parameters.get(dataeleIndex) instanceof StringExpr) {
                        dataEle = ((StringExpr)expr.parameters.get((int)dataeleIndex)).value;
                    } else if (expr.parameters.get(dataeleIndex) instanceof IntExpr) {
                        dataEle = ((IntExpr)expr.parameters.get((int)dataeleIndex)).value.toString();
                    }
                    RptItemData itemdat = new RptItemData(((StringExpr)expr.parameters.get((int)0)).value, dataEle);
                    if (this.itemOrgTreeRelaMap != null && this.itemOrgTreeRelaMap.get(itemdat) != null) {
                        parameterContext.setAttribute("orgTreeInfo", this.itemOrgTreeRelaMap.get(itemdat));
                    }
                }
            }
            expression = fillFormula.fillFormulaParameter(ctx, (FunctionExpr)expression, parameterContext);
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr;
            ((BinaryOperationExpr)expression).left = expr = this.fillFormulaExpression(ctx, ((BinaryOperationExpr)expression).left, parameterContext);
            ((BinaryOperationExpr)expression).right = expr = this.fillFormulaExpression(ctx, ((BinaryOperationExpr)expression).right, parameterContext);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr;
            ((UnaryOperationExpr)expression).operand = expr = this.fillFormulaExpression(ctx, ((UnaryOperationExpr)expression).operand, parameterContext);
        }
        return expression;
    }

    private Map[] getFormulaResult() throws BOSException, EASBizException {
        this.formulaRuntimeEnv.getCalculateBook().calc();
        Sheet sheet = this.formulaRuntimeEnv.getCalculateBook().getSheet(0);
        int precision = 2;
        if (this.currency != null) {
            precision = this.currency.getPrecision();
        }
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> resultFormula = new HashMap<String, String>();
        String formula = null;
        for (int m = 0; m <= sheet.getMaxRowIndex(); ++m) {
            Variant objValue = sheet.getRange(m, 1).getValue();
            formula = sheet.getRange(m, 1).getFormula();
            if (objValue == null || objValue.isNull()) {
                objValue = new Variant((Object)CslConstant.BGZERO);
            }
            String key = sheet.getRange(m, 0).getValue().toString();
            BigDecimal lValue = FormulaRuntimeEnvCalC.toBigDecimal(objValue);
            if (lValue != null) {
                lValue = lValue.setScale(precision, 4);
                resultMap.put(key, lValue);
            } else {
                resultMap.put(key, (BigDecimal)objValue);
            }
            resultFormula.put(key, formula);
        }
        return new Map[]{resultMap, resultFormula};
    }

    private static BigDecimal toBigDecimal(Object obj) {
        try {
            if (obj != null) {
                Variant v;
                if (obj instanceof BigDecimal) {
                    return (BigDecimal)obj;
                }
                if (obj instanceof Variant && ((v = (Variant)obj).isEmpty() || v.isNull())) {
                    return new BigDecimal(0.0);
                }
                if (obj.toString().startsWith("#PARAMETER")) {
                    return null;
                }
                if (obj.toString().indexOf("DIV/0") > -1) {
                    return null;
                }
                return new BigDecimal(obj.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"toBigDecimal:", (Throwable)e);
        }
        return null;
    }

    private FormulaRuntimeFactory.FormulaRuntimeEnv getCalculateFormulaRuntimeEnv() throws BOSException {
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        try {
            ICalculateContextProvider calculateContextProvider = this.getCalculateContextProvider(this.ctx, this.reportInfo);
            formulaRuntimeEnv = FormulaRuntimeFactory.getInstance().getFormulaRuntime(calculateContextProvider);
        }
        catch (Exception ex) {
            throw new BOSException("init formula runtime error", (Throwable)ex);
        }
        return formulaRuntimeEnv;
    }

    private ICalculateContextProvider getCalculateContextProvider(Context ctx, CslReportInfo rptInfo) throws BOSException {
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        calcContext.setReportAdapter((IReportPropertyAdapter)new CSLPropertyAdapter(rptInfo, ctx));
        try {
            ReportVariables reportVariables = ReportVariables.loadFromBook((Book)rptInfo.getBook());
            calcContext.setReportVariables(reportVariables);
        }
        catch (Exception ex) {
            throw new BOSException("UnpackBook Exception", (Throwable)ex);
        }
        return calcContext;
    }

    private void saveCheckFormulaBook(Book book) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (!StringUtils.isEmpty((String)easInstanceHome) && DebugLogger.isDebug) {
            try {
                IOHelper.saveToFile((Book)book, (String)(easInstanceHome + "/convDiffCheckBook.data"));
            }
            catch (IOException e) {
                logger.error((Object)"save btwCheckBookData error", (Throwable)e);
            }
        }
    }
}

