/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.formulasolu.client.AbstractFormulaSoluFilterUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FormulaSoluFilterUI
extends AbstractFormulaSoluFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaSoluFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.pmtTemplate.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RptTemplateQuery");
        this.pmtTemplate.setEditFormat("$number$");
        this.pmtTemplate.setDisplayFormat("$name$");
        this.pmtTemplate.setCommitFormat("$number$");
        this.pmtTemplate.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("template.isFreezed", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("template.isK3Tpl", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("template.templateType", new HashSet<Object>(Arrays.asList(6, 10)), CompareType.INCLUDE));
        this.pmtTemplate.setEntityViewInfo(view);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo fiiIsIncludeHistoryVersion;
        if (this.filterInfo == null) {
            this.filterInfo = new FilterInfo();
        } else {
            this.filterInfo.getFilterItems().clear();
        }
        int formulaIndex = 0;
        if (this.txtNumber.getText() != null && this.txtNumber.getText().trim().length() > 0) {
            FilterItemInfo filterItemNumber = new FilterItemInfo("number", (Object)("%" + this.txtNumber.getText().trim() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(filterItemNumber);
            ++formulaIndex;
        }
        if (this.txtName.getText() != null && this.txtName.getText().trim().length() > 0) {
            FilterItemInfo filterItemName = new FilterItemInfo("name", (Object)("%" + this.txtName.getText() + "%"), CompareType.LIKE);
            this.filterInfo.getFilterItems().add(filterItemName);
            ++formulaIndex;
        }
        if (this.pmtTemplate.getValue() != null) {
            TemplateInfo info = (TemplateInfo)this.pmtTemplate.getValue();
            String groupid = info.getGroup();
            FilterItemInfo filterItemNumber = new FilterItemInfo("templateGroupId", (Object)groupid, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemNumber);
            ++formulaIndex;
        }
        if (this.chkIsAudited.isSelected()) {
            FilterItemInfo filterItemIsAudited = new FilterItemInfo("auditedStatus", (Object)new Integer(AuditedStatusEnum.AUDITED.getValue()), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemIsAudited);
            ++formulaIndex;
        }
        if (!this.chkIsIncludeHistoryVersion.isSelected()) {
            fiiIsIncludeHistoryVersion = new FilterItemInfo("versionStatus", (Object)new Integer(2), CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(fiiIsIncludeHistoryVersion);
            ++formulaIndex;
        } else {
            fiiIsIncludeHistoryVersion = new FilterItemInfo("versionStatus", (Object)new Integer(100), CompareType.NOTEQUALS);
            this.filterInfo.getFilterItems().add(fiiIsIncludeHistoryVersion);
            ++formulaIndex;
        }
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < formulaIndex; ++i) {
            if (i == 0) {
                sbFormula.append(" (#0)");
                continue;
            }
            sbFormula.append(" and (#" + i + ")");
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo view) {
        this.clearUI();
        super.loadData(view);
        FilterItemCollection fic = view.getFilter() == null ? new FilterItemCollection() : view.getFilter().getFilterItems();
        for (int i = 0; i < fic.size(); ++i) {
            FilterItemInfo filterItemInfo = fic.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("name")) {
                String reportName = (String)filterItemInfo.getCompareValue();
                if (reportName.startsWith("%")) {
                    reportName = reportName.substring(1);
                }
                if (reportName.endsWith("%")) {
                    reportName = reportName.substring(0, reportName.length() - 1);
                }
                this.txtName.setText(reportName);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                if (number.startsWith("%")) {
                    number = number.substring(1);
                }
                if (number.endsWith("%")) {
                    number = number.substring(0, number.length() - 1);
                }
                this.txtNumber.setText(number);
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("templateGroupId")) {
                String groupid = (String)filterItemInfo.getCompareValue();
                try {
                    TemplateInfo info = TemplateFactory.getRemoteInstance().getTemplateInfo("where group ='" + groupid + "' and versionStatus = " + 1 + " and isK3Tpl = 0 and isFreezed = 0 ");
                    this.pmtTemplate.setValue((Object)info);
                }
                catch (Exception exception) {}
                continue;
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("auditedStatus")) {
                Integer intAuditStatus = (Integer)filterItemInfo.getCompareValue();
                if (AuditedStatusEnum.getEnum((int)intAuditStatus).equals((Object)AuditedStatusEnum.AUDITED)) {
                    this.chkIsAudited.setSelected(true);
                    continue;
                }
                this.chkIsAudited.setSelected(false);
                continue;
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("versionStatus")) continue;
            Integer intVersionStatus = (Integer)filterItemInfo.getCompareValue();
            if (intVersionStatus == 2) {
                this.chkIsIncludeHistoryVersion.setSelected(false);
                continue;
            }
            this.chkIsIncludeHistoryVersion.setSelected(true);
        }
    }

    private void clearUI() {
        this.txtNumber.setText("");
        this.txtName.setText("");
        this.pmtTemplate.setValue(null);
        this.chkIsAudited.setSelected(false);
        this.chkIsIncludeHistoryVersion.setSelected(false);
    }

    public void clear() {
        this.clearUI();
        super.clear();
    }
}

