/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexException;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.client.AbstractFormulaSoluListUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluDispenseUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluEditUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluFilterUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluUnDispenseUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSolutionProcessUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FormulaSoluListUI
extends AbstractFormulaSoluListUI {
    private static final long serialVersionUID = -5779380584670841100L;
    private static final Logger logger = CoreUIObject.getLogger(FormulaSoluListUI.class);
    private static final String FORMULASOLU_PATH = "com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource";
    private static final String TBLMAIN_AUDITED_STATUS = "auditedStatus";
    private static final String TBLMAIN_ID = "id";
    private boolean selfGradeOnly = false;
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private CommonQueryDialog conditionDialog = null;
    private FormulaSoluFilterUI conditionPanel = null;

    public FormulaSoluListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                int n = end;
                for (int i = begin; i <= n; ++i) {
                    Object recordCreatorid;
                    if (FormulaSoluListUI.this.tblMain.getRow(i) == null || (recordCreatorid = FormulaSoluListUI.this.tblMain.getRow(i).getCell("trackRecordCreatorid").getValue()) == null || recordCreatorid.equals(FormulaSoluListUI.this.company.getId().toString())) continue;
                    FormulaSoluListUI.this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CslGradeManageUtil.showBtnByCurrentOrg(this.btnUpdateMaintainOrg);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                FormulaSoluListUI.this.changeBtnSateByCreateCompany();
            }
        });
        this.actionCopyAndAddNew.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionFmtEdit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_modifyformat"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex > -1) {
            String tmpId = this.getTblMain().getRow(rowIndex).getCell("templateId").getValue().toString();
            try {
                TemplateInfo tmpl = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(tmpId));
                uiContext.put((Object)"tmpInfo", (Object)tmpl);
            }
            catch (EASBizException e1) {
                logger.error((Object)"prepareUIContext: ", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"prepareUIContext: ", (Throwable)e1);
            }
        }
    }

    @Override
    public void actionFmtEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFmtEdit_actionPerformed(e);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.getTblMain().getRow(rowIndex);
        String soluId = (String)row.getCell(TBLMAIN_ID).getValue();
        if (2 == Integer.parseInt(((BizEnumValueDTO)row.getCell(TBLMAIN_AUDITED_STATUS).getValue()).getValue().toString())) {
            if (this.isLastestVersion(row)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)FORMULASOLU_PATH, (String)"35_haveTemplateEdition"));
                return;
            }
            if (MsgBox.showConfirm2((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"36_TemplateEdition")) == 2) {
                return;
            }
            int result = MsgBox.showConfirm3((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"37_Template_IsAutoUpdate"));
            if (result == 2) {
                return;
            }
            boolean isAutoUpdate = result == 0;
            soluId = FormulaSoluFactory.getRemoteInstance().version(soluId, isAutoUpdate);
            this.actionRefresh_actionPerformed(e);
        }
        UIContext uiContext = new UIContext((Object)this);
        String tmpId = this.getTblMain().getRow(rowIndex).getCell("templateId").getValue().toString();
        try {
            Uuid editLock = MutexUtil.setMutex((String)"FormulaSoluEdit", (BOSUuid)BOSUuid.read((String)soluId), (String)"ActionEdit");
            uiContext.put((Object)"formulaSoluLockid", (Object)editLock);
        }
        catch (MutexException ex) {
            MsgBox.showError((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"13_FormulaSoluisEditing"));
            SysUtil.abort();
        }
        uiContext.put((Object)"ID", (Object)tmpId);
        uiContext.put((Object)"openTemplate", (Object)Boolean.TRUE);
        uiContext.put((Object)"formulaSoluid", (Object)soluId);
        final IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FormulaSolutionProcessUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.show();
            }
        });
    }

    private boolean isLastestVersion(IRow row) throws EASBizException, BOSException {
        String number = (String)row.getCell("number").getValue();
        String id = (String)row.getCell(TBLMAIN_ID).getValue();
        return FormulaSoluFactory.getRemoteInstance().exists("where number = '" + number + "' and versionStatus in (" + 0 + "," + 1 + ") and id != '" + id + "'");
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FormulaSoluFactory.getRemoteInstance();
    }

    private KDTable getTblMain() {
        return this.tblMain;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            String oprtState = OprtState.EDIT;
            Object recordCreatorid = this.tblMain.getRow(rowIndex).getCell("trackRecordCreatorid").getValue();
            if (recordCreatorid != null) {
                IRow row = this.getTblMain().getRow(rowIndex);
                if (!recordCreatorid.equals(this.company.getId().toString()) || 2 == Integer.parseInt(((BizEnumValueDTO)row.getCell(TBLMAIN_AUDITED_STATUS).getValue()).getValue().toString())) {
                    oprtState = OprtState.VIEW;
                }
            }
            this.showProcessUI(oprtState);
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void showProcessUI(String oprtState) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String tmpId = this.getTblMain().getRow(rowIndex).getCell("templateId").getValue().toString();
        String formulaId = this.getTblMain().getRow(rowIndex).getCell(TBLMAIN_ID).getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        if (OprtState.EDIT.equals(oprtState)) {
            try {
                Uuid editLock = MutexUtil.setMutex((String)"FormulaSoluEdit", (BOSUuid)BOSUuid.read((String)formulaId), (String)"ActionEdit");
                uiContext.put((Object)"formulaSoluLockid", (Object)editLock);
            }
            catch (MutexException e) {
                MsgBox.showError((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"13_FormulaSoluisEditing"));
                SysUtil.abort();
            }
        }
        uiContext.put((Object)"ID", (Object)tmpId);
        uiContext.put((Object)"openTemplate", (Object)Boolean.TRUE);
        uiContext.put((Object)"formulaSoluid", (Object)formulaId);
        final IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FormulaSolutionProcessUI.class.getName(), (Map)uiContext, null, oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.show();
            }
        });
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.showProcessUI(OprtState.VIEW);
    }

    private List<String> getDispenseIds(boolean isUn) throws EASBizException, BOSException {
        this.checkSelected();
        ArrayList<String> formulaSoluIds = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> groupMap = new ArrayList<String>();
        ArrayList<String> appendName = new ArrayList<String>();
        StringBuffer tipTempName = new StringBuffer();
        ArrayList selectRowNum = this.getSelectList();
        for (int i = 0; i < selectRowNum.size(); ++i) {
            IRow row = this.tblMain.getRow(((Integer)selectRowNum.get(i)).intValue());
            String id = row.getCell(TBLMAIN_ID).getValue().toString();
            ids.add(id);
            if (this.isEquals(row, TBLMAIN_AUDITED_STATUS, AuditedStatusEnum.AUDITED.getAlias())) {
                formulaSoluIds.add(id);
            }
            if (this.isSoluVersioned(row)) {
                String resName = "47_versionedSoluDisp";
                if (isUn) {
                    resName = "48_versionedSoluUndisp";
                }
                MsgBox.showWarning((String)EASResource.getString((String)FORMULASOLU_PATH, (String)resName));
                SysUtil.abort();
            }
            if (isUn) continue;
            String groupId = row.getCell("templateGroupId").getValue().toString();
            String tempName = row.getCell("templateName").getValue().toString();
            if (!groupMap.contains(groupId)) {
                groupMap.add(groupId);
                continue;
            }
            if (appendName.contains(tempName)) continue;
            tipTempName.append(tempName).append("\n");
            appendName.add(tempName);
        }
        if (formulaSoluIds.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"12_selectSolu"));
            this.setTableSelectRow(ids);
            SysUtil.abort();
        }
        if (tipTempName.length() > 0) {
            MsgBox.showConfirm3a((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"28_checkDispense"), (String)tipTempName.toString());
            this.setTableSelectRow(ids);
            SysUtil.abort();
        }
        return formulaSoluIds;
    }

    private boolean isSoluVersioned(IRow row) {
        BizEnumValueDTO versionStatus = (BizEnumValueDTO)row.getCell("versionStatus").getValue();
        return Integer.valueOf(versionStatus.getValue().toString()) == 2;
    }

    @Override
    public void actionFormulaSoluDispense_actionPerformed(ActionEvent e) throws Exception {
        List<String> formulaSoluIds = this.getDispenseIds(false);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"formulaSoluIdKey", formulaSoluIds);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaSoluDispenseUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionFormulaSoluUnDispense_actionPerformed(ActionEvent e) throws Exception {
        List<String> formulaSoluIds = this.getDispenseIds(true);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"formulaSoluIdKey", formulaSoluIds);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FormulaSoluUnDispenseUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.actionRefresh_actionPerformed(e);
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg("T_CSL_FormulaSolu", "FTrackRecordCreatorID", this.getSelectedIdValues());
        this.clearCache();
        this.actionRefresh_actionPerformed(e);
    }

    private void clearCache() {
        ICacheService svc = CacheServiceFactory.getInstance();
        svc.discardType(new BOSObjectType("A531F1A9"));
    }

    private void changeBtnSateByCreateCompany() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        if (!this.tblMain.getRow(selectRow).getCell("trackRecordCreatorid").getValue().toString().equals(this.company.getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnFmtEdit.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else {
            if (AuditedStatusEnum.AUDITED.getAlias().equals(this.tblMain.getRow(selectRow).getCell(TBLMAIN_AUDITED_STATUS).getValue().toString())) {
                this.menuItemEdit.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnRemove.setEnabled(false);
            } else {
                this.btnEdit.setEnabled(true);
                this.menuItemEdit.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                this.btnRemove.setEnabled(true);
            }
            this.btnFmtEdit.setEnabled(true);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionCopyAndAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyAndAddNew_actionPerformed(e);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        FormulaSoluInfo info = FormulaSoluFactory.getRemoteInstance().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(id));
        uiContext.put((Object)"formulaSoluIdBeforeCopy", (Object)info.getId().toString());
        info.setId(null);
        info.setNumber(null);
        info.setName(null);
        info.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        info.setAuditor(null);
        info.setCreator(this.getUserInfo());
        info.setLastUpdateUser(this.getUserInfo());
        uiContext.put((Object)"formulaSolu", (Object)info);
        uiContext.put((Object)"isCopyAction", (Object)true);
        String oprt = OprtState.ADDNEW;
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FormulaSoluEditUI.class.getName(), (Map)uiContext, null, oprt);
        window.show();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        this.setTableSelectRow(ids);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        List<String> ids = this.getselectIds(TBLMAIN_AUDITED_STATUS, AuditedStatusEnum.UNAUDITED.getAlias(), true);
        this.doAudit(AuditedStatusEnum.AUDITED, ids, "29_auditTips");
    }

    @Override
    public void actionUNAudit_actionPerformed(ActionEvent e) throws Exception {
        List<String> ids = this.getselectIds(TBLMAIN_AUDITED_STATUS, AuditedStatusEnum.AUDITED.getAlias(), true);
        this.doAudit(AuditedStatusEnum.UNAUDITED, ids, "30_unauditTips");
    }

    private void doAudit(AuditedStatusEnum auditedStatus, List<String> ids, String tipsResName) throws Exception {
        if (ids == null || ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)FORMULASOLU_PATH, (String)tipsResName));
            this.setTableSelectRow(ids);
            SysUtil.abort();
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        for (String id : ids) {
            FormulaSoluInfo info = new FormulaSoluInfo();
            info.setId(BOSUuid.read((String)id));
            info.setAuditedStatus(auditedStatus);
            info.setAuditor(AuditedStatusEnum.AUDITED.equals((Object)auditedStatus) ? this.getUserInfo() : null);
            colls.add((CoreBaseInfo)info);
        }
        if (colls.size() > 0) {
            this.getBizInterface().updateBatchData(colls);
        }
        this.refresh(null);
        this.setTableSelectRow(ids);
    }

    private List<String> getselectIds(String colName, String equalValue, boolean isCreateOrg) {
        this.checkSelected();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList selectRowNum = this.getSelectList();
        if (selectRowNum.size() <= 0 || StringUtils.isEmpty((String)colName) || StringUtils.isEmpty((String)equalValue)) {
            return ids;
        }
        boolean isadd = true;
        for (int i = 0; i < selectRowNum.size(); ++i) {
            IRow row = this.tblMain.getRow(((Integer)selectRowNum.get(i)).intValue());
            if (!this.isEquals(row, colName, equalValue)) continue;
            if (isCreateOrg) {
                Object recordCreatorid = this.tblMain.getRow(((Integer)selectRowNum.get(i)).intValue()).getCell("trackRecordCreatorid").getValue();
                isadd = recordCreatorid == null || recordCreatorid.equals(this.company.getId().toString());
            }
            if (!isadd) continue;
            ids.add(row.getCell(TBLMAIN_ID).getValue().toString());
        }
        return ids;
    }

    private boolean isEquals(IRow row, String colName, String equalValue) {
        return equalValue.equals(row.getCell(colName).getValue().toString());
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        List<String> formulaSoluIds = this.getselectIds(TBLMAIN_AUDITED_STATUS, AuditedStatusEnum.UNAUDITED.getAlias(), true);
        if (formulaSoluIds.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)FORMULASOLU_PATH, (String)"24_auditSoluCannotDelete"));
            return;
        }
        if (!this.confirmRemove()) {
            return;
        }
        for (int i = 0; i < formulaSoluIds.size(); ++i) {
            String id = formulaSoluIds.get(i).toString();
            FormulaSoluFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(id));
        }
        this.refresh(e);
    }

    private void setTableSelectRow(List ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell(TBLMAIN_ID).getValue().toString();
            if (!ids.contains(id)) continue;
            this.tblMain.getSelectManager().select(i, 0);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            MetaDataPK mainQueryPk = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.formulasolu", (String)"FormulaSoluQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPk);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setTitle(EASResource.getString((String)FORMULASOLU_PATH, (String)"34_filterUITitile"));
            this.conditionDialog.setWidth(300);
            this.conditionDialog.setHeight(180);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        }
        return this.conditionDialog;
    }

    public FormulaSoluFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new FormulaSoluFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            CustomerParams cp = new CustomerParams();
            cp.addCustomerParam("parent", this.getMetaDataPK().getFullName());
            this.conditionPanel.setCustomerParams(cp);
        }
        return this.conditionPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = FormulaSoluListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.getConditionDialog().show()) {
                this.tHelper.setDialog(this.getConditionDialog());
                this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
                this.addGradeFilter();
                this.doQuery(this.getConditionDialog());
                this.tblMain.removeRows();
            } else {
                SysUtil.abort();
            }
        } else {
            this.tblMain.removeRows();
        }
    }

    private void addGradeFilter() throws BOSException {
        FilterInfo info = this.getDefaultFilterForQuery();
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            this.mainQuery.getFilter().mergeFilter(info, "and");
        } else if (this.mainQuery != null) {
            this.mainQuery.setFilter(info);
        }
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)2, CompareType.NOTEQUALS));
        evi.setFilter(filterInfo);
        return evi;
    }
}

