/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RunTimeException;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.fi.gr.cslrpt.client.UnionVersion2F7;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.client.AbstractFormulaSoluUnDispenseUI;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaSoluUnDispenseUI
extends AbstractFormulaSoluUnDispenseUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaSoluUnDispenseUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadOrgBound();
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    protected void kDBizPrmptOrgTree_dataChanged(DataChangeEvent e) throws Exception {
        super.kDBizPrmptOrgTree_dataChanged(e);
        if (this.kDBizPrmptOrgTree.getData() != null && this.kDBizPrmptOrgTree.getData() instanceof OrgTreeInfo) {
            OrgTreeInfo orgBound = (OrgTreeInfo)this.kDBizPrmptOrgTree.getData();
            this.refreshOrgUnit(orgBound.getId().toString());
            this.kDBizPrmptOrgUnit.setEnabled(true);
            this.actionRefresh_actionPerformed(null);
        } else {
            this.kDBizPrmptOrgUnit.setEnabled(false);
        }
    }

    @Override
    protected void kDBizPrmptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        List formulaSoluIds = (List)this.getUIContext().get("formulaSoluIdKey");
        if (formulaSoluIds.size() == 1) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("formulaSoluId", (Object)formulaSoluIds.get(0).toString());
            filterInfo.getFilterItems().add(item);
            if (this.kDBizPrmptOrgUnit.getData() != null && this.kDBizPrmptOrgUnit.getData() instanceof OrgUnitInfo) {
                FilterItemInfo item2 = new FilterItemInfo("company.id", (Object)((OrgUnitInfo)this.kDBizPrmptOrgUnit.getData()).getId().toString());
                filterInfo.getFilterItems().add(item2);
            }
            if (this.kDBizPrmptOrgTree.getData() != null && this.kDBizPrmptOrgTree.getData() instanceof OrgTreeInfo) {
                String treeId = ((OrgTreeInfo)this.kDBizPrmptOrgTree.getData()).getId().toString();
                FilterInfo filterInfo2 = new FilterInfo("company.id in(select funitid from t_org_structure where ftreeid='" + treeId + "')");
                filterInfo.mergeFilter(filterInfo2, "and");
            }
            if (this.formulaSoluDispenseQuery == null) {
                this.formulaSoluDispenseQuery = new EntityViewInfo();
            }
            this.formulaSoluDispenseQuery.setFilter(filterInfo);
            this.kdDispenseTable.removeRows();
        } else {
            String treeId = null;
            ArrayList<String> companyIds = null;
            if (this.kDBizPrmptOrgTree.getData() != null && this.kDBizPrmptOrgTree.getData() instanceof OrgTreeInfo) {
                treeId = ((OrgTreeInfo)this.kDBizPrmptOrgTree.getData()).getId().toString();
            }
            if (this.kDBizPrmptOrgUnit.getData() != null && this.kDBizPrmptOrgUnit.getData() instanceof OrgUnitInfo) {
                companyIds = new ArrayList<String>();
                companyIds.add(((OrgUnitInfo)this.kDBizPrmptOrgUnit.getData()).getId().toString());
            }
            FullOrgUnitCollection orgUnitColl = FormulaSoluDispenseFactory.getRemoteInstance().getFormulaSoluSameCompany(formulaSoluIds, treeId, companyIds);
            this.kdDispenseTable.removeRows(false);
            if (orgUnitColl != null) {
                IRow row = null;
                this.kdDispenseTable.checkParsed();
                for (int i = 0; i < orgUnitColl.size(); ++i) {
                    row = this.kdDispenseTable.addRow();
                    row.getCell("isSelected").setValue((Object)false);
                    row.getCell("companyNumber").setValue((Object)orgUnitColl.get(i).getNumber());
                    row.getCell("companyName").setValue((Object)orgUnitColl.get(i).getName());
                    row.getCell("companyId").setValue((Object)orgUnitColl.get(i).getId().toString());
                }
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.kdDispenseTable, (String)"isSelected", (Boolean)Boolean.TRUE);
    }

    @Override
    public void actionDeselectAll_actionPerformed(ActionEvent e) throws Exception {
        CslRptUtil.selectTable((KDTable)this.kdDispenseTable, (String)"isSelected", (Boolean)Boolean.FALSE);
    }

    @Override
    public void actionUnDispense_actionPerformed(ActionEvent e) throws Exception {
        List<String> companyIds = this.getSelectCompanyId();
        List formulSoluIds = (List)this.getUIContext().get("formulaSoluIdKey");
        if (!companyIds.isEmpty() && !formulSoluIds.isEmpty()) {
            Map result = FormulaSoluDispenseFactory.getRemoteInstance().unDispenseFormulaSolu(formulSoluIds, companyIds);
            String report = this.getReportString(result);
            if (report != null && report.length() != 0) {
                UIContext uiCtx = new UIContext((Object)this);
                String title = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"40_soluUndispCheckInfo");
                uiCtx.put((Object)"Title", (Object)title);
                SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)report);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public List<String> getSelectCompanyId() throws Exception {
        ArrayList<String> companyIds = new ArrayList<String>();
        ICell cell = null;
        String selectCol = "isSelected";
        String companyCol = "companyId";
        for (int i = 0; i < this.kdDispenseTable.getExpandedRowCount(); ++i) {
            cell = this.kdDispenseTable.getCell(i, selectCol);
            if (!Boolean.TRUE.equals(cell.getValue())) continue;
            companyIds.add(this.kdDispenseTable.getCell(i, companyCol).getValue().toString());
        }
        return companyIds;
    }

    private String getReportString(Map map) throws RunTimeException {
        int i;
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuffer report = new StringBuffer();
        String str = null;
        Object o1 = null;
        Object o2 = null;
        List list1 = null;
        List list2 = null;
        Object[] params = null;
        str = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"46_unDispTitle");
        report.append(str).append("\r\n\r\n");
        if (map.containsKey("reason1")) {
            o1 = map.get("reason1");
            if (o1 == null || !(o1 instanceof List)) {
                throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
            }
            list1 = o1;
            str = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"43_reason1");
            for (i = 0; i < list1.size(); ++i) {
                o2 = list1.get(i);
                if (o2 == null || !(o2 instanceof List) || ((List)o2).size() != 2) {
                    throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
                }
                list2 = o2;
                params = list2.toArray();
                report.append(MessageFormat.format(str, params)).append("\r\n");
            }
        }
        if (map.containsKey("reason2")) {
            o1 = map.get("reason2");
            if (o1 == null || !(o1 instanceof List)) {
                throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
            }
            list1 = o1;
            str = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"44_reason2");
            for (i = 0; i < list1.size(); ++i) {
                o2 = list1.get(i);
                if (o2 == null || !(o2 instanceof List) || ((List)o2).size() != 2) {
                    throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
                }
                list2 = o2;
                params = list2.toArray();
                report.append(MessageFormat.format(str, params)).append("\r\n");
            }
        }
        if (map.containsKey("reason3")) {
            o1 = map.get("reason3");
            if (o1 == null || !(o1 instanceof List)) {
                throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
            }
            list1 = o1;
            str = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"45_reason3");
            for (i = 0; i < list1.size(); ++i) {
                o2 = list1.get(i);
                if (o2 == null || !(o2 instanceof List) || ((List)o2).size() != 4) {
                    throw new RunTimeException(RunTimeException.INVALIDARGUMENTS, new Object[]{this.getMetaDataPK().getFullName(), "getReportString"});
                }
                list2 = o2;
                params = list2.toArray();
                report.append(MessageFormat.format(str, params)).append("\r\n");
            }
        }
        return report.toString();
    }

    private void loadOrgBound() throws EASBizException, BOSException {
        Integer orgTypeInt;
        this.kDBizPrmptOrgTree.setValue(null);
        UnionVersion2F7 unionF7 = new UnionVersion2F7();
        unionF7.setTitile(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"341_CSLReportExportFilterUI"));
        FilterInfo treeFilter = null;
        if (this.getUIContext() != null && this.getUIContext().get("orgTypeInt") instanceof Integer && OrgType.getEnum((int)(orgTypeInt = (Integer)this.getUIContext().get("orgTypeInt"))) != null) {
            treeFilter = new FilterInfo();
            treeFilter.appendFilterItem("layerType", (Object)orgTypeInt);
        }
        unionF7.setTreeFilter(treeFilter);
        this.kDBizPrmptOrgTree.setSelector((KDPromptSelector)unionF7);
        this.kDBizPrmptOrgTree.setEditable(false);
    }

    private void refreshOrgUnit(String treeID) {
        this.kDBizPrmptOrgUnit.setValue(null);
        UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 1);
        f7.setTreeID(treeID);
        f7.setMultiSelect(false);
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.kDBizPrmptOrgUnit.setSelector((KDPromptSelector)f7);
        this.kDBizPrmptOrgUnit.setEditable(false);
    }
}

