/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.client;

import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.PopMenuManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectReplacer;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.template.TemplateProcessBookProvider;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynaRptBasePointIndexHandle;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.MutexUtil;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaFinder;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaReplacer;
import com.kingdee.eas.fi.newrpt.client.designer.ReportMenuState;
import com.kingdee.eas.fi.newrpt.client.designer.RptItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.templatePropertyAdapter;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.client.AbstractFormulaSolutionProcessUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluEditUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSoluListUI;
import com.kingdee.eas.fi.newrpt.formulasolu.client.FormulaSolutionMenuManage;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.sqlGetData.client.SqlScriptEditUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.ISimpleDialogListener;
import com.kingdee.eas.fi.rpt.client.RptCheckUI;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FormulaSolutionProcessUI
extends AbstractFormulaSolutionProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaSolutionProcessUI.class);
    private static final long serialVersionUID = -6349862262268694712L;
    public FormulaSoluInfo formulaSoluInfo = null;
    private Map<String, String> oldFormulaMap = new HashMap<String, String>();

    public Map<String, String> getOldFormulaMap() {
        return this.oldFormulaMap;
    }

    public FormulaSolutionProcessUI() throws Exception {
        this.setMenuStrategy(new FormulaSolutionMenuManage());
        this.setBookProvider((IBookProvider)new TemplateProcessBookProvider());
        this.setVariableProvider(this.createVariableProvider());
        this.setPropertyAdapter(new templatePropertyAdapter(this.getBookProvider()));
    }

    private IReportVariableProvider createVariableProvider() {
        return new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initTemplateSheetReservedVariables(sheetName, ((TemplateInfo)FormulaSolutionProcessUI.this.getBookProvider().getEditValue()).getPeriodType());
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        };
    }

    @Override
    public String getUITitle() {
        String startStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"4_ProcessUITitle");
        String soluName = this.formulaSoluInfo.getName();
        return startStr + "-" + soluName;
    }

    @Override
    public void onLoad() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            String templateId = (String)this.getUIContext().get("ID");
            if (!FormulaSoluFactory.getRemoteInstance().templateExists(templateId)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"23_templateDeleted"));
                SysUtil.abort();
            }
        }
        super.onLoad();
        this.setNewBook();
        this.setFormulaToBook();
        this.isAllowChangeCheckSolution();
        this.requestNetControl();
        this.setActions();
        this.hideToolBarItems();
        this.hideSpreadToolBar();
        this.hideSpreadPopMenu();
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).getSheetOption().setCellDisplayMode(1);
        }
        if (this.formulaSoluInfo.getId() != null) {
            boolean isAudited = this.formulaSoluInfo.getAuditedStatus().getValue() == 2;
            String meunText = isAudited ? RptUtil.getRptMenuResource((String)"miUnAudit") : RptUtil.getRptMenuResource((String)"miAudit");
            this.menuItemAudit.setText(meunText);
        } else {
            this.menuItemAudit.setText(RptUtil.getRptMenuResource((String)"miAudit"));
        }
    }

    private void isAllowChangeCheckSolution() {
        RptUtilForClient.isLockBookExpTank((Book)this.getBook(), (boolean)false);
    }

    private void setNewBook() throws Exception {
        if (this.getUIContext().containsKey("formulaSoluid")) {
            String formulaSoluid = (String)this.getUIContext().get("formulaSoluid");
            this.formulaSoluInfo = FormulaSoluFactory.getRemoteInstance().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(formulaSoluid));
            Book book = null;
            book = this.getUIContext().get("reportUseFormulasoluBook") == null ? this.formulaSoluInfo.getBook() : (Book)this.getUIContext().get("reportUseFormulasoluBook");
            book.getUndoManager().enable(true);
            this.getSpreadManager().getSpreadContainer().setBook(book);
            this.getSpreadManager().getSpreadContainer().repaint();
        } else if (this.getUIContext().containsKey("formulaSolu")) {
            this.formulaSoluInfo = (FormulaSoluInfo)this.getUIContext().get("formulaSolu");
        }
    }

    private void setFormulaToBook() {
        if (this.getUIContext().containsKey("formulaSoluIdBeforeCopy")) {
            String formulaSoluid = (String)this.getUIContext().get("formulaSoluIdBeforeCopy");
            try {
                FormulaSoluInfo formulaSoluInfo = FormulaSoluFactory.getRemoteInstance().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(formulaSoluid));
                Book book = formulaSoluInfo.getBook();
                Book tplBook = this.getSpreadManager().getSpreadContainer().getBook();
                FormulaSoluCalcHelp.getInstance().replaceCellContentBySolu(tplBook, book);
                FormulaSoluCalcHelp.getInstance().synCheckSolution(tplBook, book);
                tplBook.getUndoManager().enable(true);
                this.getSpreadManager().getSpreadContainer().setBook(tplBook);
                this.getSpreadManager().getSpreadContainer().repaint();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void setActions() {
        SpreadManager.registerRenderProvider(new DefaultItemRenderProvider());
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        TemplateInfo template = (TemplateInfo)this.getBookProvider().getEditValue();
        RptTmpTypeEnum templateType = template.getTemplateType();
        if (templateType.getValue() == 13 || templateType.getValue() == 10 || templateType.getValue() == 11) {
            actions.getAction("Undo").setVisible(false);
            actions.getAction("Redo").setVisible(false);
            actions.getAction("Undo").setEnabled(false);
            actions.getAction("Redo").setEnabled(false);
        }
        actions.getAction("Show_Comment_Wizzard").setEnabled(true);
        SpreadAction action = actions.getAction("Show_Formula_Wizzard");
        action.setEnabled(true);
        this.getActionMap().put("F8", (Action)action);
        KeyStroke ks = KeyStroke.getKeyStroke("F8");
        this.getInputMap(2).put(ks, "F8");
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
        }
        Action actionFormulaSoluProperties = this.createFormulaSolutionEditUIAction();
        actionFormulaSoluProperties.setEnabled(true);
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        actionFormulaSoluProperties.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        actionFormulaSoluProperties.putValue("Name", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"5_FormulaSoluEdit"));
        actionFormulaSoluProperties.putValue("ShortDescription", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"5_FormulaSoluEdit"));
        KDToolBar toolBar = toolBarManager.getToolBar("common");
        Action actionUpgradeTheTemplateVersion = this.createUpgradeTheTemplateVersionToTheNewestOne();
        actionUpgradeTheTemplateVersion.setEnabled(true);
        actionUpgradeTheTemplateVersion.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        actionUpgradeTheTemplateVersion.putValue("Name", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"14_FormulaSoluProcessUI"));
        actionUpgradeTheTemplateVersion.putValue("ShortDescription", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"14_FormulaSoluProcessUI"));
        this.getSpreadManager().addKDSBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
            }
        });
        this.getSpreadManager().addKDSBlockInvalidListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                SortedCellBlockArray changedBlocks = e.getChangedBlocks();
                if (changedBlocks == null) {
                    return;
                }
                Sheet sheet = e.getSheet();
                for (int i = 0; i < changedBlocks.size(); ++i) {
                    CellBlock block = changedBlocks.getBlock(i);
                    if (block == null) continue;
                    Sheet.ICellsIterator iter = sheet.getCellsIterator(block, false, true);
                    while (iter.hasNext()) {
                        Cell cell = iter.next();
                        if (cell == null) continue;
                        String newFormula = cell.getFormula();
                        if (e.hasState(SheetChangeEvent.Changed_SelectionActive) && cell.getUserObject("formulaSolutionTempFormula") == null) {
                            cell.setUserObject("formulaSolutionTempFormula", (Object)newFormula);
                        }
                        if (e.getChangedStates() != SheetChangeEvent.Changed_Content && e.getChangedStates() != 3L) continue;
                        String oldFormulaStr = cell.getUserObject("formulaSolutionTempFormula") == null ? "" : cell.getUserObjectValue("formulaSolutionTempFormula").toString();
                        String string = newFormula = newFormula == null ? "" : newFormula;
                        if (oldFormulaStr.equals(newFormula)) {
                            ShareStyleAttributes ssa = (ShareStyleAttributes)cell.getUserObjectValue("formulaSolutionProcessUISSA");
                            if (ssa == null) continue;
                            cell.removeUserObject("formulaSolutionNeedSave");
                            cell.setSSA(ssa);
                            continue;
                        }
                        cell.setUserObject("formulaSolutionNeedSave", (Object)"true");
                        FormulaSolutionProcessUI.this.setCellGreenSSA(cell);
                    }
                }
            }
        });
    }

    private Action createUpgradeTheTemplateVersionToTheNewestOne() {
        AbstractAction actionUpgradeTheTemplateVersion = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmplNumber = FormulaSolutionProcessUI.this.formulaSoluInfo.getTemplateNumber();
                String tmplid = FormulaSolutionProcessUI.this.formulaSoluInfo.getTemplateId();
                int tmpltype = FormulaSolutionProcessUI.this.formulaSoluInfo.getTemplateType().getValue();
                try {
                    TemplateInfo tmplInfo = TemplateFactory.getRemoteInstance().getTemplateInfo("select id,data,templateType where number = '" + tmplNumber + "' and isFreezed = 0 and isK3Tpl = 0 and versionStatus = 1 and templateType = " + tmpltype + "");
                    if (tmplid.equals(tmplInfo.getId().toString())) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"15_FormulaSoluProcessUI"));
                        SysUtil.abort();
                    } else {
                        if (FormulaSolutionProcessUI.this.formulaSoluInfo.getId() == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"16_FormulaSoluProcessUI"));
                            SysUtil.abort();
                        }
                        Book newBook = tmplInfo.getBook();
                        newBook.setAutoCalculate(false);
                        FormulaSoluItemListCollection coll = FormulaSoluItemListFactory.getRemoteInstance().getFormulaSoluItemListCollection("where FormulaSolu = '" + FormulaSolutionProcessUI.this.formulaSoluInfo.getId().toString() + "'");
                        FormulaSolutionProcessUI.this.setFormulasToTheBook(tmplInfo, newBook, coll);
                        newBook.getUndoManager().enable(true);
                        FormulaSolutionProcessUI.this.getSpreadManager().getSpreadContainer().setBook(newBook);
                        FormulaSolutionProcessUI.this.getSpreadManager().getSpreadContainer().repaint();
                        for (int i = 0; i < FormulaSolutionProcessUI.this.getBook().getSheetCount(); ++i) {
                            FormulaSolutionProcessUI.this.getBook().getSheet(i).getSheetOption().setCellDisplayMode(1);
                        }
                        FormulaSolutionProcessUI.this.formulaSoluInfo.setTemplateId(tmplInfo.getId().toString());
                        FormulaSolutionProcessUI.this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"18_FormulaSoluProcessUI"));
                    }
                }
                catch (Exception e1) {
                    FormulaSolutionProcessUI.this.handleException(e1);
                }
            }
        };
        return actionUpgradeTheTemplateVersion;
    }

    private Action createFormulaSolutionEditUIAction() {
        AbstractAction actionFormulaSoluProperties = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"formulaSolu", (Object)FormulaSolutionProcessUI.this.formulaSoluInfo);
                uiContext.put((Object)"isFromProcessUI", (Object)true);
                String oprt = OprtState.ADDNEW;
                if (FormulaSolutionProcessUI.this.formulaSoluInfo.getId() != null) {
                    oprt = OprtState.EDIT;
                    uiContext.put((Object)"ID", (Object)FormulaSolutionProcessUI.this.formulaSoluInfo.getId().toString());
                }
                try {
                    IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FormulaSoluEditUI.class.getName(), (Map)uiContext, null, oprt);
                    window.show();
                }
                catch (UIException e1) {
                    FormulaSolutionProcessUI.this.handleException((Exception)((Object)e1));
                }
            }
        };
        return actionFormulaSoluProperties;
    }

    private void hideSpreadPopMenu() {
        PopMenuManager pop = this.getSpreadManager().getSpreadContainer().getPopMenuManager();
        pop.setItemVisible("MenuItem_Delete", false);
        pop.setItemVisible("MenuItem_DeleteRow", false);
        pop.setItemVisible("MenuItem_DeleteCol", false);
        pop.setItemVisible("MenuItem_SelectablePaste", false);
        pop.setItemVisible("MenuItem_Insert", false);
        pop.setItemVisible("MenuItem_InsertCol", false);
        pop.setItemVisible("MenuItem_InsertRow", false);
        pop.setItemVisible("MenuItem_Hide", false);
        pop.setItemVisible("MenuItem_Unhide", false);
        pop.setItemVisible("MenuItem_HyperLink", false);
        pop.setItemVisible("MenuItem_ColumWidth", false);
        pop.setItemVisible("MenuItem_RowHeight", false);
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        actions.getAction("Sheet_Hide").setVisible(false);
        actions.getAction("Sheet_Unhide").setVisible(false);
    }

    private void hideSpreadToolBar() {
        ToolBarManager toolBar = this.getSpreadManager().getSpreadContainer().getToolBarManager();
    }

    private void hideToolBarItems() {
        this.btnCalculate.setVisible(false);
        this.btnCalculateCurrentSheet.setVisible(false);
        this.btnBalance.setVisible(false);
        this.btnCheck.setVisible(false);
        this.btnSheetManager.setVisible(false);
        this.btnValueFormulaSwitch.setVisible(false);
        this.btnValueFormulaSwitch.setEnabled(false);
        this.toolBar.getComponentAtIndex(3).setVisible(false);
        this.toolBar.getComponentAtIndex(4).setVisible(false);
        this.toolBar.getComponentAtIndex(5).setVisible(false);
        this.toolBar.getComponentAtIndex(6).setVisible(false);
        TemplateInfo template = (TemplateInfo)this.getBookProvider().getEditValue();
        RptTmpTypeEnum templateType = template.getTemplateType();
        if (templateType.getValue() == 13 || templateType.getValue() == 10 || templateType.getValue() == 11) {
            this.toolBar.getComponentAtIndex(12).setVisible(false);
            this.toolBar.getComponentAtIndex(13).setVisible(false);
            this.toolBar.getComponentAtIndex(14).setVisible(false);
            this.toolBar.getComponentAtIndex(15).setVisible(false);
            this.toolBar.getComponentAtIndex(16).setVisible(false);
            this.toolBar.getComponentAtIndex(17).setVisible(false);
            this.toolBar.getComponentAtIndex(18).setVisible(false);
            this.toolBar.getComponentAtIndex(19).setVisible(false);
            this.toolBar.getComponentAtIndex(20).setVisible(false);
        } else {
            this.toolBar.getComponentAtIndex(15).setVisible(false);
            this.toolBar.getComponentAtIndex(16).setVisible(false);
            this.toolBar.getComponentAtIndex(17).setVisible(false);
            this.toolBar.getComponentAtIndex(18).setVisible(false);
            this.toolBar.getComponentAtIndex(19).setVisible(false);
            this.toolBar.getComponentAtIndex(20).setVisible(false);
            this.toolBar.getComponentAtIndex(21).setVisible(false);
        }
    }

    @Override
    public void onShow() {
        super.onShow();
        this.getSpreadManager().setItemFormulaShowModel(0);
        this.getSpreadManager().getSpreadContainer().getFacadeManager().getWizzardFinder().addUserObjectFinder((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"2_BaseReportDesignerUI"), this.getItemFormulaMatcher(), this.getItemFormulaReplacer());
        RptTmpTypeEnum tmpType = ((TemplateInfo)this.getBookProvider().getEditValue()).getTemplateType();
        this.getSpreadManager().setItemFormulaProvider(new RptItemFormulaProvider(tmpType));
        this.getSpreadManager().setItemFormulaEnable(false);
    }

    protected ICellUserObjectMatcher getItemFormulaMatcher() {
        return new ItemFormulaFinder();
    }

    protected ICellUserObjectReplacer getItemFormulaReplacer() {
        return new ItemFormulaReplacer();
    }

    @Override
    public void actionSqlGetDataSet_actionPerformed(ActionEvent e) throws Exception {
        Book b = this.getBook();
        Sheet sheet = b.getActiveSheet();
        Cell cell = sheet.getActiveCell();
        if (!DynamicTemplateUtility.isBasePointCell((Cell)cell)) {
            MsgBox.showInfo((String)CslRptUtil.getString(null, (String)"com.kingdee.eas.fi.newrpt.sqlGetData.SqlGetDataResource", (String)"notBasePoint"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"ID", null);
        String oldSqlText = (String)cell.getUserObjectValue("sqlText");
        uiContext.put((Object)"sqlText", (Object)oldSqlText);
        if (cell.getUserObject("formulaSolutionTempFormula") == null) {
            cell.setUserObject("formulaSolutionTempFormula", (Object)oldSqlText);
        } else {
            oldSqlText = (String)cell.getUserObjectValue("formulaSolutionTempFormula");
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow sqlEditUI = uiFactory.create("com.kingdee.eas.fi.newrpt.sqlGetData.client.SqlScriptEditUI", (Map)uiContext, null, OprtState.VIEW);
        sqlEditUI.show();
        SqlScriptEditUI sqlScriptEditUI = (SqlScriptEditUI)sqlEditUI.getUIObject();
        String sqlText = sqlScriptEditUI.getData();
        cell.setUserObject("sqlText", (Object)sqlText);
        oldSqlText = oldSqlText == null ? "" : oldSqlText;
        String string = sqlText = sqlText == null ? "" : sqlText;
        if (oldSqlText.equals(sqlText)) {
            ShareStyleAttributes ssa = (ShareStyleAttributes)cell.getUserObjectValue("formulaSolutionProcessUISSA");
            if (ssa != null) {
                cell.removeUserObject("formulaSolutionNeedSave");
                cell.setSSA(ssa);
            }
        } else {
            cell.setUserObject("formulaSolutionNeedSave", (Object)"true");
            this.setCellGreenSSA(cell);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.formulaSoluInfo == null) {
            this.formulaSoluInfo = (FormulaSoluInfo)this.getUIContext().get("formulaSolu");
        }
        Book book = this.getBook();
        this.formulaSoluInfo.setBook(book);
        try {
            String id;
            if (this.formulaSoluInfo.getId() == null) {
                this.formulaSoluInfo.setVersionStatus(VersionStatusEnum.CREATED);
                this.formulaSoluInfo.setVersionNumber("1.1");
                this.formulaSoluInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                id = FormulaSoluFactory.getRemoteInstance().addnew(this.formulaSoluInfo);
                this.formulaSoluInfo.setId(BOSUuid.read((String)id.toString()));
                if (OprtState.EDIT.equals(this.oprtState) && !this.getUIContext().containsKey("formulaSoluLockid")) {
                    Uuid editLock = MutexUtil.setMutex((String)"FormulaSoluEdit", (BOSUuid)this.formulaSoluInfo.getId(), (String)"ActionEdit");
                    this.getUIContext().put("formulaSoluLockid", editLock);
                }
            } else {
                id = this.formulaSoluInfo.getId().toString();
                FormulaSoluFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(id), this.formulaSoluInfo);
            }
        }
        catch (Exception ex) {
            if (ex instanceof SQLAccessException) {
                if (ex.getMessage().indexOf("FDESCRIPTION") > 0) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"51_descTooLong"));
                    SysUtil.abort();
                } else {
                    this.handleException(ex);
                }
            }
            this.handleException(ex);
        }
        boolean isexist = FormulaSoluItemListFactory.getRemoteInstance().exists("select id where FormulaSolu = '" + this.formulaSoluInfo.getId().toString() + "'");
        if (isexist) {
            FormulaSoluItemListFactory.getRemoteInstance().delete("where FormulaSolu = '" + this.formulaSoluInfo.getId().toString() + "'");
        }
        this.getSpreadManager().getModifyManager().discardAllEdits();
        this.showSuccessMsg(DesignerResource.getString("saveOK"));
        this.sheetNames.clear();
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.sheetNames.add(this.getBook().getSheetName(i));
        }
    }

    private void createFormulaSoluItemListCollForDynaNormalRptByVertical(FormulaSoluItemListCollection coll, Sheet sheet, String sheetid, Point basepoint, DynaParameters param, String operation) {
        Point endPoint = this.getDynaRange(sheet, basepoint);
        Sheet.ColsIterator it = sheet.getColsIterator(basepoint.x, endPoint.x, false);
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basepoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        Cell formulaCell = null;
        while (it.hasNext()) {
            int row;
            int colIndex = it.next().getCol();
            boolean isBase = colIndex == basepoint.x;
            ItemFormula item = UserObjectHelper.getItemFormula((Cell)sheet.getCell(basepoint.y, isBase ? colIndex + 1 : colIndex, false));
            if (item == null || (formulaCell = sheet.getCell(row = isBase ? basepoint.y : basepoint.y + boforeSumFormulaCount + 1, colIndex, false)) == null) continue;
            String formula = null;
            String itemFormulaStr = null;
            if (isBase) {
                try {
                    Object sqlText = formulaCell.getUserObjectValue("sqlText");
                    if (sqlText != null) {
                        formula = sqlText.toString();
                        itemFormulaStr = item.getFormula() + "sqlText";
                    }
                }
                catch (Exception sqlText) {}
            } else {
                formula = formulaCell.getFormula();
                itemFormulaStr = item.getFormula();
            }
            if ("actionSave".equals(operation)) {
                if (StringUtils.isEmpty((String)itemFormulaStr) || StringUtils.isEmpty((String)formula) || formulaCell.getUserObject("formulaSolutionNeedSave") == null || !"true".equals(formulaCell.getUserObjectValue("formulaSolutionNeedSave"))) continue;
                FormulaSoluItemListInfo info = this.createFormulaSoluItemListInfo(sheetid, basepoint.y, colIndex, formula, itemFormulaStr, this.getSheetType(sheet));
                coll.add(info);
                continue;
            }
            if (!"actionUpgrade".equals(operation)) continue;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                FormulaSoluItemListInfo info = coll.get(i);
                String oldItemFormulaStr = info.getItemFormula();
                String newFormula = info.getFormula();
                if (StringUtils.isEmpty((String)itemFormulaStr) || !itemFormulaStr.equals(oldItemFormulaStr)) continue;
                formulaCell.setFormula(newFormula);
                formulaCell.setUserObject("formulaSolutionNeedSave", (Object)"true");
            }
        }
    }

    public int getColCount(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    public int getRowCount(Sheet curSheet, int top, int left) {
        int height;
        for (int i = height = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    public Point getDynaRange(Sheet sheet, Point basePoint) {
        Point point = null;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
        int colSize = param.getDefaultCounter();
        int x = basePoint.y;
        int y = basePoint.x;
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basePoint, sheet, true, true);
        int sumFormulaCount = indexHandle.getSumRangeCount();
        if (param.getSpreadStyle() == 0) {
            int x1 = x + colSize + sumFormulaCount;
            point = new Point(this.getColCount(sheet, x, y), x1);
        } else if (param.getSpreadStyle() == 1) {
            int y1 = y + colSize + sumFormulaCount;
            point = new Point(y1, this.getRowCount(sheet, x, y));
        }
        return point;
    }

    private void createFormulaSoluItemListCollForDynaNormalRptByHorizontal(FormulaSoluItemListCollection coll, Sheet sheet, String sheetid, Point basepoint, DynaParameters param, String operation) {
        Point endPoint = this.getDynaRange(sheet, basepoint);
        Sheet.RowsIterator it = sheet.getRowsIterator(basepoint.y, endPoint.y, false);
        DynaRptBasePointIndexHandle indexHandle = new DynaRptBasePointIndexHandle(param, basepoint, sheet, true, true);
        int boforeSumFormulaCount = indexHandle.getBeforeDynaItemSumRangeCount();
        while (it.hasNext()) {
            int col;
            Cell formulaCell;
            Row r = it.next();
            boolean isBase = r.getRow() == basepoint.y;
            ItemFormula item = UserObjectHelper.getItemFormula((Cell)sheet.getCell(isBase ? r.getRow() + 1 : r.getRow(), basepoint.x, false));
            if (item == null || (formulaCell = r.getCell(col = isBase ? basepoint.x : basepoint.x + boforeSumFormulaCount + 1, false)) == null) continue;
            String formula = null;
            String itemFormulaStr = null;
            if (isBase) {
                try {
                    Object sqlText = formulaCell.getUserObjectValue("sqlText");
                    if (sqlText != null) {
                        formula = sqlText.toString();
                        itemFormulaStr = item.getFormula() + "sqlText";
                    }
                }
                catch (Exception sqlText) {}
            } else {
                formula = formulaCell.getFormula();
                itemFormulaStr = item.getFormula();
            }
            if ("actionSave".equals(operation)) {
                if (StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)itemFormulaStr) || formulaCell.getUserObject("formulaSolutionNeedSave") == null || !"true".equals(formulaCell.getUserObjectValue("formulaSolutionNeedSave"))) continue;
                FormulaSoluItemListInfo info = this.createFormulaSoluItemListInfo(sheetid, r.getRow(), basepoint.x, formula, itemFormulaStr, this.getSheetType(sheet));
                coll.add(info);
                continue;
            }
            if (!"actionUpgrade".equals(operation)) continue;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                FormulaSoluItemListInfo info = coll.get(i);
                String oldItemFormulaStr = info.getItemFormula();
                String newFormula = info.getFormula();
                if (StringUtils.isEmpty((String)itemFormulaStr) || !itemFormulaStr.equals(oldItemFormulaStr)) continue;
                formulaCell.setFormula(newFormula);
                formulaCell.setUserObject("formulaSolutionNeedSave", (Object)"true");
            }
        }
    }

    private void createFormulaSoluItemListCollForCommon(FormulaSoluItemListCollection coll, Sheet sheet, String sheetid, String operation) {
        Sheet.ICellsIterator it = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, true);
        while (it.hasNext()) {
            FormulaSoluItemListInfo info;
            Cell cell = it.next();
            if (cell == null || cell.getUserObject("ITEM") == null) continue;
            String formula = cell.getFormula();
            ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
            String itemFormulaStr = itemFormula.getFormula();
            if ("actionSave".equals(operation)) {
                if (StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)itemFormulaStr) || cell.getUserObject("formulaSolutionNeedSave") == null || !"true".equals(cell.getUserObjectValue("formulaSolutionNeedSave"))) continue;
                int rowIndex = cell.getRow();
                int colIndex = cell.getCol();
                info = this.createFormulaSoluItemListInfo(sheetid, rowIndex, colIndex, formula, itemFormulaStr, this.getSheetType(sheet));
                coll.add(info);
                continue;
            }
            if (!"actionUpgrade".equals(operation)) continue;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                String oldItemFormulaStr = info.getItemFormula();
                String newFormula = info.getFormula();
                if (StringUtils.isEmpty((String)itemFormulaStr) || !itemFormulaStr.equals(oldItemFormulaStr)) continue;
                cell.setFormula(newFormula);
                cell.setUserObject("formulaSolutionNeedSave", (Object)"true");
                this.setCellGreenSSA(cell);
            }
        }
    }

    private void setCellGreenSSA(Cell cell) {
        ShareStyleAttributes oldSSA = cell.getSSA();
        cell.setUserObject("formulaSolutionProcessUISSA", (Object)oldSSA);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(Color.GREEN);
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        cell.setSSA(ssa);
    }

    private void createFormulaSoluItemListCollForInterOrExch(FormulaSoluItemListCollection coll, Sheet sheet, String sheetid, String operation) {
        int iPosLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int iPosTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        if (iPosLeft < 0) {
            iPosLeft = 0;
        }
        if (iPosTop < 0) {
            iPosTop = 0;
        }
        int extX = sheet.getMaxColIndex() + 1;
        for (int j = iPosLeft + 1; j < extX; ++j) {
            Range range1 = sheet.getRange(iPosTop + 1, j);
            if (range1 == null) continue;
            String formula = range1.getFormula();
            Range rangeItemFormula = sheet.getRange(iPosTop, j);
            if (rangeItemFormula == null || rangeItemFormula.getUserObject("ITEM") == null) continue;
            ItemFormula itemFormula = (ItemFormula)rangeItemFormula.getUserObject("ITEM");
            String itemFormulaStr = itemFormula.getFormula();
            if ("actionSave".equals(operation)) {
                if (StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)itemFormulaStr) || range1.getUserObject("formulaSolutionNeedSave") == null || !"true".equals(range1.getUserObject("formulaSolutionNeedSave"))) continue;
                FormulaSoluItemListInfo info = this.createFormulaSoluItemListInfo(sheetid, iPosTop, j, formula, itemFormulaStr, this.getSheetType(sheet));
                coll.add(info);
                continue;
            }
            if (!"actionUpgrade".equals(operation)) continue;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                FormulaSoluItemListInfo info = coll.get(i);
                String oldItemFormulaStr = info.getItemFormula();
                String newFormula = info.getFormula();
                if (StringUtils.isEmpty((String)itemFormulaStr) || !itemFormulaStr.equals(oldItemFormulaStr)) continue;
                range1.setFormula(newFormula);
                range1.setUserObject("formulaSolutionNeedSave", (Object)"true");
            }
        }
    }

    private FormulaSoluItemListInfo createFormulaSoluItemListInfo(String sheetid, int rowIndex, int colIndex, String formula, String itemFormulaStr, int sheetType) {
        FormulaSoluItemListInfo info = new FormulaSoluItemListInfo();
        info.setFormulaSolu(this.formulaSoluInfo);
        info.setSheetID(sheetid);
        info.setItemFormula(itemFormulaStr);
        info.setFormula(formula);
        info.setPosX(rowIndex);
        info.setPosY(colIndex);
        info.setSheetType(sheetType);
        return info;
    }

    private boolean isInterOrExchSheet(Sheet sheet) {
        int reportClass = this.getSheetType(sheet);
        boolean isInter = reportClass == 10;
        boolean isExch = reportClass == 20;
        return isInter || isExch;
    }

    @Override
    protected boolean checkBeforeWindowClosing() {
        boolean isClose = super.checkBeforeWindowClosing();
        if (isClose && this.getUIContext().containsKey("formulaSoluLockid")) {
            Uuid formulaSoluLockid = (Uuid)this.getUIContext().get("formulaSoluLockid");
            MutexUtil.releaseMutex((Uuid)formulaSoluLockid);
        }
        return isClose;
    }

    @Override
    public boolean destroyWindow() {
        Object o = this.getUIContext().get("Owner");
        if (o != null && o instanceof FormulaSoluListUI) {
            try {
                ((FormulaSoluListUI)((Object)o)).refreshList();
            }
            catch (Exception e) {
                logger.error((Object)"destroyWindow error.", (Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    private void setFormulasToTheBook(TemplateInfo tmplInfo, Book newBook, FormulaSoluItemListCollection coll) {
        if (coll.size() > 0) {
            int tmplType = tmplInfo.getTemplateType().getValue();
            int SheetCount = newBook.getSheetCount();
            for (int i = 0; i < SheetCount; ++i) {
                Sheet sheet = newBook.getSheet(i);
                String sheetid = sheet.getID();
                if (this.isInterOrExchSheet(sheet)) {
                    this.createFormulaSoluItemListCollForInterOrExch(coll, sheet, sheetid, "actionUpgrade");
                    continue;
                }
                if (tmplType == 10) {
                    ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                    if (basePointList == null || basePointList.size() <= 0) continue;
                    for (int k = basePointList.size() - 1; k >= 0; --k) {
                        Point basepoint = (Point)basePointList.get(k);
                        DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basepoint);
                        if (param.getSpreadStyle() == 0) {
                            this.createFormulaSoluItemListCollForDynaNormalRptByVertical(coll, sheet, sheetid, basepoint, param, "actionUpgrade");
                            continue;
                        }
                        if (param.getSpreadStyle() != 1) continue;
                        this.createFormulaSoluItemListCollForDynaNormalRptByHorizontal(coll, sheet, sheetid, basepoint, param, "actionUpgrade");
                    }
                    continue;
                }
                this.createFormulaSoluItemListCollForCommon(coll, sheet, sheetid, "actionUpgrade");
            }
        }
    }

    @Override
    public void actionToolsRptAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.formulaSoluInfo == null) {
            this.formulaSoluInfo = (FormulaSoluInfo)this.getUIContext().get("formulaSolu");
        }
        if (this.formulaSoluInfo.getId() == null || this.formulaSoluInfo.getAuditedStatus().getValue() == 1 && this.isRptModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"50_saveFirst"));
            SysUtil.abort();
        }
        String soluId = this.formulaSoluInfo.getId().toString();
        ReportMenuState reportMenuState = new ReportMenuState(null, this.getBookProvider());
        if (this.formulaSoluInfo.getAuditedStatus().getValue() == 1) {
            FormulaSoluFactory.getRemoteInstance().audit(soluId);
            reportMenuState.setEditState(OprtState.VIEW);
            this.setOprtState(OprtState.VIEW);
            this.getMenuStrategy().refreshMenu(reportMenuState, true);
            this.menuItemAudit.setText(RptUtil.getRptMenuResource((String)"miUnAudit"));
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"41_auditSuccess"));
        } else {
            FormulaSoluFactory.getRemoteInstance().unAudit(soluId);
            reportMenuState.setEditState(OprtState.EDIT);
            this.setOprtState(OprtState.EDIT);
            this.getMenuStrategy().refreshMenu(reportMenuState);
            this.menuItemAudit.setText(RptUtil.getRptMenuResource((String)"miAudit"));
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"42_unAuditSuccess"));
            ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
            actions.getAction("Show_Style_Wizzard").setEnabled(true);
            actions.getAction("Show_Formula_Wizzard").setEnabled(true);
        }
        this.formulaSoluInfo = FormulaSoluFactory.getRemoteInstance().getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(soluId));
        this.showSheetMenuItem();
    }

    private void showSheetMenuItem() {
        PopMenuManager pop = this.getSpreadManager().getSpreadContainer().getPopMenuManager();
        JPopupMenu popupMenu = pop.getCtrlPopup();
        int size = popupMenu.getComponentCount();
        for (int i = 0; i < size; ++i) {
            if (!(popupMenu.getComponent(i) instanceof KDMenuItem)) continue;
            KDMenuItem menuItem = (KDMenuItem)popupMenu.getComponent(i);
            menuItem.setEnabled(true);
        }
    }

    @Override
    public void actionReportCheckSolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext cont = new UIContext((Object)this);
        cont.put((Object)"book", (Object)this.getBook());
        RptCheckUI wizard = RptCheckUI.getInstance((UIContext)cont);
        IUIWindow window2 = wizard.getUIWindow();
        if (window2 instanceof JDialog) {
            ((JDialog)window2).setModal(false);
        }
        BookProperties properties = BookProperties.loadFromBook((Book)this.getBook());
        final RptOperationSchemaComp operationSchema = properties.getOperationSchema();
        List allSheetsName = this.getSpreadManager().getAllSheetsName();
        allSheetsName.add(0, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"35_ReportDesignerUI"));
        wizard.setSheetNames(allSheetsName);
        boolean reportCanSaveCheckSolution = this.getReportCanSaveCheckSolution();
        if (reportCanSaveCheckSolution) {
            wizard.addSimpleDialogListener((ISimpleDialogListener)new IControlledDialogListener(){

                public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
                    if (!isOk || result == null) {
                        return;
                    }
                    operationSchema.setExpTank((RptCheckExpTank)((RptCheckExpTank)result).clone());
                    if (operationSchema != null) {
                        if (FormulaSolutionProcessUI.this.formulaSoluInfo == null) {
                            FormulaSolutionProcessUI.this.formulaSoluInfo = (FormulaSoluInfo)FormulaSolutionProcessUI.this.getUIContext().get("formulaSolu");
                        }
                        Book book = FormulaSolutionProcessUI.this.getBook();
                        book.setUserObject("operationSchemas", (Object)operationSchema);
                        SelectorItemCollection sc = new SelectorItemCollection();
                        sc.add("data");
                        try {
                            FormulaSolutionProcessUI.this.formulaSoluInfo.setBook(book);
                            FormulaSoluFactory.getRemoteInstance().updatePartial(FormulaSolutionProcessUI.this.formulaSoluInfo, sc);
                        }
                        catch (Exception e) {
                            logger.error((Object)"FormulaSolu updatePartialError: ", (Throwable)e);
                        }
                    }
                }

                public Object getTrueController() {
                    return null;
                }

                public void pilotSetout(ISimpleDialog source) {
                }
            });
        }
        wizard.open((Object)operationSchema.getExpTank(), null, null, null, reportCanSaveCheckSolution);
    }
}

