/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationCollection;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GenInvestEliminationHand {
    private Sheet activeSheet = null;
    private CslReportInfo report = null;
    private static Map<Integer, String> colKeyToEliminationAndEntryColumnMap = new HashMap<Integer, String>();
    private static Set<String> eliminationFieldSet = new HashSet<String>();
    private int saveOkCount = 0;
    private int errorCount = 0;

    public GenInvestEliminationHand(Sheet activeSheet, CslReportInfo report) {
        this.report = report;
        this.activeSheet = activeSheet;
    }

    public void genInvestElimination() throws Exception {
        int returnType = this.genInvestEliminationBySheet(this.activeSheet);
        if (returnType == 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"96_noData"));
        } else {
            String flag = this.saveOkCount + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"97_number");
            if (this.errorCount > 0) {
                flag = flag + "\uff1b\n" + this.errorCount + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"98_error");
            }
            MsgBox.showInfo((String)flag);
        }
    }

    private InvestTempletInfo getInvestTempletInfo(String templateId) throws Exception {
        String oql = "select investNewType,eliminationMode.id where id='" + templateId + "'";
        InvestTempletInfo investTempletInfo = InvestTempletFactory.getRemoteInstance().getInvestTempletInfo(oql);
        return investTempletInfo;
    }

    public int genInvestEliminationBySheet(Sheet sheet) throws Exception {
        int left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        UserObject obj = sheet.getUserObject("rowCount");
        if (top < 0 || left < 0 || obj == null) {
            return 1;
        }
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = (Integer)sheet.getUserObjectValue("rowCount") + top;
        int columnCount = (Integer)sheet.getUserObjectValue("columnCount") + 2;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        HashMap<Integer, String> colIndexElimFieldMap = new HashMap<Integer, String>();
        HashMap<String, EliminationInfo> eliminationMap = new HashMap<String, EliminationInfo>();
        boolean isFirst = true;
        String eliminationNum = null;
        for (int row = start; row < rowCount; ++row) {
            EliminationInfo eliminationInfo = new EliminationInfo();
            EliminationEntryInfo eliminationEntryInfo = new EliminationEntryInfo();
            eliminationEntryInfo.setIsVisible(true);
            for (int col = 0; col < columnCount; ++col) {
                Object value;
                Object fieldValue;
                Range cell;
                String fieldName = null;
                if (isFirst) {
                    cell = sheet.getRange(top, left + col);
                    if (cell == null || cell.getUserObject("ITEM") == null) continue;
                    ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM");
                    String colValue = itemFormula.getExt("columnValue");
                    fieldName = colKeyToEliminationAndEntryColumnMap.get((int)Integer.valueOf(colValue));
                    colIndexElimFieldMap.put(col, fieldName);
                } else {
                    fieldName = (String)colIndexElimFieldMap.get(col);
                }
                if (fieldName == null) continue;
                CellBlock cellBlock = sheet.getMergeBlock(top + row, left + col);
                cell = sheet.getRange(top + row, left + col);
                Object object = fieldValue = cellBlock == null ? cell.getValue().getValue() : sheet.getCell(cellBlock.getRow(), cellBlock.getCol(), true).getValue().getValue();
                if ("number".equals(fieldName) && !eliminationMap.containsKey(fieldValue)) {
                    String templateId = (String)cell.getUserObject("elimTemplateId");
                    eliminationInfo.setTempletID(templateId);
                    if (StringUtils.isEmpty((String)templateId)) break;
                    InvestTempletInfo investTempletInfo = this.getInvestTempletInfo(templateId);
                    eliminationInfo.setInvestNewType(investTempletInfo.getInvestNewType());
                    eliminationInfo.setEliminationMode(investTempletInfo.getEliminationMode());
                } else if ("debit".equals(fieldName) || "credit".equals(fieldName)) {
                    cellBlock = sheet.getMergeBlock(top + row, left + ++col);
                    cell = sheet.getRange(top + row, left + col);
                    Object object2 = fieldValue = cellBlock == null ? cell.getValue().getValue() : sheet.getCell(cellBlock.getRow(), cellBlock.getCol(), true).getValue().getValue();
                    if (fieldValue != null) {
                        value = null;
                        try {
                            value = new BigDecimal(fieldValue.toString());
                        }
                        catch (Exception e) {
                            MsgBox.showInfo((String)(cell.getName(false) + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"94_fill") + fieldValue + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"95_modfy")));
                            SysUtil.abort();
                        }
                        if (BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                            fieldValue = null;
                        }
                    }
                } else {
                    value = cellBlock == null ? cell.getUserObject("id") : sheet.getCell(cellBlock.getRow(), cellBlock.getCol(), true).getUserObjectValue("id");
                    String cellUserObjectValue = value == null ? null : value.toString();
                    fieldValue = this.createEliminationFieldObject(fieldValue, fieldName, cellUserObjectValue);
                }
                if (this.isEliminationField(fieldName)) {
                    if (fieldValue == null) continue;
                    eliminationInfo.put(fieldName, fieldValue);
                    continue;
                }
                if (fieldValue == null) continue;
                eliminationEntryInfo.put(fieldName, fieldValue);
            }
            isFirst = false;
            if (eliminationInfo.getNumber() != null) {
                eliminationNum = eliminationInfo.getNumber();
            }
            if (eliminationNum != null && !eliminationMap.containsKey(eliminationNum)) {
                this.setDefaultValueToElimination(eliminationInfo);
                eliminationMap.put(eliminationNum, eliminationInfo);
            }
            if (eliminationNum == null) continue;
            eliminationInfo = (EliminationInfo)eliminationMap.get(eliminationNum);
            eliminationEntryInfo.setSeq(eliminationInfo.getEntries().size() + 1);
            eliminationInfo.getEntries().add(eliminationEntryInfo);
        }
        CoreBaseCollection saveColl = new CoreBaseCollection();
        EliminationCollection existColl = this.getExistEliminationNumber(eliminationMap.keySet(), this.report.getOrgTree().getId().toString(), this.report.getOrgUnit().getId().toString(), this.report.getYear(), this.report.getPeriod());
        if (existColl.size() > 0) {
            HashSet<String> existNumber = new HashSet<String>();
            StringBuffer existNumberTips = new StringBuffer();
            String number = null;
            for (int i = 0; i < existColl.size(); ++i) {
                number = existColl.get(i).getNumber();
                existNumberTips.append(number).append(",");
                existNumber.add(number);
            }
            existNumberTips.deleteCharAt(existNumberTips.length() - 1);
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"91_confirmTitle")).append("\n");
            msg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"92_confirm")).append("\n");
            msg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"93_Cancel"));
            if (0 == MsgBox.showConfirm3(null, (String)msg.toString(), (String)existNumberTips.toString())) {
                saveColl = this.getSaveEliminationColl(eliminationMap, existNumber);
            } else {
                SysUtil.abort();
            }
        } else {
            saveColl = this.getSaveEliminationColl(eliminationMap, null);
            if (saveColl.size() == 0) {
                return 1;
            }
        }
        if (saveColl.size() > 0) {
            EliminationFactory.getRemoteInstance().batchSubmitDataAndDoSpecialRptItem(saveColl);
        }
        this.saveOkCount += saveColl.size();
        this.errorCount += existColl.size();
        return 0;
    }

    private CoreBaseCollection getSaveEliminationColl(Map<String, EliminationInfo> eliminationMap, Set<String> existNumber) {
        CoreBaseCollection saveColl = new CoreBaseCollection();
        EliminationInfo info = null;
        Set<String> numberSet = eliminationMap.keySet();
        for (String elimNumber : numberSet) {
            info = eliminationMap.get(elimNumber);
            if (existNumber == null) {
                saveColl.add((CoreBaseInfo)info);
                continue;
            }
            if (existNumber.contains(elimNumber)) continue;
            saveColl.add((CoreBaseInfo)info);
        }
        return saveColl;
    }

    private void setDefaultValueToElimination(EliminationInfo eliminationInfo) {
        eliminationInfo.setOrgBound(this.report.getOrgTree());
        eliminationInfo.setOrgUnit(this.report.getOrgUnit());
        eliminationInfo.setYear(this.report.getYear());
        eliminationInfo.setPeriod((int)this.report.getPeriod());
        eliminationInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        eliminationInfo.setCurrency(this.report.getCurrency());
        eliminationInfo.setSourceCurrency(this.report.getCurrency());
        eliminationInfo.setDataSource(RptSrcTypeEnum.INVESTELIMMANUSCRIPT);
        eliminationInfo.setElimType(ElimTypeEnum.Main_Invest_New);
        eliminationInfo.setDate(this.report.getReportDate());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        eliminationInfo.setCreator(user);
        eliminationInfo.setCreateTime(now);
    }

    public EliminationCollection getExistEliminationNumber(Set<String> numbers, String treeId, String unitId, int year, int period) throws Exception {
        HashSet<String> newNumbers = new HashSet<String>();
        for (String number : numbers) {
            if (StringUtils.isEmpty((String)number)) continue;
            newNumbers.add(number);
        }
        if (newNumbers.size() == 0) {
            return new EliminationCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", newNumbers, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)treeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)unitId, CompareType.EQUALS));
        view.setFilter(filter);
        EliminationCollection coll = EliminationFactory.getRemoteInstance().getEliminationCollection(view);
        return coll;
    }

    private boolean isEliminationField(String fieldName) {
        return eliminationFieldSet.contains(fieldName);
    }

    private Object createEliminationFieldObject(Object fieldValue, String fieldName, String cellUserObjectValue) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)cellUserObjectValue)) {
            return fieldValue;
        }
        if ("displayTemplateType".equals(fieldName)) {
            TemplateTypeInfo templateTypeInfo = new TemplateTypeInfo();
            if (!cellUserObjectValue.equals("111111111111111111111111110=")) {
                templateTypeInfo.setId(BOSUuid.read((String)cellUserObjectValue));
            }
            return templateTypeInfo;
        }
        if ("invCompany".equals(fieldName) || "targetCompany".equals(fieldName) || "company".equals(fieldName)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(cellUserObjectValue), selector);
            return orgUnitInfo;
        }
        if ("item".equals(fieldName)) {
            RPTItemInfo rptItemInfo = new RPTItemInfo();
            rptItemInfo.setId(BOSUuid.read((String)cellUserObjectValue));
            rptItemInfo.setNumber(fieldValue == null ? null : fieldValue.toString());
            return rptItemInfo;
        }
        if ("dataElement".equals(fieldName)) {
            return cellUserObjectValue;
        }
        return fieldValue;
    }

    static {
        colKeyToEliminationAndEntryColumnMap.put(0, "number");
        colKeyToEliminationAndEntryColumnMap.put(4, "displayTemplateType");
        colKeyToEliminationAndEntryColumnMap.put(15, "remark");
        colKeyToEliminationAndEntryColumnMap.put(1, "invCompany");
        colKeyToEliminationAndEntryColumnMap.put(2, "targetCompany");
        colKeyToEliminationAndEntryColumnMap.put(6, "summary");
        colKeyToEliminationAndEntryColumnMap.put(7, "item");
        colKeyToEliminationAndEntryColumnMap.put(9, "dataElement");
        colKeyToEliminationAndEntryColumnMap.put(10, "company");
        colKeyToEliminationAndEntryColumnMap.put(11, "debit");
        colKeyToEliminationAndEntryColumnMap.put(12, "credit");
        eliminationFieldSet.add("number");
        eliminationFieldSet.add("displayTemplateType");
        eliminationFieldSet.add("remark");
    }
}

