/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptColumnEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptShowTypeEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractInvestElimManuScriptWizardUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.ChooseScene;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.ColumnMoveUpOrDownListener;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimManuScriptColumn;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimManuScriptSelectedColumn;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JScrollBar;
import org.apache.log4j.Logger;

public class InvestElimManuScriptWizardUI
extends AbstractInvestElimManuScriptWizardUI {
    private static final long serialVersionUID = 5960963345306588444L;
    private static final Logger logger = CoreUIObject.getLogger(InvestElimManuScriptWizardUI.class);
    private static final String split = ",";
    private Sheet curSheet;
    private List<InvestElimManuScriptColumn> orderedColumns = null;
    private HashMap mapDataGetColumn;
    private final String ROW_SELECTED = "ROW_SELECTED";
    private boolean hasDebitAdjust = false;
    private boolean hasCreditAdjust = false;
    final KDTableMoveAction rowMoveAction = new KDTableMoveAction(this.tblSelectBizScene);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        this.initControl();
        this.initColumn(true);
        this.fillDataFromSheet();
    }

    private void fillDataFromSheet() {
        this.initSceneFromSheet();
        this.initColumnsFromSheet();
        this.initCombFromSheet();
        this.loadTable(this.tblShow);
    }

    private void initSceneFromSheet() {
        if (this.curSheet.getUserObject("sceneIds") != null) {
            String sceneIdsString = String.valueOf(this.curSheet.getUserObject("sceneIds").getValue());
            String[] sceneIds = sceneIdsString.split(split);
            LinkedHashSet<String> scenes = new LinkedHashSet<String>();
            for (String id : sceneIds) {
                scenes.add(id);
            }
            if (!scenes.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", scenes, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("name");
                selector.add("number");
                selector.add("description");
                view.setSelector(selector);
                try {
                    SceneCollection coll = SceneFactory.getRemoteInstance().getSceneCollection(view);
                    if (coll != null && !coll.isEmpty()) {
                        List<SceneInfo> sortSceneInfos = this.sort(scenes, coll);
                        int size = sortSceneInfos.size();
                        for (int i = 0; i < size; ++i) {
                            SceneInfo info = sortSceneInfos.get(i);
                            IRow row = this.tblSelectBizScene.addRow();
                            row.getCell("ID").setValue((Object)info.getId().toString());
                            row.getCell("number").setValue((Object)info.getNumber());
                            row.getCell("name").setValue((Object)info.getName());
                            row.getCell("info").setValue((Object)info);
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"QuerySceneByNumbers: ", (Throwable)e);
                }
            }
        }
    }

    private List<SceneInfo> sort(Set<String> scenes, SceneCollection coll) {
        Iterator<String> it = scenes.iterator();
        ArrayList<SceneInfo> sortSceneInfos = new ArrayList<SceneInfo>();
        block0: while (it.hasNext()) {
            String id = it.next();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                SceneInfo info = coll.get(i);
                if (!id.equals(info.getId().toString())) continue;
                sortSceneInfos.add(info);
                continue block0;
            }
        }
        return sortSceneInfos;
    }

    private void initCombFromSheet() {
        if (this.curSheet.getUserObject("showType") != null) {
            String showType = String.valueOf(this.curSheet.getUserObject("showType").getValue());
            InvestElimManuScriptShowTypeEnum showTypeEnum = InvestElimManuScriptShowTypeEnum.getEnum(Integer.valueOf(showType));
            this.combShowSequence.setSelectedItem((Object)showTypeEnum);
        }
    }

    private void initColumnsFromSheet() {
        int rowCount = this.curSheet.getMaxRowIndex() + 1;
        int colCount = this.curSheet.getMaxColIndex() + 1;
        ItemFormula itemFormula = null;
        ArrayList<InvestElimManuScriptColumn> list = new ArrayList<InvestElimManuScriptColumn>();
        HashSet<String> keys = new HashSet<String>();
        Object key = null;
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                String columnValue;
                Cell cell = this.curSheet.getCell(row, col, false);
                if (cell == null || cell.getUserObject("ITEM") == null || (itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue()) == null || itemFormula.getExt("columnValue") == null || keys.contains(columnValue = itemFormula.getExt("columnValue").trim())) continue;
                keys.add(columnValue);
                int index = this.indexColumn(columnValue);
                InvestElimManuScriptColumn column = this.getOrderedColumn().get(index);
                column.isSelected = true;
                list.add(column);
                this.getOrderedColumn().remove(index);
                int colValue = Integer.valueOf(columnValue);
                if (11 != colValue && 12 != colValue) continue;
                column = this.getOrderedColumn().get(index);
                list.add(column);
                this.getOrderedColumn().remove(index);
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (StringUtils.isEmpty((String)adjustColumnsStr)) continue;
                String[] adjustColumns = adjustColumnsStr.split(split);
                int type = -1;
                for (String obj : adjustColumns) {
                    type = Integer.valueOf(obj);
                    if (column == null) continue;
                    for (InvestElimManuScriptColumn adjustColumn : column.columns) {
                        if (!adjustColumn.key.equals(columnValue + type)) continue;
                        adjustColumn.isSelected = true;
                    }
                }
            }
        }
        if (!list.isEmpty()) {
            for (InvestElimManuScriptColumn column : this.getOrderedColumn()) {
                list.add(column);
            }
            this.getOrderedColumn().clear();
            this.getOrderedColumn().addAll(list);
            this.getMapDataGetColumn().clear();
            this.initColumn(false);
        }
    }

    private void initControl() {
        this.btnSceneUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnSceneDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnSceneTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnSceneBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.btnSelectBizScene.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnColumnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnColumnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnColumnTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnColumnBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.tblSelectBizScene.checkParsed();
        this.tblSelectBizScene.getSelectManager().setSelectMode(10);
        this.tblSelectBizScene.getStyleAttributes().setLocked(true);
        this.tblSelectBizScene.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblSelectBizScene.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblSelectBizScene.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.tblShow.checkParsed();
        this.tblShow.getSelectManager().setSelectMode(4);
        this.tblShow.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.tblShow.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.pnlColumn.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.initTxtLocation();
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"4_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initColumn(boolean isFirstInit) {
        Map uiContext = this.getUIContext();
        ColumnMoveUpOrDownListener columnMoveUpOrDownListener = new ColumnMoveUpOrDownListener(uiContext);
        List<InvestElimManuScriptColumn> columns = this.getOrderedColumn();
        KDCheckBox chk = null;
        int y = 0;
        if (isFirstInit) {
            this.getMapDataGetColumn().clear();
        }
        this.pnlColumn.removeAll();
        Rectangle rect = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            InvestElimManuScriptColumn column = columns.get(i);
            if (column.isArray()) {
                for (InvestElimManuScriptColumn col : column.columns) {
                    chk = (KDCheckBox)this.getMapDataGetColumn().get(col.key);
                    if (chk == null) {
                        chk = new KDCheckBox(col.column.getAlias());
                        chk.setName(col.key);
                        this.getMapDataGetColumn().put(col.key, chk);
                        chk.setBounds(new Rectangle(col.x, y, chk.getText().length() * 25 + 20, 22));
                        boolean selected = isFirstInit ? true : col.isSelected;
                        chk.setSelected(selected);
                        chk.setEditable(false);
                        chk.setEnabled(false);
                    } else {
                        rect = chk.getBounds();
                        rect.y = y;
                        chk.setBounds(rect);
                    }
                    this.pnlColumn.add((Component)chk);
                }
                y += 20;
                continue;
            }
            chk = (KDCheckBox)this.getMapDataGetColumn().get(column.key);
            if (chk == null) {
                chk = new KDCheckBox(column.column.getAlias());
                chk.setName(column.key);
                this.getMapDataGetColumn().put(column.key, chk);
                if (isFirstInit) {
                    chk.setSelected(true);
                } else {
                    chk.setSelected(column.isSelected);
                }
                if (column.column.getValue() != 4 && column.column.getValue() != 6 && column.column.getValue() != 15 && column.column.getValue() != 3 && column.column.getValue() != 5) {
                    chk.setEditable(false);
                    chk.setEnabled(false);
                } else {
                    chk.addItemListener((ItemListener)columnMoveUpOrDownListener);
                    chk.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            InvestElimManuScriptWizardUI.this.valueChange();
                        }
                    });
                }
                chk.setBounds(new Rectangle(column.x, y, chk.getText().length() * 25 + 20, 22));
            } else {
                rect = chk.getBounds();
                rect.y = y;
                chk.setBounds(rect);
            }
            this.pnlColumn.add((Component)chk);
            y += 20;
        }
        this.pnlColumn.updateUI();
    }

    private void stateChange(KDCheckBox chk, final String key) {
        chk.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((KDCheckBox)e.getSource()).isSelected()) {
                    if (InvestElimManuScriptWizardUI.this.getMapDataGetColumn().get(key) != null) {
                        ((KDCheckBox)InvestElimManuScriptWizardUI.this.getMapDataGetColumn().get(key)).setSelected(true);
                    }
                } else if (InvestElimManuScriptWizardUI.this.getMapDataGetColumn().get(key) != null) {
                    ((KDCheckBox)InvestElimManuScriptWizardUI.this.getMapDataGetColumn().get(key)).setSelected(false);
                }
            }
        });
    }

    private void valueChange() {
        this.loadTable(this.tblShow);
    }

    private void loadTable(KDTable table) {
        boolean isIncludeAdjust;
        int left = CslRptUtil.getBasePosition_Left((Sheet)this.curSheet);
        int top = CslRptUtil.getBasePosition_Top((Sheet)this.curSheet);
        if (left < 0 || top < 0) {
            top = this.curSheet.getActiveRow();
            left = this.curSheet.getActiveCol();
        }
        table.removeColumns();
        table.setRowCount(-1);
        int rowCount = top + 1;
        Vector<InvestElimManuScriptSelectedColumn> columns = this.getColumnsVector();
        if (columns == null || columns.size() == 0) {
            return;
        }
        table.setHeadDisplayMode(1);
        table.setCellDisplayMode(1);
        int columnCount = columns.size() + left;
        boolean bl = isIncludeAdjust = this.hasDebitAdjust || this.hasCreditAdjust;
        if (isIncludeAdjust) {
            ++rowCount;
        }
        table.addColumns(columnCount);
        table.addRows(rowCount + 1);
        this.fillTable(table, top, left, columns, rowCount, columnCount, isIncludeAdjust);
        CslRptUtil.saveBasePosition((KDTable)table, (int)left, (int)top);
    }

    private void fillTable(KDTable table, int top, int left, Vector<InvestElimManuScriptSelectedColumn> columns, int rowCount, int columnCount, boolean isIncludeAdjust) {
        KDTMergeManager mm = null;
        if (isIncludeAdjust) {
            mm = table.getMergeManager();
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        for (int i = top; i <= rowCount; ++i) {
            if (isIncludeAdjust && i == top + 1) continue;
            int index = 0;
            for (int j = left; j < columnCount; ++j) {
                RptCell curRptCell;
                if (i != top) continue;
                ICell curCell = table.getRow(i).getCell(j);
                InvestElimManuScriptSelectedColumn column = columns.get(index);
                String columnName = column.column.getAlias();
                curCell.setValue((Object)columnName);
                curCell.setStyleAttributes(sa);
                Object curCellObj = curCell.getUserObject();
                if (curCellObj != null && curCellObj instanceof RptCell) {
                    curRptCell = (RptCell)curCellObj;
                } else {
                    curRptCell = new RptCell(curCell);
                    curCell.setUserObject((Object)curRptCell);
                }
                if (j == left && isIncludeAdjust) {
                    mm.mergeBlock(i, j, i + 1, j, 4);
                }
                ItemFormula itemFormula = new ItemFormula();
                itemFormula.putExt("columnValue", Integer.toString(column.column.getValue()));
                curRptCell.setItemFormula(itemFormula);
                if (isIncludeAdjust) {
                    curRptCell.putExtObj((Object)"columnIndex", (Object)index);
                    if (column.column.equals((Object)InvestElimManuScriptColumnEnum.Debit) || column.column.equals((Object)InvestElimManuScriptColumnEnum.Credit)) {
                        String adjustColumnsStr = column.toStringForAdjustColumns();
                        if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                            itemFormula.putExt("adjustColumns", adjustColumnsStr);
                            ICell adjustCell = null;
                            for (int k = 0; k < column.adjustColumns.size(); ++k) {
                                adjustCell = table.getRow(i + 1).getCell(j + k);
                                if (adjustCell == null || k != 0) {
                                    table.addColumn();
                                    adjustCell = table.getRow(i + 1).getCell(j + k);
                                }
                                adjustCell.setValue((Object)new Variant((Object)column.adjustColumns.get(k).getAlias()));
                                adjustCell.setStyleAttributes(sa);
                            }
                            mm.mergeBlock(i, j, i, j + column.adjustColumns.size() - 1, 4);
                            j = j + column.adjustColumns.size() - 1;
                            columnCount = columnCount + column.adjustColumns.size() - 1;
                        } else {
                            mm.mergeBlock(i, j, i + 1, j, 4);
                        }
                    } else {
                        mm.mergeBlock(i, j, i + 1, j, 4);
                    }
                }
                ++index;
            }
        }
    }

    private Vector<InvestElimManuScriptSelectedColumn> getColumnsVector() {
        Map columnsMap = this.getColumnsMap();
        if (columnsMap == null || columnsMap.isEmpty()) {
            return null;
        }
        Vector<InvestElimManuScriptSelectedColumn> vecResult = new Vector<InvestElimManuScriptSelectedColumn>(0);
        for (Object col : columnsMap.keySet()) {
            InvestElimManuScriptSelectedColumn column = new InvestElimManuScriptSelectedColumn((InvestElimManuScriptColumnEnum)((Object)col), (List)columnsMap.get(col));
            vecResult.add(column);
        }
        return vecResult;
    }

    private Map getColumnsMap() {
        this.hasDebitAdjust = false;
        this.hasCreditAdjust = false;
        LinkedHashMap columns = new LinkedHashMap(0);
        int size = this.orderedColumns.size();
        if (size > 0) {
            ArrayList<InvestElimManuScriptColumnEnum> adjustList = null;
            InvestElimManuScriptColumn column = null;
            for (int i = 0; i < size; ++i) {
                KDCheckBox cb;
                column = this.orderedColumns.get(i);
                if (column.isArray() || (cb = (KDCheckBox)this.getMapDataGetColumn().get(column.key)) == null || !cb.isSelected()) continue;
                int value = Integer.valueOf(column.key);
                adjustList = null;
                if (11 == value) {
                    cb = (KDCheckBox)this.getMapDataGetColumn().get(String.valueOf(11) + 14);
                    if (cb != null && cb.isSelected()) {
                        this.hasDebitAdjust = true;
                    }
                    if (this.hasDebitAdjust) {
                        adjustList = new ArrayList<InvestElimManuScriptColumnEnum>();
                        adjustList.add(InvestElimManuScriptColumnEnum.AdjustBefore);
                        adjustList.add(InvestElimManuScriptColumnEnum.AdjustAfter);
                    }
                    columns.put(InvestElimManuScriptColumnEnum.Debit, adjustList);
                }
                if (12 == value) {
                    cb = (KDCheckBox)this.getMapDataGetColumn().get(String.valueOf(12) + 14);
                    if (cb != null && cb.isSelected()) {
                        this.hasCreditAdjust = true;
                    }
                    if (this.hasCreditAdjust) {
                        adjustList = new ArrayList();
                        adjustList.add(InvestElimManuScriptColumnEnum.AdjustBefore);
                        adjustList.add(InvestElimManuScriptColumnEnum.AdjustAfter);
                    }
                    columns.put(InvestElimManuScriptColumnEnum.Credit, adjustList);
                }
                if (0 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.BizNumber, null);
                }
                if (1 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.InvestCompany, null);
                }
                if (2 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.TargetInvestCompany, null);
                }
                if (3 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.InvestRate, null);
                }
                if (4 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.ElimClassification, null);
                }
                if (5 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.Scene, null);
                }
                if (6 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.ElimStep, null);
                }
                if (7 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.ItemNumber, null);
                }
                if (8 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.ItemName, null);
                }
                if (9 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.DataElement, null);
                }
                if (10 == value) {
                    columns.put(InvestElimManuScriptColumnEnum.CompanyName, null);
                }
                if (15 != value) continue;
                columns.put(InvestElimManuScriptColumnEnum.Description, null);
            }
        }
        return columns;
    }

    private List<InvestElimManuScriptColumn> getOrderedColumn() {
        if (this.orderedColumns == null) {
            this.orderedColumns = new ArrayList<InvestElimManuScriptColumn>();
            StringBuffer key = new StringBuffer();
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.BizNumber));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.InvestCompany));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.TargetInvestCompany));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.InvestRate));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.ElimClassification));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.Scene));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.ElimStep));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.ItemNumber));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.ItemName));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.DataElement));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.CompanyName));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.Debit));
            key.append(11).append(13).append(14);
            this.orderedColumns.add(new InvestElimManuScriptColumn(new InvestElimManuScriptColumn[]{this.getColumn(InvestElimManuScriptColumnEnum.AdjustBefore, InvestElimManuScriptColumnEnum.Debit, 20), this.getColumn(InvestElimManuScriptColumnEnum.AdjustAfter, InvestElimManuScriptColumnEnum.Debit, 120)}, key.toString()));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.Credit));
            key.setLength(0);
            key.append(12).append(13).append(14);
            this.orderedColumns.add(new InvestElimManuScriptColumn(new InvestElimManuScriptColumn[]{this.getColumn(InvestElimManuScriptColumnEnum.AdjustBefore, InvestElimManuScriptColumnEnum.Credit, 20), this.getColumn(InvestElimManuScriptColumnEnum.AdjustAfter, InvestElimManuScriptColumnEnum.Credit, 120)}, key.toString()));
            this.orderedColumns.add(this.getColumn(InvestElimManuScriptColumnEnum.Description));
        }
        return this.orderedColumns;
    }

    private InvestElimManuScriptColumn getColumn(InvestElimManuScriptColumnEnum colEnum, InvestElimManuScriptColumnEnum parentColEnum, int x) {
        return new InvestElimManuScriptColumn(colEnum, String.valueOf(parentColEnum.getValue()) + String.valueOf(colEnum.getValue()), x);
    }

    private InvestElimManuScriptColumn getColumn(InvestElimManuScriptColumnEnum colEnum) {
        return new InvestElimManuScriptColumn(colEnum, String.valueOf(colEnum.getValue()));
    }

    public HashMap getMapDataGetColumn() {
        if (this.mapDataGetColumn == null) {
            this.mapDataGetColumn = new HashMap();
        }
        return this.mapDataGetColumn;
    }

    @Override
    public void actionSelectBizScene_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectBizScene_actionPerformed(e);
        List scenes = new ChooseScene().open((Component)((Object)this), true, this.getChooseScenesEntityView(), this.btnSelectBizScene.getText(), null, this.getChooseScenesHiddenColumnSetting());
        if (scenes != null && !scenes.isEmpty()) {
            int size = scenes.size();
            for (int i = 0; i < size; ++i) {
                SceneInfo scene = (SceneInfo)scenes.get(i);
                IRow row = this.tblSelectBizScene.addRow();
                row.getCell("ID").setValue((Object)scene.getId().toString());
                row.getCell("number").setValue((Object)scene.getNumber());
                row.getCell("name").setValue((Object)scene.getName());
                row.getCell("info").setValue((Object)scene);
            }
        }
    }

    protected Map getChooseScenesHiddenColumnSetting() {
        HashMap<String, Boolean> hiddenColumns = new HashMap<String, Boolean>();
        hiddenColumns.put("id", Boolean.TRUE);
        hiddenColumns.put("isFreezed", Boolean.TRUE);
        hiddenColumns.put("createTime", Boolean.TRUE);
        hiddenColumns.put("lastUpdateTime", Boolean.TRUE);
        hiddenColumns.put("trackRecordCreator.name", Boolean.TRUE);
        hiddenColumns.put("trackRecordCreator.id", Boolean.TRUE);
        hiddenColumns.put("creator.name", Boolean.TRUE);
        hiddenColumns.put("creator.id", Boolean.TRUE);
        hiddenColumns.put("lastUpdateUser.name", Boolean.TRUE);
        hiddenColumns.put("lastUpdateUser.id", Boolean.TRUE);
        hiddenColumns.put("displayTemplateType.id", Boolean.TRUE);
        return hiddenColumns;
    }

    private EntityViewInfo getChooseScenesEntityView() {
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        int maskIndex = 0;
        filter.getFilterItems().add(new FilterItemInfo("isfreezed", (Object)new Integer(0), CompareType.EQUALS));
        maskString.append("#" + maskIndex++);
        Set<String> selectIds = this.getSelectScenesIds();
        if (!selectIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.NOTINCLUDE));
            maskString.append(" and #" + maskIndex++);
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("description");
        view.setSelector(selector);
        logger.debug((Object)("[Scenes]view:" + view));
        return view;
    }

    private Set<String> getSelectScenesIds() {
        HashSet<String> tmpIds = new HashSet<String>();
        Object id = null;
        for (int i = 0; i < this.tblSelectBizScene.getRowCount(); ++i) {
            id = this.tblSelectBizScene.getRow(i).getCell("ID").getValue();
            if (id == null) continue;
            tmpIds.add(id.toString());
        }
        return tmpIds;
    }

    @Override
    public void actionSceneUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionSceneUp_actionPerformed(e);
        this.checkSelected();
        this.rowMoveAction.moveSelectedRowToPreRow();
    }

    @Override
    public void actionSceneDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionSceneDown_actionPerformed(e);
        this.checkSelected();
        this.rowMoveAction.moveSelectedRowToNextRow();
    }

    @Override
    public void actionSceneTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionSceneTop_actionPerformed(e);
        this.checkSelected();
        this.rowMoveAction.moveSelectedRowToHead();
    }

    @Override
    public void actionSceneBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionSceneBottom_actionPerformed(e);
        this.checkSelected();
        this.rowMoveAction.moveSelectedRowToTail();
    }

    private void checkSelected() {
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.tblSelectBizScene);
        if (selectRowIndexes.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.SelectRowFirst"));
            return;
        }
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"4_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblSelectBizScene.getColumnIndex("number");
            int colIndex2 = this.tblSelectBizScene.getColumnIndex("name");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblSelectBizScene, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionColumnUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnUp_actionPerformed(e);
        int direction = 0;
        this.moveColumn(direction);
        this.loadTable(this.tblShow);
    }

    @Override
    public void actionColumnDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnDown_actionPerformed(e);
        int direction = 1;
        this.moveColumn(direction);
        this.loadTable(this.tblShow);
    }

    @Override
    public void actionColumnTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnTop_actionPerformed(e);
        int direction = 2;
        this.moveColumn(direction);
        this.loadTable(this.tblShow);
    }

    @Override
    public void actionColumnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionColumnBottom_actionPerformed(e);
        int direction = 3;
        this.moveColumn(direction);
        this.loadTable(this.tblShow);
    }

    private void moveColumn(int direction) {
        boolean isBottom;
        String selectChkKey = (String)this.getUIContext().get("ROW_SELECTED");
        int index = this.indexColumn(selectChkKey);
        if (index < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.SelectRowFirst"));
            return;
        }
        InvestElimManuScriptColumn column = this.orderedColumns.get(index);
        if (column.isArray()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"CannotMove"));
            return;
        }
        KDCheckBox selectChk = (KDCheckBox)this.getMapDataGetColumn().get(selectChkKey);
        boolean isUp = direction == 0;
        boolean isDown = direction == 1;
        boolean isTop = direction == 2;
        boolean bl = isBottom = direction == 3;
        if ((isUp || isTop) && (index <= 0 || column.isArray() && index <= 1)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsFirstRow"));
            selectChk.requestFocusInWindow();
            this.pnlColumn.scrollRectToVisible(selectChk.getBounds());
            return;
        }
        if ((isDown || isBottom) && (index >= this.orderedColumns.size() - 1 || index == this.orderedColumns.size() - 2 && this.orderedColumns.get(index + 1).isArray())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"batchFill.MoveIsLastRow"));
            selectChk.requestFocusInWindow();
            this.pnlColumn.scrollRectToVisible(selectChk.getBounds());
            return;
        }
        ArrayList<InvestElimManuScriptColumn> curColum = new ArrayList<InvestElimManuScriptColumn>();
        ArrayList<InvestElimManuScriptColumn> nextColum = new ArrayList<InvestElimManuScriptColumn>();
        int startindex = index;
        int nextIndex = 0;
        if (isUp) {
            nextIndex = index - 1;
            if (column.isArray()) {
                curColum.add(this.orderedColumns.get(index - 1));
                curColum.add(column);
                nextIndex = index - 2;
            } else if (column.hasChild) {
                curColum.add(column);
                curColum.add(this.orderedColumns.get(index + 1));
                nextIndex = index - 1;
            } else {
                curColum.add(column);
            }
            column = this.orderedColumns.get(nextIndex);
            if (column.isArray()) {
                nextColum.add(this.orderedColumns.get(nextIndex - 1));
                nextColum.add(column);
                startindex = nextIndex - 1;
            } else {
                nextColum.add(column);
                startindex = nextIndex;
            }
        } else if (isDown) {
            nextIndex = index + 1;
            startindex = index;
            if (column.isArray()) {
                curColum.add(this.orderedColumns.get(index - 1));
                curColum.add(column);
                nextIndex = index + 1;
                startindex = index - 1;
            } else if (column.hasChild) {
                curColum.add(column);
                curColum.add(this.orderedColumns.get(index + 1));
                nextIndex = index + 2;
            } else {
                curColum.add(column);
            }
            column = this.orderedColumns.get(nextIndex);
            if (column.hasChild) {
                nextColum.add(column);
                nextColum.add(this.orderedColumns.get(nextIndex + 1));
            } else {
                nextColum.add(column);
            }
        } else if (isTop) {
            nextIndex = 0;
            if (column.isArray()) {
                curColum.add(this.orderedColumns.get(index - 1));
                curColum.add(column);
            } else {
                curColum.add(column);
            }
            column = this.orderedColumns.get(nextIndex);
            if (column.hasChild) {
                nextColum.add(column);
                nextColum.add(this.orderedColumns.get(nextIndex + 1));
            } else {
                nextColum.add(column);
            }
            startindex = nextIndex;
        } else if (isBottom) {
            nextIndex = this.orderedColumns.size() - 1;
            if (column.isArray()) {
                curColum.add(this.orderedColumns.get(index - 1));
                curColum.add(column);
            } else {
                curColum.add(column);
            }
            startindex = nextIndex;
            column = this.orderedColumns.get(nextIndex);
            if (column.isArray()) {
                nextColum.add(this.orderedColumns.get(nextIndex - 1));
                nextColum.add(column);
            } else {
                nextColum.add(column);
            }
        }
        this.orderedColumns.removeAll(curColum);
        this.orderedColumns.removeAll(nextColum);
        if (isUp || isDown) {
            this.orderedColumns.addAll(startindex, isUp ? nextColum : curColum);
            this.orderedColumns.addAll(startindex, isUp ? curColum : nextColum);
        }
        if (isTop) {
            this.orderedColumns.addAll(startindex, nextColum);
            this.orderedColumns.addAll(startindex, curColum);
        } else if (isBottom) {
            this.orderedColumns.addAll(nextColum);
            this.orderedColumns.addAll(curColum);
        }
        nextColum.clear();
        curColum.clear();
        this.initColumn(false);
        selectChk = (KDCheckBox)this.getMapDataGetColumn().get(selectChkKey);
        selectChk.requestFocusInWindow();
        this.pnlColumn.scrollRectToVisible(selectChk.getBounds());
    }

    private int indexColumn(String key) {
        InvestElimManuScriptColumn column = null;
        for (int i = 0; i < this.orderedColumns.size(); ++i) {
            column = this.orderedColumns.get(i);
            if (column.isArray()) {
                for (InvestElimManuScriptColumn col : column.columns) {
                    if (!col.key.equals(key)) continue;
                    return i;
                }
                continue;
            }
            if (!column.key.equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.checkScene();
        this.loadSheet(this.curSheet);
        this.disposeUIWindow();
    }

    private void checkScene() {
        if (this.tblSelectBizScene.getRowCount() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"SceneCannotNull"));
            SysUtil.abort();
        }
    }

    private void loadSheet(Sheet sheet) {
        boolean isIncludeAdjust;
        int top = sheet.getActiveRow();
        int left = sheet.getActiveCol();
        Vector<InvestElimManuScriptSelectedColumn> columns = this.getColumnsVector();
        if (columns == null || columns.size() == 0) {
            return;
        }
        int rowCount = top;
        int columnCount = columns.size() + left;
        boolean bl = isIncludeAdjust = this.hasDebitAdjust || this.hasCreditAdjust;
        if (isIncludeAdjust) {
            ++rowCount;
        }
        this.clearRanges(sheet, columnCount);
        this.fillSheet(sheet, top, left, columns, rowCount, columnCount, isIncludeAdjust);
        String[] columnString = this.getColumnString();
        sheet.setUserObject("orderColumnKey", (Object)columnString[0]);
        sheet.setUserObject("checkValue", (Object)columnString[1]);
        String sceneIdsString = this.getSceneIdsString();
        if (sceneIdsString != null) {
            sheet.setUserObject("sceneIds", (Object)sceneIdsString);
        }
        String showType = String.valueOf(((InvestElimManuScriptShowTypeEnum)((Object)this.combShowSequence.getSelectedItem())).getValue());
        sheet.setUserObject("showType", (Object)showType);
        sheet.setUserObject("columnCount", (Object)columnCount);
        sheet.setUserObject("isIncludeAdjust", (Object)isIncludeAdjust);
        CslRptUtil.saveBasePosition((Sheet)sheet, (int)left, (int)top);
    }

    private void clearRanges(Sheet sheet, int columnCount) {
        boolean isIncludeAdjust;
        int bpTop = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        int bpLeft = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        int top = sheet.getActiveRow();
        int left = sheet.getActiveCol();
        int rowCount = top;
        if (bpTop != -1) {
            top = bpTop;
            rowCount = bpTop;
            left = bpLeft;
            columnCount += left;
        } else {
            return;
        }
        if (sheet.getUserObject("isIncludeAdjust") != null && (isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue())).booleanValue())) {
            ++rowCount;
            columnCount += 4;
        }
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRowRange(top, rowCount)).clear(true, true, true, true, new String[0]);
        UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getRowRange(top, rowCount)).delete();
    }

    private String getSceneIdsString() {
        int rowCount = this.tblSelectBizScene.getRowCount();
        if (rowCount > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.tblSelectBizScene.getRow(i);
                String id = String.valueOf(row.getCell("ID").getValue());
                sb.append(id);
                if (i == rowCount - 1) continue;
                sb.append(split);
            }
            return sb.toString();
        }
        return null;
    }

    private void fillSheet(Sheet sheet, int top, int left, Vector columns, int rowCount, int columnCount, boolean isIncludeAdjust) {
        SpreadManager spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        for (int i = top; i <= rowCount; ++i) {
            if (isIncludeAdjust && i == top + 1) continue;
            int index = 0;
            for (int j = left; j < columnCount; ++j) {
                Cell curCell = sheet.getCell(i, j, true);
                InvestElimManuScriptSelectedColumn column = (InvestElimManuScriptSelectedColumn)columns.get(index);
                String columnName = column.column.getAlias();
                curCell.setValue(new Variant((Object)columnName));
                this.autoSetColWidth(spreadManager, sheet, i, j);
                ItemFormula itemFormula = new ItemFormula();
                curCell.setUserObject("ITEM", (Object)itemFormula);
                if (i == top && j == left && isIncludeAdjust) {
                    itemFormula.putExt("isIncludeAdjust", "1");
                }
                itemFormula.putExt("columnValue", Integer.toString(column.column.getValue()));
                if (isIncludeAdjust) {
                    curCell.setUserObject("columnIndex", (Object)index);
                    if (column.column.equals((Object)InvestElimManuScriptColumnEnum.Debit) || column.column.equals((Object)InvestElimManuScriptColumnEnum.Credit)) {
                        Range range;
                        String adjustColumnsStr = column.toStringForAdjustColumns();
                        if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                            itemFormula.putExt("adjustColumns", adjustColumnsStr);
                            range = sheet.getRange(i, j, i, j + column.adjustColumns.size() - 1);
                            this.setLocked(sheet, range);
                            range.merge();
                            Cell adjustCell = null;
                            for (int k = 0; k < column.adjustColumns.size(); ++k) {
                                adjustCell = sheet.getCell(i + 1, j + k, true);
                                adjustCell.setValue(new Variant((Object)column.adjustColumns.get(k).getAlias()));
                                this.autoSetColWidth(spreadManager, sheet, i + 1, i + 1);
                                adjustCell.setUserObject("adjustColumn", (Object)column.adjustColumns.get(k));
                                Range adjustRange = sheet.getRange(i + 1, j + k, i + 1, j + k);
                                this.setLocked(sheet, adjustRange);
                            }
                            j = j + column.adjustColumns.size() - 1;
                            columnCount = columnCount + column.adjustColumns.size() - 1;
                        } else {
                            range = sheet.getRange(i, j, i + 1, j);
                            this.setLocked(sheet, range);
                            range.merge();
                        }
                    } else {
                        Range range = sheet.getRange(i, j, i + 1, j);
                        this.setLocked(sheet, range);
                        range.merge();
                    }
                }
                ++index;
            }
        }
        this.setBorder(sheet.getRange(top, left, rowCount, columnCount - 1));
    }

    private void setLocked(Sheet sheet, Range range) {
        this.setSheetProtection(sheet, Boolean.TRUE, this.getSheetOperation());
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(true);
        range.setStyle(sa, sa);
    }

    private void setSheetProtection(Sheet sheet, boolean locked, List sheetOperation) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected() && locked && !pro.isProtected()) {
                Object _obj2 = null;
                pro.deleteOperations();
                for (Object _obj2 : sheetOperation) {
                    if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                    pro.appendOperation(((Integer)_obj2).intValue());
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
        } else if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            if (pro.isProtected()) {
                pro.stop();
            }
        }
    }

    private List getSheetOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    private void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        Cell cell = sheet.getCell(row, col, true);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 12)) {
            width = w + 12;
        }
        if (width > 0) {
            if (width > 200) {
                width = 200;
            }
            sheet.getColRange(col, col).setColumnWidth(width + 8);
        }
    }

    public void setBorder(Range range) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_H, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_H, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_V, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_V, LineStyle.SINGLE_LINE);
        sa.setFontSize(10);
        range.setStyle(sa, saInnerBorder);
        this.setHorizontalAlign(range, Styles.HorizontalAlignment.CENTER);
    }

    public void setHorizontalAlign(Range range, Styles.HorizontalAlignment hAlign) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(hAlign);
        range.setStyle(sa, sa);
    }

    private String[] getColumnString() {
        StringBuffer orderStr = new StringBuffer();
        StringBuffer chkValueStr = new StringBuffer();
        List<InvestElimManuScriptColumn> columns = this.getOrderedColumn();
        for (InvestElimManuScriptColumn column : columns) {
            if (orderStr.length() > 0) {
                orderStr.append(split);
                chkValueStr.append(split);
            }
            if (column.isArray()) {
                int i = 0;
                for (InvestElimManuScriptColumn col : column.columns) {
                    if (i > 0) {
                        orderStr.append(split);
                        chkValueStr.append(split);
                    }
                    orderStr.append(col.key);
                    KDCheckBox cb = (KDCheckBox)this.getMapDataGetColumn().get(col.key);
                    chkValueStr.append(cb.isSelected());
                    ++i;
                }
                continue;
            }
            orderStr.append(column.key);
            KDCheckBox cb = (KDCheckBox)this.getMapDataGetColumn().get(column.key);
            chkValueStr.append(cb.isSelected());
        }
        return new String[]{orderStr.toString(), chkValueStr.toString()};
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveRow_actionPerformed(e);
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.tblSelectBizScene);
        if (selectRowIndexes.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
            int rowIndex = selectRowIndexes[i];
            this.tblSelectBizScene.removeRow(rowIndex);
        }
    }
}

