/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.DataElementF7UI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.RptItemF7UI;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class InvestElimMnsF7CellRender
implements IRenderProvider,
IBasicRender {
    private static final Logger logger = Logger.getLogger((String)InvestElimMnsF7CellRender.class.getName());
    private KDSpread spread = null;
    private String oprtState = null;

    public InvestElimMnsF7CellRender(KDSpread spread, String oprtState) {
        this.spread = spread;
        this.oprtState = oprtState;
    }

    @Override
    public IBasicRender getRender(Cell cell, int viewMode) {
        if (cell == null || !this.checkState() || this.spread.getBook().getSheetCount() == 0) {
            return null;
        }
        KDWorkButton btn = null;
        SpreadView sv = this.getSpreadView(cell);
        if (sv == null) {
            return null;
        }
        if (cell.getSheet().getActiveCell() == null || !cell.getSheet().getActiveCell().equals(cell)) {
            if (cell.getSheet().getActiveCell() == null) {
                this.clearButton(btn);
            }
            return null;
        }
        if (cell.getUserObject("dimemsion") == null) {
            this.clearButton(btn);
        } else {
            String dimemsion = String.valueOf(cell.getUserObject("dimemsion").getValue());
            if ("rptItemNumber".equals(dimemsion)) {
                int rptItemNameColIndex = Integer.valueOf(String.valueOf(cell.getUserObject("rptItemNameIndex").getValue()));
                btn = this.createQueryRptItemButton(cell, rptItemNameColIndex);
            } else if ("dataElement".equals(dimemsion)) {
                btn = this.createQueryDataElementButton(cell);
            }
            this.clearButton(btn);
            this.setCellRender(cell, btn);
        }
        return null;
    }

    public void setCellRender(Cell cell, KDWorkButton btn) {
        if (btn == null) {
            return;
        }
        if (btn.isVisible() && this.checkBounds(cell, btn)) {
            return;
        }
        SpreadView sv = this.getSpreadView(cell);
        if (sv == null) {
            return;
        }
        sv.remove((Component)btn);
        Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
        btn.setBounds(rect.x + rect.width - 16, rect.y + rect.height - 16, 16, 16);
        sv.add((Component)btn);
        sv.updateUI();
    }

    public void clearButton(KDWorkButton btn) {
        int fhC = this.spread.getFixHorizonCount();
        int fvC = this.spread.getFixVerticalCount();
        int hC = this.spread.getHorizonCount();
        int vC = this.spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)this.spread.getView(i, j);
                for (int c = sv.getComponentCount() - 1; c >= 0; --c) {
                    if (!(sv.getComponent(c) instanceof KDWorkButton)) continue;
                    if (btn == null) {
                        sv.remove(c);
                        continue;
                    }
                    if (((KDWorkButton)sv.getComponent(c)).getName().equals(btn.getName())) continue;
                    sv.remove(c);
                }
            }
        }
    }

    protected boolean checkBounds(Cell cell, KDWorkButton btn) {
        boolean isFix = true;
        Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
        if (btn.getBounds().x != rect.x + rect.width - 16 || btn.getBounds().y != rect.y + rect.height - 16) {
            isFix = false;
        }
        return isFix;
    }

    private boolean checkState() {
        return OprtState.EDIT.equals(this.oprtState) || OprtState.ADDNEW.equals(this.oprtState);
    }

    private KDWorkButton createQueryRptItemButton(final Cell cell, final int col) {
        KDWorkButton btn = new KDWorkButton();
        btn.setName("btnQueryRptItem" + cell.getRow());
        btn.setFactType(0);
        Color bgColor = new Color(7645403);
        btn.setBackground(bgColor);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        btn.setIcon((Icon)new ImageIcon(icon_off));
        btn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                try {
                    IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.investworkpaper.client.RptItemF7UI", (Map)uiContext, null);
                    iUIWindow.show();
                    if (!((RptItemF7UI)iUIWindow.getUIObject()).isCancel()) {
                        RPTItemInfo info = ((RptItemF7UI)iUIWindow.getUIObject()).getReturnValue();
                        cell.setValue(new Variant((Object)info.getNumber()));
                        cell.setUserObject("id", (Object)info.getId().toString());
                        int row = cell.getRow();
                        UserObjectHelper.getUnprotectedRange((Range)cell.getSheet().getRange(row, col)).setValue(new Variant((Object)info.getName()));
                    }
                }
                catch (UIException e1) {
                    logger.error((Object)"createUI: ", (Throwable)e1);
                }
            }
        });
        return btn;
    }

    private KDWorkButton createQueryDataElementButton(final Cell cell) {
        KDWorkButton btn = new KDWorkButton();
        btn.setName("btnQueryDataElement" + cell.getRow());
        btn.setFactType(0);
        Color bgColor = new Color(7645403);
        btn.setBackground(bgColor);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        btn.setIcon((Icon)new ImageIcon(icon_off));
        btn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UIContext uiContext = new UIContext((Object)this);
                try {
                    IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.investworkpaper.client.DataElementF7UI", (Map)uiContext, null);
                    iUIWindow.show();
                    if (!((DataElementF7UI)iUIWindow.getUIObject()).isCancel()) {
                        DataElementInfo info = ((DataElementF7UI)iUIWindow.getUIObject()).getReturnValue();
                        cell.setValue(new Variant((Object)info.getName()));
                        cell.setUserObject("id", (Object)info.getInterSeq());
                    }
                }
                catch (UIException e1) {
                    logger.error((Object)"createUI: ", (Throwable)e1);
                }
            }
        });
        return btn;
    }

    private SpreadView getSpreadView(Cell cell) {
        int fhC = this.spread.getFixHorizonCount();
        int fvC = this.spread.getFixVerticalCount();
        int hC = this.spread.getHorizonCount();
        int vC = this.spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)this.spread.getView(i, j);
                if (sv.getFirstRow() > cell.getRow() || sv.getEndRow() < cell.getRow() || sv.getFirstCol() > cell.getCol() || sv.getEndCol() < cell.getCol()) continue;
                return sv;
            }
        }
        return null;
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
    }
}

