/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractInvestElimMnsRptEditUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class InvestElimMnsRptEditUI
extends AbstractInvestElimMnsRptEditUI {
    private static final long serialVersionUID = -3611890848086744151L;
    private static final Logger logger = CoreUIObject.getLogger(InvestElimMnsRptEditUI.class);
    ICSLContext cslCtx = null;
    OrgTreeInfo unitTree = null;
    OrgUnitInfo company = null;
    private static final String resClassName = "com.kingdee.eas.fi.gr.cslrpt.RptUIMsg";
    public static final int BATCHSAVE_REPEAT = 1;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    private boolean isCtrlPress = false;
    boolean isSelect = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mapLinkOpenParam = (Map)this.getUIContext().get("KEY_LINKOPENRPT_PARAM");
        this.cslCtx = this.mapLinkOpenParam != null ? CSLContextHelper.getCSLContext((Map)this.mapLinkOpenParam) : CSLContextHelper.getCSLContext();
        this.unitTree = this.cslCtx.getCurOrgBound();
        this.company = this.cslCtx.getCurOrgGroup();
        this.initData();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"45_title") + " " + CslRptUtil.getString((String)"AddNew"));
        this.initTable();
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.btnLocation.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.initTxtLocation();
        CslRptUIUtil.addTableSelectedListener((KDTable)this.tblTemplate, (String)"select");
        this.initTableEvent();
        CslClientHelper.initCurrencyCombox((JComboBox)this.comboCurrency);
        this.setMessageBarText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"45_title") + this.getMainStatusBar().getMessage());
    }

    private void initTxtLocation() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        this.txtLocation.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtLocation);
        this.txtLocation.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initTableEvent() {
        this.tblTemplate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 17) {
                    InvestElimMnsRptEditUI.this.isCtrlPress = true;
                } else if (e.getKeyCode() == 127) {
                    SysUtil.abort();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (InvestElimMnsRptEditUI.this.isCtrlPress) {
                    InvestElimMnsRptEditUI.this.isCtrlPress = false;
                }
            }
        });
        this.tblTemplate.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int count = InvestElimMnsRptEditUI.this.tblTemplate.getRowCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        InvestElimMnsRptEditUI.this.tblTemplate.getRow(i).getCell("select").setValue((Object)false);
                    }
                }
            }
        });
        this.tblTemplate.getColumn("select").getStyleAttributes().setLocked(false);
    }

    private void initTable() {
        this.tblTemplate.checkParsed();
        this.tblTemplate.getSelectManager().setSelectMode(10);
        KDTSortManager sm = new KDTSortManager(this.tblTemplate);
        sm.setEnableSortable(true);
        sm.setSortAuto(true);
        sm.setClickCount(1);
        this.tblTemplate.setSortMange(sm);
        this.tblTemplate.getColumn("Template.number").setSortable(true);
        this.tblTemplate.getColumn("Template.name").setSortable(true);
        this.tblTemplate.getColumn("Template.templateType").setSortable(true);
        this.tblTemplate.getColumn("Template.lastUpdateTime").setSortable(true);
        this.tblTemplate.getColumn("Template.periodType").setSortable(true);
        this.tblTemplate.getColumn("Template.description").setSortable(true);
    }

    private void initData() throws BOSException {
        super.setDataObject("querySumTemplateQuery", (IObjectValue)new EntityViewInfo());
        CslClientHelper.initCurrencyToCombox((JComboBox)this.comboCurrency, (boolean)true, (boolean)false);
        this.datePickerDate.setValue((Object)this.cslCtx.getCurReportDate());
        this.datePickerDate.setEnabled(false);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        List selectedTemplateIds = this.getSelectedTemplateIdList();
        this.batchAddReports(selectedTemplateIds);
    }

    private void batchAddReports(List<String> selectedTemplateIds) throws Exception {
        ArrayList<TemplateInfo> successLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> repeatLst = new ArrayList<TemplateInfo>();
        ArrayList<TemplateInfo> failedLst = new ArrayList<TemplateInfo>();
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        info.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(selectedTemplateIds), CompareType.INCLUDE));
        info.setSelector(this.getSelectorsForTemplate());
        TemplateCollection tempColl = TemplateFactory.getRemoteInstance().getTemplateCollection(info);
        Date date = (Date)this.datePickerDate.getValue();
        int year = this.cslCtx.getCurRptYear();
        short period = (short)this.cslCtx.getCurRptPeriod();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        for (TemplateInfo template : tempColl) {
            int ret = InvestElimManuScriptUtil.addNewInvestElimMnsRpt(template, date, year, period, currency, this.unitTree, this.company);
            if (ret == 1) {
                repeatLst.add(template);
                continue;
            }
            if (ret == 2) {
                failedLst.add(template);
                continue;
            }
            successLst.add(template);
        }
        CslRptUIUtil.displayResult((Object)((Object)this), successLst, repeatLst, null, failedLst, (String)((CurrencyInfo)this.comboCurrency.getSelectedItem()).getName());
    }

    public SelectorItemCollection getSelectorsForTemplate() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isPublished"));
        sic.add(new SelectorItemInfo("isPublic"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("publicStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("templateType"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.isGrouping"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("reportDate"));
        sic.add(new SelectorItemInfo("data"));
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.tblTemplate.getRowCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_EmptyTemplate"));
            SysUtil.abort();
        }
        if (this.tblTemplate.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblTemplate.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblTemplate.getRow(rowIndex = selectBlock.getTop())).getCell(this.tblTemplate.getColumnIndex("Template.id"))) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    private List getSelectedTemplateIdList() {
        ArrayList<String> list = new ArrayList<String>();
        int count = this.tblTemplate.getRowCount();
        if (count > 0) {
            boolean isSelect = false;
            for (int i = 0; i < count; ++i) {
                isSelect = (Boolean)this.tblTemplate.getRow(i).getCell("select").getValue();
                if (!isSelect) continue;
                String id = (String)this.tblTemplate.getRow(i).getCell("Template.id").getValue();
                list.add(id);
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        if (list.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resClassName, (String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return list;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = null;
        try {
            exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            exec.option().isAutoTranslateEnum = true;
            int index = 1;
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgBound().getId().toString());
            exec.setParameter(index++, (Object)new Integer(this.cslCtx.getCurRptPeriodType().getValue()));
            exec.setParameter(index++, (Object)this.cslCtx.getCurOrgGroup().getId().toString());
            FilterInfo filter = this.querySumTemplateQuery.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            index = filter.getFilterItems().size();
            StringBuffer maskString = new StringBuffer();
            if (filter.getMaskString() == null || filter.getMaskString().length() == 0) {
                maskString.append(" #").append(index++);
                maskString.append(" and #").append(index++);
            } else {
                maskString.append(filter.getMaskString());
                maskString.append(" and #").append(index++);
                maskString.append(" and #").append(index++);
            }
            filter.getFilterItems().add(new FilterItemInfo("Template.templateType", (Object)new Integer(21)));
            filter.getFilterItems().add(new FilterItemInfo("Template.isFreezed", (Object)new Integer(0)));
            filter.setMaskString(maskString.toString());
            FilterInfo dataPermissionFilter = CslRptUtil.getDataPermissionFilter(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), (String)"csl_cslrpttmp_view");
            if (dataPermissionFilter != null) {
                for (int i = 0; i < dataPermissionFilter.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = dataPermissionFilter.getFilterItems().get(i);
                    filterItemInfo.setPropertyName("Template." + filterItemInfo.getPropertyName());
                }
                filter.mergeFilter(dataPermissionFilter, "AND");
            }
            this.querySumTemplateQuery.setFilter(filter);
            exec.setObjectView(this.querySumTemplateQuery);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return exec;
    }

    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        return super.destroyWindow();
    }

    @Override
    protected void tblTemplate_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.isSelect = true;
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getSelectedTemplateID());
            this.batchAddReports(list);
            if (this.isSelect) {
                this.destroyWindow();
            }
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.isCtrlPress) {
            IRow row = this.tblTemplate.getRow(e.getRowIndex());
            boolean isSelect = (Boolean)row.getCell("select").getValue();
            row.getCell("select").setValue((Object)(!isSelect ? 1 : 0));
            this.tblTemplate.checkParsed();
        }
    }

    @Override
    public void actionLocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocation_actionPerformed(e);
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"84_quickQueryInput");
        String search = this.txtLocation.getText();
        if (!StringUtils.isEmpty((String)search) && !search.equals(defaultStr)) {
            int colIndex1 = this.tblTemplate.getColumnIndex("Template.number");
            int colIndex2 = this.tblTemplate.getColumnIndex("Template.name");
            CslRptUIUtil.tableMainLocate((KDTable)this.tblTemplate, (String)search, (int[])new int[]{colIndex1, colIndex2});
        }
    }

    @Override
    public void actionDisplay_actionPerformed(ActionEvent e) throws Exception {
        CslRptUIUtil.tableSelectDisplay((KDTable)this.tblTemplate, (String)"select", (KDWorkButton)this.btnDisplay);
    }
}

