/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptClientHelperUI;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptFilterUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractInvestElimMnsRptListUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsRptEditUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsRptProcessUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class InvestElimMnsRptListUI
extends AbstractInvestElimMnsRptListUI
implements ICSLContextUI {
    private static final long serialVersionUID = -2502037871549886835L;
    private static final Logger logger = CoreUIObject.getLogger(InvestElimMnsRptListUI.class);
    CommonQueryDialog conditionDialog = null;
    GroupRptFilterUI conditionPanel = null;
    private FilterInfo currentFilter = null;
    private static final int Message_Delay_Time = 6000;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (CSLContextHelper.isInitialized((Map)this.getUIContext())) {
            this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.investworkpaper", (String)"InvestElimMnsRptQuery");
            super.onLoad();
            CSLContextHelper.registUIObject((ICSLContextUI)this);
        } else {
            SysUtil.abort();
        }
        this.initControl();
    }

    private void initControl() throws BOSException {
        this.tblMain.setColumnMoveable(true);
        this.tblMain.getViewManager().setFreezeView(0, 5);
        CslRptUIUtil.changeActionEnabledByTableSelect((KDTable)this.tblMain, (ItemAction)this.actionEdit);
        ICSLContext cslCtx = CSLContextHelper.getCSLContext();
        OrgTreeInfo orgBound = cslCtx.getCurOrgBound();
        OrgUnitInfo company = cslCtx.getCurOrgGroup();
        if (orgBound != null && orgBound.getName() != null) {
            this.txtOrgBound.setText(orgBound.getName());
        }
        this.combOrgUnit.removeAllItems();
        if (company != null) {
            this.combOrgUnit.addItem((Object)company);
        }
        CslRptClientHelperUI.setCruYearAndPeriod((ICSLContext)cslCtx, (KDSpinner)this.spYear, (KDSpinner)this.spPeriod);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        try {
            dialog = this.getConditionDialog();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return dialog;
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.investworkpaper", (String)"InvestElimMnsRptQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"26_FilterTitle"));
            this.conditionDialog.setWidth(330);
            this.conditionDialog.setHeight(250);
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsRptListUI");
        }
        return this.conditionDialog;
    }

    public GroupRptFilterUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new GroupRptFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
            this.conditionPanel.setReportType(20);
        }
        return this.conditionPanel;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = InvestElimMnsRptListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            if (this.conditionDialog == null) {
                this.conditionDialog = this.initCommonQueryDialog();
                this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"26_FilterTitle"));
            }
            if (this.conditionDialog.show()) {
                this.doQuery(this.conditionDialog);
                this.mainQuery = this.conditionDialog.getEntityViewInfoResult();
                this.currentFilter = this.mainQuery.getFilter();
            } else {
                SysUtil.abort();
            }
        } else if (this.mainQuery != null) {
            this.currentFilter = this.mainQuery.getFilter();
        }
        this.filterQuery();
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return new EntityViewInfo();
    }

    private void filterQuery() throws Exception {
        this.mainQuery.setFilter(this.getFilterInfo());
        this.tblMain.removeRows();
    }

    private FilterInfo getFilterInfo() throws BOSException, EASBizException {
        FilterInfo filter;
        FilterItemCollection fic;
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        int periodType = ctx.getCurRptPeriodType().getValue();
        int year = ctx.getCurRptYear();
        int period = ctx.getCurRptPeriod();
        String orgBoundId = ctx.getCurOrgBound().getId().toString();
        String orgUnitId = ctx.getCurOrgGroup().getId().toString();
        if (this.currentFilter == null) {
            this.currentFilter = new FilterInfo();
        }
        if ((fic = (filter = (FilterInfo)this.currentFilter.clone()).getFilterItems()) == null) {
            fic = new FilterItemCollection();
        }
        StringBuffer maskString = new StringBuffer();
        int index = fic.size();
        if (filter.getMaskString() != null) {
            maskString.append("(" + filter.getMaskString() + ")");
        }
        fic.add(new FilterItemInfo("orgTree.id", (Object)orgBoundId, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        fic.add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        maskString.append(" and #" + index++);
        String ms = maskString.toString();
        if (ms.startsWith(" and ")) {
            ms = ms.substring(" and ".length());
        }
        filter.setMaskString(ms);
        return filter;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectIds();
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), (List)list, (boolean)true, (boolean)true);
        this.batchAudit(list);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectIds();
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), (List)list, (boolean)true, (boolean)true);
        this.batchUnAudit(list);
    }

    private void batchUnAudit(ArrayList list) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        HashSet set = new HashSet(list);
        IRow row = null;
        int countSuccess = 0;
        int countUnaudit = 0;
        StringBuffer unAudited = new StringBuffer();
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            if (!set.contains(id)) continue;
            String rptName = row.getCell("name").getValue().toString();
            String currencyName = (String)row.getCell("currency").getValue();
            int auditedStatus = ((BizEnumValueInfo)row.getCell("auditStatus").getValue()).getInt();
            if (auditedStatus == 1) {
                unAudited.append(rptName);
                if (currencyName != null) {
                    unAudited.append("-").append(currencyName);
                }
                unAudited.append("<br/>");
                ++countUnaudit;
                continue;
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            CslReportFactory.getRemoteInstance().updateMnsAuditStatus(ids, 1);
            ++countSuccess;
        }
        StringBuffer msg = new StringBuffer();
        if (countSuccess > 0) {
            msg.append(CslRptUtil.getStringWithFormat((String)"941_unAuditSucces", (Object[])new Object[]{countSuccess}));
        }
        if (countUnaudit > 0) {
            if (countSuccess > 0) {
                msg.append("<br/>");
            }
            msg.append(CslRptUtil.getStringWithFormatCR((String)"1019_cslReportUnAudited", (Object[])new Object[]{countUnaudit}));
            msg.append("<br/>");
            msg.append(unAudited);
            msg.append("<br/>");
        }
        if (countSuccess > 0) {
            this.autoLocale();
        }
        if (countSuccess > 0 && unAudited.length() == 0) {
            this.showSuccessMessage(msg);
        } else if (!StringUtils.isEmpty((String)msg.toString())) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)CslRptUtil.getString((String)"CslRptUUCheckResult"));
            ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            ctx.put((Object)"String", (Object)msg.toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private void batchAudit(ArrayList list) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        HashSet set = new HashSet(list);
        IRow row = null;
        ICslReport icr = CslReportFactory.getRemoteInstance();
        StringBuffer checkMsg = new StringBuffer();
        StringBuffer audited = new StringBuffer();
        int countSuccess = 0;
        int countAudited = 0;
        Map cslReportCollection = CslRptUtil.getCslReportBooks(null, set);
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            String id = (String)row.getCell("id").getValue();
            String rptName = row.getCell("name").getValue().toString();
            String currencyName = (String)row.getCell("currency").getValue();
            int auditedStatus = ((BizEnumValueInfo)row.getCell("auditStatus").getValue()).getInt();
            if (!set.contains(id)) continue;
            if (auditedStatus != 1) {
                audited.append(rptName);
                if (currencyName != null) {
                    audited.append("-").append(currencyName);
                }
                audited.append("<br/>");
                ++countAudited;
                continue;
            }
            Book book = (Book)cslReportCollection.get(id);
            StringBuffer tips = new StringBuffer();
            int size = book.getSheetCount();
            for (int j = 0; j < size; ++j) {
                Sheet sheet = book.getSheet(j);
                String message = InvestElimManuScriptUtil.checkDebitAndCreditHaveData(sheet);
                if (message == null || message.length() <= 0) continue;
                tips.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"40_sheet", (Object[])new Object[]{sheet.getSheetName()})).append("<br/>");
                tips.append(message);
            }
            if (tips.length() > 0) {
                checkMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"42_report", (Object[])new Object[]{rptName})).append("<br/>");
                checkMsg.append(tips.toString());
                continue;
            }
            tips = new StringBuffer();
            CslReportInfo cslReport = icr.getCslReportInfo((IObjectPK)new ObjectUuidPK(id));
            Book calBook = InvestElimManuScriptUtil.initBook(cslReport);
            int size2 = book.getSheetCount();
            for (int j = 0; j < size2; ++j) {
                Sheet sheet = book.getSheet(j);
                StringBuffer message = new StringBuffer();
                String msg = InvestElimManuScriptUtil.checkVerifyRelation(sheet, calBook);
                if (msg != null && !StringUtils.isEmpty((String)msg)) {
                    message.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"39_verifyMsg")).append("<br/>");
                    message.append(msg);
                }
                if (message.length() <= 0) continue;
                tips.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"40_sheet", (Object[])new Object[]{sheet.getSheetName()})).append("<br/>");
                tips.append(message.toString()).append("<br/>");
            }
            if (tips.length() > 0) {
                checkMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"42_report", (Object[])new Object[]{rptName})).append("<br/>");
                checkMsg.append(tips.toString());
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            CslReportFactory.getRemoteInstance().updateMnsAuditStatus(ids, 2);
            ++countSuccess;
        }
        StringBuffer msg = new StringBuffer();
        if (countSuccess > 0) {
            msg.append(CslRptUtil.getStringWithFormat((String)"CslRptUUAuditOKReport", (Object[])new Object[]{countSuccess}));
        }
        if (countAudited > 0) {
            if (countSuccess > 0) {
                msg.append("<br/>");
            }
            msg.append(CslRptUtil.getStringWithFormatCR((String)"cslReportAudited", (Object[])new Object[]{countAudited}));
            msg.append("<br/>");
            msg.append(audited);
            msg.append("<br/>");
        }
        if (checkMsg.length() > 0) {
            if (countSuccess > 0 || countAudited > 0) {
                msg.append("<br/>");
            }
            msg.append(checkMsg.toString());
        }
        if (countSuccess > 0) {
            this.autoLocale();
        }
        if (countSuccess > 0 && checkMsg.length() == 0 && audited.length() == 0) {
            this.showSuccessMessage(msg);
        } else if (!StringUtils.isEmpty((String)msg.toString())) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"Title", (Object)CslRptUtil.getString((String)"CslRptUUCheckResult"));
            ctx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
            ctx.put((Object)"String", (Object)msg.toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private void showSuccessMessage(StringBuffer msg) {
        MainStatusBar mainStatusBar = this.getMainStatusBar();
        final KDLabel barLabel = mainStatusBar.getMsgLabel();
        final Color foreGround = barLabel.getForeground();
        final Icon icon = barLabel.getIcon();
        final String formerMessage = barLabel.getText();
        final Color backGround = barLabel.getBackground();
        this.setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(CoreUI.SHOW_MESSAGE_BG_OK);
        this.setMessageText(msg.toString());
        this.showMessage();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(6000L);
                    barLabel.setForeground(foreGround);
                    barLabel.setBackground(backGround);
                    barLabel.setText(formerMessage);
                    barLabel.setIcon(icon);
                    barLabel.setOpaque(false);
                    barLabel.repaint();
                }
                catch (InterruptedException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }).start();
    }

    private void autoLocale() throws Exception {
        int i;
        int rowCount = this.tblMain.getRowCount();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        ArrayList<String> selectIdList = new ArrayList<String>();
        for (i = 0; i < selectRows.length; ++i) {
            ICell curCell = this.tblMain.getRow(selectRows[i]).getCell("id");
            if (curCell == null || curCell.getValue() == null) continue;
            selectIdList.add(curCell.getValue().toString());
        }
        this.setLocatePre(false);
        this.refreshList();
        this.tblMain.getSelectManager().removeAll();
        for (i = 0; i < selectIdList.size(); ++i) {
            String id = (String)selectIdList.get(i);
            for (int j = 0; j < rowCount; ++j) {
                Object rowId;
                if (this.tblMain.getRow(j) == null || (rowId = this.tblMain.getRow(j).getCell("id").getValue()) == null || !id.equals(rowId.toString())) continue;
                this.tblMain.getSelectManager().add(j, 0);
            }
        }
    }

    private ArrayList getSelectIds() throws Exception {
        int selectRowCount = this.tblMain.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        ArrayList<Object> selectIds = new ArrayList<Object>();
        for (int i = 0; i < selectRowCount; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                String id = this.tblMain.getRow(j).getCell("id").getValue().toString();
                if (id == null) continue;
                selectIds.add(this.tblMain.getRow(j).getCell("id").getValue());
            }
        }
        return selectIds;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.isAudit()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"43_audited"));
            SysUtil.abort();
        }
        this.openReport(OprtState.EDIT);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.openReport(OprtState.VIEW);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.filterQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        CslRptCalcUtil.batchCheckMutexLock((Component)((Object)this), (List)ids, (boolean)true, (boolean)false);
        if (!this.confirmRemove()) {
            return;
        }
        StringBuffer errorDetailMSG = new StringBuffer();
        String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
        String s1 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_0");
        String s2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_1");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        ICoreBase iCoreBase = this.getCoreBaseInterface();
        for (int i = 0; i < ids.size(); ++i) {
            String reportId = (String)ids.get(i);
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(reportId);
            }
            catch (Throwable ex) {
                errorDetailMSG.append(s1).append(i + 1).append(s2).append(ExceptionMessageUtility.getMessage((Throwable)ex)).append("\n");
                continue;
            }
            CslReportInfo report = this.getReportInfo(reportId, sic);
            if (report != null && report.getPublishedStatus().getValue() == 1) {
                try {
                    iCoreBase.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)report.getId().toString())));
                    continue;
                }
                catch (Exception ex) {
                    errorDetailMSG.append(s1).append(i + 1).append(s2).append(ExceptionMessageUtility.getMessage((Throwable)ex)).append("\n");
                    continue;
                }
                finally {
                    try {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener(reportId);
                    }
                    catch (Throwable e1) {
                        logger.error((Object)"RELEASEALL: ", e1);
                    }
                }
            }
            if (report == null) continue;
            String msg = "";
            if (report.getPublishedStatus().getValue() != 1) {
                msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptIsPublished");
            }
            if (msg.length() <= 0) continue;
            errorDetailMSG.append(s1);
            errorDetailMSG.append(i + 1);
            errorDetailMSG.append(s2);
            errorDetailMSG.append(msg);
            errorDetailMSG.append("\n");
        }
        if (errorDetailMSG.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
        }
        this.refresh(e);
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = (ICslReport)this.getBizInterface();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getEditUIName() {
        return InvestElimMnsRptEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CslReportFactory.getRemoteInstance();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            this.tableClicked();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    private void tableClicked() throws Exception {
        ICSLContext ctx = CSLContextHelper.getCSLContext();
        if (this.btnView.isVisible() && this.btnView.isEnabled()) {
            if (this.btnEdit.isVisible() && this.btnEdit.isEnabled() && ctx != null && !ctx.isQueryBudget()) {
                this.checkSelected();
                String id = this.getSelectedKeyValue();
                if (this.isAudit()) {
                    this.openReport(OprtState.VIEW);
                } else {
                    ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
                    ObjectUuidPK orgPK = new ObjectUuidPK(ctx.getCurOrgGroup().getId());
                    if (PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "csl_eliminvestmns_edit")) {
                        this.openReport(OprtState.EDIT);
                    } else {
                        this.openReport(OprtState.VIEW);
                    }
                }
            } else {
                this.openReport(OprtState.VIEW);
            }
        }
    }

    private boolean isAudit() {
        int[] selectRowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        return 2 == ((BizEnumValueDTO)this.tblMain.getRow(selectRowIndex[0]).getCell("auditStatus").getValue()).getInt();
    }

    private void openReport(String state) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        boolean hasMutexLock = RptNewUIUtil.hasMutexLock(null, id);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"hasMutexLock", (Object)hasMutexLock);
        String processUI = InvestElimMnsRptProcessUI.class.getName();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, state);
        window.show();
    }

    public void update(Observable o, Object arg) {
        CSLContextHelper.update((Observable)o, (CoreUI)this);
    }
}

