/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.investworkpaper.GenInvestEliminationHand;
import com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimMnsFacadeFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingNewInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractInvestElimMnsRptProcessUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsF7CellRender;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsRptListUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.InvestElimMnsRptMenuManager;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneTypeMappingUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.SheetColumMergeHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvestElimMnsRptProcessUI
extends AbstractInvestElimMnsRptProcessUI
implements ICSLContextUI {
    private static final long serialVersionUID = 2776643369444902628L;
    private static final Logger logger = CoreUIObject.getLogger(InvestElimMnsRptProcessUI.class);
    private String oprtStatus;
    private int count = 1;
    private InvestElimMnsF7CellRender render;

    public InvestElimMnsRptProcessUI() throws Exception {
        this.init();
    }

    public InvestElimMnsRptProcessUI(CslReportInfo cslReportInfo, String oprtStatus) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.getUIContext().put("InitDataObject", cslReportInfo);
        this.getUIContext().put("ID", cslReportInfo.getId().toString());
        this.oprtStatus = oprtStatus;
        this.init();
    }

    private void init() {
        this.setMenuStrategy(new InvestElimMnsRptMenuManager());
        this.setBookProvider((IBookProvider)new CslReportProvider());
        this.setPropertyAdapter((IReportPropertyAdapter)new CSLPropertyAdapter());
        this.setVariableProvider(new IReportVariableProvider(){

            @Override
            public void initSheetDefaultVariable(String sheetName, ReportVariables variables) {
                ReportVariables init = VariablesHelper.initSheetReservedVariables(sheetName, InvestElimMnsRptProcessUI.this.getCslReportProvider().getCSLlReportInfo().getPeriodType());
                variables.addAll(init, false);
            }

            @Override
            public void initReportDefaultVariable(ReportVariables variables) {
            }
        });
    }

    @Override
    public void onLoad() throws Exception {
        if (this.oprtStatus != null) {
            this.setOprtState(this.oprtStatus);
            this.getUIContext().put("CanEdit", Boolean.TRUE);
        }
        super.onLoad();
        if (this.oprtStatus != null) {
            CslReportInfo reportInfo = (CslReportInfo)this.getEditData();
            FullOrgUnitInfo orgUnitInfo = reportInfo.getOrgUnit();
            OrgTreeInfo orgTreeInfo = reportInfo.getOrgTree();
            CslWorkTableUtil.setUIContext((OrgUnitInfo)orgUnitInfo, orgTreeInfo);
        }
        this.OpenCSLContextUI();
        this.initMenu();
        this.registerRender();
        this.registerCellAction();
    }

    private void registerCellAction() {
        this.getSpreadManager().addKDSBlockInvalidListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                InvestElimMnsRptProcessUI.this.cellAction(e);
            }
        });
    }

    private void cellAction(SheetChangeEvent e) {
        String des;
        int len;
        Range desRange;
        Variant variant;
        ItemFormula itemFormula;
        String colValue;
        int columnValue;
        Sheet sheet = e.getSheet();
        Cell activeCell = sheet.getActiveCell();
        if (activeCell == null) {
            return;
        }
        if (e.getChangedStates() != SheetChangeEvent.Changed_Content && e.getChangedStates() != 3L) {
            return;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        int n = top = top >= 0 ? top : 0;
        if (sheet.getUserObject("columnCount") == null) {
            return;
        }
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int row = activeCell.getRow();
        int col = activeCell.getCol();
        if (!isIncludeAdjust && row == top || isIncludeAdjust && row == top + 1) {
            return;
        }
        Range dcRange = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(top, col - 1));
        if (dcRange.getUserObject("ITEM") == null) {
            Range desRange2 = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(top, col));
            if (desRange2.getUserObject("ITEM") == null) {
                return;
            }
            dcRange = desRange2;
        }
        if ((columnValue = Integer.valueOf(colValue = (itemFormula = (ItemFormula)dcRange.getUserObject("ITEM")).getExt("columnValue")).intValue()) != 11 && columnValue != 12 && columnValue != 15) {
            return;
        }
        if (columnValue == 11 || columnValue == 12) {
            Range originalRange = sheet.getRange(row, col - 1);
            if (StringUtils.isEmpty((String)originalRange.getFormula()) && StringUtils.isEmpty((String)(originalRange = sheet.getRange(row, col - 2)).getValue().toString()) && StringUtils.isEmpty((String)(originalRange = sheet.getRange(row, col - 3)).getValue().toString())) {
                return;
            }
            Range confirmRange = sheet.getRange(row, col);
            Variant value = confirmRange.getValue();
            try {
                if (value != null && !value.isError()) {
                    value.toBigDecimal();
                }
            }
            catch (SyntaxErrorException e1) {
                String error = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"88_notBigDecimal", (Object[])new Object[]{value});
                MsgBox.showError((Component)((Object)this), (String)error);
                activeCell.setValue(Variant.nullVariant);
                return;
            }
            if (value != null && !value.isError()) {
                int def;
                String amount = value.toString();
                int length = amount.length();
                int n2 = def = amount.contains(".") ? 22 : 21;
                if (length > def) {
                    String error = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"100_amountTooBig");
                    MsgBox.showError((Component)((Object)this), (String)error);
                    activeCell.setValue(Variant.nullVariant);
                    return;
                }
            }
        } else if (columnValue == 15 && (variant = (desRange = sheet.getRange(row, col)).getValue()) != null && (len = (des = variant.toString()).length()) > 256) {
            String error = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"101_desTooLong");
            MsgBox.showError((Component)((Object)this), (String)error);
            activeCell.setValue(Variant.nullVariant);
            return;
        }
    }

    @Override
    public void onShow() {
        super.onShow();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.getBook().setCalculate(true);
        }
        this.actionGenVoucher.setVisible(false);
        this.checkMutexLock();
        this.btnElimTypeMapped.setIsControlByParent(false);
        this.btnElimTypeMapped.setTextIconDisStyle((short)3);
        this.btnGenInvestElim.setIsControlByParent(false);
        this.btnGenInvestElim.setTextIconDisStyle((short)3);
        this.btnGenInvestElimMns.setIsControlByParent(false);
        this.btnGenInvestElimMns.setTextIconDisStyle((short)3);
        this.btnRemoveZeroRow.setIsControlByParent(false);
        this.btnRemoveZeroRow.setTextIconDisStyle((short)3);
    }

    private void checkMutexLock() {
        boolean hasMutexLock;
        if (this.getUIContext().containsKey("hasMutexLock") && (hasMutexLock = Boolean.valueOf(String.valueOf(this.getUIContext().get("hasMutexLock"))).booleanValue())) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"46_warning", (Object[])new Object[]{this.getEditData().getName()});
            this.showWarningMsg(msg);
        }
    }

    @Override
    public void showWarningMsg(String msg) {
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.setMessageBgcolor(Color.yellow);
        this.setMessageText(msg);
        this.showMessage();
    }

    private void registerRender() {
        SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
        this.render = new InvestElimMnsF7CellRender(spreadContext.getSpread(), this.getOprtState());
        SpreadManager.registerRenderProvider(this.render);
    }

    private void initMenu() {
        this.menuInsert.add((Component)this.menuItemInsertPic, 8);
        this.menuItemInsertPic.setVisible(true);
        this.menuItemInsertPic.setEnabled(true);
        this.actionInsertPicture.setVisible(true);
        this.actionInsertPicture.setEnabled(true);
        this.actionElimTypeMapped.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_mappinginput"));
        this.actionGenInvestElimMns.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.actionGenInvestElim.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_creat"));
        this.actionRemoveZeroRow.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.actionCheckBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.actionToolsCompanyFill.setVisible(false);
        this.actionInvestCompanyFill.setVisible(false);
        this.kmInsertMutiRow.setVisible(false);
        this.menuItemSort.setVisible(false);
        this.menuItemGroup.setVisible(false);
        this.menuFilter.setVisible(false);
        this.showEipDataFilterUI.setVisible(false);
        this.menuItemappingSolu2AcctItem.setVisible(false);
        this.menuItemClassifiedStatistics.setVisible(false);
        this.menuItemValidation.setVisible(false);
        this.menuRightClear.setVisible(false);
    }

    private void OpenCSLContextUI() {
        Object owner = this.getUIContext().get("Owner");
        boolean need = this.getUIContext().get("KEY_LINKOPENRPT_PARAM") == null;
        boolean bl = need = need && owner instanceof ICSLContextUI;
        if (need) {
            if (CSLContextHelper.isInitialized((Map)this.getUIContext())) {
                CSLContextHelper.registUIObject((ICSLContextUI)this);
            } else {
                SysUtil.abort();
            }
        }
    }

    private CslReportProvider getCslReportProvider() {
        return (CslReportProvider)this.getBookProvider();
    }

    private ReportBaseInfo getEditData() {
        return this.getCslReportProvider().getCSLlReportInfo();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionElimTypeMapped_actionPerformed(ActionEvent e) throws Exception {
        super.actionElimTypeMapped_actionPerformed(e);
        this.openUI();
    }

    private void openUI() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.getActiveSheetSceneNumbers(uiContext);
        this.getTreeNumberAndUnitNumber(uiContext);
        IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneTypeMappingUI", (Map)uiContext, null);
        iUIWindow.show();
        boolean isCancel = ((SceneTypeMappingUI)iUIWindow.getUIObject()).isCancel();
        if (!isCancel) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"107_genFirst"));
        }
    }

    private void getActiveSheetSceneNumbers(UIContext uiContext) {
        String sceneIds;
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject(sceneIds = "sceneIds") != null) {
            String sceneIdsString = String.valueOf(sheet.getUserObject(sceneIds).getValue());
            uiContext.put((Object)"sceneIds", (Object)sceneIdsString);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"SceneCannotNull"));
            SysUtil.abort();
        }
    }

    private void getShowType(UIContext uiContext) {
        String type;
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject(type = "showType") != null) {
            String showType = String.valueOf(sheet.getUserObject(type).getValue());
            uiContext.put((Object)"showType", (Object)showType);
        }
    }

    private void getTreeNumberAndUnitNumber(UIContext uiContext) throws EASBizException, BOSException {
        CslReportInfo cslReportInfo = (CslReportInfo)this.getEditData();
        String treeId = cslReportInfo.getOrgTree().getId().toString();
        String unitId = cslReportInfo.getOrgUnit().getId().toString();
        OrgTreeInfo treeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(treeId));
        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
        uiContext.put((Object)"orgTreeNumber", (Object)treeInfo.getNumber());
        uiContext.put((Object)"orgUnitNumber", (Object)orgUnit.getNumber());
        uiContext.put((Object)"orgTree", (Object)treeInfo);
        uiContext.put((Object)"orgUnit", (Object)orgUnit);
    }

    @Override
    public void actionGenInvestElimMns_actionPerformed(ActionEvent e) throws Exception {
        super.actionGenInvestElimMns_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        this.getActiveSheetSceneNumbers(uiContext);
        this.getTreeNumberAndUnitNumber(uiContext);
        this.getShowType(uiContext);
        boolean isCancel = this.openTypeMappingUI(uiContext);
        if (!isCancel) {
            this.genInvestElimMns(uiContext);
        }
    }

    private void genInvestElimMns(final UIContext uiContext) throws EASBizException, BOSException {
        InvestElimMnsRptProcessUI ui = this;
        if (this.getUIContext().get("parentOwner") != null) {
            ui = (CoreUI)this.getUIContext().get("parentOwner");
        }
        ProgressDialogNew progressDialog = ProgressDialogHelper.createProgressDialogNew(ui, true);
        progressDialog.setWindowMsgTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"16_GenDone"));
        progressDialog.setMsg("");
        progressDialog.setUiTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"16_GenDone"));
        progressDialog.run(true, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"17_Gen"), -1);
                try {
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"24_Del"));
                    InvestElimMnsRptProcessUI.this.delSheetDataRows();
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"25_DelDone"));
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"18_Query"));
                    Map params = InvestElimMnsRptProcessUI.this.getGenInvestElimMnsParams(uiContext);
                    List investElimMnsRecords = InvestElimMnsFacadeFactory.getRemoteInstance().genInvestElimMnsRecord(params);
                    if (investElimMnsRecords == null || investElimMnsRecords.isEmpty()) {
                        Sheet sheet = InvestElimMnsRptProcessUI.this.getBook().getActiveSheet();
                        if (sheet.getUserObject("realColumnCount") != null) {
                            sheet.removeUserObject("realColumnCount");
                            sheet.removeUserObject("rowCount");
                        }
                        return;
                    }
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"19_QueryDone"));
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"20_Fill"));
                    InvestElimMnsRptProcessUI.this.fillSheet(investElimMnsRecords);
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"21_FillDone"));
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"22_Cal"));
                    InvestElimMnsRptProcessUI.this.bookCalculate();
                    monitor.subTaskBegin(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"23_CalDone"));
                }
                catch (Exception e) {
                    logger.error((Object)"genInvestElimMns error.", (Throwable)e);
                    monitor.done();
                }
                finally {
                    monitor.done();
                }
            }
        }, progressDialog);
    }

    private void delSheetDataRows() {
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject("rowCount") == null) {
            return;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        this.getBook().setCalculate(false);
        SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
        InvestElimMnsRptProcessUI.clearButton(spreadContext);
        UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(start, rowCount)).delete();
    }

    private void fillSheet(List investElimMnsRecords) {
        int left = 0;
        int top = 0;
        Sheet sheet = this.getBook().getActiveSheet();
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        int n = top = top >= 0 ? top : 0;
        if (sheet.getUserObject("columnCount") == null) {
            return;
        }
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) - 1;
        int rowCount = investElimMnsRecords.size() + top;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        int index = 0;
        SpreadManager spreadManager = this.getSpreadManager();
        ArrayList<Integer> mergeColumns = new ArrayList<Integer>();
        ArrayList<Range> lockRanges = new ArrayList<Range>();
        ArrayList<Cell> rptItemCells = new ArrayList<Cell>();
        ArrayList<Cell> deCells = new ArrayList<Cell>();
        int rptItemNameCol = -1;
        int descriptionColIndex = -1;
        int bizNumberColIndex = -1;
        HashMap<String, String[]> rowMap = new HashMap<String, String[]>();
        String[] rows = null;
        StringBuffer debitLocal = new StringBuffer();
        StringBuffer creditLocal = new StringBuffer();
        StringBuffer debitLocalConfirm = new StringBuffer();
        StringBuffer creditLocalConfirm = new StringBuffer();
        this.getBook().setCalculate(false);
        String bizNumber = null;
        for (int row = start; row < rowCount; ++row) {
            Map values = (Map)investElimMnsRecords.get(index);
            boolean isDiffRow = false;
            int dc = -1;
            for (int col = left; col <= columnCount; ++col) {
                Range range;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                this.collectMergeColumnIndex(mergeColumns, col, columnValue);
                Cell itemNumberCell = sheet.getCell(row, col, true);
                this.collectRptItemNumberCell(itemNumberCell, columnValue, rptItemCells, deCells);
                if (0 == columnValue) {
                    bizNumberColIndex = col;
                } else if (8 == columnValue) {
                    rptItemNameCol = col;
                } else if (15 == columnValue) {
                    descriptionColIndex = col;
                }
                String value = null;
                if (values.get(colValue) != null) {
                    value = String.valueOf(values.get(colValue));
                }
                String valueid = null;
                String idKey = colValue + "id";
                if (values.containsKey(idKey)) {
                    if (0 == columnValue) {
                        InvestTempletInfo tmplInfo = (InvestTempletInfo)values.get(idKey);
                        Range range2 = sheet.getRange(row, col);
                        if (bizNumber != null) {
                            if (!bizNumber.equals(value)) {
                                debitLocal = new StringBuffer();
                                creditLocal = new StringBuffer();
                                debitLocalConfirm = new StringBuffer();
                                creditLocalConfirm = new StringBuffer();
                                bizNumber = value;
                                rows = new String[2];
                                rows[0] = String.valueOf(row);
                                rowMap.put(bizNumber, rows);
                            } else if (rowMap.containsKey(bizNumber)) {
                                String[] tmpRows = (String[])rowMap.get(bizNumber);
                                tmpRows[1] = String.valueOf(row);
                            }
                        } else {
                            bizNumber = value;
                            rows = new String[2];
                            rows[0] = String.valueOf(row);
                            rowMap.put(bizNumber, rows);
                        }
                        range2.setUserObject("elimTemplateId", (Object)tmplInfo.getId().toString());
                        range2.setUserObject("eliminationMode", tmplInfo.getEliminationMode() != null ? tmplInfo.getEliminationMode().getId().toString() : null);
                    } else {
                        valueid = String.valueOf(values.get(idKey));
                    }
                    if (7 == columnValue) {
                        range = sheet.getRange(row, col);
                        String diffKey = colValue + "diffEntry";
                        range.setUserObject("diffEntry", values.get(diffKey));
                        isDiffRow = Boolean.valueOf(String.valueOf(values.get(diffKey)));
                        String sceneIdKey = colValue + "sceneId";
                        range.setUserObject("sceneId", values.get(sceneIdKey));
                        String dcKey = colValue + "dc";
                        range.setUserObject("dc", values.get(dcKey));
                        dc = Integer.valueOf(String.valueOf(values.get(dcKey)));
                    }
                }
                if (3 == columnValue) {
                    range = sheet.getRange(row, col);
                    this.setHorizontalAlign(range, Styles.HorizontalAlignment.RIGHT);
                }
                if (columnValue == 11 || columnValue == 12) {
                    Range rangeCon;
                    String confirmCellIndex;
                    String originalCellIndex;
                    if ("0".equals(value)) {
                        value = null;
                    }
                    String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                    String formulaKey = colValue + "formula";
                    String formula = String.valueOf(values.get(formulaKey));
                    Range range3 = sheet.getRange(row, col);
                    this.setFormual(sheet, values, formulaKey, formula, range3);
                    if (value != null) {
                        range3.setValue(new Variant((Object)value));
                    }
                    if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                        originalCellIndex = this.getConfirmCellIndex(sheet, row, col, false);
                        confirmCellIndex = this.getConfirmCellIndex(sheet, row, col, true);
                        rangeCon = sheet.getRange(row, col + 1);
                        debitLocal = this.getDebitCombinCellIndex(originalCellIndex, isDiffRow, columnValue, debitLocal);
                        creditLocal = this.getCreditCombinCellIndex(originalCellIndex, isDiffRow, columnValue, creditLocal);
                        debitLocalConfirm = this.getDebitCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, debitLocalConfirm);
                        creditLocalConfirm = this.getCreditCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, creditLocalConfirm);
                        this.setDiffFormula(range3, columnValue, isDiffRow, dc, debitLocal, creditLocal);
                        this.setFormual(sheet, values, formulaKey, formula, rangeCon);
                        this.setDiffFormula(rangeCon, columnValue, isDiffRow, dc, debitLocalConfirm, creditLocalConfirm);
                        this.setAmountCellFormat(sheet, spreadManager, row, col, range3);
                        ++col;
                        if (row == start) {
                            ++columnCount;
                        }
                    } else {
                        originalCellIndex = this.getConfirmCellIndex(sheet, row, col, false);
                        confirmCellIndex = this.getConfirmCellIndex(sheet, row, col, true);
                        debitLocal = this.getDebitCombinCellIndex(originalCellIndex, isDiffRow, columnValue, debitLocal);
                        creditLocal = this.getCreditCombinCellIndex(originalCellIndex, isDiffRow, columnValue, creditLocal);
                        debitLocalConfirm = this.getDebitCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, debitLocalConfirm);
                        creditLocalConfirm = this.getCreditCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, creditLocalConfirm);
                        this.setDiffFormula(range3, columnValue, isDiffRow, dc, debitLocal, creditLocal);
                        rangeCon = sheet.getRange(row, col + 1);
                        this.setDiffFormula(rangeCon, columnValue, isDiffRow, dc, debitLocalConfirm, creditLocalConfirm);
                        this.setAmountCellFormat(sheet, spreadManager, row, col, range3);
                    }
                    this.collectLockRanges(range3, columnValue, lockRanges);
                    continue;
                }
                range = sheet.getRange(row, col);
                range.setValue(new Variant((Object)value));
                this.collectLockRanges(range, columnValue, lockRanges);
                if (valueid != null) {
                    range.setUserObject("id", (Object)valueid);
                }
                this.autoSetColWidth(spreadManager, sheet, row, col);
            }
            if (isDiffRow) {
                debitLocal = new StringBuffer();
                creditLocal = new StringBuffer();
                debitLocalConfirm = new StringBuffer();
                creditLocalConfirm = new StringBuffer();
            }
            ++index;
        }
        this.setFontSize(sheet.getRange(start, left, rowCount - 1, columnCount));
        this.setRptItemNameColIndexToCell(sheet, rptItemNameCol, rptItemCells);
        this.LockRanges(sheet, lockRanges);
        this.merge(true, sheet, start, rowCount, mergeColumns, bizNumberColIndex, descriptionColIndex, rowMap);
        this.setBorder(sheet.getRange(start, left, rowCount - 1, columnCount));
        sheet.setUserObject("realColumnCount", (Object)columnCount);
        sheet.setUserObject("rowCount", (Object)investElimMnsRecords.size());
    }

    private void setFormual(Sheet sheet, Map values, String formulaKey, String formula, Range range) {
        if (values.get(formulaKey) != null) {
            if (RptUtil.isFormulaValid((String)formula, (Sheet)sheet)) {
                formula = "=" + formula;
            }
            range.setFormula(formula);
        }
    }

    private void setDiffFormula(Range range, int columnValue, boolean isDiffRow, int dc, StringBuffer debitLocalSb, StringBuffer creditLocalSb) {
        if (!isDiffRow) {
            return;
        }
        StringBuffer totalFormula = new StringBuffer();
        String debitLocal = debitLocalSb.toString();
        String creditLocal = creditLocalSb.toString();
        if (StringUtils.isEmpty((String)debitLocal) || StringUtils.isEmpty((String)debitLocal)) {
            Variant variant = range.getValue();
            range.setFormula(null);
            try {
                if (variant.compareTo(new Variant(0)) != 0) {
                    range.setValue(variant);
                }
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"setDiffFormula: ", (Throwable)e);
            }
            return;
        }
        if (dc == 1) {
            if (creditLocal.indexOf("+") > 0) {
                totalFormula.append("(").append(creditLocal).append(")");
            } else {
                totalFormula.append(creditLocal);
            }
            totalFormula.append("-");
            if (debitLocal.indexOf("+") > 0) {
                totalFormula.append("(").append(debitLocal).append(")");
            } else {
                totalFormula.append(debitLocal);
            }
        } else if (dc == 2) {
            if (debitLocal.indexOf("+") > 0) {
                totalFormula.append("(").append(debitLocal).append(")");
            } else {
                totalFormula.append(debitLocal);
            }
            totalFormula.append("-");
            if (creditLocal.indexOf("+") > 0) {
                totalFormula.append("(").append(creditLocal).append(")");
            } else {
                totalFormula.append(creditLocal);
            }
        }
        if (dc == 1 && columnValue == 11 || dc == 2 && columnValue == 12) {
            range.setFormula("=" + totalFormula.toString());
        }
    }

    private StringBuffer getDebitCombinCellIndex(String confirmCellIndex, boolean isDiffRow, int columnValue, StringBuffer debitLocal) {
        if (isDiffRow) {
            return debitLocal;
        }
        if (columnValue == 11) {
            if (debitLocal.length() > 0) {
                debitLocal.append("+").append(confirmCellIndex);
            } else {
                debitLocal.append(confirmCellIndex);
            }
        }
        return debitLocal;
    }

    private StringBuffer getCreditCombinCellIndex(String confirmCellIndex, boolean isDiffRow, int columnValue, StringBuffer creditLocal) {
        if (isDiffRow) {
            return creditLocal;
        }
        if (columnValue == 12) {
            if (creditLocal.length() > 0) {
                creditLocal.append("+").append(confirmCellIndex);
            } else {
                creditLocal.append(confirmCellIndex);
            }
        }
        return creditLocal;
    }

    private void setAmountCellFormat(Sheet sheet, SpreadManager spreadManager, int row, int col, Range range) {
        this.autoSetColWidth(spreadManager, sheet, row, col);
        this.setHorizontalAlign(range, Styles.HorizontalAlignment.RIGHT);
        this.autoSetColWidth(spreadManager, sheet, row, col + 1);
        range = sheet.getRange(row, col + 1);
        this.setHorizontalAlign(range, Styles.HorizontalAlignment.RIGHT);
    }

    private String getConfirmCellIndex(Sheet sheet, int row, int col, boolean isConfirmCol) {
        int colomnIndex = 0;
        colomnIndex = isConfirmCol ? col + 2 : col + 1;
        String cellIndex = InvestElimManuScriptUtil.excelColIndexToStr(colomnIndex) + (row + 1);
        return cellIndex;
    }

    private void bookCalculate() {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setEnableCalculation(false);
        }
        this.getBook().getActiveSheet().setEnableCalculation(true);
        boolean isSkip = this.getBook().isSkipListeners();
        this.getBook().setSkipListeners(true);
        this.getBook().calc();
        this.getBook().setCalculate(true);
        this.getBook().setSkipListeners(isSkip);
        this.getSpreadManager().getSpreadContainer().repaint();
    }

    private void collectMergeColumnIndex(List<Integer> mergeColumns, int col, int columnValue) {
        if (!(1 != columnValue && 2 != columnValue || mergeColumns.contains(col))) {
            mergeColumns.add(col);
        }
    }

    private void collectLockRanges(Range range, int columnValue, List<Range> lockRanges) {
        if (0 == columnValue || 1 == columnValue || 2 == columnValue || 3 == columnValue || 4 == columnValue || 7 == columnValue || 8 == columnValue || 9 == columnValue || 10 == columnValue || 5 == columnValue || 11 == columnValue || 12 == columnValue) {
            lockRanges.add(range);
        }
    }

    private void LockRanges(Sheet sheet, List<Range> lockRanges) {
        if (lockRanges.isEmpty()) {
            return;
        }
        for (Range range : lockRanges) {
            this.setLock(range);
        }
    }

    private void setLock(Range range) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(true);
        range.setStyle(sa, sa);
    }

    private void merge(boolean isMerge, Sheet sheet, int start_row, int end_row, List<Integer> mergeColumns, int bizNumberColIndex, int descriptionColIndex, Map<String, String[]> rowMap) {
        int end;
        int start;
        String[] rows;
        if (bizNumberColIndex != -1) {
            SheetColumMergeHelper mergeHelper = new SheetColumMergeHelper(sheet, bizNumberColIndex, start_row, bizNumberColIndex, end_row);
            mergeHelper.merge(isMerge);
        }
        if (!mergeColumns.isEmpty()) {
            for (String key : rowMap.keySet()) {
                rows = rowMap.get(key);
                if (rows.length != 2 || rows[1] == null) continue;
                start = Integer.valueOf(rows[0]);
                end = Integer.valueOf(rows[1]);
                int size = mergeColumns.size();
                for (int i = 0; i < size; ++i) {
                    int colIndex = mergeColumns.get(i);
                    SheetColumMergeHelper mergeHelper = new SheetColumMergeHelper(sheet, colIndex, start, colIndex, end + 1);
                    mergeHelper.merge(isMerge);
                }
            }
        }
        if (descriptionColIndex != -1) {
            for (String key : rowMap.keySet()) {
                rows = rowMap.get(key);
                if (rows.length != 2 || rows[1] == null) continue;
                start = Integer.valueOf(rows[0]);
                end = Integer.valueOf(rows[1]);
                Range range = sheet.getRange(start, descriptionColIndex, end, descriptionColIndex);
                range.setIgnoreProtected(true);
                range.merge();
            }
        }
    }

    private void setHorizontalAlign(Range range, Styles.HorizontalAlignment hAlign) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(hAlign);
        range.setStyle(sa, sa);
    }

    public void setBorder(Range range) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_H, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_H, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderPenStyle(Styles.Position.INNER_V, PenStyle.PS_SOLID);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_V, LineStyle.SINGLE_LINE);
        range.setStyle(sa, saInnerBorder);
    }

    private void setFontSize(Range range) {
        range = UserObjectHelper.getUnprotectedRange((Range)range);
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(10);
        range.setStyle(sa, sa);
    }

    private void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        Cell cell = sheet.getCell(row, col, true);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 12)) {
            width = w + 12;
        }
        if (width > 0) {
            if (width > 270) {
                width = 270;
            }
            sheet.getColRange(col, col).setColumnWidth(width);
        }
    }

    private Map getGenInvestElimMnsParams(UIContext uiContext) throws EASBizException, BOSException {
        Map params = this.getParams(uiContext);
        CslReportInfo cslReportInfo = (CslReportInfo)this.getEditData();
        String treeId = cslReportInfo.getOrgTree().getId().toString();
        String unitId = cslReportInfo.getOrgUnit().getId().toString();
        String sourceCurrencyId = null;
        sourceCurrencyId = cslReportInfo.getSourceCurrency() != null ? cslReportInfo.getSourceCurrency().getId().toString() : cslReportInfo.getCurrency().getId().toString();
        CurrencyInfo sourceCurrencyinfo = this.getCurrencyInfo(sourceCurrencyId);
        String currencyId = cslReportInfo.getCurrency().getId().toString();
        CurrencyInfo currencyinfo = this.getCurrencyInfo(currencyId);
        OrgTreeInfo treeInfo = (OrgTreeInfo)uiContext.get((Object)"orgTree");
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)uiContext.get((Object)"orgUnit");
        int year = cslReportInfo.getYear();
        short period = cslReportInfo.getPeriod();
        Date reportDate = cslReportInfo.getReportDate();
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        int mergeType = RptAutoWeaveUtil.getMergeMode(null, (String)treeId).getValue();
        String tmplId = cslReportInfo.getTemplate().getId().toString();
        TemplateInfo tmplInfo = this.getTemplateInfo(tmplId);
        Sheet currentActiveSheet = this.getBook().getActiveSheet();
        String currentSheetName = currentActiveSheet.getSheetName();
        params.put("cslReportId", cslReportInfo.getId().toString());
        params.put("orgTreeId", treeId);
        params.put("orgUnitId", unitId);
        params.put("orgTree", treeInfo);
        params.put("orgUnit", orgUnitInfo);
        params.put("sourceCurrency", sourceCurrencyinfo);
        params.put("currency", currencyinfo);
        params.put("mnsTmpl", tmplInfo);
        params.put("year", year);
        params.put("period", Integer.valueOf(period));
        params.put("rptDate", reportDate);
        params.put("periodType", periodType);
        params.put("mergeType", mergeType);
        params.put("sceneIds", String.valueOf(uiContext.get((Object)"sceneIds")));
        params.put("showType", String.valueOf(uiContext.get((Object)"showType")));
        params.put("activeSheetName", currentSheetName);
        return params;
    }

    private TemplateInfo getTemplateInfo(String tmplId) throws EASBizException, BOSException {
        TemplateInfo tmplInfo = TemplateFactory.getRemoteInstance().getTemplateInfo("select id,number,name where id = '" + tmplId + "'");
        return tmplInfo;
    }

    private CurrencyInfo getCurrencyInfo(String currencyId) throws EASBizException, BOSException {
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection("select id,number,name,precision where id = '" + currencyId + "'");
        return currencyCollection.get(0);
    }

    private boolean openTypeMappingUI(UIContext uiContext) throws EASBizException, BOSException {
        Map params = this.getParams(uiContext);
        List infos = SceneTypeMappingFactory.getRemoteInstance().getSceneTypeMappingNewInfos(params);
        Set<String> sceneTypeIds = this.getSceneTypes(uiContext);
        boolean isCancel = false;
        if (infos != null && !infos.isEmpty()) {
            Iterator<String> it = sceneTypeIds.iterator();
            ArrayList<Boolean> result = new ArrayList<Boolean>();
            while (it.hasNext()) {
                String sceneTypeId = it.next();
                int size = infos.size();
                for (int i = 0; i < size; ++i) {
                    SceneTypeMappingNewInfo info = (SceneTypeMappingNewInfo)infos.get(i);
                    String sceneTypeMappId = info.getSceneTypeId();
                    if (!sceneTypeId.equals(sceneTypeMappId)) continue;
                    result.add(Boolean.TRUE);
                }
            }
            if (result.size() != sceneTypeIds.size()) {
                IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneTypeMappingUI", (Map)uiContext, null);
                iUIWindow.show();
                isCancel = ((SceneTypeMappingUI)iUIWindow.getUIObject()).isCancel();
            }
        } else {
            IUIWindow iUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneTypeMappingUI", (Map)uiContext, null);
            iUIWindow.show();
            isCancel = ((SceneTypeMappingUI)iUIWindow.getUIObject()).isCancel();
        }
        return isCancel;
    }

    private Set<String> getSceneTypes(UIContext uiContext) {
        HashSet<String> sceneTypeIds = new HashSet<String>();
        String split = ",";
        String sceneIdsString = (String)uiContext.get((Object)"sceneIds");
        String[] sceneIds = sceneIdsString.split(split);
        HashSet<String> scenes = new HashSet<String>();
        for (String sceneId : sceneIds) {
            scenes.add(sceneId);
        }
        if (!scenes.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", scenes, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("displayTemplateType");
            view.setSelector(selector);
            try {
                SceneCollection coll = SceneFactory.getRemoteInstance().getSceneCollection(view);
                if (coll != null && !coll.isEmpty()) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        SceneInfo scene = coll.get(i);
                        String sceneTypeId = scene.getDisplayTemplateType().getId().toString();
                        sceneTypeIds.add(sceneTypeId);
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"getSceneTypes: ", (Throwable)e);
            }
        }
        return sceneTypeIds;
    }

    private Map getParams(UIContext uiContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgTreeNumber = (String)uiContext.get((Object)"orgTreeNumber");
        params.put("orgTreeNumber", orgTreeNumber);
        String orgUnitNumber = (String)uiContext.get((Object)"orgUnitNumber");
        params.put("orgUnitNumber", orgUnitNumber);
        return params;
    }

    @Override
    public void actionGenInvestElim_actionPerformed(ActionEvent e) throws Exception {
        String id = ((CslReportInfo)this.getEditData()).getId().toString();
        CslReportInfo info = CslReportFactory.getRemoteInstance().getCslReportInfo("select *,currency.precision where id='" + id + "'");
        Sheet activeSheet = this.getActiveSheet(info);
        if (activeSheet == null) {
            return;
        }
        String msg = InvestElimManuScriptUtil.checkBalance(activeSheet);
        if (!StringUtils.isEmpty((String)msg) && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"99_balance")) == 2) {
            SysUtil.abort();
        }
        GenInvestEliminationHand genInvestEliminationHand = new GenInvestEliminationHand(activeSheet, info);
        genInvestEliminationHand.genInvestElimination();
    }

    private Sheet getActiveSheet(CslReportInfo info) throws Exception {
        Sheet currentActiveSheet = this.getBook().getActiveSheet();
        String currentSheetName = currentActiveSheet.getSheetName();
        Book book = info.getBook();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String sheetName = sheet.getSheetName();
            if (!currentSheetName.equals(sheetName)) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public void onSheetActive(Sheet sheet) {
        super.onSheetActive(sheet);
        SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
        InvestElimMnsRptProcessUI.clearButton(spreadContext);
    }

    public void update(Observable o, Object arg) {
        CSLContextHelper.update((Observable)o, (CoreUI)this);
    }

    @Override
    public boolean checkBeforeWindowClosing() {
        if (this.getUIContext().get("Owner") instanceof InvestElimMnsRptListUI) {
            InvestElimMnsRptListUI listUI = (InvestElimMnsRptListUI)((Object)this.getUIContext().get("Owner"));
            try {
                listUI.refreshList();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return super.checkBeforeWindowClosing();
    }

    protected void disposeUIWindow() {
        CSLContextHelper.unRegistUIObject((ICSLContextUI)this);
        super.disposeUIWindow();
    }

    @Override
    public void actionToolsRptAudit_actionPerformed(ActionEvent e) throws Exception {
        CslReportInfo editData = (CslReportInfo)this.getEditData();
        if (editData.getAuditedStatus() == AuditedStatusEnum.UNAUDITED) {
            if ((this.isRptModify() || this.getBook().getUndoManager().canUndo()) && (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState()))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"5_BaseReportDesignerUI"));
                return;
            }
            String msg = null;
            Book book = this.getBook();
            StringBuffer tips = new StringBuffer();
            int size = book.getSheetCount();
            for (int i = 0; i < size; ++i) {
                Sheet sheet = book.getSheet(i);
                StringBuffer message = new StringBuffer();
                msg = InvestElimManuScriptUtil.checkDebitAndCreditHaveData(sheet);
                if (msg != null && msg.length() > 0) {
                    message.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"54_AllHasData")).append("<br/>");
                    message.append(msg);
                }
                if (message.length() <= 0) continue;
                tips.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"40_sheet", (Object[])new Object[]{sheet.getSheetName()})).append("<br/>");
                tips.append(message.toString()).append("<br/>");
            }
            msg = tips.toString();
            if (StringUtils.isEmpty((String)msg)) {
                tips = new StringBuffer();
                Book calBook = InvestElimManuScriptUtil.initBook(editData);
                int size2 = book.getSheetCount();
                for (int i = 0; i < size2; ++i) {
                    Sheet sheet = book.getSheet(i);
                    StringBuffer message = new StringBuffer();
                    msg = InvestElimManuScriptUtil.checkVerifyRelation(sheet, calBook);
                    if (msg != null && !StringUtils.isEmpty((String)msg)) {
                        message.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"39_verifyMsg")).append(" \n");
                        msg = msg.replaceAll("<br/>", "\n");
                        message.append(msg);
                    }
                    if (message.length() <= 0) continue;
                    tips.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"40_sheet", (Object[])new Object[]{sheet.getSheetName()})).append(" \n");
                    tips.append(message.toString()).append(" \n");
                }
                msg = tips.toString();
                if (!StringUtils.isEmpty((String)msg)) {
                    int result;
                    InvestElimMnsRptProcessUI ui = this;
                    if (this.getUIContext().get("parentOwner") != null) {
                        ui = (CoreUI)this.getUIContext().get("parentOwner");
                    }
                    if ((result = MsgBox.showConfirm3((Component)((Object)ui), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"55_verifyTitle"), (String)msg)) == 0) {
                        super.actionToolsRptAudit_actionPerformed(e);
                        this.setOprtState(OprtState.VIEW);
                        SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
                        InvestElimMnsRptProcessUI.clearButton(spreadContext);
                        if (this.render != null) {
                            UserCellDisplayProvider.removeRenderProvider(this.render);
                            this.render = null;
                        }
                    }
                } else {
                    super.actionToolsRptAudit_actionPerformed(e);
                    this.setOprtState(OprtState.VIEW);
                    SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
                    InvestElimMnsRptProcessUI.clearButton(spreadContext);
                    if (this.render != null) {
                        UserCellDisplayProvider.removeRenderProvider(this.render);
                        this.render = null;
                    }
                }
            } else {
                this.showFailMessage(msg);
            }
        } else {
            super.actionToolsRptAudit_actionPerformed(e);
            this.setOprtState(OprtState.EDIT);
            this.registerRender();
        }
        this.actionGenVoucher.setVisible(false);
    }

    @Override
    public void actionRemoveZeroRow_actionPerformed(ActionEvent e) throws Exception {
        this.getBook().setCalculate(false);
        this.unMerge(false);
        boolean isRemoved = this.removeZeroRows();
        if (isRemoved) {
            this.reOrderBizNumber();
            this.modifyDiffFormula();
        }
        this.unMerge(true);
        this.bookCalculate();
    }

    private void reOrderBizNumber() throws EASBizException, BOSException {
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject("rowCount") == null) {
            return;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        String bizNumber = null;
        String newBizNumber = null;
        int index = 0;
        CslReportInfo cslReportInfo = (CslReportInfo)this.getEditData();
        String currencyId = cslReportInfo.getCurrency().getId().toString();
        CurrencyInfo currencyinfo = this.getCurrencyInfo(currencyId);
        String currencyNumber = currencyinfo.getNumber();
        String tmplId = cslReportInfo.getTemplate().getId().toString();
        TemplateInfo tmplInfo = this.getTemplateInfo(tmplId);
        String mnsTmplNumber = tmplInfo.getNumber();
        for (int row = start; row < rowCount; ++row) {
            for (int col = left; col < columnCount; ++col) {
                ItemFormula itemFormula;
                String colValue;
                int columnValue;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null || 0 != (columnValue = Integer.valueOf(colValue = (itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue()).getExt("columnValue")).intValue())) continue;
                Range range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(row, col));
                if (bizNumber == null || !bizNumber.equals(range.getValue().toString())) {
                    bizNumber = range.getValue().toString();
                    String seq = InvestElimManuScriptUtil.getSequence(index);
                    String number = InvestElimManuScriptUtil.getEntryNumber(currencyNumber, mnsTmplNumber, seq);
                    range.setValue(new Variant((Object)number));
                    newBizNumber = number;
                    ++index;
                    continue;
                }
                if (!bizNumber.equals(range.getValue().toString())) continue;
                range.setValue(new Variant(newBizNumber));
            }
        }
    }

    private void unMerge(boolean isMerge) {
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject("rowCount") == null) {
            return;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        int bizNumberColIndex = -1;
        int descriptionColIndex = -1;
        String bizNumber = null;
        HashMap<String, String[]> rowMap = new HashMap<String, String[]>();
        String[] rows = null;
        ArrayList<Integer> mergeColumns = new ArrayList<Integer>();
        for (int row = start; row < rowCount; ++row) {
            for (int col = left; col <= columnCount; ++col) {
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                if (0 == columnValue) {
                    bizNumberColIndex = col;
                } else if (15 == columnValue) {
                    descriptionColIndex = col;
                }
                if (0 == columnValue) {
                    String[] tmpRows;
                    Range range = sheet.getRange(row, col);
                    if (!range.getValue().isNull()) {
                        if (bizNumber == null || !bizNumber.equals(range.getValue().toString())) {
                            bizNumber = range.getValue().toString();
                            rows = new String[2];
                            rows[0] = String.valueOf(row);
                            rowMap.put(bizNumber, rows);
                        } else if (rowMap.containsKey(bizNumber)) {
                            tmpRows = (String[])rowMap.get(bizNumber);
                            tmpRows[1] = String.valueOf(row);
                        }
                    } else if (rowMap.containsKey(bizNumber)) {
                        tmpRows = (String[])rowMap.get(bizNumber);
                        tmpRows[1] = String.valueOf(row);
                    }
                }
                this.collectMergeColumnIndex(mergeColumns, col, columnValue);
            }
        }
        this.merge(isMerge, sheet, start, rowCount, mergeColumns, bizNumberColIndex, descriptionColIndex, rowMap);
    }

    private void modifyDiffFormula() {
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject("rowCount") == null) {
            return;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        StringBuffer debitLocal = new StringBuffer();
        StringBuffer creditLocal = new StringBuffer();
        StringBuffer debitLocalConfirm = new StringBuffer();
        StringBuffer creditLocalConfirm = new StringBuffer();
        String bizNumber = null;
        this.getBook().setCalculate(false);
        for (int row = start; row < rowCount; ++row) {
            boolean isDiffRow = false;
            int dc = -1;
            for (int col = left; col < columnCount; ++col) {
                Range rangecon;
                String confirmCellIndex;
                String originalCellIndex;
                Range range;
                Range range2;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                if (0 == columnValue) {
                    range2 = sheet.getRange(row, col);
                    String number = range2.getValue().toString();
                    if (bizNumber != null) {
                        if (!bizNumber.equals(number)) {
                            debitLocal = new StringBuffer();
                            creditLocal = new StringBuffer();
                            debitLocalConfirm = new StringBuffer();
                            creditLocalConfirm = new StringBuffer();
                            bizNumber = number;
                        }
                    } else {
                        bizNumber = number;
                    }
                }
                if (7 == columnValue) {
                    range2 = sheet.getRange(row, col);
                    isDiffRow = Boolean.valueOf(String.valueOf(range2.getUserObject("diffEntry")));
                    dc = Integer.valueOf(String.valueOf(range2.getUserObject("dc")));
                }
                if (columnValue != 11 && columnValue != 12) continue;
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                    range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(row, col));
                    originalCellIndex = this.getConfirmCellIndex(sheet, row, col, false);
                    confirmCellIndex = this.getConfirmCellIndex(sheet, row, col, true);
                    debitLocal = this.getDebitCombinCellIndex(originalCellIndex, isDiffRow, columnValue, debitLocal);
                    creditLocal = this.getCreditCombinCellIndex(originalCellIndex, isDiffRow, columnValue, creditLocal);
                    debitLocalConfirm = this.getDebitCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, debitLocalConfirm);
                    creditLocalConfirm = this.getCreditCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, creditLocalConfirm);
                    this.setDiffFormula(range, columnValue, isDiffRow, dc, debitLocal, creditLocal);
                    rangecon = sheet.getRange(row, col + 1);
                    this.setDiffFormula(rangecon, columnValue, isDiffRow, dc, debitLocalConfirm, creditLocalConfirm);
                    ++col;
                    if (row != start) continue;
                    ++columnCount;
                    continue;
                }
                range = UserObjectHelper.getUnprotectedRange((Range)sheet.getRange(row, col));
                originalCellIndex = this.getConfirmCellIndex(sheet, row, col, false);
                confirmCellIndex = this.getConfirmCellIndex(sheet, row, col, true);
                debitLocal = this.getDebitCombinCellIndex(originalCellIndex, isDiffRow, columnValue, debitLocal);
                creditLocal = this.getCreditCombinCellIndex(originalCellIndex, isDiffRow, columnValue, creditLocal);
                debitLocalConfirm = this.getDebitCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, debitLocalConfirm);
                creditLocalConfirm = this.getCreditCombinCellIndex(confirmCellIndex, isDiffRow, columnValue, creditLocalConfirm);
                this.setDiffFormula(range, columnValue, isDiffRow, dc, debitLocal, creditLocal);
                rangecon = sheet.getRange(row, col + 1);
                this.setDiffFormula(rangecon, columnValue, isDiffRow, dc, debitLocalConfirm, creditLocalConfirm);
            }
            if (!isDiffRow) continue;
            debitLocal = new StringBuffer();
            creditLocal = new StringBuffer();
            debitLocalConfirm = new StringBuffer();
            creditLocalConfirm = new StringBuffer();
        }
    }

    private boolean removeZeroRows() throws SyntaxErrorException {
        boolean isRemove = false;
        Sheet sheet = this.getBook().getActiveSheet();
        if (sheet.getUserObject("rowCount") == null) {
            return false;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        ArrayList<Integer> delRows = new ArrayList<Integer>();
        BigDecimal zero = new BigDecimal("0");
        String bizNumber = null;
        String elimTmplId = null;
        String elimModeId = null;
        String investCompanyNum = null;
        String investCompanyId = null;
        String tarInvestCompanyNum = null;
        String tarInvestCompanyId = null;
        for (int row = start; row < rowCount; ++row) {
            boolean debitValueIsNull = false;
            boolean creditValueIsNull = false;
            for (int col = left; col < columnCount; ++col) {
                BigDecimal value;
                Range range;
                Range range2;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                if (0 == columnValue) {
                    range2 = sheet.getRange(row, col);
                    elimTmplId = this.setUserObjectValue(range2, elimTmplId, "elimTemplateId", row, col);
                    elimModeId = this.setUserObjectValue(range2, elimModeId, "eliminationMode", row, col);
                    bizNumber = this.setValue(range2, bizNumber, row, col);
                }
                if (1 == columnValue) {
                    range2 = sheet.getRange(row, col);
                    investCompanyId = this.setUserObjectValue(range2, investCompanyId, "id", row, col);
                    investCompanyNum = this.setValue(range2, investCompanyNum, row, col);
                }
                if (2 == columnValue) {
                    range2 = sheet.getRange(row, col);
                    tarInvestCompanyId = this.setUserObjectValue(range2, tarInvestCompanyId, "id", row, col);
                    tarInvestCompanyNum = this.setValue(range2, tarInvestCompanyNum, row, col);
                }
                if (columnValue != 11 && columnValue != 12) continue;
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                    range = sheet.getRange(row, col + 1);
                    Variant variant = range.getValue();
                    if (!variant.isError()) {
                        BigDecimal value2;
                        BigDecimal bigDecimal = value2 = range.getValue() != null ? range.getValue().toBigDecimal() : zero;
                        if (value2.compareTo(zero) == 0) {
                            if (columnValue == 11) {
                                debitValueIsNull = true;
                            } else if (columnValue == 12) {
                                creditValueIsNull = true;
                            }
                        }
                    }
                    ++col;
                    if (row != start) continue;
                    ++columnCount;
                    continue;
                }
                range = sheet.getRange(row, col);
                BigDecimal bigDecimal = value = range.getValue() != null ? range.getValue().toBigDecimal() : zero;
                if (value.compareTo(zero) != 0) continue;
                if (columnValue == 11) {
                    debitValueIsNull = true;
                    continue;
                }
                if (columnValue != 12) continue;
                creditValueIsNull = true;
            }
            if (!debitValueIsNull || !creditValueIsNull) continue;
            delRows.add(row);
        }
        if (delRows.size() > 0) {
            SpreadContext spreadContext = this.getSpreadManager().getSpreadContainer();
            InvestElimMnsRptProcessUI.clearButton(spreadContext);
            Collections.reverse(delRows);
            int size = delRows.size();
            for (int i = 0; i < size; ++i) {
                int row = (Integer)delRows.get(i);
                UserObjectHelper.getUnprotectedRange((Range)sheet.getRowRange(row, row)).delete(true);
            }
            int oldRowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue()));
            int newRowCount = oldRowCount - delRows.size();
            sheet.setUserObject("rowCount", (Object)newRowCount);
            isRemove = true;
        }
        return isRemove;
    }

    private String setUserObjectValue(Range range, String value, String key, int row, int col) {
        if (!range.getValue().isNull()) {
            if (range.getUserObject(key) != null) {
                value = range.getUserObject(key).toString();
            }
        } else if (!StringUtils.isEmpty((String)value)) {
            range.setUserObject(key, (Object)value);
        }
        return value;
    }

    private String setValue(Range range, String number, int row, int col) {
        if (!range.getValue().isNull()) {
            number = range.getValue().toString();
        } else {
            range.setValue(new Variant((Object)number));
            this.setFontSize(range);
        }
        return number;
    }

    private void collectRptItemNumberCell(Cell cell, int columnValue, List<Cell> rptItemCells, List<Cell> deCells) {
        if (7 == columnValue) {
            cell.setUserObject("dimemsion", (Object)"rptItemNumber");
            rptItemCells.add(cell);
        } else if (9 == columnValue) {
            cell.setUserObject("dimemsion", (Object)"dataElement");
            deCells.add(cell);
        }
    }

    private void setRptItemNameColIndexToCell(Sheet sheet, int col, List<Cell> rptItemCells) {
        if (rptItemCells.isEmpty()) {
            return;
        }
        for (Cell cell : rptItemCells) {
            cell.setUserObject("rptItemNameIndex", (Object)col);
        }
    }

    public static void clearButton(SpreadContext spreadContext) {
        KDSpread spread = spreadContext.getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)spread.getView(i, j);
                for (int c = sv.getComponentCount() - 1; c >= 0; --c) {
                    if (!(sv.getComponent(c) instanceof KDWorkButton)) continue;
                    sv.remove(c);
                }
            }
        }
    }

    @Override
    public void actionCheckBalance_actionPerformed(ActionEvent e) throws Exception {
        Sheet sheet = this.getBook().getActiveSheet();
        String msg = InvestElimManuScriptUtil.checkBalance(sheet);
        this.showFailMessage(msg);
        this.showSuccessMessage(msg);
    }

    private void showFailMessage(String msg) {
        if (msg != null && msg.length() > 0) {
            try {
                InvestElimMnsRptProcessUI ui = this;
                if (this.getUIContext().get("parentOwner") != null) {
                    ui = (CoreUI)this.getUIContext().get("parentOwner");
                }
                UIContext uiCtx = new UIContext((Object)ui);
                uiCtx.put((Object)"String", (Object)msg.toString());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiCtx, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                logger.error((Object)"showEditorPanelUI: ", (Throwable)e);
            }
        }
    }

    private void showSuccessMessage(String msg) {
        if (msg != null && msg.length() == 0) {
            String success = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"30_successMsg");
            MsgBox.showInfo((Component)((Object)this), (String)success);
            SysUtil.abort();
        }
    }
}

