/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractRptItemF7UI;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class RptItemF7UI
extends AbstractRptItemF7UI {
    private static final long serialVersionUID = 7024874463332374726L;
    private static final Logger logger = CoreUIObject.getLogger(RptItemF7UI.class);
    private boolean isCanceled = false;
    private RPTItemInfo rptItemInfo = null;
    private int selectRow = -1;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.queryRPTItemQuery == null) {
            this.queryRPTItemQuery = new EntityViewInfo();
            FilterInfo fltrInfo = new FilterInfo();
            fltrInfo.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
            fltrInfo.setMaskString("#0");
            this.queryRPTItemQuery.setFilter(fltrInfo);
        }
        this.kdtQueryRPTItemQuery.setEditable(false);
        Image icon_off = KDResourceManager.getImageOfRapid((String)"prompt_off.gif");
        this.btnQuery.setIcon((Icon)new ImageIcon(icon_off));
        this.initTxtInput();
        this.initListeners();
    }

    private void initTxtInput() {
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"4_quickQueryInput");
        this.txtInput.setText(defaultStr);
        CslRptUIUtil.QuickQueryHandler quickQueryHandler = new CslRptUIUtil.QuickQueryHandler(this.txtInput);
        this.txtInput.addFocusListener((FocusListener)quickQueryHandler);
    }

    private void initListeners() {
        this.kdtQueryRPTItemQuery.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                RptItemF7UI.this.tableRowSelected(e);
            }
        });
        this.kdtQueryRPTItemQuery.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    RptItemF7UI.this.selectRow = e.getRowIndex();
                    RptItemF7UI.this.doSelected();
                }
            }
        });
    }

    private void tableRowSelected(KDTSelectEvent e) {
        this.selectRow = e.getSelectBlock().getBeginRow();
    }

    public void doSelected() {
        logger.debug((Object)("select row is:" + this.selectRow));
        IRow row = this.kdtQueryRPTItemQuery.getRow(this.selectRow);
        if (row != null) {
            String id = row.getCell("id").getValue().toString();
            try {
                this.rptItemInfo = RPTItemFactory.getRemoteInstance().getRPTItemInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (EASBizException e1) {
                logger.error((Object)"RPTItemInfoEASBizException", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"RPTItemInfoBosException", (Throwable)e1);
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.doSelected();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.rptItemInfo = null;
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        this.quickQueryCondition();
    }

    private void quickQueryCondition() {
        FilterInfo fltrInfo = new FilterInfo();
        String defaultStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"4_quickQueryInput");
        String filterString = this.txtInput.getText();
        if (!StringUtils.isEmpty((String)filterString) && !filterString.equals(defaultStr)) {
            fltrInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterString + "%"), CompareType.LIKE));
            fltrInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterString + "%"), CompareType.LIKE));
            fltrInfo.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
            StringBuffer sbMask = new StringBuffer();
            sbMask.append(" (#0 ").append(" or #1) ").append(" and #2");
            fltrInfo.setMaskString(sbMask.toString());
        } else {
            fltrInfo.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
            fltrInfo.setMaskString("#0");
        }
        this.queryRPTItemQuery.setFilter(fltrInfo);
        this.kdtQueryRPTItemQuery.removeRows();
    }

    public RPTItemInfo getReturnValue() {
        return this.rptItemInfo;
    }

    public boolean isCancel() {
        return this.isCanceled;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

