/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.FormulaSelector;
import com.kingdee.eas.fi.gr.cslrpt.client.TemplateSelectF7Dialog;
import com.kingdee.eas.fi.gr.weaverpt.client.uiaction.KDTableMoveAction;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.LogicFlagEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractSceneEditUI;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class SceneEditUI
extends AbstractSceneEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SceneEditUI.class);
    private static final String TRICD_SEQ = "seq";
    private static final String TRICD_LEFTBRACKET = "leftBracket";
    private static final String TRICD_TRIGGERCONDITION = "triggerCondition";
    private static final String TRICD_RIGHTBRACKET = "rightBracket";
    private static final String TRICD_LOGICFLAG = "logicFlag";
    private static final String TMP_SEQ = "seq";
    private static final String TMP_NUMBER = "templateNumber";
    private static final String TMP_NAME = "templateName";
    private static final String TMP_INVESTNEWTYPE = "investNewType";
    private static final String VERIFY_RPTITEM = "rptItemNum";
    private static final String VERIFY_RPTITEMNAME = "rptItemName";
    private static final String VERIFY_DATAELEMENT = "dataElement";
    private static final String VERIFY_OPERATESYMBOL = "operateSymbol";
    private static final String VERIFY_AMOUNT = "amount";
    private static final String VERIFY_TIPS = "verifyTips";
    private final String SOURCE_PATH = "com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource";
    private static final String TriggerConditionQuery = "com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionQuery";
    private static List leftBracket_List = new ArrayList(7);
    private static List rightBracket_List = new ArrayList(7);
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();

    public void onShow() throws Exception {
        super.onShow();
        RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
    }

    public void onLoad() throws Exception {
        this.initTable();
        this.initVerifyConditionTable();
        this.initSelfListener();
        super.onLoad();
        this.initButtonAndMenu();
    }

    private void initSelfListener() {
        final KDTableMoveAction triCdrowMoveAction = new KDTableMoveAction(this.kdtTriggerConditionEtries);
        this.kbtnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCdrowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.kbtnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCdrowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.kbtnMoveBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCdrowMoveAction.moveSelectedRowToHead();
            }
        });
        this.kbtnMoveEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                triCdrowMoveAction.moveSelectedRowToTail();
            }
        });
        final KDTableMoveAction tempRowMoveAction = new KDTableMoveAction(this.kdtTemplateEtries);
        this.btnMoveTplUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tempRowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMoveTplDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tempRowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMoveTplBegin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tempRowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMoveTplEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tempRowMoveAction.moveSelectedRowToTail();
            }
        });
        this.btnAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SceneEditUI.this.tblCheckConditionEntries.addRow();
            }
        });
        this.btnDelRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)SceneEditUI.this.tblCheckConditionEntries);
                int rowIndex = 0;
                for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
                    rowIndex = selectRowIndexes[i];
                    SceneEditUI.this.tblCheckConditionEntries.removeRow(rowIndex);
                }
            }
        });
        final KDTableMoveAction tblCheckRowMoveAction = new KDTableMoveAction(this.tblCheckConditionEntries);
        this.btnMovUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tblCheckRowMoveAction.moveSelectedRowToPreRow();
            }
        });
        this.btnMovDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tblCheckRowMoveAction.moveSelectedRowToNextRow();
            }
        });
        this.btnMovTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tblCheckRowMoveAction.moveSelectedRowToHead();
            }
        });
        this.btnMovBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tblCheckRowMoveAction.moveSelectedRowToTail();
            }
        });
    }

    private void initTable() {
        this.kdtTemplateEtries.checkParsed(false);
        this.kdtTemplateEtries.getStyleAttributes().setLocked(true);
        this.kdtTriggerConditionEtries.checkParsed(false);
        KDComboBox leftBracketCom = new KDComboBox();
        leftBracketCom.addItems(leftBracket_List.toArray());
        this.kdtTriggerConditionEtries.getColumn(TRICD_LEFTBRACKET).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)leftBracketCom));
        KDBizPromptBox TriCdF7 = new KDBizPromptBox();
        TriCdF7.setQueryInfo(TriggerConditionQuery);
        TriCdF7.setEditFormat("$number$");
        TriCdF7.setDisplayFormat("$number$");
        TriCdF7.setEditable(true);
        TriCdF7.setCommitFormat("$number$");
        TriCdF7.addCommonF7KDTableListener(new CommonF7KDTableListener(){

            public void onTableStructureCreated(KDTable table) {
                Object[] listenerArray = table.getListenerList().getListenerList();
                for (int i = 0; i < listenerArray.length; ++i) {
                    Object obj = listenerArray[i];
                    if (!(obj instanceof KDTDataFillListener)) continue;
                    table.removeKDTDataFillListener((KDTDataFillListener)obj);
                    break;
                }
            }
        });
        this.kdtTriggerConditionEtries.getColumn(TRICD_TRIGGERCONDITION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)TriCdF7));
        KDComboBox rightBracketCom = new KDComboBox();
        rightBracketCom.addItems(rightBracket_List.toArray());
        this.kdtTriggerConditionEtries.getColumn(TRICD_RIGHTBRACKET).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)rightBracketCom));
        KDComboBox logicFlagCom = new KDComboBox();
        logicFlagCom.addItem((Object)"");
        logicFlagCom.addItems(LogicFlagEnum.getEnumList().toArray());
        this.kdtTriggerConditionEtries.getColumn(TRICD_LOGICFLAG).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)logicFlagCom));
    }

    private void initVerifyConditionTable() throws Exception {
        this.tblCheckConditionEntries.checkParsed(false);
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setEditable(true);
        bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter(bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)bizBoxItem);
        this.tblCheckConditionEntries.getColumn(VERIFY_RPTITEM).setEditor((ICellEditor)itemEditor);
        this.tblCheckConditionEntries.getColumn(VERIFY_RPTITEMNAME).getStyleAttributes().setLocked(true);
        KDComboBox cmbDataElement = new KDComboBox();
        CslClientHelper.initDataElementCombox((KDComboBox)cmbDataElement, (boolean)false, (boolean)false, (boolean)false);
        this.tblCheckConditionEntries.getColumn(VERIFY_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        KDComboBox cmbOperateSymbol = new KDComboBox();
        cmbOperateSymbol.addItems(OperateSymbolEnum.getEnumList().toArray());
        this.tblCheckConditionEntries.getColumn(VERIFY_OPERATESYMBOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbOperateSymbol));
        KDPromptBox prmtBoxD = new KDPromptBox();
        prmtBoxD.setSelector((KDPromptSelector)new FormulaSelector((CoreUIObject)this, 0));
        prmtBoxD.setEditable(true);
        prmtBoxD.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox source = (KDPromptBox)e.getSource();
                Object value = source.getValue();
                if (value == null) {
                    SceneEditUI.this.putClientProperty("clientProperty_formula_credit", null);
                }
            }
        });
        KDTDefaultCellEditor formulaEditorD = new KDTDefaultCellEditor((IKDEditor)prmtBoxD);
        this.tblCheckConditionEntries.getColumn(VERIFY_AMOUNT).setEditor((ICellEditor)formulaEditorD);
        KDBizMultiLangBox multiLangBox = new KDBizMultiLangBox();
        multiLangBox.setMaxLength(500);
        KDTDefaultCellEditor mEditor = new KDTDefaultCellEditor((JComboBox)multiLangBox);
        this.tblCheckConditionEntries.getColumn(VERIFY_TIPS).setEditor((ICellEditor)mEditor);
        this.tblCheckConditionEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent evt) {
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    SceneEditUI.this.tableValueChanged(e);
                }
                catch (EASBizException e1) {
                    logger.error((Object)"tableValueChanged_EASBizException", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"tableValueChanged_BOSException", (Throwable)e1);
                }
            }
        });
        this.tblCheckConditionEntries.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                SceneEditUI.this.fillFormula(e);
            }
        });
    }

    private void fillFormula(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        if (rowIndex > this.tblCheckConditionEntries.getRowCount() || rowIndex < 0) {
            return;
        }
        if (e.getColumnIndex() == this.tblCheckConditionEntries.getColumnIndex(VERIFY_AMOUNT)) {
            this.setCellFormulaProperty(this.tblCheckConditionEntries.getRow(rowIndex));
        }
    }

    private void tableValueChanged(KDTEditEvent e) throws BOSException, EASBizException {
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = kdtEntry.getRow(selectRow);
        if (e.getColIndex() == this.tblCheckConditionEntries.getColumnIndex(VERIFY_RPTITEM)) {
            if (e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
                RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
                row.getCell(VERIFY_RPTITEMNAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            } else if (e.getValue() == null) {
                row.getCell(VERIFY_RPTITEMNAME).setValue(null);
            }
        } else if (e.getColIndex() == this.tblCheckConditionEntries.getColumnIndex(VERIFY_AMOUNT)) {
            this.setCellFormulaProperty(row);
        }
    }

    private void setCellFormulaProperty(IRow row) {
        Object formulaObj = row.getCell(VERIFY_AMOUNT).getValue();
        if (formulaObj != null && formulaObj.toString().trim().length() > 0) {
            this.putClientProperty("clientProperty_formula_credit", formulaObj.toString());
        } else {
            this.putClientProperty("clientProperty_formula_credit", null);
        }
    }

    private void initButtonAndMenu() throws EASBizException, BOSException {
        this.actionCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.menuView.setVisible(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.menuBiz.setVisible(false);
        } else if ("VIEW".equals(this.getOprtState()) || "EDIT".equals(this.getOprtState())) {
            SceneInfo sceneInfo = SceneFactory.getRemoteInstance().getSceneInfo("select isFreezed,trackRecordCreator where id='" + this.editData.getId().toString() + "'");
            CompanyOrgUnitInfo trackRecordCreator = sceneInfo.getTrackRecordCreator();
            boolean istrackRecordCreator = trackRecordCreator.getId().toString().equals(this.company.getId().toString());
            boolean isFreeze = sceneInfo.isIsFreezed();
            if (isFreeze) {
                this.actionCancelCancel.setVisible(istrackRecordCreator);
                this.actionCancelCancel.setEnabled(istrackRecordCreator);
                this.actionCancel.setVisible(istrackRecordCreator);
                if (istrackRecordCreator) {
                    // empty if block
                }
                this.actionCancel.setEnabled(false);
                if ("EDIT".equals(this.getOprtState())) {
                    this.actionEdit.setEnabled(false);
                } else {
                    this.actionEdit.setEnabled(istrackRecordCreator);
                }
            } else {
                this.actionCancel.setVisible(istrackRecordCreator);
                this.actionCancel.setEnabled(istrackRecordCreator);
                this.actionCancelCancel.setVisible(istrackRecordCreator);
                if (istrackRecordCreator) {
                    // empty if block
                }
                this.actionCancelCancel.setEnabled(false);
                if (istrackRecordCreator) {
                    // empty if block
                }
                this.actionEdit.setEnabled(false);
            }
            this.menuBiz.setVisible(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTable();
        this.loadVerifyRelationEntries();
    }

    private void loadTable() {
        this.kdtTriggerConditionEtries.removeRows();
        this.kdtTemplateEtries.removeRows();
        this.tblCheckConditionEntries.removeRows();
        if ("ADDNEW".equals(this.getOprtState())) {
            for (int i = 0; i < 6; ++i) {
                this.tableTriggerConditionAddRow();
            }
            this.storeFields();
        } else {
            TemplateEntryCollection templateEtries;
            IRow row;
            TriggerConditionEntryCollection triggerConditionEtries = this.editData.getTriggerConditionEtries();
            if (!triggerConditionEtries.isEmpty()) {
                triggerConditionEtries.sort("seq");
                int triCdSize = triggerConditionEtries.size();
                for (int i = 0; i < triCdSize; ++i) {
                    TriggerConditionEntryInfo triCdInfo = triggerConditionEtries.get(i);
                    triCdInfo.remove("id");
                    row = this.kdtTriggerConditionEtries.addRow();
                    row.getCell(TRICD_LEFTBRACKET).setValue((Object)triCdInfo.getLeftBracket());
                    row.getCell(TRICD_TRIGGERCONDITION).setValue((Object)triCdInfo.getTriggerCondition());
                    row.getCell(TRICD_RIGHTBRACKET).setValue((Object)triCdInfo.getRightBracket());
                    row.getCell(TRICD_LOGICFLAG).setValue((Object)triCdInfo.getLogicFlag());
                }
            }
            if (!(templateEtries = this.editData.getTemplateEtries()).isEmpty()) {
                templateEtries.sort("seq");
                int tempSize = templateEtries.size();
                for (int i = 0; i < tempSize; ++i) {
                    TemplateEntryInfo tempEntryInfo = templateEtries.get(i);
                    tempEntryInfo.remove("id");
                    InvestTempletInfo template = tempEntryInfo.getTemplate();
                    row = this.kdtTemplateEtries.addRow();
                    row.getCell(TMP_NUMBER).setValue((Object)template.getNumber());
                    row.getCell(TMP_NUMBER).setUserObject((Object)template);
                    row.getCell(TMP_NAME).setValue((Object)template.getName());
                    row.getCell(TMP_INVESTNEWTYPE).setValue((Object)template.getInvestNewType());
                }
            }
        }
    }

    private void loadVerifyRelationEntries() {
        this.tblCheckConditionEntries.removeRows();
        VerifyRelationCollection verifyRelations = this.editData.getVerifyRelation();
        if (!verifyRelations.isEmpty()) {
            verifyRelations.sort("seq");
            Iterator it = verifyRelations.iterator();
            IRow row = null;
            while (it.hasNext()) {
                VerifyRelationInfo verifyRelationInfo = (VerifyRelationInfo)it.next();
                verifyRelationInfo.remove("id");
                row = this.tblCheckConditionEntries.addRow();
                row.getCell(VERIFY_RPTITEM).setValue((Object)verifyRelationInfo.getRptItem());
                row.getCell(VERIFY_RPTITEMNAME).setValue((Object)verifyRelationInfo.getRptItem().getName());
                row.getCell(VERIFY_DATAELEMENT).setValue((Object)verifyRelationInfo.getDataElement());
                row.getCell(VERIFY_OPERATESYMBOL).setValue((Object)verifyRelationInfo.getOperateSymbol());
                row.getCell(VERIFY_AMOUNT).setValue((Object)verifyRelationInfo.getAmount());
                row.getCell(VERIFY_TIPS).setValue((Object)verifyRelationInfo.getVerifyTips());
            }
        }
    }

    @Override
    public void storeFields() {
        IRow row;
        super.storeFields();
        this.editData.setSyncOldValue(true);
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        this.editData.setTrackRecordCreator(companyOrgUnitInfo);
        TriggerConditionEntryCollection triggerConditionEtries = this.editData.getTriggerConditionEtries();
        triggerConditionEtries.clear();
        int triCdRowCount = this.kdtTriggerConditionEtries.getRowCount();
        int seqIndex = 0;
        for (int i = 0; i < triCdRowCount; ++i) {
            row = this.kdtTriggerConditionEtries.getRow(i);
            String leftBracket = (String)row.getCell(TRICD_LEFTBRACKET).getValue();
            TriggerConditionInfo triConditionInfo = (TriggerConditionInfo)row.getCell(TRICD_TRIGGERCONDITION).getValue();
            String rightBracket = (String)row.getCell(TRICD_RIGHTBRACKET).getValue();
            Object logicValue = row.getCell(TRICD_LOGICFLAG).getValue();
            if (StringUtils.isEmpty((String)leftBracket) && StringUtils.isEmpty((String)rightBracket) && triConditionInfo == null && ("".equals(logicValue) || logicValue == null)) continue;
            TriggerConditionEntryInfo tConditionEntryInfo = new TriggerConditionEntryInfo();
            tConditionEntryInfo.setSeq(++seqIndex);
            tConditionEntryInfo.setLeftBracket(leftBracket);
            tConditionEntryInfo.setTriggerCondition(triConditionInfo);
            tConditionEntryInfo.setRightBracket(rightBracket);
            tConditionEntryInfo.setLogicFlag("".equals(logicValue) ? null : (LogicFlagEnum)((Object)logicValue));
            tConditionEntryInfo.setScene(this.editData);
            triggerConditionEtries.add(tConditionEntryInfo);
        }
        TemplateEntryCollection templateEtries = this.editData.getTemplateEtries();
        templateEtries.clear();
        int tempRowCount = this.kdtTemplateEtries.getRowCount();
        for (int i = 0; i < tempRowCount; ++i) {
            row = this.kdtTemplateEtries.getRow(i);
            TemplateEntryInfo templateEntryInfo = new TemplateEntryInfo();
            templateEntryInfo.setSeq(i + 1);
            templateEntryInfo.setTemplate((InvestTempletInfo)row.getCell(TMP_NUMBER).getUserObject());
            templateEntryInfo.setScene(this.editData);
            templateEtries.add(templateEntryInfo);
        }
        this.storeVerifyConditions();
        this.editData.setSyncOldValue(false);
    }

    private void storeVerifyConditions() {
        int rowCount = this.tblCheckConditionEntries.getRowCount();
        Object rptItem = null;
        Object dataElement = null;
        Object operateSymbol = null;
        Object amount = null;
        Object verifyTips = null;
        VerifyRelationInfo verifyRelationInfo = null;
        VerifyRelationCollection verifyRelationCollection = this.editData.getVerifyRelation();
        verifyRelationCollection.clear();
        int size = rowCount;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblCheckConditionEntries.getRow(i);
            rptItem = row.getCell(VERIFY_RPTITEM).getValue();
            dataElement = row.getCell(VERIFY_DATAELEMENT).getValue();
            operateSymbol = row.getCell(VERIFY_OPERATESYMBOL).getValue();
            amount = row.getCell(VERIFY_AMOUNT).getValue();
            verifyTips = row.getCell(VERIFY_TIPS).getValue();
            verifyRelationInfo = new VerifyRelationInfo();
            verifyRelationInfo.setRptItem((RPTItemInfo)rptItem);
            verifyRelationInfo.setDataElement((DataElementInfo)dataElement);
            verifyRelationInfo.setOperateSymbol((OperateSymbolEnum)operateSymbol);
            verifyRelationInfo.setAmount(String.valueOf(amount));
            verifyRelationInfo.setSeq(i + 1);
            verifyRelationInfo.setScene(this.editData);
            verifyRelationInfo.setVerifyTips(String.valueOf(verifyTips));
            verifyRelationCollection.add(verifyRelationInfo);
        }
    }

    @Override
    protected void btnAddTpl_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddTpl_actionPerformed(e);
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"template", (Object)this.getTempNumberStr());
        uiContext.put((Object)"openTempUI", (Object)SceneEditUI.class.getName());
        TemplateSelectF7Dialog templateSelectF7Dialog = new TemplateSelectF7Dialog((IUIObject)this);
        templateSelectF7Dialog.setUiContext(uiContext);
        templateSelectF7Dialog.show();
        if (!templateSelectF7Dialog.isCanceled()) {
            this.kdtTemplateEtries.removeRows();
            Object data = templateSelectF7Dialog.getData();
            if ("removeAll".equals(data)) {
                return;
            }
            LinkedList tplList = (LinkedList)data;
            for (InvestTempletInfo investTempletInfo : tplList) {
                IRow addRow = this.kdtTemplateEtries.addRow();
                addRow.getCell(TMP_NUMBER).setValue((Object)investTempletInfo.getNumber());
                addRow.getCell(TMP_NUMBER).setUserObject((Object)investTempletInfo);
                addRow.getCell(TMP_NAME).setValue((Object)investTempletInfo.getName());
                addRow.getCell(TMP_INVESTNEWTYPE).setValue((Object)investTempletInfo.getInvestNewType());
            }
        }
    }

    @Override
    protected void btnDelTpl_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelTpl_actionPerformed(e);
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kdtTemplateEtries);
        int rowIndex = 0;
        for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
            rowIndex = selectRowIndexes[i];
            this.kdtTemplateEtries.removeRow(rowIndex);
        }
    }

    private String getTempNumberStr() {
        int rowCount = this.kdtTemplateEtries.getRowCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            String tempNumber = (String)this.kdtTemplateEtries.getRow(i).getCell(TMP_NUMBER).getValue();
            if (!StringUtils.isEmpty((String)tempNumber)) {
                sb.append(tempNumber);
            }
            if (i == rowCount - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setFreezeButtonStatus();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        SceneFactory.getRemoteInstance().freeze(ids, true);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(true);
        if ("EDIT".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else if ("VIEW".equals(this.getOprtState())) {
            this.actionEdit.setEnabled(true);
            this.actionSubmit.setEnabled(false);
        }
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANCEL_SUCCESS"));
        this.showMessage();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        SceneFactory.getRemoteInstance().freeze(ids, false);
        this.setOprtState("VIEW");
        this.actionCancel.setEnabled(true);
        this.actionCancelCancel.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionSubmit.setEnabled(false);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_ENABLE_SUCCESS"));
        this.showMessage();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setFreezeButtonStatus();
    }

    private void setFreezeButtonStatus() throws EASBizException, BOSException {
        if (this.editData.getId() != null) {
            SceneInfo sceneInfo = SceneFactory.getRemoteInstance().getSceneInfo("select isFreezed where id='" + this.editData.getId().toString() + "'");
            if (sceneInfo.isIsFreezed()) {
                this.actionCancelCancel.setVisible(true);
                this.actionCancelCancel.setEnabled(true);
                this.actionCancel.setVisible(true);
                this.actionCancel.setEnabled(false);
            } else {
                this.actionCancel.setVisible(true);
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setVisible(true);
                this.actionCancelCancel.setEnabled(false);
            }
        }
    }

    @Override
    protected void kbtnAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnAddNew_actionPerformed(e);
        this.tableTriggerConditionAddRow();
    }

    @Override
    protected void kbtnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.kbtnDelete_actionPerformed(e);
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.kdtTriggerConditionEtries);
        int rowIndex = 0;
        for (int i = selectRowIndexes.length - 1; i >= 0; --i) {
            rowIndex = selectRowIndexes[i];
            this.kdtTriggerConditionEtries.removeRow(rowIndex);
        }
    }

    private void tableTriggerConditionAddRow() {
        IRow addRow = this.kdtTriggerConditionEtries.addRow();
        addRow.getCell(TRICD_LOGICFLAG).setValue((Object)"");
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        TemplateEntryCollection templateEtries;
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"5_SceneEditUI"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"13_SceneEditUI"));
            SysUtil.abort();
        }
        if ((templateEtries = this.editData.getTemplateEtries()).isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"6_SceneEditUI"));
            SysUtil.abort();
        }
        this.verifTriggerCondition();
        this.verifyTableData();
    }

    private void verifTriggerCondition() {
        int rowCount = this.kdtTriggerConditionEtries.getRowCount();
        IRow row = null;
        StringBuilder sbBracket = new StringBuilder();
        boolean isLastLineLogicNull = false;
        int index = -1;
        int logicNullIndex = -1;
        int maxRowIndex = -1;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtTriggerConditionEtries.getRow(i);
            TriggerConditionInfo triggerConditionInfo = (TriggerConditionInfo)row.getCell(TRICD_TRIGGERCONDITION).getValue();
            String leftBracket = (String)row.getCell(TRICD_LEFTBRACKET).getValue();
            String rightBracket = (String)row.getCell(TRICD_RIGHTBRACKET).getValue();
            Object logicValue = row.getCell(TRICD_LOGICFLAG).getValue();
            if (StringUtils.isEmpty((String)leftBracket) && StringUtils.isEmpty((String)rightBracket) && triggerConditionInfo == null && ("".equals(logicValue) || logicValue == null)) continue;
            if (triggerConditionInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"8_SceneEditUI"));
                SysUtil.abort();
            }
            if (logicValue != null && !"".equals(logicValue)) {
                isLastLineLogicNull = true;
                index = row.getRowIndex();
            } else {
                isLastLineLogicNull = false;
                if (logicNullIndex == -1) {
                    logicNullIndex = i;
                }
            }
            if (!StringUtils.isEmpty((String)leftBracket)) {
                sbBracket.append(leftBracket);
            }
            if (!StringUtils.isEmpty((String)rightBracket)) {
                sbBracket.append(rightBracket);
            }
            maxRowIndex = i;
        }
        if (maxRowIndex == -1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"61_triggerConditionNull"));
            SysUtil.abort();
        }
        if (isLastLineLogicNull) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"71_lastTriggerLogicMustNull"));
            if (index != -1) {
                this.kdtTriggerConditionEtries.getRow(index).getCell(TRICD_LOGICFLAG).setValue(null);
            }
            SysUtil.abort();
        }
        if (logicNullIndex < maxRowIndex) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"102_logicNotNull"));
            SysUtil.abort();
        }
        String strBracket = sbBracket.toString();
        while (strBracket.contains("()")) {
            strBracket = strBracket.replaceAll("\\(\\)", "");
        }
        if (!StringUtils.isEmpty((String)strBracket)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"9_SceneEditUI"));
            SysUtil.abort();
        }
    }

    private void verifyTableData() {
        Object rptItem = null;
        Object dataElement = null;
        Object operateSymbol = null;
        Object amount = null;
        Object verifyTips = null;
        int rowCount = this.tblCheckConditionEntries.getRowCount();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        int size = rowCount;
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblCheckConditionEntries.getRow(i);
            rptItem = row.getCell(VERIFY_RPTITEM).getValue();
            dataElement = row.getCell(VERIFY_DATAELEMENT).getValue();
            operateSymbol = row.getCell(VERIFY_OPERATESYMBOL).getValue();
            amount = row.getCell(VERIFY_AMOUNT).getValue();
            verifyTips = row.getCell(VERIFY_TIPS).getValue();
            if (rptItem == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"31_ChooseRptItem", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (dataElement == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"32_chooseDataElement", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (operateSymbol == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"33_ChooseOperateSymbol", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (amount == null || StringUtils.isEmpty((String)((String)amount))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"34_inputAmount", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            if (verifyTips == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"35_inputVerifyTips", (Object[])new Object[]{i + 1}));
                SysUtil.abort();
            }
            RPTItemInfo rptItemInfo = (RPTItemInfo)rptItem;
            String rptId = rptItemInfo.getId().toString();
            String rptNumber = rptItemInfo.getNumber();
            DataElementInfo dataElementInfo = (DataElementInfo)dataElement;
            String dataElementId = dataElementInfo.getId().toString();
            String dataElementNumber = dataElementInfo.getNumber();
            String key = rptId + dataElementId;
            if (map.containsKey(key)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"41_repeat", (Object[])new Object[]{rptNumber, dataElementNumber}));
                SysUtil.abort();
                continue;
            }
            map.put(key, Boolean.TRUE);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("triggerConditionEtries.*"));
        sic.add(new SelectorItemInfo("triggerConditionEtries.triggerCondition.id"));
        sic.add(new SelectorItemInfo("triggerConditionEtries.triggerCondition.number"));
        sic.add(new SelectorItemInfo("triggerConditionEtries.triggerCondition.name"));
        sic.add(new SelectorItemInfo("templateEtries.*"));
        sic.add(new SelectorItemInfo("templateEtries.template.id"));
        sic.add(new SelectorItemInfo("templateEtries.template.name"));
        sic.add(new SelectorItemInfo("templateEtries.template.number"));
        sic.add(new SelectorItemInfo("templateEtries.template.investNewType"));
        sic.add(new SelectorItemInfo("displayTemplateType.id"));
        sic.add(new SelectorItemInfo("verifyRelation.*"));
        sic.add(new SelectorItemInfo("verifyRelation.rptItem.id"));
        sic.add(new SelectorItemInfo("verifyRelation.rptItem.number"));
        sic.add(new SelectorItemInfo("verifyRelation.rptItem.name"));
        sic.add(new SelectorItemInfo("verifyRelation.dataElement.id"));
        sic.add(new SelectorItemInfo("verifyRelation.dataElement.number"));
        sic.add(new SelectorItemInfo("verifyRelation.dataElement.name"));
        return sic;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return super.getValue(pk);
    }

    protected IObjectValue createNewData() {
        SceneInfo sceneInfo = new SceneInfo();
        TemplateTypeInfo type = new TemplateTypeInfo();
        String idString = (String)this.getUIContext().get("displayTypeId");
        if (idString != null) {
            BOSUuid id = BOSUuid.read((String)idString);
            type.setId(id);
            sceneInfo.setDisplayTemplateType(type);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.NO_Root_Selected"));
            SysUtil.abort();
        }
        return sceneInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SceneFactory.getRemoteInstance();
    }

    public boolean destroyWindow() {
        boolean b;
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof ListUI && !(owner instanceof TreeListUI)) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        }
        if (!(b = super.destroyWindow())) {
            RptUtilForClient.setWindowIsNotResizable((IUIWindow)this.getUIWindow());
        }
        return b;
    }

    static {
        leftBracket_List.add("");
        leftBracket_List.add("(");
        leftBracket_List.add("((");
        leftBracket_List.add("(((");
        leftBracket_List.add("((((");
        leftBracket_List.add("(((((");
        leftBracket_List.add("((((((");
        rightBracket_List.add("");
        rightBracket_List.add(")");
        rightBracket_List.add("))");
        rightBracket_List.add(")))");
        rightBracket_List.add("))))");
        rightBracket_List.add(")))))");
        rightBracket_List.add("))))))");
    }
}

