/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.weaverpt.client.assist.KDTableUtilForRpt;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneRecordInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractSceneListUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneEditUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneFilterUI;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.client.GroupTreecomponent;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class SceneListUI
extends AbstractSceneListUI {
    private static final Logger logger = CoreUIObject.getLogger(SceneListUI.class);
    protected GroupTreecomponent treeComponent;
    public CommonQueryDialog conditionDialog = null;
    public CustomerQueryPanel conditionPanel = null;
    private OrgUnitInfo company = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean selfGradeOnly = false;

    public SceneListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                SceneListUI.this.fillTable(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButtonAndMenu();
        this.init();
        CslGradeManageUtil.showBtnByCurrentOrg(this.btnUpdateMaintainOrg);
    }

    private void initButtonAndMenu() {
        this.menuItemLocate.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setVisible(true);
    }

    private void init() throws Exception {
        this.mainQuery.setIngorePreOrders(true);
        this.treeComponent = new GroupTreecomponent((ListUI)this, this.treeView, DisplayTemplateTypeEnum.SCENE);
        this.treeComponent.initialize();
        if (this.treeComponent.getActionBatchMove() != null) {
            this.menuItemBatchMove.setCustomAction((Action)this.treeComponent.getActionBatchMove());
        }
        this.tblMain.setColumnMoveable(true);
        this.initSelfListener();
    }

    protected void initSelfListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                SceneListUI.this.changeBtnState();
            }
        });
    }

    private void fillTable(KDTDataRequestEvent e) {
        int begin = e.getFirstRow();
        int end = e.getLastRow();
        int n = end;
        for (int i = begin; i <= n; ++i) {
            Object recordCreatorid;
            if (this.tblMain.getRow(i) == null || (recordCreatorid = this.tblMain.getRow(i).getCell("trackRecordCreator.id").getValue()) == null || recordCreatorid.equals(this.company.getId().toString())) continue;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(Color.pink);
        }
    }

    private void changeBtnState() {
        int selectRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        Boolean isFreezed = (Boolean)this.tblMain.getRow(selectRow).getCell("isFreezed").getValue();
        Boolean istrackRecordCreator = this.tblMain.getRow(selectRow).getCell("trackRecordCreator.id").getValue().toString().equals(this.company.getId().toString());
        this.actionCancelCancel.setEnabled(istrackRecordCreator != false && isFreezed != false);
        this.actionCancel.setEnabled(istrackRecordCreator != false && isFreezed == false);
        this.actionEdit.setEnabled(isFreezed != false && istrackRecordCreator != false);
        this.actionRemove.setEnabled(isFreezed != false && istrackRecordCreator != false);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"displayTypeId", (Object)this.treeComponent.getRealSelectedNodeKeyValue());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String isFreezed = KDTableUtilForRpt.getSelectedFieldValueBy((KDTable)this.tblMain, (String)"isFreezed");
        if (Boolean.TRUE.toString().equals(isFreezed)) {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pk;
        this.checkSelected();
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        List[] rows = KDTableUtilForRpt.getSelectedFieldsValueBy((KDTable)this.tblMain, (String[])new String[]{"id", "name", "isFreezed", "trackRecordCreator.id"});
        ArrayList<IObjectPK> ids = new ArrayList<IObjectPK>();
        StringBuffer msg = new StringBuffer();
        int length = rows.length;
        for (int i = 0; i < length; ++i) {
            if (!this.company.getId().toString().equals(rows[i].get(3)) || !Boolean.TRUE.toString().equals(rows[i].get(2))) continue;
            String id = String.valueOf(rows[i].get(0));
            String name = String.valueOf(rows[i].get(1));
            pk = new ObjectUuidPK(id);
            ids.add(pk);
            msg.append(name).append("\n");
        }
        if (ids.size() > 0 && this.confirmRemove()) {
            String[] msgs = this.checkSceneRelated(ids);
            if (ids.size() > 0) {
                IObjectPK[] pks = new IObjectPK[ids.size()];
                int size = ids.size();
                for (int i = 0; i < size; ++i) {
                    pks[i] = pk = (IObjectPK)ids.get(i);
                }
                SceneFactory.getRemoteInstance().deleteBatchData(pks);
            }
            if (msgs != null) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msgs[0], (String)msgs[1], (int)8188);
            }
            this.refreshList();
        }
    }

    private String[] checkSceneRelated(List<IObjectPK> ids) throws BOSException {
        String[] msgs = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        for (IObjectPK pk : ids) {
            set.add(pk.toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("scene", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("template.number"));
        selector.add(new SelectorItemInfo("template.name"));
        selector.add(new SelectorItemInfo("template.versionStatus"));
        selector.add(new SelectorItemInfo("scene.number"));
        selector.add(new SelectorItemInfo("scene.name"));
        selector.add(new SelectorItemInfo("scene.id"));
        viewInfo.setSelector(selector);
        SceneRecordCollection sceneRecords = SceneRecordFactory.getRemoteInstance().getSceneRecordCollection(viewInfo);
        if (sceneRecords != null && sceneRecords.size() > 0) {
            Iterator it = sceneRecords.iterator();
            ArrayList tmplTitles = new ArrayList();
            StringBuffer msgBuF = new StringBuffer();
            ArrayList<ObjectUuidPK> canNotRemoves = new ArrayList<ObjectUuidPK>();
            while (it.hasNext()) {
                SceneRecordInfo info = (SceneRecordInfo)it.next();
                VersionStatusEnum tmplVersionStatus = info.getTemplate().getVersionStatus();
                if (!tmplVersionStatus.equals((Object)VersionStatusEnum.UNVERSION)) continue;
                canNotRemoves.add(new ObjectUuidPK(info.getScene().getId().toString()));
                String tmplMsg = info.getTemplate().getNumber() + "-" + info.getTemplate().getName();
                String sceneMsg = info.getScene().getNumber() + "-" + info.getScene().getName();
                String detail = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"86_SceneRecordTips", (Object[])new Object[]{sceneMsg, tmplMsg});
                if (tmplTitles.contains(detail)) continue;
                msgBuF.append(detail).append("\n");
            }
            int size = canNotRemoves.size();
            if (size > 0) {
                ids.removeAll(canNotRemoves);
                String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
                msgs = new String[]{deleteError, msgBuF.toString()};
                return msgs;
            }
        }
        return msgs;
    }

    protected boolean confirmRemove(String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"7_SceneEditUI"), (String)msg));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet ids = new HashSet(idList);
        SceneFactory.getRemoteInstance().freeze(ids, true);
        this.refreshList();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_CANCEL_SUCCESS"));
        this.showMessage();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet ids = new HashSet(idList);
        SceneFactory.getRemoteInstance().freeze(ids, false);
        this.refreshList();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"WARN_ENABLE_SUCCESS"));
        this.showMessage();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = SceneListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName())) {
            this.setDialogMainQueryCondition();
            if (this.treeComponent != null) {
                this.treeComponent.refreshTree();
            }
        }
    }

    protected void setDialogMainQueryCondition() throws Exception {
        if (this.getConditionDialog().show()) {
            this.doQuery(this.getConditionDialog());
            this.mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            this.setFilterCondition();
            this.tblMain.removeRows();
            this.refreshList();
        } else {
            SysUtil.abort();
        }
    }

    private void setFilterCondition() {
        FilterInfo filter = this.mainQuery.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
        }
        this.mainQuery.setFilter(filter);
    }

    private CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = MetaDataPK.create((String)"com.kingdee.eas.fi.newrpt.investworkpaper", (String)"SceneQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(220);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"81_sceneFilterTitle"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.newrpt.investworkpaper.client.SceneListUI");
        }
        return this.conditionDialog;
    }

    private CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new SceneFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog conditionDialog1 = null;
        try {
            conditionDialog1 = this.getConditionDialog();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"No_FilterUI"));
        }
        return conditionDialog1;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        EntityViewInfo evi = new EntityViewInfo();
        return evi;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    public void refreshList() throws Exception {
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        super.refreshList();
        this.tblMain.getSelectManager().select(0, 0);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionSelfAndAllSwitch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selfGradeOnly) {
            this.selfGradeOnly = false;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        } else {
            this.selfGradeOnly = true;
            this.btnSelfAndAllSwitch.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll"));
        }
        this.changeFilterByFlag();
        this.refreshList();
    }

    public void changeFilterByFlag() throws BOSException {
        FilterInfo gradeInfo = new FilterInfo();
        if (this.selfGradeOnly) {
            gradeInfo = this.getSelfGradeFilter();
        } else {
            gradeInfo = this.getGradeSettingFilter();
            if (gradeInfo.getFilterItems().size() == 0) {
                gradeInfo.getFilterItems().add(new FilterItemInfo("trackRecordCreator.id", (Object)"0", CompareType.NOTEQUALS));
            }
        }
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null) {
            this.getMainQuery().setFilter(gradeInfo);
            return;
        }
        boolean find = false;
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"trackRecordCreator.id".equalsIgnoreCase(item.getPropertyName())) continue;
            item.setCompareValue(gradeInfo.getFilterItems().get(0).getCompareValue());
            item.setCompareType(gradeInfo.getFilterItems().get(0).getCompareType());
            find = true;
            break;
        }
        if (!find) {
            this.getMainQuery().getFilter().mergeFilter(gradeInfo, "AND");
        }
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private FilterInfo getSelfGradeFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.getSelfDataPub(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    @Override
    public void actionUpdateMaintainOrg_actionPerformed(ActionEvent e) throws Exception {
        CslGradeManageUtil.updateMaintainOrg("T_CSL_Scene", "FTrackRecordCreatorID", this.getSelectedIdValues());
        this.actionRefresh_actionPerformed(e);
    }

    protected String getEditUIName() {
        return SceneEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SceneFactory.getRemoteInstance();
    }

    protected ArrayList getImportParam() {
        String solutionName = "eas.fi.gr.pp.ppScene";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"70_sceneImportTitle");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        String solutionName = "eas.fi.gr.ppScene";
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName;
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"70_sceneImportTitle");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        this.ExportData();
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.investworkpaper.SceneForExportQuery"));
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refreshList();
    }
}

