/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneTypeMappingNewInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.AbstractSceneTypeMappingUI;
import com.kingdee.eas.fi.newrpt.investworkpaper.client.TemplateTypeSelector;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeCollection;
import com.kingdee.eas.fi.rpt.TemplateTypeFactory;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SceneTypeMappingUI
extends AbstractSceneTypeMappingUI {
    private static final long serialVersionUID = -8176461120564194952L;
    private static final Logger logger = CoreUIObject.getLogger(SceneTypeMappingUI.class);
    private boolean isListenerTrigger = true;
    private boolean isCancel = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
        this.initTableListener();
        this.initTable();
    }

    private void initControl() {
        this.tblMain.checkParsed();
        Color curColor = new Color(0xF6F6BF);
        this.tblMain.getColumn("elimTypeNumber").getStyleAttributes().setBackground(curColor);
        this.tblMain.getColumn("sceneTypeNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("sceneTypeName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("elimTypeName").getStyleAttributes().setLocked(true);
        this.tblMain.repaint();
    }

    private void initTableListener() {
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                if (e.getRowIndex() < 0 || e.getColumnIndex() < 0) {
                    return;
                }
                if (SceneTypeMappingUI.this.tblMain.getColumn(e.getColumnIndex()).getKey().equals("elimTypeNumber") && SceneTypeMappingUI.this.tblMain.getCell(e.getRowIndex(), e.getColumnIndex()).getEditor() == null) {
                    KDBizPromptBox promptBox = new KDBizPromptBox();
                    promptBox.setSelector((KDPromptSelector)new TemplateTypeSelector());
                    final KDBizPromptBox finalPromptBox = promptBox;
                    promptBox.addSelectorListener(new SelectorListener(){

                        public void willShow(SelectorEvent e) {
                            ((TemplateTypeSelector)finalPromptBox.getSelector()).setTemplateType(DisplayTemplateTypeEnum.ELIMINATION);
                            ((TemplateTypeSelector)finalPromptBox.getSelector()).setOrgUnitSql(SceneTypeMappingUI.this.getOrgUnitSql());
                        }
                    });
                    promptBox.setEditable(false);
                    KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
                    SceneTypeMappingUI.this.tblMain.getCell(e.getRowIndex(), e.getColumnIndex()).setEditor((ICellEditor)cellEditor);
                }
            }
        });
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                ICell curCell;
                if (evt.getRowIndex() < 0 || evt.getColIndex() < 0) {
                    return;
                }
                if (SceneTypeMappingUI.this.tblMain.getColumn(evt.getColIndex()).getKey().equals("elimTypeNumber") && SceneTypeMappingUI.this.tblMain.getRowCount() > evt.getRowIndex() && (curCell = SceneTypeMappingUI.this.tblMain.getCell(evt.getRowIndex(), evt.getColIndex())) != null) {
                    Object cellObj = curCell.getValue();
                    if (cellObj != null && cellObj instanceof TemplateTypeInfo) {
                        TemplateTypeInfo elimTypeInfo = (TemplateTypeInfo)cellObj;
                        SceneTypeMappingUI.this.setCellValue(evt.getRowIndex(), elimTypeInfo);
                    } else {
                        SceneTypeMappingUI.this.setCellValue(evt.getRowIndex(), null);
                    }
                }
            }
        });
    }

    private void setCellValue(int rowIndex, TemplateTypeInfo elimTypeInfo) {
        if (this.isListenerTrigger) {
            try {
                this.isListenerTrigger = false;
                if (elimTypeInfo != null && !elimTypeInfo.isEmpty()) {
                    this.tblMain.getRow(rowIndex).getCell("elimTypeNumber").setValue((Object)elimTypeInfo.getNumber());
                    this.tblMain.getRow(rowIndex).getCell("elimTypeId").setValue((Object)elimTypeInfo.getId().toString());
                    this.tblMain.getRow(rowIndex).getCell("elimTypeName").setValue((Object)elimTypeInfo.getName());
                } else {
                    this.tblMain.getRow(rowIndex).getCell("elimTypeNumber").setValue(null);
                    this.tblMain.getRow(rowIndex).getCell("elimTypeId").setValue(null);
                    this.tblMain.getRow(rowIndex).getCell("elimTypeName").setValue(null);
                }
            }
            finally {
                this.isListenerTrigger = true;
            }
        }
    }

    private String getOrgUnitSql() {
        String orgTreeNumber = (String)this.getUIContext().get("orgTreeNumber");
        String orgUnitNumber = (String)this.getUIContext().get("orgUnitNumber");
        StringBuffer sql = new StringBuffer();
        if (!StringUtils.isEmpty((String)orgTreeNumber) && !StringUtils.isEmpty((String)orgUnitNumber)) {
            sql.append("select distinct structure.Funitid from T_ORG_structure structure ");
            sql.append(" inner join T_ORG_Tree tree on structure.FTreeId = tree.Fid ");
            sql.append(" inner join T_ORG_BaseUnit unit on unit.Fid = structure.FUnitid ");
            sql.append(" where tree.fnumber='").append(orgTreeNumber).append("' ");
            sql.append(" and unit.fnumber='").append(orgUnitNumber).append("' ");
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTable() throws EASBizException, BOSException {
        this.tblMain.removeRows(false);
        List<SceneTypeMappingNewInfo> mappingInfos = this.getSceneTypeMappingInfos();
        boolean isTag = this.isListenerTrigger;
        for (SceneTypeMappingNewInfo info : mappingInfos) {
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("sceneTypeId").setValue((Object)info.getSceneTypeId());
            row.getCell("sceneTypeNumber").setValue((Object)info.getSceneTypeNumber());
            row.getCell("sceneTypeName").setValue((Object)info.getSceneTypeName());
            if (info.getElimTypeNumber() == null) continue;
            try {
                if (this.isListenerTrigger) {
                    this.isListenerTrigger = false;
                }
                row.getCell("elimTypeNumber").setValue((Object)info.getElimTypeNumber());
            }
            finally {
                this.isListenerTrigger = isTag;
            }
            row.getCell("elimTypeId").setValue((Object)info.getElimTypeId());
            row.getCell("elimTypeName").setValue((Object)info.getElimTypeName());
        }
    }

    private List<SceneTypeMappingNewInfo> getSceneTypeMappingInfos() throws EASBizException, BOSException {
        Map params = this.getParams();
        List infos = SceneTypeMappingFactory.getRemoteInstance().getSceneTypeMappingNewInfos(params);
        Set<String> sceneTypeIds = this.getSceneTypes();
        List<SceneTypeMappingNewInfo> newInfos = this.getSceneTypeCollectionByIds(sceneTypeIds);
        if (infos != null && !infos.isEmpty()) {
            block0: for (SceneTypeMappingNewInfo newInfo : newInfos) {
                String sceneTypeId = newInfo.getSceneTypeId();
                int size = infos.size();
                for (int i = 0; i < size; ++i) {
                    SceneTypeMappingNewInfo info = (SceneTypeMappingNewInfo)infos.get(i);
                    String sceneTypeMappId = info.getSceneTypeId();
                    if (!sceneTypeId.equals(sceneTypeMappId)) continue;
                    String elimTypeId = info.getElimTypeId();
                    String elimTypeNumber = info.getElimTypeNumber();
                    String elimTypeName = info.getElimTypeName();
                    String id = info.getId();
                    newInfo.setElimTypeId(elimTypeId);
                    newInfo.setElimTypeNumber(elimTypeNumber);
                    newInfo.setElimTypeName(elimTypeName);
                    newInfo.setId(id);
                    continue block0;
                }
            }
        }
        return newInfos;
    }

    private Map getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgTreeNumber = (String)this.getUIContext().get("orgTreeNumber");
        params.put("orgTreeNumber", orgTreeNumber);
        String orgUnitNumber = (String)this.getUIContext().get("orgUnitNumber");
        params.put("orgUnitNumber", orgUnitNumber);
        return params;
    }

    private List<SceneTypeMappingNewInfo> getSceneTypeCollectionByIds(Set<String> sceneTypeIds) {
        ArrayList<SceneTypeMappingNewInfo> mappingInfos = new ArrayList<SceneTypeMappingNewInfo>();
        if (!sceneTypeIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", sceneTypeIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            view.setSelector(selector);
            SorterItemCollection sortor = new SorterItemCollection();
            sortor.add(new SorterItemInfo("number"));
            try {
                TemplateTypeCollection tmplTypecoll = TemplateTypeFactory.getRemoteInstance().getTemplateTypeCollection(view);
                if (tmplTypecoll != null && !tmplTypecoll.isEmpty()) {
                    for (TemplateTypeInfo info : tmplTypecoll) {
                        SceneTypeMappingNewInfo mappingInfo = new SceneTypeMappingNewInfo();
                        mappingInfo.setSceneTypeId(info.getId().toString());
                        mappingInfo.setSceneTypeNumber(info.getNumber());
                        mappingInfo.setSceneTypeName(info.getName());
                        mappingInfos.add(mappingInfo);
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"getTemplateTypeCollection: ", (Throwable)e);
            }
        }
        return mappingInfos;
    }

    private Set<String> getSceneTypes() {
        HashSet<String> sceneTypeIds = new HashSet<String>();
        String split = ",";
        String sceneIdsString = (String)this.getUIContext().get("sceneIds");
        String[] sceneIds = sceneIdsString.split(split);
        HashSet<String> scenes = new HashSet<String>();
        for (String sceneId : sceneIds) {
            scenes.add(sceneId);
        }
        if (!scenes.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", scenes, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isFreezed", (Object)new Integer(0)));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("displayTemplateType");
            view.setSelector(selector);
            try {
                SceneCollection coll = SceneFactory.getRemoteInstance().getSceneCollection(view);
                if (coll != null && !coll.isEmpty()) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        SceneInfo scene = coll.get(i);
                        String sceneTypeId = scene.getDisplayTemplateType().getId().toString();
                        sceneTypeIds.add(sceneTypeId);
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"getSceneTypes: ", (Throwable)e);
            }
        }
        return sceneTypeIds;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.verifyEntry();
        this.saveMappingData();
        this.destroyWindow();
        this.isCancel = false;
    }

    private void saveMappingData() throws EASBizException, BOSException {
        int count = this.tblMain.getRowCount();
        if (count > 0) {
            String orgTreeNumber = (String)this.getUIContext().get("orgTreeNumber");
            String orgUnitNumber = (String)this.getUIContext().get("orgUnitNumber");
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblMain.getRow(i);
                SceneTypeMappingInfo mappinginfo = new SceneTypeMappingInfo();
                mappinginfo.setOrgTreeNumber(orgTreeNumber);
                mappinginfo.setOrgUnitNumber(orgUnitNumber);
                TemplateTypeInfo typeInfo = new TemplateTypeInfo();
                String sceneTypeId = String.valueOf(row.getCell("sceneTypeId").getValue());
                typeInfo.setId(BOSUuid.read((String)sceneTypeId));
                mappinginfo.setSceneType(typeInfo);
                typeInfo = new TemplateTypeInfo();
                String elimTypeId = String.valueOf(row.getCell("elimTypeId").getValue());
                typeInfo.setId(BOSUuid.read((String)elimTypeId));
                mappinginfo.setElimType(typeInfo);
                if (row.getCell("id").getValue() != null) {
                    mappinginfo.setId(BOSUuid.read((String)String.valueOf(row.getCell("id").getValue())));
                }
                SceneTypeMappingFactory.getRemoteInstance().submit((CoreBaseInfo)mappinginfo);
            }
        }
    }

    private void verifyEntry() {
        int count = this.tblMain.getRowCount();
        if (count > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.getCell("elimTypeNumber").getValue() != null) continue;
                sb.append(i + 1).append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"10_SceneTypeMappingUI", (Object[])new Object[]{sb.toString()}));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
        this.isCancel = true;
    }

    public boolean destroyWindow() {
        this.isCancel = true;
        return super.destroyWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

