/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationCollection;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationInfo;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.RptFormula;
import com.kingdee.eas.fi.rpt.excelformula.RptFormulaComp;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvestElimManuScriptUtil {
    private static final Logger logger = CoreUIObject.getLogger(InvestElimManuScriptUtil.class);
    public static final String strResource = "com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource";
    public static final int BATCHSAVE_REPEAT = 1;
    public static final int BATCHSAVE_FAILED = 2;
    public static final int BATCHSAVE_SUCCEED = 3;
    public static final String split = "_";

    public static Expression checkFormulaFormat(String formulaString, List<String> formulaNames) throws CheckFormulaException {
        Expression stmt = null;
        try {
            stmt = ExcelFormulaPaserHelper.parse((String)formulaString);
        }
        catch (Exception e) {
            throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, (Throwable)e);
        }
        InvestElimManuScriptUtil.checkExpressionIsFormula(stmt);
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        formulaNames = InvestElimManuScriptUtil.getFormulaNames(formulaNames);
        InvestElimManuScriptUtil.checkFormulaFormat(stmt, results, formulaNames);
        if (results.contains(Boolean.FALSE)) {
            throw new CheckFormulaException(CheckFormulaException.EXISTNOTSUPPORTFORMULA);
        }
        return stmt;
    }

    private static List<String> getFormulaNames(List<String> formulaNames) throws CheckFormulaException {
        if (formulaNames == null) {
            formulaNames = new ArrayList<String>();
            RptFormulaComp comp = RptFormulaComp.getInstance();
            comp.setK3(false);
            if (!comp.isLoaded()) {
                try {
                    comp.load();
                }
                catch (Exception e) {
                    throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR, (Throwable)e);
                }
            }
            for (RptFormula fm : comp.getFormulasByCategory(null)) {
                formulaNames.add(fm.getName().toUpperCase());
            }
        }
        return formulaNames;
    }

    private static void checkFormulaFormat(Expression stmt, List<Boolean> results, List<String> formulaNames) throws CheckFormulaException {
        InvestElimManuScriptUtil.checkExistsFormula(stmt, formulaNames, results);
    }

    private static List<Boolean> checkExistsFormula(Expression stmt, List<String> formulasList, List<Boolean> results) {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            Locale locale = SysContext.getSysContext().getLocale();
            if (formulasList.contains(funName.toUpperCase(locale))) {
                results.add(Boolean.TRUE);
            } else {
                results.add(Boolean.FALSE);
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)stmt).left;
            InvestElimManuScriptUtil.checkExistsFormula(expr, formulasList, results);
            expr = ((BinaryOperationExpr)stmt).right;
            InvestElimManuScriptUtil.checkExistsFormula(expr, formulasList, results);
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)stmt).operand;
            InvestElimManuScriptUtil.checkExistsFormula(expr, formulasList, results);
        }
        return results;
    }

    public static int addNewInvestElimMnsRpt(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws Exception {
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (RptTmpTypeEnum.INVESTELIMMANUSCRIPT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.INVESTELIMMANUSCRIPT;
        }
        DataCollectInfo dataCollect = DataCollectConstant.getActualDC();
        if (rptType != null && !InvestElimManuScriptUtil.verifyCslReport(unitTree.getId().toString(), company.getId().toString(), template.getPeriodType().getValue(), year, period, currency.getId().toString(), template.getId().toString(), rptType.getValue(), dataCollect)) {
            return 1;
        }
        InvestElimManuScriptUtil.addSingleEditData(template, date, year, period, currency, unitTree, company);
        return 3;
    }

    private static boolean verifyCslReport(String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateID, int reportType, DataCollectInfo dataCollect) throws Exception {
        String rptId = CslRptUIUtil.getReportByOldVersionTmp((String)treeID, (String)companyID, (int)periodType, (int)year, (int)period, (String)currencyID, (String)templateID, (int)reportType, null, (String)dataCollect.getNumber());
        return rptId == null;
    }

    public static CslReportInfo addSingleEditData(TemplateInfo template, Date date, int year, short period, CurrencyInfo currency, OrgTreeInfo unitTree, OrgUnitInfo company) throws IOException, Exception {
        RptTmpTypeEnum tmpType = template.getTemplateType();
        RptSrcTypeEnum rptType = null;
        if (RptTmpTypeEnum.INVESTELIMMANUSCRIPT.equals((Object)tmpType)) {
            rptType = RptSrcTypeEnum.INVESTELIMMANUSCRIPT;
        }
        int periodType = template.getPeriodType().getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        boolean isMergeByFiscalPeriod = CSLParamUtil.getBooleanCslParamValue(null, (String)"GR_CSL_MergeByFiscalPeriod");
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.getPeriodCollection(null, (OrgTreeInfo)unitTree);
        }
        Date startDate = FiscalPeriodHelper.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        Date endDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periods, (int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType), (boolean)isMergeByFiscalPeriod);
        CslReportInfo editData = new CslReportInfo();
        editData.setYear(year);
        editData.setPeriod(period);
        editData.setOrgType(OrgType.Company);
        editData.setStartDate(startDate);
        editData.setEndDate(endDate);
        editData.setReportDate((Date)new Timestamp(date.getTime()));
        editData.setOrgTree(unitTree);
        editData.setOrgUnit(company);
        editData.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        Book tmplbook = template.getBook();
        editData.setTemplate(template);
        editData.setBook(tmplbook);
        RptSheetParamCollection sheetParams = template.getSheetParam();
        if (sheetParams != null && sheetParams.size() > 0) {
            for (int j = 0; j < sheetParams.size(); ++j) {
                sheetParams.get(j).setRelaType(ReportTypeEnum.REPORT);
                sheetParams.get(j).setStatus(1);
            }
        }
        editData.getSheetParam().addCollection(sheetParams);
        editData.setSourceType(rptType);
        editData.setCurrency(currency);
        editData.setNumber("001");
        editData.setName(template.getName());
        editData.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        editData.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        editData.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        editData.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        editData.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        editData.setDataCollect(DataCollectConstant.getActualDC());
        editData.setDataCollectNumber("ACTUALDATA");
        IObjectPK pk = CslReportFactory.getRemoteInstance().submit((CoreBaseInfo)editData);
        editData.setId(BOSUuid.read((String)pk.toString()));
        return editData;
    }

    public static String excelColIndexToStr(int columnIndex) {
        if (columnIndex <= 0) {
            return null;
        }
        String columnStr = "";
        --columnIndex;
        do {
            if (columnStr.length() > 0) {
                --columnIndex;
            }
            columnStr = (char)(columnIndex % 26 + 65) + columnStr;
        } while ((columnIndex = (columnIndex - columnIndex % 26) / 26) > 0);
        return columnStr;
    }

    public static String getBizNumber(String elimTypeNumber, String invCompanyNumber, String targetCompanyNumber, String seq) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
        String date = dateFormat.format(new Date());
        elimTypeNumber = InvestElimManuScriptUtil.getNewElimTypeNumber(elimTypeNumber);
        sb.append(elimTypeNumber);
        sb.append("C");
        sb.append(invCompanyNumber);
        sb.append("T");
        sb.append(targetCompanyNumber);
        sb.append(date);
        sb.append(split);
        sb.append(seq);
        return sb.toString();
    }

    public static String getSequence(int index) {
        StringBuffer sb = new StringBuffer();
        if (++index < 10) {
            sb.append("0").append(index);
        } else {
            sb.append(index);
        }
        return sb.toString();
    }

    public static String getEntryNumber(String currencyNumber, String mnsTmplNumber, String seq) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("MMddHHmmss");
        Calendar calendar = Calendar.getInstance();
        String timeStamp = df.format(calendar.getTime());
        sb.append("QY").append(split).append(mnsTmplNumber).append(split).append(currencyNumber).append(split);
        sb.append(timeStamp).append(split);
        int entryNumberLength = 8 - seq.length();
        for (int i = 0; i < entryNumberLength; ++i) {
            sb.append(0);
        }
        sb.append(seq);
        return sb.toString();
    }

    private static String getNewElimTypeNumber(String elimTypeNumber) {
        if (elimTypeNumber.endsWith("C")) {
            elimTypeNumber = elimTypeNumber.substring(0, elimTypeNumber.length() - 1);
            elimTypeNumber = InvestElimManuScriptUtil.getNewElimTypeNumber(elimTypeNumber);
        }
        return elimTypeNumber;
    }

    public static String checkDebitAndCreditHaveData(Sheet sheet) {
        if (sheet.getUserObject("rowCount") == null) {
            return null;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) + left - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        StringBuffer msg = new StringBuffer();
        for (int row = start; row < rowCount; ++row) {
            boolean debitHasData = false;
            boolean creditHasData = false;
            boolean debitIsNull = false;
            boolean creditIsNull = false;
            for (int col = left; col < columnCount; ++col) {
                Range range;
                ItemFormula itemFormula;
                String colValue;
                int columnValue;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null || (columnValue = Integer.valueOf(colValue = (itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue()).getExt("columnValue")).intValue()) != 11 && columnValue != 12) continue;
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                    range = sheet.getRange(row, col + 1);
                    debitHasData = InvestElimManuScriptUtil.debitHasData(range, columnValue, debitHasData);
                    creditHasData = InvestElimManuScriptUtil.creditHashData(range, columnValue, creditHasData);
                    debitIsNull = InvestElimManuScriptUtil.debitIsNull(range, columnValue, debitIsNull);
                    creditIsNull = InvestElimManuScriptUtil.creditIsNull(range, columnValue, creditIsNull);
                    ++col;
                    if (row != start) continue;
                    ++columnCount;
                    continue;
                }
                range = sheet.getRange(row, col);
                debitHasData = InvestElimManuScriptUtil.debitHasData(range, columnValue, debitHasData);
                creditHasData = InvestElimManuScriptUtil.creditHashData(range, columnValue, creditHasData);
                debitIsNull = InvestElimManuScriptUtil.debitIsNull(range, columnValue, debitIsNull);
                creditIsNull = InvestElimManuScriptUtil.creditIsNull(range, columnValue, creditIsNull);
            }
            if (debitHasData && creditHasData) {
                msg.append(EASResource.getString((String)strResource, (String)"36_debitAndCreditHasData", (Object[])new Object[]{row + 1})).append("<br/>");
            }
            if (!debitIsNull || !creditIsNull) continue;
            msg.append(EASResource.getString((String)strResource, (String)"90_debitAndCreditIsNull", (Object[])new Object[]{row + 1})).append("<br/>");
        }
        return msg.toString();
    }

    private static boolean debitIsNull(Range range, int columnValue, boolean debitIsNull) {
        if (columnValue == 11) {
            try {
                BigDecimal value;
                BigDecimal bigDecimal = value = range.getValue() != null ? range.getValue().toBigDecimal() : BigDecimal.ZERO;
                if (value.compareTo(BigDecimal.ZERO) == 0) {
                    debitIsNull = true;
                }
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"debitIsNull: ", (Throwable)e);
            }
        }
        return debitIsNull;
    }

    private static boolean creditIsNull(Range range, int columnValue, boolean creditIsNull) {
        if (columnValue == 12) {
            try {
                BigDecimal value;
                BigDecimal bigDecimal = value = range.getValue() != null ? range.getValue().toBigDecimal() : BigDecimal.ZERO;
                if (value.compareTo(BigDecimal.ZERO) == 0) {
                    creditIsNull = true;
                }
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"debitHasData: ", (Throwable)e);
            }
        }
        return creditIsNull;
    }

    private static boolean debitHasData(Range range, int columnValue, boolean debitHasData) {
        if (columnValue == 11) {
            try {
                BigDecimal debit = range.getValue().toBigDecimal();
                if (debit.compareTo(BigDecimal.ZERO) != 0) {
                    debitHasData = true;
                }
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"debitHasData: ", (Throwable)e);
            }
        }
        return debitHasData;
    }

    private static boolean creditHashData(Range range, int columnValue, boolean creditHasData) {
        if (columnValue == 12) {
            try {
                BigDecimal credit = range.getValue().toBigDecimal();
                if (credit.compareTo(BigDecimal.ZERO) != 0) {
                    creditHasData = true;
                }
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"creditHashData: ", (Throwable)e);
            }
        }
        return creditHasData;
    }

    public static String checkBalance(Sheet sheet) {
        if (sheet.getUserObject("rowCount") == null) {
            return null;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) + left - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        BigDecimal debitTotal = BigDecimal.ZERO;
        BigDecimal creditTotal = BigDecimal.ZERO;
        String bizNumber = null;
        StringBuffer msg = new StringBuffer();
        for (int row = start; row < rowCount; ++row) {
            for (int col = left; col < columnCount; ++col) {
                Range range;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                if (0 == columnValue) {
                    Range range2 = sheet.getRange(row, col);
                    if (bizNumber != null && !range2.getValue().isNull()) {
                        if (debitTotal.compareTo(creditTotal) != 0) {
                            msg.append(EASResource.getString((String)strResource, (String)"29_checkBalance", (Object[])new Object[]{bizNumber})).append("<br/>");
                        }
                        debitTotal = BigDecimal.ZERO;
                        creditTotal = BigDecimal.ZERO;
                        bizNumber = range2.getValue().toString();
                    }
                    if (bizNumber == null) {
                        bizNumber = range2.getValue().toString();
                    }
                }
                if (columnValue != 11 && columnValue != 12) continue;
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                    range = sheet.getRange(row, col + 1);
                    debitTotal = InvestElimManuScriptUtil.getDebitTotal(range, columnValue, debitTotal);
                    creditTotal = InvestElimManuScriptUtil.getCreditTotal(range, columnValue, creditTotal);
                    ++col;
                    if (row != start) continue;
                    ++columnCount;
                    continue;
                }
                range = sheet.getRange(row, col);
                debitTotal = InvestElimManuScriptUtil.getDebitTotal(range, columnValue, debitTotal);
                creditTotal = InvestElimManuScriptUtil.getCreditTotal(range, columnValue, creditTotal);
            }
            if (row != rowCount - 1) continue;
            if (debitTotal.compareTo(creditTotal) != 0) {
                msg.append(EASResource.getString((String)strResource, (String)"29_checkBalance", (Object[])new Object[]{bizNumber})).append("<br/>");
            }
            debitTotal = BigDecimal.ZERO;
            creditTotal = BigDecimal.ZERO;
        }
        return msg.toString();
    }

    private static BigDecimal getDebitTotal(Range range, int columnValue, BigDecimal debitTotal) {
        if (columnValue == 11) {
            try {
                BigDecimal debit = range.getValue().toBigDecimal();
                debitTotal = debitTotal.add(debit);
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"getDebitTotal: ", (Throwable)e);
            }
        }
        return debitTotal;
    }

    private static BigDecimal getCreditTotal(Range range, int columnValue, BigDecimal creditTotal) {
        if (columnValue == 12) {
            try {
                BigDecimal credit = range.getValue().toBigDecimal();
                creditTotal = creditTotal.add(credit);
            }
            catch (SyntaxErrorException e) {
                logger.error((Object)"getDebitTotal: ", (Throwable)e);
            }
        }
        return creditTotal;
    }

    public static String checkVerifyRelation(Sheet sheet, Book calBook) {
        if (sheet.getUserObject("rowCount") == null) {
            return null;
        }
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left((Sheet)sheet);
        top = CslRptUtil.getBasePosition_Top((Sheet)sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        boolean isIncludeAdjust = Boolean.valueOf(String.valueOf(sheet.getUserObject("isIncludeAdjust").getValue()));
        int rowCount = Integer.valueOf(String.valueOf(sheet.getUserObject("rowCount").getValue())) + top;
        int columnCount = Integer.valueOf(String.valueOf(sheet.getUserObject("columnCount").getValue())) + left - 1;
        int start = top + 1;
        if (isIncludeAdjust) {
            rowCount += 2;
            start = top + 2;
        } else {
            ++rowCount;
        }
        StringBuffer msg = new StringBuffer();
        String bizNumber = null;
        Map<String, VerifyRelationInfo> verifyRelationInfoMap = InvestElimManuScriptUtil.getVerifyConditons(sheet);
        InvestElimManuScriptUtil.calculateFormula(calBook, sheet, top, start, left, rowCount, columnCount, verifyRelationInfoMap);
        for (int row = start; row < rowCount; ++row) {
            String sceneId = null;
            String rptItemId = null;
            String interSeq = null;
            BigDecimal amount = BigDecimal.ZERO;
            for (int col = left; col < columnCount; ++col) {
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                Range range = sheet.getRange(row, col);
                if (0 == columnValue && !range.getValue().isNull()) {
                    bizNumber = range.getValue().toString();
                }
                if (7 == columnValue) {
                    sceneId = String.valueOf(range.getUserObject("sceneId"));
                    rptItemId = String.valueOf(range.getUserObject("id"));
                }
                if (9 == columnValue) {
                    interSeq = String.valueOf(range.getUserObject("id"));
                }
                if (columnValue != 11 && columnValue != 12) continue;
                String adjustColumnsStr = itemFormula.getExt("adjustColumns");
                if (!StringUtils.isEmpty((String)adjustColumnsStr)) {
                    try {
                        Range rangeCom = sheet.getRange(row, col + 1);
                        BigDecimal value = rangeCom.getValue().toBigDecimal();
                        if (value.compareTo(BigDecimal.ZERO) != 0) {
                            amount = value;
                        }
                    }
                    catch (SyntaxErrorException e) {
                        logger.error((Object)"toBigDecimal: ", (Throwable)e);
                    }
                    ++col;
                    if (row != start) continue;
                    ++columnCount;
                    continue;
                }
                try {
                    BigDecimal value = range.getValue().toBigDecimal();
                    if (value.compareTo(BigDecimal.ZERO) == 0) continue;
                    amount = value;
                    continue;
                }
                catch (SyntaxErrorException e) {
                    logger.error((Object)"toBigDecimal: ", (Throwable)e);
                }
            }
            String tips = InvestElimManuScriptUtil.checkValue(verifyRelationInfoMap, sceneId, rptItemId, interSeq, amount, bizNumber, row, calBook);
            if (tips.length() <= 0) continue;
            msg.append(tips);
        }
        return msg.toString();
    }

    private static void calculateFormula(Book calBook, Sheet sheet, int top, int start, int left, int rowCount, int columnCount, Map<String, VerifyRelationInfo> verifyRelationInfoMap) {
        int index = 0;
        Sheet calSheet = calBook.getSheet(0);
        calSheet.setName(sheet.getSheetName());
        for (int row = start; row < rowCount; ++row) {
            String sceneId = null;
            String rptItemId = null;
            String interSeq = null;
            for (int col = left; col < columnCount; ++col) {
                VerifyRelationInfo verifyRelationInfo;
                String value;
                String key;
                Cell cell = sheet.getCell(top, col, true);
                if (cell.getUserObject("ITEM") == null) continue;
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String colValue = itemFormula.getExt("columnValue");
                int columnValue = Integer.valueOf(colValue);
                Range range = sheet.getRange(row, col);
                if (7 == columnValue) {
                    sceneId = String.valueOf(range.getUserObject("sceneId"));
                    rptItemId = String.valueOf(range.getUserObject("id"));
                }
                if (9 == columnValue) {
                    interSeq = String.valueOf(range.getUserObject("id"));
                }
                if (!verifyRelationInfoMap.containsKey(key = sceneId + rptItemId + interSeq) || (value = (verifyRelationInfo = verifyRelationInfoMap.get(key)).getAmount()).indexOf("(") <= -1) continue;
                Cell calCellkey = calSheet.getCell(index, 0, true);
                calCellkey.setFormula(key);
                Cell calCell = calSheet.getCell(index, 1, true);
                value = "=" + value;
                calCell.setFormula(value);
                ++index;
            }
        }
        calBook.calc();
        for (int i = 0; i < index; ++i) {
            String key = calSheet.getCell(i, 0, false).getValue().toString();
            String value = calSheet.getCell(i, 1, false).getValue().toString();
            if (!verifyRelationInfoMap.containsKey(key)) continue;
            VerifyRelationInfo verifyRelationInfo = verifyRelationInfoMap.get(key);
            verifyRelationInfo.setAmount(value);
        }
    }

    public static Book initBook(final CslReportInfo cslReport) throws Exception {
        Book book = Book.Manager.getNewBook((String)"book", (int)1);
        book.setCalculate(false);
        FormulaDefinition.registerFormulaToBook(book, new ICalculateContextProvider(){

            public Context getServerContext() {
                return null;
            }

            public ReportVariables getReportVariables() {
                ReportVariables v = null;
                try {
                    Book book = cslReport.getBook();
                    v = ReportVariables.loadFromBook((Book)book);
                    if (v == null) {
                        v = new ReportVariables();
                        v.storeToBook(book);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"getReportVariablesError: ", (Throwable)e);
                }
                VariableEntry variableEntry = new VariableEntry("Check_Permissioin", null);
                variableEntry.setDescription(EASResource.getString((String)InvestElimManuScriptUtil.strResource, (String)"47_variableName"));
                variableEntry.setValue(Boolean.toString(false));
                variableEntry.setType(1);
                v.addOrReplace(variableEntry);
                return v;
            }

            public IReportPropertyAdapter getReportAdapter() {
                CSLPropertyAdapter adapter = new CSLPropertyAdapter(cslReport, null);
                return adapter;
            }

            public IErrorProvider getErrorProvider() {
                return null;
            }

            public IErrorResultProvider getErrorResultProvider() {
                return null;
            }
        });
        return book;
    }

    private static String checkValue(Map<String, VerifyRelationInfo> verifyRelationInfoMap, String sceneId, String rptItemId, String interSeq, BigDecimal amount, String bizNumber, int rowIndex, Book calBook) {
        StringBuffer msg = new StringBuffer();
        String key = sceneId + rptItemId + interSeq;
        if (verifyRelationInfoMap.containsKey(key)) {
            VerifyRelationInfo verifyRelationInfo = verifyRelationInfoMap.get(key);
            BigDecimal defValue = BigDecimal.ZERO;
            String value = verifyRelationInfo.getAmount();
            try {
                defValue = new BigDecimal(value);
            }
            catch (Exception e) {
                msg.append(EASResource.getString((String)strResource, (String)"37_veriFyTip", (Object[])new Object[]{bizNumber, rowIndex + 1}));
                msg.append(EASResource.getString((String)strResource, (String)"103_formulaError")).append("<br/>");
                return msg.toString();
            }
            int symbol = verifyRelationInfo.getOperateSymbol().getValue();
            String verifyTips = verifyRelationInfo.getVerifyTips();
            String defMsg = EASResource.getString((String)strResource, (String)"37_veriFyTip", (Object[])new Object[]{bizNumber, rowIndex + 1});
            switch (symbol) {
                case 3: {
                    if (amount.abs().compareTo(defValue) == 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
                case 4: {
                    if (amount.abs().compareTo(defValue) > 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
                case 5: {
                    if (amount.abs().compareTo(defValue) < 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
                case 6: {
                    if (amount.abs().compareTo(defValue) > 0 || amount.abs().compareTo(defValue) == 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
                case 7: {
                    if (amount.abs().compareTo(defValue) < 0 || amount.abs().compareTo(defValue) == 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
                case 8: {
                    if (amount.abs().compareTo(defValue) != 0) break;
                    msg.append(defMsg).append(verifyTips).append("<br/>");
                    break;
                }
            }
        }
        return msg.toString();
    }

    private static Map<String, VerifyRelationInfo> getVerifyConditons(Sheet sheet) {
        String sceneIdsString;
        Set<String> sceneIdsSet;
        VerifyRelationCollection verifyRelationCollection;
        HashMap<String, VerifyRelationInfo> verifyConditionMap = new HashMap<String, VerifyRelationInfo>();
        String key = "sceneIds";
        if (sheet.getUserObject(key) != null && (verifyRelationCollection = InvestElimManuScriptUtil.getVerifyRelationCollection(sceneIdsSet = InvestElimManuScriptUtil.getSceneIdsSet(sceneIdsString = String.valueOf(sheet.getUserObject(key).getValue())))) != null && !verifyRelationCollection.isEmpty()) {
            Iterator it = verifyRelationCollection.iterator();
            while (it.hasNext()) {
                VerifyRelationInfo verifyRelationInfo = (VerifyRelationInfo)it.next();
                String sceneId = verifyRelationInfo.getScene().getId().toString();
                String rptItemId = verifyRelationInfo.getRptItem().getId().toString();
                int interSeq = verifyRelationInfo.getDataElement().getInterSeq();
                key = sceneId + rptItemId + interSeq;
                verifyConditionMap.put(key, verifyRelationInfo);
            }
        }
        return verifyConditionMap;
    }

    private static VerifyRelationCollection getVerifyRelationCollection(Set<String> sceneIdsSet) {
        VerifyRelationCollection verifyRelationCollection = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("dataElement.id"));
            sic.add(new SelectorItemInfo("dataElement.interSeq"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("scene.id", sceneIdsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("scene.number");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            SorterItemInfo sorterItem1 = new SorterItemInfo("seq");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem1);
            view.setSorter(sorter);
            verifyRelationCollection = VerifyRelationFactory.getRemoteInstance().getVerifyRelationCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)"getVerifyRelationCollection: ", (Throwable)e);
        }
        return verifyRelationCollection;
    }

    private static Set<String> getSceneIdsSet(String sceneIdsString) {
        String[] sceneIds;
        HashSet<String> scenes = new HashSet<String>();
        String split = ",";
        for (String sceneId : sceneIds = sceneIdsString.split(split)) {
            scenes.add(sceneId);
        }
        return scenes;
    }

    private static void checkExpressionIsFormula(Expression stmt) throws CheckFormulaException {
        if (!(stmt instanceof FunctionExpr || stmt instanceof BinaryOperationExpr || stmt instanceof UnaryOperationExpr)) {
            throw new CheckFormulaException(CheckFormulaException.INCLUDEFORMULA);
        }
    }
}

