/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.IItemMap;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ItemMapFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ItemMapInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptSelInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractItemMapListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.OFileFilter;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

public class ItemMapListUI
extends AbstractItemMapListUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemMapListUI.class);
    private static final String COL_ID = "id";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_DataTypeName = "dataTypeName";
    private static final String COL_JQNumber = "JQNumber";
    private static final String COL_JQName = "JQName";
    private static final String COL_RptNumber = "rptNumber";
    private static final String COL_RptName = "rptName";
    private static final String COL_JQTxtNumber = "JQTxtNumber";
    private static final String COL_JQTxtName = "JQTxtName";
    private static final String COL_DataTypeID = "dataTypeID";
    private static final String COL_DataType = "dataType";
    private Set delIDs = new HashSet();
    private int curSelRowIndex = 0;
    Map<String, Map<String, Map<String, String>>> allDataMap = null;
    Map<String, String> rptDataMap = null;
    Map<String, String> itemDataMap = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.curSelRowIndex = e.getRowIndex();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemMapFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ItemMapInfo objectValue = new ItemMapInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_NAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_RptName).getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.initData();
    }

    private void initData() throws Exception {
        IItemMap itemInt = ItemMapFactory.getRemoteInstance();
        this.allDataMap = itemInt.getAllData();
        this.rptDataMap = itemInt.getRptMap();
        this.itemDataMap = itemInt.getItemMap();
    }

    protected String getKeyFieldName() {
        return COL_ID;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HashMap actionMap = this.getActionManager().getActionSet();
        Object[] keySet = actionMap.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            ItemAction action = (ItemAction)actionMap.get(keySet[i]);
            action.setVisible(false);
        }
        this.actionLocate.setVisible(true);
        this.actionQuery.setVisible(true);
        this.actionSave.setVisible(true);
        this.actionImportData.setVisible(true);
        this.actionExport.setVisible(true);
        this.actionAddRow.setVisible(true);
        this.actionRemoveRow.setVisible(true);
        this.actionClearAll.setVisible(true);
        this.actionRefresh.setVisible(true);
        KDBizPromptBox itemBox = this.createF7Box("com.kingdee.eas.fi.newrpt.jiuqiInterface.app.F7RptItemQuery", "$number$", "$number$", "$number$");
        itemBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ItemMapListUI.this.itemBoxWillShow((KDBizPromptBox)e.getSource());
            }
        });
        itemBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ItemMapListUI.this.itemBoxWillShow((KDBizPromptBox)e.getSource());
            }
        });
        this.setTableEditor(itemBox, COL_NUMBER, "$number$");
        KDBizPromptBox dataEleBox = this.createF7Box("com.kingdee.eas.fi.newrpt.jiuqiInterface.app.F7DataEleQuery", "$name$", "$name$", "$name$");
        dataEleBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ItemMapListUI.this.dataEleBoxWillShow((KDBizPromptBox)e.getSource());
            }
        });
        dataEleBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ItemMapListUI.this.dataEleBoxWillShow((KDBizPromptBox)e.getSource());
            }
        });
        this.setTableEditor(dataEleBox, COL_DataTypeName, "$name$");
        KDBizPromptBox rptNameBox = this.createF7Box("com.kingdee.eas.fi.newrpt.jiuqiInterface.app.F7RptSelQuery", "$rptNumber$", "$rptNumber$", "$rptNumber$");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add(COL_RptNumber);
        sic.add(COL_RptName);
        rptNameBox.setSelectorCollection(sic);
        this.setTableEditor(rptNameBox, COL_RptNumber, "$rptNumber$");
    }

    private void itemBoxWillShow(KDBizPromptBox box) {
        IRow row = this.tblMain.getRow(this.curSelRowIndex);
        if (row.getCell(COL_RptNumber).getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.notReportNumber"));
            this.tblMain.getEditManager().editCellAt(this.curSelRowIndex, this.tblMain.getColumnIndex(COL_RptNumber));
            SysUtil.abort();
        }
        String rptNumber = (String)row.getCell(COL_RptNumber).getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(COL_RptNumber, (Object)rptNumber));
        evi.setFilter(filter);
        box.setEntityViewInfo(evi);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    private void dataEleBoxWillShow(KDBizPromptBox box) {
        IRow row = this.tblMain.getRow(this.curSelRowIndex);
        if (row.getCell(COL_NUMBER).getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.notEASRptNumber"));
            this.tblMain.getEditManager().editCellAt(this.curSelRowIndex, this.tblMain.getColumnIndex(COL_NUMBER));
            SysUtil.abort();
        }
        String itemNumber = (String)row.getCell(COL_NUMBER).getValue();
        String rptNumber = (String)row.getCell(COL_RptNumber).getValue();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemNnumber", (Object)itemNumber));
        filter.getFilterItems().add(new FilterItemInfo(COL_RptNumber, (Object)rptNumber));
        evi.setFilter(filter);
        box.setEntityViewInfo(evi);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        Object obj;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (this.tblMain.getColumnKey(colIndex).equals(COL_NUMBER)) {
            obj = row.getCell(COL_NUMBER).getValue();
            if (obj != null && obj instanceof Object[]) {
                Object[] items = (Object[])obj;
                RPTItemInfo item = (RPTItemInfo)items[0];
                if (e.getOldValue() == null) {
                    row.getCell(COL_NUMBER).setValue((Object)item.getNumber());
                    row.getCell(COL_NAME).setValue((Object)item.getName());
                } else if (!e.getOldValue().equals(item.getNumber())) {
                    row.getCell(COL_NUMBER).setValue((Object)item.getNumber());
                    row.getCell(COL_NAME).setValue((Object)item.getName());
                    row.getCell(COL_DataTypeName).setValue(null);
                }
                String rptName = (String)row.getCell(COL_RptName).getValue();
                String rptNumber = (String)row.getCell(COL_RptNumber).getValue();
                this.fillItemsToTable(items, rptNumber, rptName, rowIndex);
            } else if (obj == null) {
                row.getCell(COL_NUMBER).setValue(null);
                row.getCell(COL_NAME).setValue(null);
                row.getCell(COL_DataTypeName).setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(colIndex).equals(COL_DataTypeName) && (obj = row.getCell(COL_DataTypeName).getValue()) != null && obj instanceof Object[]) {
            Object[] dataEles = (Object[])obj;
            DataElementInfo dataEle = (DataElementInfo)dataEles[0];
            row.getCell(COL_DataTypeName).setValue((Object)dataEle.getName());
            String itemNumber = (String)row.getCell(COL_NUMBER).getValue();
            String itemName = (String)row.getCell(COL_NAME).getValue();
            String rptNumber = (String)row.getCell(COL_RptNumber).getValue();
            String rptName = (String)row.getCell(COL_RptName).getValue();
            this.fillDataElesToTable(dataEles, itemNumber, itemName, rptNumber, rptName, rowIndex);
        }
        if (this.tblMain.getColumnKey(colIndex).equals(COL_RptNumber)) {
            obj = row.getCell(COL_RptNumber).getValue();
            if (obj != null && obj instanceof Object[]) {
                Object[] rpts = (Object[])obj;
                RptSelInfo rpt = (RptSelInfo)rpts[0];
                if (e.getOldValue() == null) {
                    row.getCell(COL_RptNumber).setValue((Object)rpt.getRptNumber());
                    row.getCell(COL_RptName).setValue((Object)rpt.getRptName());
                } else if (!e.getOldValue().equals(rpt.getRptNumber())) {
                    row.getCell(COL_RptNumber).setValue((Object)rpt.getRptNumber());
                    row.getCell(COL_RptName).setValue((Object)rpt.getRptName());
                    row.getCell(COL_NUMBER).setValue(null);
                    row.getCell(COL_NAME).setValue(null);
                    row.getCell(COL_DataTypeName).setValue(null);
                }
                this.fillRptsToTable(rpts, rowIndex);
            } else if (obj == null) {
                row.getCell(COL_RptName).setValue(null);
                row.getCell(COL_NUMBER).setValue(null);
                row.getCell(COL_NAME).setValue(null);
                row.getCell(COL_DataTypeName).setValue(null);
            }
        }
    }

    private void fillItemsToTable(Object[] items, String rptNumber, String rptName, int rowIndex) {
        for (int i = 1; i < items.length; ++i) {
            if (items[i] == null || !(items[i] instanceof RPTItemInfo)) continue;
            RPTItemInfo item = (RPTItemInfo)items[i];
            IRow row = this.tblMain.addRow(rowIndex + 1);
            this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
            row.getCell(COL_NUMBER).setValue((Object)item.getNumber());
            row.getCell(COL_NAME).setValue((Object)item.getName());
            row.getCell(COL_RptNumber).setValue((Object)rptNumber);
            row.getCell(COL_RptName).setValue((Object)rptName);
        }
    }

    private void fillDataElesToTable(Object[] dataEles, String itemNumber, String itemName, String rptNumber, String rptName, int rowIndex) {
        for (int i = 1; i < dataEles.length; ++i) {
            if (dataEles[i] == null || !(dataEles[i] instanceof DataElementInfo)) continue;
            DataElementInfo dataEle = (DataElementInfo)dataEles[i];
            IRow row = this.tblMain.addRow(rowIndex + 1);
            this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
            row.getCell(COL_NUMBER).setValue((Object)itemNumber);
            row.getCell(COL_NAME).setValue((Object)itemName);
            row.getCell(COL_DataTypeName).setValue((Object)dataEle.getName());
            row.getCell(COL_RptNumber).setValue((Object)rptNumber);
            row.getCell(COL_RptName).setValue((Object)rptName);
        }
    }

    private void fillRptsToTable(Object[] rpts, int rowIndex) {
        for (int i = 1; i < rpts.length; ++i) {
            if (rpts[i] == null || !(rpts[i] instanceof CslReportInfo)) continue;
            CslReportInfo rpt = (CslReportInfo)rpts[i];
            IRow row = this.tblMain.addRow(rowIndex + 1);
            this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
            row.getCell(COL_RptName).setValue((Object)rpt.getName());
            if (rpt.getTemplate() == null) continue;
            row.getCell(COL_RptNumber).setValue((Object)rpt.getTemplate().getNumber());
        }
    }

    private KDBizPromptBox createF7Box(String queryInfo, String displayFormat, String commitFormat, String editFormat) {
        KDBizPromptBox box = new KDBizPromptBox();
        box.setQueryInfo(queryInfo);
        box.setDisplayFormat(displayFormat);
        box.setCommitFormat(commitFormat);
        box.setEditFormat(editFormat);
        box.setEnabledMultiSelection(true);
        return box;
    }

    private void setTableEditor(KDBizPromptBox box, String colName, String renderName) {
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)box);
        this.tblMain.getColumn(colName).setEditor((ICellEditor)editor);
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat(renderName));
        this.tblMain.getColumn(colName).setRenderer((IBasicRender)render);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.delData();
        this.saveData();
    }

    protected void delData() {
        if (this.delIDs.size() > 0) {
            Object[] idSet = this.delIDs.toArray();
            ObjectStringPK[] pks = new ObjectStringPK[idSet.length];
            for (int i = 0; i < idSet.length; ++i) {
                ObjectStringPK pk;
                pks[i] = pk = new ObjectStringPK(idSet[i].toString());
            }
            try {
                ItemMapFactory.getRemoteInstance().delete((IObjectPK[])pks);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void saveData() throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            CoreBaseCollection cbColl = new CoreBaseCollection();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row == null) continue;
                ItemMapInfo info = new ItemMapInfo();
                info.put(COL_ID, row.getCell(COL_ID).getValue());
                if (row.getCell(COL_NUMBER).getValue() instanceof RPTItemInfo) {
                    RPTItemInfo item = (RPTItemInfo)row.getCell(COL_NUMBER).getValue();
                    info.put(COL_NUMBER, item.getNumber());
                } else {
                    info.put(COL_NUMBER, row.getCell(COL_NUMBER).getValue());
                }
                if (row.getCell(COL_NAME).getValue() != null) {
                    info.setName(row.getCell(COL_NAME).getValue().toString());
                } else {
                    info.setName(null);
                }
                if (row.getCell(COL_DataTypeName).getValue() instanceof DataElementInfo) {
                    DataElementInfo dataEle = (DataElementInfo)row.getCell(COL_DataTypeName).getValue();
                    info.put(COL_DataTypeName, dataEle.getName());
                } else {
                    info.put(COL_DataTypeName, row.getCell(COL_DataTypeName).getValue());
                }
                info.put(COL_JQNumber, row.getCell(COL_JQNumber).getValue());
                info.put(COL_JQName, row.getCell(COL_JQName).getValue());
                info.put(COL_JQTxtNumber, row.getCell(COL_JQTxtNumber).getValue());
                info.put(COL_JQTxtName, row.getCell(COL_JQTxtName).getValue());
                info.put(COL_RptNumber, row.getCell(COL_RptNumber).getValue());
                info.put(COL_RptName, row.getCell(COL_RptName).getValue());
                cbColl.add((CoreBaseInfo)info);
            }
            try {
                ItemMapFactory.getRemoteInstance().saveBatchData(cbColl);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.refreshList();
            this.showSaveSuccess();
        }
    }

    protected void showSaveSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.saveOk"));
        this.setNextMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.saveOk"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_NUMBER, COL_NAME, COL_DataTypeName, COL_JQNumber, COL_JQName, COL_RptName, COL_JQTxtNumber, COL_JQTxtName};
        return locateNames;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorterColl = viewInfo.getSorter();
        if (sorterColl.size() == 0) {
            sorterColl.add(new SorterItemInfo(COL_NUMBER));
            sorterColl.add(new SorterItemInfo(COL_NAME));
            sorterColl.add(new SorterItemInfo(COL_DataTypeName));
            sorterColl.add(new SorterItemInfo(COL_JQNumber));
            sorterColl.add(new SorterItemInfo(COL_JQName));
            sorterColl.add(new SorterItemInfo(COL_RptName));
            sorterColl.add(new SorterItemInfo(COL_JQTxtNumber));
            sorterColl.add(new SorterItemInfo(COL_JQTxtName));
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        sorterColl.resetValue();
        return exec;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new OFileFilter(".xls", " *.xls | xls"));
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.showOpenDialog((Component)((Object)this));
        File file = jfc.getSelectedFile();
        if (file != null) {
            this.parseXlsFile(file);
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
    }

    @Override
    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex;
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.notSelectRow"));
            SysUtil.abort();
        }
        if (this.tblMain.getRow(rowIndex = KDTableUtil.getSelectedRow((KDTable)this.tblMain)).getCell(COL_ID).getValue() != null) {
            String id = (String)this.tblMain.getRow(rowIndex).getCell(COL_ID).getValue();
            this.delIDs.add(id);
        }
        this.tblMain.removeRow(rowIndex);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0 && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.clearAllData")) == 0) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.getCell(COL_ID).getValue() == null) continue;
                String id = (String)row.getCell(COL_ID).getValue();
                this.delIDs.add(id);
            }
            this.tblMain.removeRows(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseXlsFile(File selectedFile) throws Exception {
        logger.info((Object)"parseXlsFile");
        if (!selectedFile.exists()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectFileNotExist"));
            SysUtil.abort();
        }
        POIFSFileSystem fs = null;
        try (FileInputStream fis = null;){
            HSSFRow row;
            int i;
            fis = new FileInputStream(selectedFile);
            fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            int sheetCount = workBook.getNumberOfSheets();
            if (sheetCount <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            for (i = 0; i < rows; ++i) {
                short tpcols;
                row = sheet.getRow(i);
                if (row == null || (tpcols = row.getLastCellNum()) <= cols) continue;
                cols = tpcols;
            }
            if (cols > this.tblMain.getColumnCount()) {
                cols = this.tblMain.getColumnCount();
            }
            if (rows == 0 || cols == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            for (i = 1; i < rows; ++i) {
                String dataEleName;
                String str;
                Object obj;
                HSSFCell cell;
                row = sheet.getRow(i);
                if (row == null || (cell = row.getCell(5)) == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String rptNumber = obj.toString();
                if (!this.allDataMap.containsKey(rptNumber)) {
                    String str2 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.reportNotNumber"), i, rptNumber);
                    MsgBox.showInfo((Component)((Object)this), (String)str2);
                    SysUtil.abort();
                    continue;
                }
                Map<String, Map<String, String>> itemMap = this.allDataMap.get(rptNumber);
                cell = row.getCell(0);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String itemNumber = obj.toString();
                if (!itemMap.containsKey(itemNumber)) {
                    String str3 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNotExist"), i, rptNumber, itemNumber);
                    MsgBox.showInfo((Component)((Object)this), (String)str3);
                    SysUtil.abort();
                    continue;
                }
                Map<String, String> dataEleMap = itemMap.get(itemNumber);
                cell = row.getCell(2);
                if (cell == null) {
                    str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.dataElemantNull"), i);
                    MsgBox.showInfo((Component)((Object)this), (String)str);
                    SysUtil.abort();
                }
                if ((obj = this.getHSSFCellValue(cell)) == null) {
                    str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.dataElemantNull"), i);
                    MsgBox.showInfo((Component)((Object)this), (String)str);
                    SysUtil.abort();
                }
                if (!dataEleMap.containsKey(dataEleName = obj.toString())) {
                    String str4 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptItemNotDataElement"), i, dataEleName, itemNumber);
                    MsgBox.showInfo((Component)((Object)this), (String)str4);
                    SysUtil.abort();
                    continue;
                }
                IRow tblRow = this.tblMain.addRow();
                this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
                tblRow.getCell(COL_NUMBER).setValue((Object)itemNumber);
                tblRow.getCell(COL_NAME).setValue((Object)this.itemDataMap.get(itemNumber));
                tblRow.getCell(COL_DataTypeName).setValue((Object)dataEleName);
                cell = row.getCell(3);
                if (cell != null) {
                    tblRow.getCell(COL_JQNumber).setValue(this.getHSSFCellValue(cell));
                }
                if ((cell = row.getCell(4)) != null) {
                    tblRow.getCell(COL_JQName).setValue(this.getHSSFCellValue(cell));
                }
                tblRow.getCell(COL_RptNumber).setValue((Object)rptNumber);
                tblRow.getCell(COL_RptName).setValue((Object)this.rptDataMap.get(rptNumber));
                cell = row.getCell(7);
                if (cell != null) {
                    tblRow.getCell(COL_JQTxtNumber).setValue(this.getHSSFCellValue(cell));
                }
                if ((cell = row.getCell(8)) == null) continue;
                tblRow.getCell(COL_JQTxtName).setValue(this.getHSSFCellValue(cell));
            }
        }
    }

    private Object getHSSFCellValue(HSSFCell cell) {
        Object value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).toString();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().toString();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case BLANK: {
                value = null;
                break;
            }
            case ERROR: {
                value = null;
                break;
            }
            default: {
                value = cell.getRichStringCellValue().toString();
            }
        }
        return value;
    }
}

