/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ItemMapFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ItemMapInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractJiuQiIndexEASItemMappingUI;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class JiuQiIndexEASItemMappingUI
extends AbstractJiuQiIndexEASItemMappingUI {
    private static final Logger logger = CoreUIObject.getLogger(JiuQiIndexEASItemMappingUI.class);
    private List<String> saveMappingIndex = new ArrayList<String>();
    private List<String> deleteMappingIndex = new ArrayList<String>();
    private Set deleteIDs = new HashSet();
    private Map<String, String> listUIJiuQiIndexMapping = new HashMap<String, String>();
    private Map<Sheet, List<String>> sheetIndexMapping = new HashMap<Sheet, List<String>>();
    private Map<Cell, ShareStyleAttributes> cellStyleMap = new HashMap<Cell, ShareStyleAttributes>();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setListUIDataToTable();
    }

    private void setListUIDataToTable() {
        KDTable table = (KDTable)this.getUIContext().get("listUITable");
        if (table == null) {
            return;
        }
        int rowCount = table.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            Object value;
            boolean isRemove = true;
            IRow row1 = table.getRow(i);
            IRow row2 = this.mappingTable.addRow(0);
            String itemNumber = null;
            String dataElement = null;
            if (row1.getCell("rptNumber").getValue() != null) {
                isRemove = false;
                row2.getCell("rptTemplateNum").setValue(row1.getCell("rptNumber").getValue());
            }
            if (row1.getCell("rptName").getValue() != null) {
                isRemove = false;
                row2.getCell("rptTemplateName").setValue(row1.getCell("rptName").getValue());
            }
            if (row1.getCell("JQName").getValue() != null) {
                isRemove = false;
                row2.getCell("jiuQiIndexName").setValue(row1.getCell("JQName").getValue());
            }
            if (row1.getCell("dataTypeName").getValue() != null) {
                isRemove = false;
                value = row1.getCell("dataTypeName").getValue();
                dataElement = value instanceof DataElementInfo ? ((DataElementInfo)value).getName() : value.toString();
                row2.getCell("dataElement").setValue((Object)dataElement);
            }
            if (row1.getCell("number").getValue() != null) {
                isRemove = false;
                value = row1.getCell("number").getValue().toString();
                itemNumber = value instanceof RPTItemInfo ? ((RPTItemInfo)value).getNumber() : value.toString().trim();
                row2.getCell("rptItemNum").setValue((Object)itemNumber);
            }
            if (row1.getCell("name").getValue() != null) {
                row2.getCell("rptItemName").setValue(row1.getCell("name").getValue());
            }
            if (isRemove) {
                this.mappingTable.removeRow(0);
                continue;
            }
            row2.getStyleAttributes().setBackground(Color.orange);
            String jiuQiIndex = null;
            if (row1.getCell("JQNumber").getValue() != null) {
                jiuQiIndex = row1.getCell("JQNumber").getValue().toString();
                row2.getCell("jiuQiIndexNum").setValue((Object)jiuQiIndex);
                if (row1.getCell("id").getValue() != null) {
                    row2.getCell("jiuQiIndexNum").setUserObject(row1.getCell("id").getValue());
                }
                this.listUIJiuQiIndexMapping.put(jiuQiIndex, itemNumber + dataElement);
            }
            if (this.saveMappingIndex.contains(itemNumber + " " + dataElement + " " + jiuQiIndex)) continue;
            this.saveMappingIndex.add(itemNumber + " " + dataElement + " " + jiuQiIndex);
        }
    }

    @Override
    protected void initTable() throws Exception {
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$name$");
        bizBoxItem.setDisplayFormat("$name$");
        bizBoxItem.setCommitFormat("$name$");
        bizBoxItem.setEditable(true);
        CslGradeManageUtil.setRptItemF7GMFilter(bizBoxItem, null);
        this.mappingTable.getColumn("rptItemNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxItem));
        KDComboBox cmbDataElement = new KDComboBox();
        CslClientHelper.initDataElementCombox((KDComboBox)cmbDataElement, (boolean)false, (boolean)true, (boolean)false);
        this.mappingTable.getColumn("dataElement").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.mappingTable.getColumn("rptItemName").getStyleAttributes().setLocked(true);
        this.mappingTable.getSelectManager().setSelectMode(10);
        this.mappingTable.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int selectRow = e.getRowIndex();
                IRow row = JiuQiIndexEASItemMappingUI.this.mappingTable.getRow(selectRow);
                if (e.getColIndex() == row.getCell("rptItemNum").getColumnIndex()) {
                    row.getCell("rptItemName").setValue((Object)JiuQiIndexEASItemMappingUI.this.getRptItemName("rptItemNum", row, false));
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    @Override
    protected void preFormulaMapping() {
        List<ItemFormula> itemFormulas = this.getSelectItemFormulasBySpreadContext(this.sourceSpreedContainer, false);
        List<Object> jiuQiIndex = this.getSelectValueBySpreadContext(this.targetSpreedContainer, true);
        List values = (List)jiuQiIndex.get(0);
        List indexNames = (List)jiuQiIndex.get(1);
        this.checkSelect(itemFormulas, values);
        for (int i = 0; i < itemFormulas.size(); ++i) {
            String rptItemNum = itemFormulas.get(i).getItemNumber();
            String dataElementNum = itemFormulas.get(i).getDataElementNumber();
            String jiuqiIndex = (String)values.get(i);
            String jiuqiIndexName = (String)indexNames.get(i);
            this.addRowFillData(rptItemNum, dataElementNum, jiuqiIndex, jiuqiIndexName);
        }
        if (this.setStyleRang.size() > 0) {
            for (int k = 0; k < this.setStyleRang.size(); ++k) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setBackground(Color.GREEN);
                ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                ((Cell)this.setStyleRang.get(k)).setSSA(ssa);
            }
        }
    }

    @Override
    protected void checkSelect(List sourceItemFormulas, List targetItemFormulas) {
        if (sourceItemFormulas.size() == 0 || targetItemFormulas.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"10_RLCellMustHasItemFormula"));
            SysUtil.abort();
        }
        if (targetItemFormulas.size() != 1 && sourceItemFormulas.size() != targetItemFormulas.size()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"11_RLFormulasMustEqual"));
            SysUtil.abort();
        }
    }

    private boolean isExistMapping(String rptItemNum, String dataElementNum, String jiuqiIndex) {
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            if (!this.getRptItemName("rptItemNum", row, true).equals(rptItemNum) || !this.getDataElementNum("dataElement", row).equals(dataElementNum) || !row.getCell("jiuQiIndexNum").getValue().equals(jiuqiIndex)) continue;
            return true;
        }
        return false;
    }

    private void addRowFillData(String rptItemNum, String dataElementNum, String jiuqiIndex, String jiuqiIndexName) {
        if (this.isExistMapping(rptItemNum, dataElementNum, jiuqiIndex)) {
            return;
        }
        IRow row = this.mappingTable.addRow(0);
        row.getCell("rptItemNum").setValue((Object)rptItemNum);
        row.getCell("rptItemName").setValue(this.rptItemCollection.get(rptItemNum));
        row.getCell("dataElement").setValue((Object)dataElementNum);
        row.getCell("jiuQiIndexNum").setValue((Object)jiuqiIndex);
        row.getCell("jiuQiIndexName").setValue((Object)jiuqiIndexName);
        row.getCell("rptTemplateNum").setValue((Object)((TemplateInfo)this.sourceTemplateF7.getValue()).getNumber());
        row.getCell("rptTemplateName").setValue((Object)((TemplateInfo)this.sourceTemplateF7.getValue()).getName());
        row.getStyleAttributes().setBackground(Color.green);
    }

    private void deleteData() throws EASBizException, BOSException {
        if (this.deleteIDs.size() > 0) {
            Object[] idSet = this.deleteIDs.toArray();
            ObjectStringPK[] pks = new ObjectStringPK[idSet.length];
            for (int i = 0; i < idSet.length; ++i) {
                ObjectStringPK pk;
                pks[i] = pk = new ObjectStringPK(idSet[i].toString());
            }
            ItemMapFactory.getRemoteInstance().delete((IObjectPK[])pks);
        }
    }

    protected String getRptItemName(String colName, IRow row, boolean NameOrNum) {
        String name = "";
        if (row.getCell(colName).getValue() != null) {
            name = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof RPTItemInfo) {
                name = ((RPTItemInfo)row.getCell(colName).getValue()).getName();
                if (NameOrNum) {
                    name = ((RPTItemInfo)row.getCell(colName).getValue()).getName();
                }
            } else {
                name = NameOrNum ? (StringUtils.isEmpty((String)((String)this.rptItemCollection.get(name))) ? name : (String)this.rptItemCollection.get(name)) : name;
            }
        }
        return name;
    }

    @Override
    protected void saveData() throws Exception {
        CoreBaseCollection cbColl = new CoreBaseCollection();
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            String itemNum = this.getRptItemName("rptItemNum", row, true);
            String itemName = row.getCell("rptItemName").getValue() == null ? "" : row.getCell("rptItemName").getValue().toString();
            String dataElement = this.getDataElementNum("dataElement", row);
            String jiuQiNumber = row.getCell("jiuQiIndexNum").getValue() == null ? null : row.getCell("jiuQiIndexNum").getValue().toString();
            ItemMapInfo info = new ItemMapInfo();
            if (row.getCell("jiuQiIndexNum").getUserObject() != null) {
                info.put("id", row.getCell("jiuQiIndexNum").getUserObject());
            }
            info.put("number", itemNum);
            info.setName(itemName);
            info.put("dataTypeName", dataElement);
            info.put("JQNumber", jiuQiNumber);
            info.put("JQName", row.getCell("jiuQiIndexName").getValue());
            info.put("JQTxtName", row.getCell("jiuQiTextNum").getValue());
            info.put("JQTxtName", row.getCell("jiuQiTextName").getValue());
            info.put("rptNumber", row.getCell("rptTemplateNum").getValue());
            info.put("rptName", row.getCell("rptTemplateName").getValue());
            if (this.saveMappingIndex.contains(itemNum + " " + dataElement + " " + jiuQiNumber)) continue;
            this.saveMappingIndex.add(itemNum + " " + dataElement + " " + jiuQiNumber);
            cbColl.add((CoreBaseInfo)info);
        }
        try {
            this.deleteData();
            ItemMapFactory.getRemoteInstance().saveBatchData(cbColl);
            this.deleteIDs = new HashSet();
            this.deleteMappingIndex = new ArrayList<String>();
            this.showSaveSuccess();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void showSaveSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource", (String)"saveOk"));
        this.setNextMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource", (String)"saveOk"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    @Override
    protected String getDataElementNum(String colName, IRow row) {
        String number = "";
        if (row.getCell(colName).getValue() != null) {
            number = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof DataElementInfo) {
                number = ((DataElementInfo)row.getCell(colName).getValue()).getName();
            }
        }
        return number;
    }

    @Override
    protected void afterRemoveRow(IRow row) {
        String jiuQiNumber;
        String itemNum = this.getRptItemName("rptItemNum", row, true);
        String dataElement = row.getCell("dataElement").getValue() == null ? null : row.getCell("dataElement").getValue().toString();
        String string = jiuQiNumber = row.getCell("jiuQiIndexNum").getValue() == null ? null : row.getCell("jiuQiIndexNum").getValue().toString();
        if (row.getCell("jiuQiIndexNum").getUserObject() != null) {
            String id = (String)row.getCell("jiuQiIndexNum").getUserObject();
            this.deleteIDs.add(id);
            this.deleteMappingIndex.add(itemNum + " " + dataElement + " " + jiuQiNumber);
        }
    }

    @Override
    protected void onSheetActive(Sheet sourceSheet, Sheet targetSheet, boolean istargetBook) {
        List<String> itemDataElemants = new ArrayList<String>();
        if (this.sheetIndexMapping.get(targetSheet) != null) {
            itemDataElemants = this.sheetIndexMapping.get(targetSheet);
        } else if (istargetBook) {
            this.setSheetStyle(targetSheet, itemDataElemants, true);
            this.sheetIndexMapping.put(targetSheet, itemDataElemants);
        }
        this.setSheetStyle(sourceSheet, itemDataElemants, false);
        if (istargetBook) {
            this.sourceSpreedContainer.repaint();
        }
    }

    private void setSheetStyle(Sheet sheet, List<String> itemDataElemants, boolean istargetTemplate) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                Object value = sheet.getRange(i, j).getUserObject("ITEM");
                if (istargetTemplate) {
                    value = sheet.getRange(i, j).getValue().getValue();
                    if (value == null || !this.listUIJiuQiIndexMapping.containsKey(value.toString())) continue;
                    this.setCellStyle(sheet.getCell(i, j, false));
                    itemDataElemants.add(this.listUIJiuQiIndexMapping.get(value.toString()));
                    continue;
                }
                if (value == null) continue;
                ItemFormula rptF = (ItemFormula)value;
                String rptItemNumber = rptF.getItemNumber();
                String dataElemantName = ((DataElementInfo)this.dataElementCollection.get(rptF.getDataElementNumber())).getNumber();
                if (itemDataElemants != null && itemDataElemants.size() > 0 && itemDataElemants.contains(rptItemNumber + dataElemantName)) {
                    if (!this.cellStyleMap.containsKey(sheet.getCell(i, j, false))) {
                        this.cellStyleMap.put(sheet.getCell(i, j, false), sheet.getCell(i, j, false).getSSA());
                    }
                    this.setCellStyle(sheet.getCell(i, j, false));
                    continue;
                }
                if (this.cellStyleMap.get(sheet.getCell(i, j, false)) == null) continue;
                sheet.getCell(i, j, false).setSSA(this.cellStyleMap.get(sheet.getCell(i, j, false)));
            }
        }
    }

    private void setCellStyle(Cell cell) {
        if (cell != null) {
            StyleAttributes sa = Styles.getEmptySA();
            sa.setBackground(Color.orange);
            ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
            cell.setSSA(ssa);
        }
    }

    @Override
    protected boolean hasNoSaveData() {
        if (this.deleteMappingIndex.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            String jiuQiNumber;
            IRow row = this.mappingTable.getRow(i);
            String itemNum = this.getRptItemName("rptItemNum", row, true);
            String dataElement = row.getCell("dataElement").getValue() == null ? null : row.getCell("dataElement").getValue().toString();
            String string = jiuQiNumber = row.getCell("jiuQiIndexNum").getValue() == null ? null : row.getCell("jiuQiIndexNum").getValue().toString();
            if (this.saveMappingIndex.contains(itemNum + " " + dataElement + " " + jiuQiNumber)) continue;
            return true;
        }
        return false;
    }
}

