/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.IReportPara;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.OrgMapFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.OrgMapInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaCollection;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptUplFacadeFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractOrgMapListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.OFileFilter;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.ReportParaEditUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

public class OrgMapListUI
extends AbstractOrgMapListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgMapListUI.class);
    private static final String COL_ID = "id";
    private static final String COL_OrgNumber = "orgNumber";
    private static final String COL_OrgName = "orgName";
    private static final String COL_RptType = "rptType";
    private static final String COL_JQNumber = "JQNumber";
    private static final String COL_JQName = "JQName";
    private static final String COL_RptScheme = "rptScheme";
    private Map dataRowIndexMap = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgMapFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OrgMapInfo objectValue = new OrgMapInfo();
        return objectValue;
    }

    protected void getDataFirsetTime(RequestRowSetEvent e) {
        super.getDataFirsetTime(e);
        this.dataRowIndexMap = this.getDataRowIndex();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initData();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getColumn(COL_JQNumber).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_JQName).getStyleAttributes().setLocked(false);
        this.btnParaSet.setEnabled(true);
    }

    private Map getDataRowIndex() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (this.tblMain.getRowCount() == 0) {
            return map;
        }
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(COL_OrgNumber).getValue() == null) continue;
            String orgNumber = (String)row.getCell(COL_OrgNumber).getValue();
            BizEnumValueDTO rptScheme = (BizEnumValueDTO)row.getCell(COL_RptScheme).getValue();
            String key = orgNumber + " " + rptScheme;
            map.put(key, row.getRowIndex());
        }
        return map;
    }

    private void initData() {
        try {
            OrgMapFactory.getRemoteInstance().initData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HashMap actionMap = this.getActionManager().getActionSet();
        Object[] keySet = actionMap.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            ItemAction action = (ItemAction)actionMap.get(keySet[i]);
            action.setVisible(false);
        }
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddUpdate.setVisible(true);
        this.btnAddUpdate.setEnabled(true);
        this.btnParaSet.setVisible(true);
        this.btnParaSet.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setVisible(true);
        this.actionLocate.setVisible(true);
        this.actionQuery.setVisible(true);
        this.actionImportData.setVisible(true);
        this.actionExport.setVisible(true);
        this.actionSave.setEnabled(true);
        this.actionSave.setVisible(true);
        this.actionParaSet.setVisible(true);
        this.actionParaSet.setEnabled(true);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_OrgNumber, COL_OrgName, COL_JQNumber, COL_JQName};
        return locateNames;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorterColl = viewInfo.getSorter();
        if (sorterColl.size() == 0) {
            sorterColl.add(new SorterItemInfo(COL_OrgNumber));
            sorterColl.add(new SorterItemInfo(COL_OrgName));
            sorterColl.add(new SorterItemInfo(COL_JQNumber));
            sorterColl.add(new SorterItemInfo(COL_JQName));
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        sorterColl.resetValue();
        return exec;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new OFileFilter(".xls", " *.xls | xls"));
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.showOpenDialog((Component)((Object)this));
        File file = jfc.getSelectedFile();
        if (file != null) {
            this.parseXlsFile(file);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveData();
    }

    protected void saveData() {
        if (this.tblMain.getRowCount() > 0) {
            CoreBaseCollection cbColl = new CoreBaseCollection();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                OrgMapInfo info = new OrgMapInfo();
                for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                    if (!this.tblMain.getColumnKey(j).equals(COL_ID) && !this.tblMain.getColumnKey(j).equals(COL_JQNumber) && !this.tblMain.getColumnKey(j).equals(COL_JQName)) continue;
                    info.put(this.tblMain.getColumnKey(j), row.getCell(j).getValue());
                }
                cbColl.add((CoreBaseInfo)info);
            }
            try {
                OrgMapFactory.getRemoteInstance().saveBatchData(cbColl);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.showSaveSuccess();
        }
    }

    protected void showSaveSuccess() {
        this.setMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.setNextMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseXlsFile(File selectedFile) throws Exception {
        logger.info((Object)"parseXlsFile");
        if (!selectedFile.exists()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectFileNotExist"));
            SysUtil.abort();
        }
        POIFSFileSystem fs = null;
        try (FileInputStream fis = null;){
            HSSFRow row;
            int i;
            fis = new FileInputStream(selectedFile);
            fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            int sheetCount = workBook.getNumberOfSheets();
            if (sheetCount <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            for (i = 0; i < rows; ++i) {
                short tpcols;
                row = sheet.getRow(i);
                if (row == null || (tpcols = row.getLastCellNum()) <= cols) continue;
                cols = tpcols;
            }
            if (cols > this.tblMain.getColumnCount()) {
                cols = this.tblMain.getColumnCount();
            }
            if (rows == 0 || cols == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            for (i = 1; i < rows; ++i) {
                Object obj;
                HSSFCell cell;
                row = sheet.getRow(i);
                if (row == null || (cell = row.getCell(0)) == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String orgNumber = obj.toString();
                cell = row.getCell(3);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String JQNumber = obj.toString();
                cell = row.getCell(4);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String JQName = obj.toString();
                cell = row.getCell(5);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String rptScheme = obj.toString();
                String key = orgNumber + " " + rptScheme;
                if (!this.dataRowIndexMap.containsKey(key) || !(this.dataRowIndexMap.get(key) instanceof Integer)) continue;
                int rowIndex = (Integer)this.dataRowIndexMap.get(key);
                IRow tblRow = this.tblMain.getRow(rowIndex);
                tblRow.getCell(COL_JQNumber).setValue((Object)JQNumber);
                tblRow.getCell(COL_JQName).setValue((Object)JQName);
            }
        }
    }

    private Object getHSSFCellValue(HSSFCell cell) {
        Object value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).toString();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().toString();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case BLANK: {
                value = null;
                break;
            }
            case ERROR: {
                value = null;
                break;
            }
            default: {
                value = cell.getRichStringCellValue().toString();
            }
        }
        return value;
    }

    @Override
    public void actionParaSet_actionPerformed(ActionEvent e) throws Exception {
        IReportPara iReportPara = ReportParaFactory.getRemoteInstance();
        ReportParaCollection coll = iReportPara.getReportParaCollection();
        if (coll != null && coll.size() > 0) {
            ReportParaInfo ReportParaInfo2 = coll.get(0);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)ReportParaInfo2.getId());
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("ReportParaEditUI", (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.jiuqiInterface.client.ReportParaEditUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportParaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportParaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionAddUpdate_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = RptUplFacadeFactory.getRemoteInstance().addUpdateOrgMap();
        if (flag) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.orgMapUpdateSucess"));
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.orgMapUpdatefail"));
        }
    }
}

