/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptLogFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptLogInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractRptLogListUI;
import com.kingdee.eas.framework.ICoreBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptLogListUI
extends AbstractRptLogListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptLogListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("orgTree.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
    }

    protected FilterInfo getDefaultFilterForQuery() {
        OrgUnitInfo[] orgUnits = null;
        try {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            if (user != null && user.getId() != null) {
                orgUnits = RptLogFactory.getRemoteInstance().getOrgUnits("csl_rptlog_view", user.getId().toString());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FilterInfo filter = new FilterInfo();
        if (orgUnits != null && orgUnits.length > 0) {
            FilterInfo tempFilter = new FilterInfo();
            tempFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.OrgUnitToSet(orgUnits), CompareType.INCLUDE));
            try {
                filter.mergeFilter(tempFilter, "and");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filter;
    }

    private Set OrgUnitToSet(OrgUnitInfo[] orgUnits) {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < orgUnits.length; ++i) {
            OrgUnitInfo orgUnit = orgUnits[i];
            ids.add(orgUnit.getId().toString());
        }
        return ids;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptLogFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        RptLogInfo objectValue = new RptLogInfo();
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HashMap actionMap = this.getActionManager().getActionSet();
        Object[] keySet = actionMap.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            ItemAction action = (ItemAction)actionMap.get(keySet[i]);
            action.setVisible(false);
        }
        this.btnRemove.setVisible(true);
        this.actionRemove.setEnabled(true);
        this.actionRemove.setVisible(true);
        this.btnRefresh.setVisible(true);
        this.actionRefresh.setEnabled(true);
        this.actionRefresh.setVisible(true);
        this.actionQuery.setEnabled(true);
        this.actionQuery.setVisible(true);
    }

    protected String getEditUIName() {
        return "";
    }
}

