/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.IItemMap;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ItemMapFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptMapFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptMapInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractRptMapListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.OFileFilter;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

public class RptMapListUI
extends AbstractRptMapListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptMapListUI.class);
    private static final String COL_ID = "id";
    private static final String COL_RptNumber = "rptNumber";
    private static final String COL_RptName = "rptName";
    private static final String COL_SheetName = "sheetName";
    private static final String COL_JQNumber = "JQNumber";
    private static final String COL_JQName = "JQName";
    private Set delIDs = new HashSet();
    Map<String, String> rptDataMap = null;
    Map<String, Map<String, String>> allDataMap = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptMapFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        RptMapInfo objectValue = new RptMapInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(COL_RptNumber).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_RptName).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_SheetName).getStyleAttributes().setLocked(true);
        this.initData();
        this.fillNoSaveDataToTable();
    }

    private void fillNoSaveDataToTable() {
        if (this.allDataMap == null) {
            return;
        }
        Set<String> rptNumberKeySet = this.allDataMap.keySet();
        for (String rptnumber : rptNumberKeySet) {
            Map<String, String> sheetMap = this.allDataMap.get(rptnumber);
            Set<String> sheetNameSet = sheetMap.keySet();
            for (String sheetName : sheetNameSet) {
                if (!this.isFill(rptnumber + sheetName)) continue;
                IRow tblRow = this.tblMain.addRow();
                this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
                tblRow.getCell(COL_RptNumber).setValue((Object)rptnumber);
                tblRow.getCell(COL_RptName).setValue((Object)sheetMap.get(sheetName));
                tblRow.getCell(COL_SheetName).setValue((Object)sheetName);
            }
        }
    }

    private boolean isFill(String key) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String tableKey;
            IRow row = this.tblMain.getRow(i);
            String string = tableKey = row.getCell(COL_RptNumber).getValue() == null ? "null" : row.getCell(COL_RptNumber).getValue().toString() + row.getCell(COL_SheetName).getValue();
            if (!tableKey.equals(key)) continue;
            return false;
        }
        return true;
    }

    private void initData() throws Exception {
        IItemMap itemInt = ItemMapFactory.getRemoteInstance();
        this.rptDataMap = itemInt.getRptMap();
        this.allDataMap = RptMapFactory.getRemoteInstance().getAllData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HashMap actionMap = this.getActionManager().getActionSet();
        Object[] keySet = actionMap.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            ItemAction action = (ItemAction)actionMap.get(keySet[i]);
            action.setVisible(false);
        }
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.actionLocate.setVisible(true);
        this.actionQuery.setVisible(true);
        this.actionSave.setVisible(true);
        this.actionImportData.setVisible(true);
        this.actionExport.setVisible(true);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.delData();
        this.saveData();
        this.refreshList();
    }

    protected void delData() {
        if (this.delIDs.size() > 0) {
            Object[] idSet = this.delIDs.toArray();
            ObjectStringPK[] pks = new ObjectStringPK[idSet.length];
            for (int i = 0; i < idSet.length; ++i) {
                ObjectStringPK pk;
                if (idSet[i] == null) continue;
                pks[i] = pk = new ObjectStringPK(idSet[i].toString());
            }
            try {
                RptMapFactory.getRemoteInstance().delete((IObjectPK[])pks);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void saveData() {
        if (this.tblMain.getRowCount() > 0) {
            CoreBaseCollection cbColl = new CoreBaseCollection();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                RptMapInfo info = new RptMapInfo();
                for (int j = 0; j < this.tblMain.getColumnCount(); ++j) {
                    info.put(this.tblMain.getColumnKey(j), row.getCell(j).getValue());
                }
                cbColl.add((CoreBaseInfo)info);
            }
            try {
                RptMapFactory.getRemoteInstance().saveBatchData(cbColl);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.showSaveSuccess();
        }
    }

    protected void showSaveSuccess() {
        this.setMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.setNextMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new OFileFilter(".xls", " *.xls | xls"));
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.showOpenDialog((Component)((Object)this));
        File file = jfc.getSelectedFile();
        if (file != null) {
            this.parseXlsFile(file);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_RptNumber, COL_RptName, COL_SheetName, COL_JQNumber, COL_JQName};
        return locateNames;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorterColl = viewInfo.getSorter();
        if (sorterColl.size() == 0) {
            sorterColl.add(new SorterItemInfo(COL_RptNumber));
            sorterColl.add(new SorterItemInfo(COL_RptName));
            sorterColl.add(new SorterItemInfo(COL_SheetName));
            sorterColl.add(new SorterItemInfo(COL_JQNumber));
            sorterColl.add(new SorterItemInfo(COL_JQName));
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        sorterColl.resetValue();
        return exec;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseXlsFile(File selectedFile) throws Exception {
        logger.info((Object)"parseXlsFile");
        if (!selectedFile.exists()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectFileNotExist"));
            SysUtil.abort();
        }
        POIFSFileSystem fs = null;
        try (FileInputStream fis = null;){
            HSSFRow row;
            int i;
            fis = new FileInputStream(selectedFile);
            fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            int sheetCount = workBook.getNumberOfSheets();
            if (sheetCount <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            for (i = 0; i < rows; ++i) {
                short tpcols;
                row = sheet.getRow(i);
                if (row == null || (tpcols = row.getLastCellNum()) <= cols) continue;
                cols = tpcols;
            }
            if (cols > this.tblMain.getColumnCount()) {
                cols = this.tblMain.getColumnCount();
            }
            if (rows == 0 || cols == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            for (i = this.tblMain.getRowCount() - 1; i > -1; --i) {
                row = this.tblMain.getRow(i);
                if (row.getCell(COL_ID).getValue() == null) continue;
                String id = (String)row.getCell(COL_ID).getValue();
                this.delIDs.add(id);
                this.tblMain.removeRow(i);
            }
            for (i = 1; i < rows; ++i) {
                Object obj;
                HSSFCell cell;
                row = sheet.getRow(i);
                if (row == null || (cell = row.getCell(0)) == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String rptNumber = obj.toString();
                if (!this.allDataMap.containsKey(rptNumber)) {
                    String str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.reportNotNumber"), i, rptNumber);
                    MsgBox.showInfo((Component)((Object)this), (String)str);
                    SysUtil.abort();
                    continue;
                }
                Map<String, String> sheetMap = this.allDataMap.get(rptNumber);
                cell = row.getCell(2);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String sheetName = obj.toString();
                if (!sheetMap.containsKey(sheetName)) {
                    String str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNotExist"), i, sheetName, rptNumber);
                    MsgBox.showInfo((Component)((Object)this), (String)str);
                    SysUtil.abort();
                    continue;
                }
                IRow tblRow = this.tblMain.addRow();
                this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
                tblRow.getCell(COL_RptNumber).setValue((Object)rptNumber);
                tblRow.getCell(COL_RptName).setValue((Object)this.rptDataMap.get(rptNumber));
                tblRow.getCell(COL_SheetName).setValue((Object)sheetName);
                cell = row.getCell(3);
                if (cell != null) {
                    tblRow.getCell(COL_JQNumber).setValue(this.getHSSFCellValue(cell));
                }
                if ((cell = row.getCell(4)) == null) continue;
                tblRow.getCell(COL_JQName).setValue(this.getHSSFCellValue(cell));
            }
        }
    }

    private Object getHSSFCellValue(HSSFCell cell) {
        Object value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).toString();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().toString();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case BLANK: {
                value = null;
                break;
            }
            case ERROR: {
                value = null;
                break;
            }
            default: {
                value = cell.getRichStringCellValue().toString();
            }
        }
        return value;
    }
}

