/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboBoxItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptSchemeEnum;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptSelFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptSelInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractRptSelListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.OFileFilter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

public class RptSelListUI
extends AbstractRptSelListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptSelListUI.class);
    private static final String COL_ID = "id";
    private static final String COL_RptNumber = "rptNumber";
    private static final String COL_RptName = "rptName";
    private static final String COL_SheetName = "sheetName";
    private static final String COL_Value = "value";
    private static final String COL_RptType = "rptType";
    private static final String COL_RptTypeID = "rptTypeID";
    private int tblRowCnt = 0;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RptSelFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        RptSelInfo objectValue = new RptSelInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getColumn(COL_Value).getStyleAttributes().setLocked(false);
        this.actionRefresh_actionPerformed(null);
        KDComboBox cmb = new KDComboBox();
        cmb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.RptSchemeEnum").toArray());
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JComboBox)cmb);
        this.tblMain.getColumn(COL_RptType).setEditor((ICellEditor)editor);
        for (int i = 0; i < this.tblRowCnt; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(COL_Value).getValue() != null) {
                Boolean value = (Boolean)row.getCell(COL_Value).getValue();
                row.getCell(COL_RptType).getStyleAttributes().setLocked(value == false);
            }
            if (!(row.getCell(COL_RptType).getValue() instanceof BizEnumValueDTO)) continue;
            BizEnumValueDTO rptType = (BizEnumValueDTO)row.getCell(COL_RptType).getValue();
            if (rptType.equals((Object)RptPeriodTypeEnum.getEnum((int)3))) {
                row.getCell(COL_RptType).setValue((Object)RptSchemeEnum.MONTH);
                continue;
            }
            if (!rptType.equals((Object)RptPeriodTypeEnum.getEnum((int)6))) continue;
            row.getCell(COL_RptType).setValue((Object)RptSchemeEnum.YEAR);
        }
    }

    protected void getDataFirsetTime(RequestRowSetEvent e) {
        super.getDataFirsetTime(e);
        this.tblRowCnt = this.tblMain.getRowCount();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected void execQuery() {
        super.execQuery();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Boolean value;
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(COL_Value).getValue() == null || !(value = (Boolean)row.getCell(COL_Value).getValue()).booleanValue() || row.getCell(COL_RptType).getValue() != null) continue;
            String str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptTypeNull"), i + 1);
            MsgBox.showInfo((Component)((Object)this), (String)str);
            this.tblMain.getEditManager().editCellAt(i, this.tblMain.getColumnIndex(COL_RptType));
            SysUtil.abort();
        }
        this.saveData();
    }

    protected void saveData() {
        if (this.tblMain.getRowCount() > 0) {
            CoreBaseCollection cbColl = new CoreBaseCollection();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                RptSelInfo info = new RptSelInfo();
                info.put(COL_ID, row.getCell(COL_ID).getValue());
                if (row.getCell(COL_Value).getValue() != null) {
                    Boolean value = (Boolean)row.getCell(COL_Value).getValue();
                    info.put(COL_Value, value);
                }
                if (row.getCell(COL_RptType).getValue() != null && row.getCell(COL_RptType).getValue() instanceof RptSchemeEnum) {
                    RptSchemeEnum rptScheme = (RptSchemeEnum)((Object)row.getCell(COL_RptType).getValue());
                    info.put(COL_RptType, rptScheme.getValue());
                } else if (row.getCell(COL_RptType).getValue() == null) {
                    info.put(COL_RptType, null);
                }
                info.put(COL_RptTypeID, row.getCell(COL_RptTypeID).getValue());
                cbColl.add((CoreBaseInfo)info);
            }
            try {
                RptSelFactory.getRemoteInstance().saveBatchData(cbColl);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.showSaveSuccess();
        }
    }

    protected void showSaveSuccess() {
        this.setMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_TemporarilySave_OK"));
        this.setNextMessageText(" " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        this.setShowMessagePolicy(0);
        this.setIsShowTextOnly(false);
        this.showMessage();
    }

    private void initData() {
        try {
            RptSelFactory.getRemoteInstance().initData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        HashMap actionMap = this.getActionManager().getActionSet();
        Object[] keySet = actionMap.keySet().toArray();
        for (int i = 0; i < keySet.length; ++i) {
            ItemAction action = (ItemAction)actionMap.get(keySet[i]);
            action.setVisible(false);
        }
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImportData.setVisible(true);
        this.btnImportData.setEnabled(true);
        this.btnInitialize.setVisible(true);
        this.btnInitialize.setEnabled(true);
        this.btnExport.setVisible(true);
        this.btnExport.setEnabled(true);
        this.actionLocate.setVisible(true);
        this.actionQuery.setVisible(true);
        this.actionSave.setEnabled(true);
        this.actionSave.setVisible(true);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_RptNumber, COL_RptName, COL_SheetName, COL_RptType, COL_RptTypeID};
        return locateNames;
    }

    protected String getEditUIName() {
        return "";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemCollection sorterColl = viewInfo.getSorter();
        if (sorterColl.size() == 0) {
            sorterColl.add(new SorterItemInfo(COL_RptNumber));
            sorterColl.add(new SorterItemInfo(COL_RptName));
            sorterColl.add(new SorterItemInfo(COL_SheetName));
            sorterColl.add(new SorterItemInfo(COL_Value));
            sorterColl.add(new SorterItemInfo(COL_RptType));
            sorterColl.add(new SorterItemInfo(COL_RptTypeID));
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        sorterColl.resetValue();
        return exec;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.tblControl(rowIndex, colIndex);
    }

    private void tblControl(int rowIndex, int colIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (this.tblMain.getColumnKey(colIndex).equals(COL_Value) && row.getCell(COL_Value).getValue() != null) {
            Boolean value = (Boolean)row.getCell(COL_Value).getValue();
            row.getCell(COL_RptType).getStyleAttributes().setLocked(value == false);
            if (!value.booleanValue()) {
                row.getCell(COL_RptType).setValue(null);
                row.getCell(COL_RptTypeID).setValue(null);
            }
        }
        if (this.tblMain.getColumnKey(colIndex).equals(COL_RptType) && row.getCell(COL_RptType).getValue() != null) {
            if (row.getCell(COL_RptType).getValue() instanceof KDComboBoxItem) {
                row.getCell(COL_RptTypeID).setValue(null);
            } else {
                RptSchemeEnum rptScheme = (RptSchemeEnum)((Object)row.getCell(COL_RptType).getValue());
                if (RptSchemeEnum.YEAR.equals((Object)rptScheme)) {
                    row.getCell(COL_RptTypeID).setValue((Object)"N");
                } else if (RptSchemeEnum.MONTH.equals((Object)rptScheme)) {
                    row.getCell(COL_RptTypeID).setValue((Object)"Y");
                }
            }
        }
    }

    @Override
    public void actionInitialize_actionPerformed(ActionEvent e) throws Exception {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.comfireInitData")))) {
            RptSelFactory.getRemoteInstance().initData();
            this.refreshList();
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        JFileChooser jfc = new JFileChooser();
        jfc.addChoosableFileFilter(new OFileFilter(".xls", " *.xls | xls"));
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.showOpenDialog((Component)((Object)this));
        File file = jfc.getSelectedFile();
        if (file != null) {
            this.parseXlsFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseXlsFile(File selectedFile) throws Exception {
        logger.info((Object)"parseXlsFile");
        if (!selectedFile.exists()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectFileNotExist"));
            SysUtil.abort();
        }
        POIFSFileSystem fs = null;
        try (FileInputStream fis = null;){
            String str;
            HSSFRow row;
            int i;
            fis = new FileInputStream(selectedFile);
            fs = new POIFSFileSystem((InputStream)fis);
            HSSFWorkbook workBook = new HSSFWorkbook(fs);
            int sheetCount = workBook.getNumberOfSheets();
            if (sheetCount <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            int cols = 0;
            for (i = 0; i < rows; ++i) {
                short tpcols;
                row = sheet.getRow(i);
                if (row == null || (tpcols = row.getLastCellNum()) <= cols) continue;
                cols = tpcols;
            }
            if (cols > this.tblMain.getColumnCount()) {
                cols = this.tblMain.getColumnCount();
            }
            if (rows == 0 || cols == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.excelNotData"));
                SysUtil.abort();
            }
            for (i = 1; i < rows; ++i) {
                String str2;
                String str3;
                Object obj;
                row = sheet.getRow(i);
                if (row == null) continue;
                HSSFCell cell = row.getCell(0);
                if (cell == null) {
                    String str4 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNumberNotNull"), i + 1);
                    MsgBox.showInfo((String)str4);
                    SysUtil.abort();
                }
                if ((obj = this.getHSSFCellValue(cell)) == null) {
                    str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNumberNotNull"), i + 1);
                    MsgBox.showInfo((String)str);
                    SysUtil.abort();
                }
                String rptNumber = obj.toString();
                cell = row.getCell(1);
                if (cell == null) {
                    str3 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNumberNotNull"), i + 1);
                    MsgBox.showInfo((String)str3);
                    SysUtil.abort();
                }
                if ((obj = this.getHSSFCellValue(cell)) == null) {
                    str3 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowRptNameNotNull"), i + 1);
                    MsgBox.showInfo((String)str3);
                    SysUtil.abort();
                }
                String rptName = obj.toString();
                cell = row.getCell(2);
                if (cell == null || (obj = this.getHSSFCellValue(cell)) == null) continue;
                String sheetName = obj.toString();
                cell = row.getCell(3);
                if (cell == null) {
                    str2 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowIsUpNotNull"), i + 1);
                    MsgBox.showInfo((String)str2);
                    SysUtil.abort();
                }
                if ((obj = this.getHSSFCellValue(cell)) == null) {
                    str2 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowIsUpNotNull"), i + 1);
                    MsgBox.showInfo((String)str2);
                    SysUtil.abort();
                }
                String yesNo = obj.toString();
                if (!EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.yes").equals(yesNo) && !EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.no").equals(yesNo)) {
                    String str5 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.yesNoDataError"), i + 1, yesNo);
                    MsgBox.showInfo((String)str5);
                    SysUtil.abort();
                }
                String rptType = "";
                if (EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.yes").equals(yesNo)) {
                    String str6;
                    cell = row.getCell(4);
                    if (cell == null) {
                        str6 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptTypeNotNull"), i + 1);
                        MsgBox.showInfo((String)str6);
                        SysUtil.abort();
                    }
                    if ((obj = this.getHSSFCellValue(cell)) == null) {
                        str6 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptTypeNotNull"), i + 1);
                        MsgBox.showInfo((String)str6);
                        SysUtil.abort();
                    }
                    rptType = obj.toString();
                    if (!RptPeriodTypeEnum.getEnum((int)6).getAlias().equals(rptType) && !RptPeriodTypeEnum.getEnum((int)3).getAlias().equals(rptType)) {
                        str6 = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptTypeDataError"), i + 1, rptType);
                        MsgBox.showInfo((String)str6);
                        SysUtil.abort();
                    }
                }
                boolean flag = false;
                for (int j = 0; j < this.tblMain.getRowCount(); ++j) {
                    IRow oldRow = this.tblMain.getRow(j);
                    String oldRptNumber = (String)oldRow.getCell(COL_RptNumber).getValue();
                    String oldRptName = (String)oldRow.getCell(COL_RptName).getValue();
                    String oldSheetName = (String)oldRow.getCell(COL_SheetName).getValue();
                    if (!oldRptNumber.equals(rptNumber) || !oldRptName.equals(rptName) || !oldSheetName.equals(sheetName)) continue;
                    flag = true;
                    if (EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.yes").equals(yesNo)) {
                        oldRow.getCell(COL_Value).setValue((Object)true);
                        if (rptType.equals(RptPeriodTypeEnum.getEnum((int)6).getAlias())) {
                            oldRow.getCell(COL_RptType).setValue((Object)RptSchemeEnum.YEAR);
                            oldRow.getCell(COL_RptTypeID).setValue((Object)"N");
                            break;
                        }
                        oldRow.getCell(COL_RptType).setValue((Object)RptSchemeEnum.MONTH);
                        oldRow.getCell(COL_RptTypeID).setValue((Object)"Y");
                        break;
                    }
                    oldRow.getCell(COL_Value).setValue((Object)false);
                    oldRow.getCell(COL_RptType).setValue(null);
                    oldRow.getCell(COL_RptTypeID).setValue(null);
                    break;
                }
                if (flag) continue;
                System.out.println(rptNumber + " " + rptName + " " + sheetName);
            }
            int uCount = 0;
            for (int k = 0; k < this.tblMain.getRowCount(); ++k) {
                IRow oldRow = this.tblMain.getRow(k);
                if (!((Boolean)oldRow.getCell(COL_Value).getValue()).booleanValue()) continue;
                ++uCount;
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectRptOk"));
            Object nexts = null;
            Object msg = null;
            Object[] objs = null;
            objs = new Object[]{new Integer(20), new Integer(10)};
            str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.selectRptDataCount"), this.tblMain.getRowCount(), uCount);
            this.setNextMessageText(str);
            this.showMessage();
        }
    }

    private Object getHSSFCellValue(HSSFCell cell) {
        Object value = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()).toString();
                    break;
                }
                value = new BigDecimal(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().toString();
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case BLANK: {
                value = null;
                break;
            }
            case ERROR: {
                value = null;
                break;
            }
            default: {
                value = cell.getRichStringCellValue().toString();
            }
        }
        return value;
    }
}

