/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.dynamic.client.GroupMultiRptProcessUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.IReportPara;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.IRptUplFacade;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaCollection;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ReportParaInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptUplFacadeFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.AbstractRptUplListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.ReportParaEditUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.RptLogListUI;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.client.RptUplFilterUI;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RptUplListUI
extends AbstractRptUplListUI {
    private static final Logger logger = CoreUIObject.getLogger(RptUplListUI.class);
    RptUplFilterUI filterUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptUplFilterUI();
        }
        return this.filterUI;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return (ICommRptBase)RptUplFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.setTableSort(this.tblMain);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("orgTree").getStyleAttributes().setHided(true);
        this.btnParaSet.setVisible(false);
    }

    private void setTableSort(KDTable table) {
        table.setColumnMoveable(true);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)table, (int)0);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).setSortable(true);
        }
        KDTSortManager sm = new KDTSortManager(table);
        sm.setSortAuto(true);
    }

    protected void query() {
        this.tblMain.removeRows();
        this.fillData();
    }

    private void fillData() {
        try {
            IRowSet rs = RptUplFacadeFactory.getRemoteInstance().getData(this.params);
            String[] colKeys = new String[this.tblMain.getColumnCount()];
            for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
                colKeys[i] = this.tblMain.getColumnKey(i);
            }
            RptUplListUI.fillDataOnTableByColName(this.tblMain, rs, colKeys);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public static void fillDataOnTableByColName(KDTable table, IRowSet rs, String[] colNames) throws Exception {
        int rsColSize = rs.getMetaData().getColumnCount();
        int tableColSize = table.getColumnCount();
        while (rs.next()) {
            IRow row = table.addRow();
            for (int i = 0; i < rsColSize && i < tableColSize; ++i) {
                row.getCell(colNames[i]).setValue(rs.getObject(i + 1));
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.tblMain.getColumn("uplDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                RptUplListUI.this.tblMain_tableClicked(e);
            }
        });
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) {
        try {
            if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
                this.openReport(OprtState.VIEW);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void openReport(String state) throws Exception {
        IRow row;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((row = this.tblMain.getRow(this.tblMain.getSelectManager().get().getTop())).getCell("rptID").getValue() == null) {
            return;
        }
        if (row.getCell("companyID").getValue() == null) {
            return;
        }
        String id = (String)row.getCell("rptID").getValue();
        String companyID = (String)row.getCell("companyID").getValue();
        FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(companyID));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("publishedStatus"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("committedStatus"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("data.*"));
        CslReportInfo report = this.getReportInfo(id, sic);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"CanEdit", (Object)Boolean.TRUE);
        uiContext.put((Object)"ISQUERYBUDGET", (Object)new Integer(CslRptUtil.isQueryBudget()));
        uiContext.put((Object)"company", (Object)orgUnit);
        String processUI = null;
        processUI = report.getSourceType() == RptSrcTypeEnum.NORMAL || report.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || report.getSourceType() == RptSrcTypeEnum.COMMITREPORT ? GroupRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.SUM || report.getSourceType() == RptSrcTypeEnum.DYNAMICSUMREPORT ? SumRptProcessUI.class.getName() : (report.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT ? GroupMultiRptProcessUI.class.getName() : CslRptProcessUI.class.getName()));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        IUIWindow window = uiFactory.create(processUI, (Map)uiContext, null, state);
        window.show();
    }

    protected CslReportInfo getReportInfo(String reportID, SelectorItemCollection selectors) throws Exception {
        ICslReport iReport = CslReportFactory.getRemoteInstance();
        return (CslReportInfo)iReport.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)reportID)), selectors);
    }

    @Override
    public void actionUpload_actionPerformed(ActionEvent e) throws Exception {
        int[] array = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            IRow row = this.tblMain.getRow(array[i]);
            String cslReportId = row.getCell("rptID").getValue().toString();
            String sheetId = row.getCell("sheetID").getValue().toString();
            IRptUplFacade iRptUplFacade = RptUplFacadeFactory.getRemoteInstance();
            String result = iRptUplFacade.createXmlStr(cslReportId, sheetId);
            if ("success".equals(result)) {
                iRptUplFacade.writeUpLoadLog(cslReportId, sheetId);
                strBuffer.append(this.getRptInfo(cslReportId, sheetId, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.uplSucess")));
                continue;
            }
            if ("ignore".equals(result)) {
                strBuffer.append(this.getRptInfo(cslReportId, sheetId, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptDataNull")));
                continue;
            }
            strBuffer.append(this.getRptInfo(cslReportId, sheetId, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.uplFail")));
        }
        this.query();
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.uplEnd"), (String)strBuffer.toString(), (int)1);
    }

    private String getRptInfo(String cslReportId, String sheetId, String result) throws BOSException, SQLException {
        String rptInfo = null;
        String sql = "select t2.fnumber,t2.fname_l2,t0.forgtreeid,t0.forgunitid,t1.fnumber as rptNumber,t0.fname as rptName,t0.fyear,t0.fperiod,t0.ftemplateid,t0.fsourceType,t1.fdynarpttype,t1.fperiodtype,t1.ftemplateType,t3.fsheetname from T_CSL_CslReport t0 inner join  T_RPT_Template t1 on t0.ftemplateid=t1.fid inner join  T_ORG_BaseUnit t2 on t0.forgunitid= t2.fid inner join  T_RPT_RPTSHEETPARA t3 on t3.freportid=t0.fid where  t0.fid = '" + cslReportId + "' and t3.fsheetid='" + sheetId + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        if (rs.next()) {
            String str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rptResult"), rs.getString("rptNumber"), rs.getString("rptName"), rs.getString("fsheetname"), result);
            rptInfo = str + "\n";
        }
        return rptInfo;
    }

    @Override
    public void actionParaSet_actionPerformed(ActionEvent e) throws Exception {
        IReportPara iReportPara = ReportParaFactory.getRemoteInstance();
        ReportParaCollection coll = iReportPara.getReportParaCollection();
        if (coll != null && coll.size() > 0) {
            ReportParaInfo ReportParaInfo2 = coll.get(0);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)ReportParaInfo2.getId());
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("ReportParaEditUI", (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.newrpt.jiuqiInterface.client.ReportParaEditUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportParaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportParaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionRptLog_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptLogListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptLogListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }
}

