/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqirpa;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.IRptReceiveFacade;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RptReceiveFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.client.DynaRangeProvider;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiTempMappingEntryCollection;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiTempMappingEntryInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiTempMappingInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ExJiuqiRptSchmInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ExportJiuqiInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RPAForJiuqiHandle {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.jiuqirpa.RPAForJiuqiHandle");
    private String resPatch = "com.kingdee.eas.fi.newrpt.jiuqirpa.MappingResource";
    public static final String rootPatchName = "C:" + File.separatorChar + "easRPAForJiuqi" + File.separatorChar;
    public static final String easReportsPatch = "easReports" + File.separatorChar;
    public static final String iniFilePatch = "iniFile" + File.separatorChar;
    public static final String splitStr = "!";
    public static final String jiuqiSplitStr = ",";
    private String defaultJiuqiOrgNumberStyle = "jqOrgNum+year+period+jqRptType";
    private Context ctx = null;
    private UserInfo userInfo = null;
    private Map viewPermissionMap = new HashMap();
    private Map<ExJiuqiRptSchmInfo, Map<String, ExportJiuqiInfo>> exportDatas = null;
    private Map<String, List<StringBuffer>> rptMappingDataTemp = new HashMap<String, List<StringBuffer>>();
    public static final String easDynaKey = "-!";
    private StringBuffer fileString = new StringBuffer();
    private StringBuffer sheetString = new StringBuffer();
    private StringBuffer cellString = new StringBuffer();
    private Book exportBook = null;
    private List<String> sheetNameList = new ArrayList<String>();
    private List<String> fileStringList = new ArrayList<String>();
    private List<String> cellStringList = new ArrayList<String>();
    private List<String> sheetStringList = new ArrayList<String>();
    private boolean forManualJiuqi = false;

    public RPAForJiuqiHandle(Context ctx, Map<ExJiuqiRptSchmInfo, Map<String, ExportJiuqiInfo>> exportDatas, UserInfo userInfo) {
        this.ctx = ctx;
        this.exportDatas = exportDatas;
        this.userInfo = userInfo;
    }

    public String exportReportAndIniFile() throws Exception {
        String forJiuqi = CSLParamUtil.getStringCslParamValue(null, (String)"forJiuqi");
        this.forManualJiuqi = "forJiuqi".equals(forJiuqi);
        ArrayList<String> jiuqiTaskNums = new ArrayList<String>();
        String jiuqiTaskStrs = null;
        Map<String, ExportJiuqiInfo> datas = null;
        CslReportCollection oneExportReports = new CslReportCollection();
        Set<ExJiuqiRptSchmInfo> schmInfoSet = this.exportDatas.keySet();
        Set<String> orgKeySet = null;
        ExportJiuqiInfo exportJiuqiInfo = null;
        String jiuqiOrgNumber = null;
        String jiuqiOrgName = null;
        String jiuqiRptType = null;
        Map<CslReportInfo, EASJiuqiTempMappingInfo> reportMappingDatas = null;
        Set<CslReportInfo> rptInfoSet = null;
        EASJiuqiTempMappingInfo easJiuqiTempMappingInfo = null;
        StringBuffer iniDataStr = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> paramKeys = new ArrayList<String>();
        for (ExJiuqiRptSchmInfo exJiuqiRptSchmInfo : schmInfoSet) {
            Object[] object = null;
            datas = this.exportDatas.get(exJiuqiRptSchmInfo);
            orgKeySet = datas.keySet();
            for (String orgKey : orgKeySet) {
                exportJiuqiInfo = datas.get(orgKey);
                reportMappingDatas = exportJiuqiInfo.getReportMappingData();
                rptInfoSet = reportMappingDatas.keySet();
                for (CslReportInfo cslReportInfo : rptInfoSet) {
                    String key = this.userInfo.getId().toString() + cslReportInfo.getOrgUnit().getId() + cslReportInfo.getSourceType();
                    if (paramKeys.contains(key)) continue;
                    paramKeys.add(key);
                    object = new Object[]{new ObjectUuidPK(this.userInfo.getId()), new ObjectUuidPK(cslReportInfo.getOrgUnit().getId()), cslReportInfo.getSourceType()};
                    params.add(object);
                }
            }
        }
        IRptReceiveFacade receiveFacade = this.ctx == null ? RptReceiveFacadeFactory.getRemoteInstance() : RptReceiveFacadeFactory.getLocalInstance((Context)this.ctx);
        this.viewPermissionMap = receiveFacade.checkViewPermission(params);
        for (ExJiuqiRptSchmInfo schmInfo : schmInfoSet) {
            datas = this.exportDatas.get(schmInfo);
            orgKeySet = datas.keySet();
            for (String orgKey : orgKeySet) {
                if (this.forManualJiuqi) {
                    this.exportBook = Book.Manager.getNewBook((String)orgKey, (int)0);
                    this.exportBook.setCalculate(false);
                    this.sheetNameList = new ArrayList<String>();
                }
                exportJiuqiInfo = datas.get(orgKey);
                jiuqiOrgNumber = exportJiuqiInfo.getJiuqiOrgNumber();
                jiuqiOrgName = exportJiuqiInfo.getJiuqiOrgName();
                jiuqiRptType = exportJiuqiInfo.getJiuqiRptType();
                reportMappingDatas = exportJiuqiInfo.getReportMappingData();
                rptInfoSet = reportMappingDatas.keySet();
                int i = 1;
                for (CslReportInfo rptInfo : rptInfoSet) {
                    iniDataStr = this.getIniDataOrgStr(schmInfo, rptInfo, jiuqiOrgNumber, jiuqiOrgName, jiuqiRptType);
                    easJiuqiTempMappingInfo = reportMappingDatas.get(rptInfo);
                    if (this.forManualJiuqi) {
                        String oneTempCellMapping;
                        if (!this.fileStringList.contains(orgKey)) {
                            this.fileString.append(iniDataStr);
                            if (i == 1) {
                                this.fileString.append(rootPatchName).append(orgKey).append(".xls").append("\r\n");
                            }
                            this.fileStringList.add(orgKey);
                        }
                        if (!this.cellStringList.contains(oneTempCellMapping = easJiuqiTempMappingInfo.getCellMappingString())) {
                            this.cellString.append(oneTempCellMapping).append("\r\n");
                            this.cellStringList.add(oneTempCellMapping);
                        }
                    }
                    if (!jiuqiTaskNums.contains(easJiuqiTempMappingInfo.getJiuqiTaskNumber())) {
                        jiuqiTaskStrs = jiuqiTaskStrs + "-" + easJiuqiTempMappingInfo.getJiuqiTaskNumber();
                        jiuqiTaskNums.add(easJiuqiTempMappingInfo.getJiuqiTaskNumber());
                    }
                    oneExportReports.add(rptInfo);
                    this.exportExcelAndIni(iniDataStr, orgKey, oneExportReports, easJiuqiTempMappingInfo);
                    oneExportReports = new CslReportCollection();
                    ++i;
                }
                if (!this.forManualJiuqi) continue;
                String string = rootPatchName + orgKey + ".xls";
                this.exportOneReportExcel(this.exportBook, string);
            }
        }
        if (this.forManualJiuqi) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[File]\r\n");
            stringBuffer.append(this.fileString);
            stringBuffer.append("\r\n");
            stringBuffer.append("[Sheet]\r\n");
            stringBuffer.append(this.sheetString);
            stringBuffer.append("\r\n");
            stringBuffer.append("[Nexus]\r\n");
            stringBuffer.append(this.cellString);
            stringBuffer.append("\r\n");
            String iniFileName = rootPatchName + "iniData.ini";
            FileOutputStream out = new FileOutputStream(iniFileName);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(stringBuffer.toString());
            writer.flush();
            writer.close();
        }
        return jiuqiTaskStrs;
    }

    private StringBuffer getIniDataOrgStr(ExJiuqiRptSchmInfo schmInfo, CslReportInfo cslrptinfo, String jiuqiOrgNumber, String jiuqiOrgName, String jiuqiRptType) {
        CslReportInfo cslrptInfoOnlyYear = null;
        try {
            String oql = "select year,period where id='" + cslrptinfo.getId().toString() + "'";
            cslrptInfoOnlyYear = CslReportFactory.getRemoteInstance().getCslReportInfo(oql);
        }
        catch (Exception e) {
            logger.error((Object)"jiuqi select rpt year,period error :\n", (Throwable)e);
            cslrptInfoOnlyYear = cslrptinfo;
        }
        String jiuiqOrgNumStyle = schmInfo.getJiuqiOrgNumberStyle() == null ? this.defaultJiuqiOrgNumberStyle : schmInfo.getJiuqiOrgNumberStyle();
        String jiuqiOrgNum = null;
        jiuqiOrgNum = jiuiqOrgNumStyle.replace("jqOrgNum", schmInfo.isIsExportOrgNum() ? jiuqiOrgNumber : "");
        jiuqiOrgNum = jiuqiOrgNum.replace("year", schmInfo.isIsExportYear() ? String.valueOf(cslrptInfoOnlyYear.getYear()) : "");
        String period = cslrptInfoOnlyYear.getPeriod() > 9 ? "" + cslrptInfoOnlyYear.getPeriod() : "0" + cslrptInfoOnlyYear.getPeriod();
        jiuqiOrgNum = jiuqiOrgNum.replace("period", schmInfo.isIsExportPeriod() ? period : "");
        jiuqiOrgNum = jiuqiOrgNum.replace("jqRptType", schmInfo.isIsExportJiuqiType() ? jiuqiRptType : "");
        jiuqiOrgNum = jiuqiOrgNum.replace("+", "");
        StringBuffer iniFileOrgStr = new StringBuffer(jiuqiOrgNum);
        iniFileOrgStr.append("=");
        iniFileOrgStr.append(jiuqiOrgName);
        iniFileOrgStr.append("&");
        return iniFileOrgStr;
    }

    public void exportExcelAndIni(StringBuffer iniDataStr, String orgKey, CslReportCollection reports, EASJiuqiTempMappingInfo mappingInfo) throws Exception {
        String excelFilePatch = rootPatchName + easReportsPatch + mappingInfo.getJiuqiTaskNumber() + File.separatorChar + orgKey + "File.separatorChar";
        String iniPatch = rootPatchName + iniFilePatch + mappingInfo.getJiuqiTaskNumber() + "File.separatorChar" + orgKey + "File.separatorChar";
        File exportDir = new File(excelFilePatch);
        if (!exportDir.exists()) {
            exportDir.mkdirs();
        }
        if (!(exportDir = new File(iniPatch)).exists()) {
            exportDir.mkdirs();
        }
        HashSet<String> rptIds = new HashSet<String>();
        for (int i = 0; i < reports.size(); ++i) {
            rptIds.add(reports.get(i).getId().toString());
        }
        ICslReport rpt = CslReportFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", rptIds, CompareType.INCLUDE));
        ev.getSelector().add(new SelectorItemInfo("data"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        ev.getSelector().add(new SelectorItemInfo("sourceType"));
        ev.getSelector().add(new SelectorItemInfo("template.dynaRptType"));
        CslReportCollection exportCslColl = rpt.getCslReportCollection(ev);
        CslReportInfo cslrptinfo = null;
        String excelFileName = null;
        Book book = null;
        boolean isDyna = false;
        for (int i = 0; i < exportCslColl.size(); ++i) {
            cslrptinfo = exportCslColl.get(i);
            String key = this.userInfo.getId().toString() + cslrptinfo.getOrgUnit().getId() + cslrptinfo.getSourceType().getValue();
            boolean canView = (Boolean)this.viewPermissionMap.get(key);
            if (!canView) continue;
            isDyna = DynaEnumRptTypeEnum.DYNAMIC.equals((Object)cslrptinfo.getTemplate().getDynaRptType());
            book = cslrptinfo.getBook();
            book.setCalculate(false);
            excelFileName = excelFilePatch + cslrptinfo.getName() + ".xls";
            iniDataStr.append(excelFileName);
            this.exportIniFile(iniDataStr, cslrptinfo.getName(), book, iniPatch, mappingInfo, isDyna);
            if (this.forManualJiuqi) {
                for (int j = 0; j < book.getSheetCount(); ++j) {
                    Sheet sheet = book.getSheet(j);
                    String sheetName = sheet.getSheetName();
                    if (this.sheetNameList.contains(sheetName)) continue;
                    this.exportBook.addSheet(sheet);
                    this.sheetNameList.add(sheetName);
                }
                continue;
            }
            this.exportOneReportExcel(book, excelFileName);
        }
    }

    private void exportIniFile(StringBuffer iniDataOrgStr, String fileName, Book book, String iniPatch, EASJiuqiTempMappingInfo mappingInfo, boolean isDyna) throws Exception {
        StringBuffer iniData = new StringBuffer();
        iniData.append("[File]\r\n");
        iniData.append(iniDataOrgStr).append("\r\n");
        iniData.append("[Sheet]\r\n");
        EASJiuqiTempMappingEntryCollection entryColl = mappingInfo.getEntry();
        EASJiuqiTempMappingEntryInfo entryInfo = null;
        ArrayList<StringBuffer> allSheetCellMappingStrList = new ArrayList<StringBuffer>();
        StringBuffer allSheetCellMappingStr = new StringBuffer();
        List<StringBuffer> cellMappingStrList = null;
        String jiuqiNumber = null;
        ArrayList<String> jqRptNumbers = new ArrayList<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            jiuqiNumber = entryInfo.getString("jqRptNumber");
            if (jqRptNumbers.contains(jiuqiNumber)) continue;
            jqRptNumbers.add(jiuqiNumber);
            cellMappingStrList = this.getCellMappingStrAndPreRate(entryInfo, book, entryInfo.getEasSheetName(), isDyna);
            String sheetMapping = jiuqiNumber + "=" + entryInfo.getEasSheetName();
            if (this.forManualJiuqi) {
                if (!this.sheetStringList.contains(sheetMapping)) {
                    this.sheetStringList.add(sheetMapping);
                    this.sheetString.append(sheetMapping);
                    this.sheetString.append("\r\n");
                }
            } else {
                iniData.append(sheetMapping);
                iniData.append("\r\n");
                if (mappingInfo.getCellMappingString() == null) {
                    if (cellMappingStrList != null && cellMappingStrList.size() > 0) {
                        for (int j = 0; j < cellMappingStrList.size(); ++j) {
                            if (allSheetCellMappingStrList.size() - 1 < j) {
                                allSheetCellMappingStr = new StringBuffer();
                                allSheetCellMappingStrList.add(allSheetCellMappingStr);
                            } else {
                                allSheetCellMappingStr = (StringBuffer)allSheetCellMappingStrList.get(j);
                            }
                            allSheetCellMappingStr.append(jiuqiNumber + "=").append(cellMappingStrList.get(j)).append("\r\n");
                        }
                    }
                } else {
                    allSheetCellMappingStr.append(mappingInfo.getCellMappingString()).append("\r\n");
                }
            }
            iniData.append("[Nexus]\r\n");
            String exportStr = "";
            for (int j = 0; j < allSheetCellMappingStrList.size(); ++j) {
                exportStr = "" + iniData + allSheetCellMappingStrList.get(j);
                String iniFileName = iniPatch + fileName + "-" + j + ".ini";
                FileOutputStream out = new FileOutputStream(iniFileName);
                OutputStreamWriter writer = new OutputStreamWriter(out);
                writer.write(exportStr);
                writer.flush();
                writer.close();
            }
        }
    }

    private void setCellAfterRateValue(Range range, EASJiuqiTempMappingEntryInfo entryInfo, Sheet sheet) {
        if (entryInfo.getRate() != 1 && entryInfo.getRate() != 0) {
            BigDecimal value = null;
            BigDecimal rateAbs = BigDecimal.ZERO;
            try {
                boolean isSetRate = true;
                ItemFormula rptF = (ItemFormula)range.getUserObject("ITEM");
                if (rptF != null) {
                    boolean bl = isSetRate = 1 == rptF.getValueType();
                }
                if (isSetRate) {
                    value = new BigDecimal(range.getValue().getValue().toString());
                    rateAbs = new BigDecimal(Math.abs(entryInfo.getRate()));
                    value = entryInfo.getRate() > 0 ? value.multiply(rateAbs) : value.divide(rateAbs);
                    range.setValue(new Variant((Object)value));
                }
            }
            catch (Exception e) {
                logger.error((Object)"setCellAfterRateValue:", (Throwable)e);
            }
        }
    }

    private boolean isRowIndexCol(Range range) {
        if (range.getValue().getValue() != null) {
            String indexStr = null;
            indexStr = range.getValue().getValue().toString().replace("\\s", "");
            if (EASResource.getString((String)this.resPatch, (String)"rowIndex1").equals(indexStr) || EASResource.getString((String)this.resPatch, (String)"rowIndex2").equals(indexStr)) {
                return true;
            }
        }
        return false;
    }

    private List<StringBuffer> getCellMappingStrAndPreRate(EASJiuqiTempMappingEntryInfo entryInfo, Book book, String sheetName, boolean isDyna) throws Exception {
        if (isDyna) {
            return this.getDynaCellMappingStrAndPreRate(entryInfo, book, sheetName);
        }
        return this.getNorCellMappingStrAndPreRate(entryInfo, book, sheetName);
    }

    private List<StringBuffer> getDynaCellMappingStrAndPreRate(EASJiuqiTempMappingEntryInfo entryInfo, Book book, String sheetName) throws Exception {
        StringBuffer result = new StringBuffer();
        ArrayList<StringBuffer> results = new ArrayList<StringBuffer>();
        Map cellMapping = entryInfo.getMappingDataInfo();
        if (cellMapping.size() > 0) {
            Sheet sheet = book.getSheet(sheetName);
            HashMap<String, String> dynaCellMapping = new HashMap<String, String>();
            HashMap<String, HashMap<Integer, String>> norCellMapping = new HashMap<String, HashMap<Integer, String>>();
            Set cellKeySet = cellMapping.keySet();
            String jiuqiIndex = null;
            Object[] itemKeys = null;
            HashMap<Integer, String> indexMap = null;
            for (String itemFormulaKey : cellKeySet) {
                jiuqiIndex = (String)cellMapping.get(itemFormulaKey);
                itemKeys = this.getIndexNumber(itemFormulaKey);
                if (itemKeys[0] != null) {
                    indexMap = (HashMap<Integer, String>)norCellMapping.get((String)itemKeys[1]);
                    if (indexMap == null) {
                        indexMap = new HashMap<Integer, String>();
                        norCellMapping.put((String)itemKeys[1], indexMap);
                    }
                    indexMap.put((Integer)itemKeys[0], jiuqiIndex);
                    continue;
                }
                dynaCellMapping.put(itemFormulaKey, jiuqiIndex);
            }
            ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            DynaRangeProvider dynaRangeProvider = new DynaRangeProvider();
            Point basePoint = null;
            Point endPoint = null;
            int endRow = -1;
            DynaParameters param = null;
            int sumLine = -1;
            Range formulaRange = null;
            ItemFormula rptF = null;
            String easItemFormula = null;
            int sRow = 0;
            String jiuqiBaseRowStr = null;
            String[] jiuqiIndexStr = null;
            StringBuffer jiuqiLineMappingStr = new StringBuffer();
            StringBuffer easLineMappingStr = new StringBuffer();
            HashMap<Integer, String> colIndexItemFormulaMap = new HashMap<Integer, String>();
            int currCount = 0;
            Map<Object, Object> norIndexMapping = new HashMap();
            for (int i = 0; i < basePointList.size(); ++i) {
                jiuqiBaseRowStr = null;
                jiuqiLineMappingStr = new StringBuffer();
                easLineMappingStr = new StringBuffer();
                colIndexItemFormulaMap = new HashMap();
                currCount = 0;
                norIndexMapping = new HashMap();
                basePoint = (Point)basePointList.get(i);
                endPoint = dynaRangeProvider.getDynaRange(sheet, basePoint);
                param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basePoint);
                HashMap<String, Point> gradeMap = new HashMap<String, Point>();
                ArrayList<String> gradeNums = new ArrayList<String>();
                if (param.isGrade() && param.getDynaItemSource() == 0) {
                    Sheet.RowsIterator it = sheet.getRowsIterator(basePoint.y + 1, basePoint.y + param.getDefaultCounter(), false);
                    while (it.hasNext()) {
                        String grade;
                        Row r = it.next();
                        ItemFormula item = UserObjectHelper.getItemFormula((Cell)r.getCell(basePoint.x, false));
                        if (item == null || (grade = item.getExt("GRADE_NUMBER")) == null) continue;
                        Point gradeStartPoint = new Point(basePoint.x, r.getRow());
                        gradeMap.put(grade, gradeStartPoint);
                        gradeNums.add(grade);
                    }
                }
                if (param.isGrade() && param.getDynaItemSource() == 0) {
                    Point gradeStartPoint = null;
                    DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basePoint.y, basePoint.x));
                    for (int gradeIndex = gradeNums.size() - 1; gradeIndex >= 0; --gradeIndex) {
                        String gradeNum = (String)gradeNums.get(gradeIndex);
                        gradeStartPoint = (Point)gradeMap.get(gradeNum);
                        DItemGradeEntryInfo gradeEntry = gradeInfo.find(gradeNum);
                        if (gradeEntry == null) continue;
                        sRow = gradeStartPoint.y;
                        int size = gradeEntry.getDetailCount();
                        for (int j = endRow = sRow + size; j >= sRow; --j) {
                            if (sRow == j || endRow == j) {
                                jiuqiLineMappingStr = new StringBuffer();
                                easLineMappingStr = new StringBuffer();
                                jiuqiBaseRowStr = null;
                            }
                            boolean isAdd = true;
                            if (sRow != j && sheet.getRange(j, basePoint.x).getValue() == null || sheet.getRange(j, basePoint.x).getValue().getValue() == null || StringUtils.isEmpty((String)sheet.getRange(j, basePoint.x).getValue().getValue().toString())) {
                                isAdd = false;
                            }
                            for (int j2 = basePoint.x + 1; j2 <= endPoint.x; ++j2) {
                                this.setCellAfterRateValue(sheet.getRange(j, j2), entryInfo, sheet);
                                if (sRow != j && endRow != j) continue;
                                formulaRange = sheet.getRange(sRow, j2);
                                rptF = (ItemFormula)formulaRange.getUserObject("ITEM");
                                if (rptF != null) {
                                    easItemFormula = rptF.getFormula();
                                }
                                if (StringUtils.isEmpty((String)easItemFormula)) continue;
                                if (sRow == j) {
                                    jiuqiIndex = (String)dynaCellMapping.get(easItemFormula + easDynaKey + "S");
                                    if (jiuqiIndex == null) continue;
                                    jiuqiIndexStr = jiuqiIndex.split(jiuqiSplitStr);
                                    if (jiuqiIndexStr.length > 1) {
                                        jiuqiIndex = jiuqiIndexStr[1];
                                        jiuqiBaseRowStr = jiuqiIndexStr[0];
                                    } else {
                                        jiuqiIndex = jiuqiIndexStr[0];
                                    }
                                    this.appendDynaLineColStr(j2, jiuqiLineMappingStr, easLineMappingStr, jiuqiIndex);
                                    continue;
                                }
                                if (endRow != j) continue;
                                jiuqiIndex = (String)dynaCellMapping.get(easItemFormula + easDynaKey + "PR");
                                if (!StringUtils.isEmpty((String)jiuqiIndex)) {
                                    jiuqiBaseRowStr = jiuqiIndex;
                                }
                                this.appendDynaLineColStr((String)dynaCellMapping.get(easItemFormula + easDynaKey + "PC"), basePoint.x, jiuqiLineMappingStr, easLineMappingStr);
                                this.appendDynaLineColStr((String)dynaCellMapping.get(easItemFormula), j2, jiuqiLineMappingStr, easLineMappingStr);
                            }
                            if (!isAdd || StringUtils.isEmpty((String)jiuqiBaseRowStr) || jiuqiLineMappingStr.length() <= 0) continue;
                            result = this.appendMappingStr(jiuqiBaseRowStr, j + 1 + "", jiuqiLineMappingStr, easLineMappingStr, result, results, ++currCount);
                        }
                    }
                } else {
                    int j;
                    if (param.isIncludeSum()) {
                        if (Integer.parseInt("1") == param.getPosition()) {
                            sumLine = basePoint.y + 1;
                            sRow = basePoint.y + 2;
                            endRow = endPoint.y;
                        } else if (Integer.parseInt("2") == param.getPosition()) {
                            sumLine = basePoint.y + 1 + param.getDefaultCounter();
                            sRow = basePoint.y + 1;
                            endRow = endPoint.y - 1;
                        }
                    }
                    for (j = basePoint.x + 1; j <= endPoint.x; ++j) {
                        this.setCellAfterRateValue(sheet.getRange(sumLine, j), entryInfo, sheet);
                        formulaRange = sheet.getRange(basePoint.y, j);
                        rptF = (ItemFormula)formulaRange.getUserObject("ITEM");
                        if (rptF == null) continue;
                        easItemFormula = rptF.getFormula();
                        colIndexItemFormulaMap.put(j, easItemFormula);
                        jiuqiIndex = (String)dynaCellMapping.get(easItemFormula + easDynaKey + "S");
                        if (jiuqiIndex != null) {
                            jiuqiIndexStr = jiuqiIndex.split(jiuqiSplitStr);
                            jiuqiIndex = jiuqiIndexStr.length > 1 ? jiuqiIndexStr[1] : jiuqiIndexStr[0];
                            this.appendDynaLineColStr(j, jiuqiLineMappingStr, easLineMappingStr, jiuqiIndex);
                        }
                        if (StringUtils.isEmpty((String)(jiuqiIndex = (String)dynaCellMapping.get(easItemFormula + easDynaKey + "PR")))) continue;
                        jiuqiBaseRowStr = jiuqiIndex;
                        norIndexMapping = this.getNorIndexMapping(entryInfo, sheet, basePoint.y, j, (Map)norCellMapping.get(easItemFormula));
                    }
                    if (jiuqiIndexStr != null && jiuqiLineMappingStr.length() > 0) {
                        result = this.appendMappingStr((String)jiuqiIndexStr[0], sumLine + 1 + "", jiuqiLineMappingStr, easLineMappingStr, result, results, ++currCount);
                    }
                    jiuqiLineMappingStr = new StringBuffer();
                    easLineMappingStr = new StringBuffer();
                    for (j = endRow; j >= sRow; --j) {
                        boolean isAdd = true;
                        if (sheet.getRange(j, basePoint.x).getValue() == null || sheet.getRange(j, basePoint.x).getValue().getValue() == null || StringUtils.isEmpty((String)sheet.getRange(j, basePoint.x).getValue().getValue().toString())) {
                            isAdd = false;
                        }
                        for (int j2 = basePoint.x + 1; j2 <= endPoint.x; ++j2) {
                            this.setCellAfterRateValue(sheet.getRange(j, j2), entryInfo, sheet);
                            if (endRow != j || StringUtils.isEmpty((String)(easItemFormula = (String)colIndexItemFormulaMap.get(j2)))) continue;
                            jiuqiIndex = (String)dynaCellMapping.get(easItemFormula + easDynaKey + "PR");
                            if (!StringUtils.isEmpty((String)jiuqiIndex)) {
                                jiuqiBaseRowStr = jiuqiIndex;
                            }
                            this.appendDynaLineColStr((String)dynaCellMapping.get(easItemFormula + easDynaKey + "PC"), basePoint.x, jiuqiLineMappingStr, easLineMappingStr);
                            this.appendDynaLineColStr((String)dynaCellMapping.get(easItemFormula), j2, jiuqiLineMappingStr, easLineMappingStr);
                        }
                        if (!isAdd || StringUtils.isEmpty(jiuqiBaseRowStr) || jiuqiLineMappingStr.length() <= 0) continue;
                        result = this.appendMappingStr(jiuqiBaseRowStr, j + 1 + "", jiuqiLineMappingStr, easLineMappingStr, result, results, ++currCount);
                    }
                }
                Set keys = norIndexMapping.keySet();
                for (String key : keys) {
                    result = this.appendMappingStr(result, results, (String)norIndexMapping.get(key), key, ++currCount);
                }
            }
        }
        if (result.length() > 0) {
            results.add(result);
        }
        return results;
    }

    private void appendDynaLineColStr(String jiuqiIndex, int colIndex, StringBuffer jiuqiLineMappingStr, StringBuffer easLineMappingStr) {
        if (jiuqiIndex != null) {
            String[] jiuqiIndexStr = jiuqiIndex.split(jiuqiSplitStr);
            jiuqiIndex = jiuqiIndexStr.length > 1 ? jiuqiIndexStr[1] : jiuqiIndexStr[0];
            this.appendDynaLineColStr(colIndex, jiuqiLineMappingStr, easLineMappingStr, jiuqiIndex);
        }
    }

    private StringBuffer appendMappingStr(String jiuqiRowStr, String easRow, StringBuffer jiuqiLineMappingStr, StringBuffer easLineMappingStr, StringBuffer result, List<StringBuffer> results, int currCount) {
        if (jiuqiLineMappingStr.toString().endsWith(jiuqiSplitStr)) {
            jiuqiLineMappingStr = jiuqiLineMappingStr.deleteCharAt(jiuqiLineMappingStr.length() - 1);
        }
        if (easLineMappingStr.toString().endsWith(jiuqiSplitStr)) {
            easLineMappingStr = easLineMappingStr.deleteCharAt(easLineMappingStr.length() - 1);
        }
        return this.appendMappingStr(result, results, "{" + jiuqiRowStr + "}{" + jiuqiLineMappingStr + "}", "{" + easRow + "}{" + easLineMappingStr + "}", currCount);
    }

    private void appendDynaLineColStr(int colIndex, StringBuffer jiuqiLineMappingStr, StringBuffer easLineMappingStr, String jiuqiColIndex) {
        jiuqiLineMappingStr.append(jiuqiColIndex).append(jiuqiSplitStr);
        String colName = TableToolkit.int2pos((int)colIndex);
        easLineMappingStr.append(colName).append(jiuqiSplitStr);
    }

    private StringBuffer appendMappingStr(StringBuffer result, List<StringBuffer> results, String jiuqi, String eas, int currCount) {
        result.append(jiuqi).append("=");
        result.append(eas).append(";");
        return result;
    }

    private Map<String, String> getNorIndexMapping(EASJiuqiTempMappingEntryInfo entryInfo, Sheet sheet, int row, int col, Map<Integer, String> norCellMapping) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        if (norCellMapping != null) {
            Set<Integer> keys = null;
            String[] jiuqiIndex = null;
            String eas = null;
            String jiuqi = null;
            String colName = null;
            keys = norCellMapping.keySet();
            for (Integer key : keys) {
                jiuqiIndex = norCellMapping.get(key).split(jiuqiSplitStr);
                jiuqi = "{" + jiuqiIndex[0] + "}{" + jiuqiIndex[1] + "}";
                colName = TableToolkit.int2pos((int)col);
                eas = "{" + (row + 1 + key) + "}{" + colName + "}";
                result.put(eas, jiuqi);
                this.setCellAfterRateValue(sheet.getRange(row + 1 + key, col), entryInfo, sheet);
            }
        }
        return result;
    }

    private Object[] getIndexNumber(String itemFormulaKey) {
        String[] keys = itemFormulaKey.split(easDynaKey);
        Object[] result = new Object[2];
        try {
            String indexStr = keys[1];
            result[0] = Integer.parseInt(indexStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        result[1] = keys[0];
        return result;
    }

    private List<StringBuffer> getNorCellMappingStrAndPreRate(EASJiuqiTempMappingEntryInfo entryInfo, Book book, String sheetName) throws Exception {
        StringBuffer result = new StringBuffer();
        ArrayList<StringBuffer> results = new ArrayList<StringBuffer>();
        Map cellMapping = entryInfo.getMappingDataInfo();
        Sheet sheet = book.getSheet(sheetName);
        if (sheet == null) {
            MsgBox.showConfirm2((String)(EASResource.getString((String)this.resPatch, (String)"67_sheetName") + sheetName + EASResource.getString((String)this.resPatch, (String)"68_change")));
            SysUtil.abort();
        }
        Range range = null;
        int currCount = 0;
        HashSet<String> cellMappingIndexs = new HashSet<String>();
        if (cellMapping.size() > 0) {
            Set keySet = cellMapping.keySet();
            String[] easCellIndex = null;
            String[] jiuqiCellIndex = null;
            String jiuqiCellIndexStr = null;
            int row = 0;
            int col = 0;
            for (String key : keySet) {
                ++currCount;
                jiuqiCellIndexStr = (String)cellMapping.get(key);
                jiuqiCellIndexStr = jiuqiCellIndexStr.substring(1, jiuqiCellIndexStr.length() - 1);
                jiuqiCellIndex = jiuqiCellIndexStr.split(jiuqiSplitStr);
                easCellIndex = key.split(splitStr);
                row = Integer.parseInt(easCellIndex[0]);
                col = Integer.parseInt(easCellIndex[1]);
                cellMappingIndexs.add(row + "" + col);
                result.append(this.getCellMappingStr(row + 1, col, jiuqiCellIndex[0], jiuqiCellIndex[1])).append(";");
                range = sheet.getRange(row, col);
                this.setCellAfterRateValue(range, entryInfo, sheet);
                if (currCount % 99 != 0) continue;
                result = result.deleteCharAt(result.length() - 1);
                result.append("\r\n");
                results.add(result);
                result = new StringBuffer();
            }
        } else {
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            ArrayList<Point> rowIndexCol = new ArrayList<Point>();
            int rowIndex = 0;
            block3: for (int i = 1; i < colCount; ++i) {
                if (rowIndex == 0) {
                    for (int j = 0; j < rowCount; ++j) {
                        range = sheet.getRange(j, i);
                        if (!this.isRowIndexCol(range)) continue;
                        rowIndexCol.add(new Point(i, j));
                        rowIndex = j;
                        continue block3;
                    }
                    continue;
                }
                range = sheet.getRange(rowIndex, i);
                if (!this.isRowIndexCol(range)) continue;
                rowIndexCol.add(new Point(i, rowIndex));
            }
            Point rowIndexColP = null;
            Point nextRowIndexColP = null;
            int startRowIndex = 0;
            int startColIndex = 0;
            int endColIndex = 0;
            int jiuqiCol = 0;
            int jiuqiRow = 0;
            if (rowIndexCol.size() > 0) {
                for (int i = 0; i < rowIndexCol.size(); ++i) {
                    rowIndexColP = (Point)rowIndexCol.get(i);
                    startRowIndex = rowIndexColP.y + 1;
                    startColIndex = rowIndexColP.x + 1;
                    if (i != rowIndexCol.size() - 1) {
                        nextRowIndexColP = (Point)rowIndexCol.get(i + 1);
                        endColIndex = nextRowIndexColP.x - 1;
                    } else {
                        endColIndex = colCount;
                    }
                    jiuqiCol = 0;
                    for (int j = startColIndex; j < endColIndex; ++j) {
                        ++jiuqiCol;
                        for (int j2 = startRowIndex; j2 < rowCount; ++j2) {
                            if (cellMappingIndexs.contains(j2 + "" + j)) continue;
                            range = sheet.getRange(j2, j - jiuqiCol);
                            try {
                                jiuqiRow = Integer.parseInt(range.getValue().getValue().toString());
                            }
                            catch (Exception e) {
                                continue;
                            }
                            range = sheet.getRange(j2, j);
                            result.append(this.getCellMappingStr(j2 + 1, j, jiuqiRow, jiuqiCol)).append(";");
                            this.setCellAfterRateValue(range, entryInfo, sheet);
                            if (++currCount % 99 != 0) continue;
                            result = result.deleteCharAt(result.length() - 1);
                            result.append("\r\n");
                            results.add(result);
                            result = new StringBuffer();
                        }
                    }
                }
            } else {
                ItemFormula rptF = null;
                boolean rowIsAdded = false;
                startRowIndex = 0;
                startColIndex = 0;
                block8: for (int startI = 0; startI < rowCount; ++startI) {
                    for (int startJ = 0; startJ < colCount; ++startJ) {
                        range = sheet.getRange(startI, startJ);
                        rptF = (ItemFormula)range.getUserObject("ITEM");
                        if (startRowIndex == 0 && rptF != null) {
                            startRowIndex = startI;
                            startColIndex = startJ;
                        }
                        if (startColIndex <= startJ || rptF == null) continue;
                        startColIndex = startJ;
                        break block8;
                    }
                }
                for (int i = startRowIndex; i < rowCount; ++i) {
                    rowIsAdded = false;
                    jiuqiCol = 0;
                    for (int j = startColIndex; j < colCount; ++j) {
                        if (cellMappingIndexs.contains(i + "" + j)) continue;
                        range = sheet.getRange(i, j);
                        rptF = (ItemFormula)range.getUserObject("ITEM");
                        ++jiuqiCol;
                        if (rptF == null) continue;
                        if (!rowIsAdded) {
                            rowIsAdded = true;
                            ++jiuqiRow;
                        }
                        result.append(this.getCellMappingStr(i + 1, j, jiuqiRow, jiuqiCol)).append(";");
                        this.setCellAfterRateValue(range, entryInfo, sheet);
                        if (++currCount % 99 != 0) continue;
                        result = result.deleteCharAt(result.length() - 1);
                        result.append("\r\n");
                        results.add(result);
                        result = new StringBuffer();
                    }
                    if (jiuqiRow <= 0 || rowIsAdded) continue;
                    ++jiuqiRow;
                }
            }
        }
        if (result.length() > 0) {
            result = result.deleteCharAt(result.length() - 1);
            result.append("\r\n");
            results.add(result);
        }
        return results;
    }

    private String getCellMappingStr(int easRow, int easCol, Object jiuqiRow, Object jiuqiCol) {
        String str = "{" + jiuqiRow + "}{" + jiuqiCol + "}";
        str = str + "={" + easRow + "}";
        String colName = TableToolkit.int2pos((int)easCol);
        str = str + "{" + colName + "}";
        return str;
    }

    private void setBookProtect(Book book) {
        BookProtection bp = book.getProtection();
        bp.appendOperation(2);
        bp.appendOperation(1);
        Protection pro = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(true);
            sheet.getRowRange(0, sheet.getRows().getMaxIntMark()).setStyle(sa, Styles.getEmptySA());
            pro = sheet.getSheetOption().getProtection(true);
            pro.start("1234");
        }
    }

    private void exportOneReportExcel(Book book, String fileName) {
        try {
            this.setBookProtect(book);
            KDSBook kdsbook = BookToKDSBook.traslate((Book)book);
            kdsbook.getBookStyleAttributes().setLocked(true);
            kdsbook.getSheets().getSheet((Object)new Integer(0)).getSheetStyleAttributes().setLocked(true);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.TRUE);
            em.exportToExcel(kdsbook, fileName);
        }
        catch (Exception e) {
            logger.debug((Object)e.getStackTrace(), (Throwable)e);
            File file = new File(fileName);
            file.delete();
        }
    }
}

