/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqirpa.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.f7.UnionVersion2F7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.jiuqirpa.AbstractEASJiuqiOrgMappingInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiOrgMappingCollection;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiOrgMappingFactory;
import com.kingdee.eas.fi.newrpt.jiuqirpa.EASJiuqiOrgMappingInfo;
import com.kingdee.eas.fi.newrpt.jiuqirpa.JiuqiReportTypeEnum;
import com.kingdee.eas.fi.newrpt.jiuqirpa.client.AbstractEASJiuqiOrgMappingEditUI;
import com.kingdee.eas.fi.rpt.treetable.TreeIcon;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.stefan.snrpc.util.StringUtil;

public class EASJiuqiOrgMappingEditUI
extends AbstractEASJiuqiOrgMappingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EASJiuqiOrgMappingEditUI.class);
    private String resPatch = "com.kingdee.eas.fi.newrpt.jiuqirpa.MappingResource";
    private TreeRenderer treeRender = new TreeRenderer();
    private final String TBL_EAS_ORG_NUMBER = "easOrgNumber";
    private final String TBL_EAS_ORG_NAME = "easOrgName";
    private final String TBL_JIUQI_ORG_NUMBER = "jiuqiOrgNumber";
    private final String TBL_JIUQI_ORG_NAME = "jiuqiOrgName";
    private final String TBL_JIUQI_REPORT_TYPE = "jiuqiReportType";
    private Map<BOSUuid, EASJiuqiOrgMappingInfo> easJiuqiOrgMappingInfoTemp = new HashMap<BOSUuid, EASJiuqiOrgMappingInfo>();
    private boolean isRowDataChange = false;
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    private CoreBaseCollection deleteMappingColl = new CoreBaseCollection();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.tblOrgMapping.checkParsed();
        super.onLoad();
        this.initTreeF7();
        this.initTable();
        this.initEditData();
    }

    private void initEditData() throws Exception {
        String orgTreeId = (String)this.getUIContext().get("orgTreeId");
        String orgTreeNumber = (String)this.getUIContext().get("orgTreeNumber");
        if (!StringUtil.isEmpty((String)orgTreeId)) {
            this.fillTable(orgTreeId);
            String oql = "select id,treeNumber,orgNumber,jiuqiOrgNumber,jiuqiOrgName,jiuqiRptType,orgTree.number,orgTree.name,orgTree.id,orgUnit.number,orgUnit.name,orgUnit.id where treeNumber='" + orgTreeNumber + "'";
            EASJiuqiOrgMappingCollection editDataColl = EASJiuqiOrgMappingFactory.getRemoteInstance().getEASJiuqiOrgMappingCollection(oql);
            EASJiuqiOrgMappingCollection needAddRowDataColl = new EASJiuqiOrgMappingCollection();
            AbstractEASJiuqiOrgMappingInfo info = null;
            if (editDataColl != null && editDataColl.size() > 0) {
                this.orgTreeF7.setData((Object)editDataColl.get(0).getOrgTree());
                String orgUnitNumber = null;
                for (int i = 0; i < editDataColl.size(); ++i) {
                    info = editDataColl.get(i);
                    this.easJiuqiOrgMappingInfoTemp.put(info.getId(), (EASJiuqiOrgMappingInfo)info);
                    orgUnitNumber = info.getOrgNumber();
                    boolean needAdd = true;
                    for (int j = 0; j < this.tblOrgMapping.getRowCount(); ++j) {
                        IRow row = this.tblOrgMapping.getRow(j);
                        String tblOrgUnitNumber = ((OrgStructureInfo)row.getCell("easOrgNumber").getValue()).getUnit().getNumber();
                        if (!tblOrgUnitNumber.equals(orgUnitNumber)) continue;
                        row.getCell("jiuqiOrgNumber").setValue((Object)info.getJiuqiOrgNumber());
                        row.getCell("jiuqiOrgName").setValue((Object)info.getJiuqiOrgName());
                        row.getCell("jiuqiReportType").setValue((Object)info.getJiuqiRptType());
                        row.setUserObject((Object)info);
                        needAdd = false;
                        break;
                    }
                    if (!needAdd) continue;
                    needAddRowDataColl.add((EASJiuqiOrgMappingInfo)info);
                }
            }
            for (int i = 0; i < needAddRowDataColl.size(); ++i) {
                OrgStructureInfo orgStructureInfo = new OrgStructureInfo();
                if (info == null) continue;
                orgStructureInfo.setUnit(info.getOrgUnit());
                info = needAddRowDataColl.get(i);
                IRow row = this.tblOrgMapping.addRow();
                row.getCell("easOrgNumber").setValue((Object)orgStructureInfo);
                row.getCell("easOrgName").setValue((Object)info.getOrgUnit());
                row.getCell("jiuqiOrgNumber").setValue((Object)info.getJiuqiOrgNumber());
                row.getCell("jiuqiOrgName").setValue((Object)info.getJiuqiOrgName());
                row.getCell("jiuqiReportType").setValue((Object)info.getJiuqiRptType());
                row.setUserObject((Object)info);
            }
        }
    }

    private void initTable() {
        KDComboBox jiuqiReportTypeBox = new KDComboBox();
        jiuqiReportTypeBox.addItems(JiuqiReportTypeEnum.getEnumList().toArray());
        this.tblOrgMapping.getColumn("jiuqiReportType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)jiuqiReportTypeBox));
        this.tblOrgMapping.getColumn("easOrgNumber").setRenderer((IBasicRender)this.treeRender);
        this.tblOrgMapping.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    if (e.getClickCount() == 1 && EASJiuqiOrgMappingEditUI.this.tblOrgMapping.getColumn(e.getColIndex()) != null && "easOrgNumber".equals(EASJiuqiOrgMappingEditUI.this.tblOrgMapping.getColumn(e.getColIndex()).getKey())) {
                        Object curObj = EASJiuqiOrgMappingEditUI.this.tblOrgMapping.getCell(e.getRowIndex(), e.getColIndex()).getValue();
                        if (EASJiuqiOrgMappingEditUI.this.treeRender != null && curObj != null && curObj instanceof OrgStructureInfo && EASJiuqiOrgMappingEditUI.this.treeRender.isInRect(((OrgStructureInfo)curObj).getId().toString(), e.getX(), e.getY())) {
                            EASJiuqiOrgMappingEditUI.this.expandNode(e.getRowIndex());
                        }
                    }
                }
                catch (Exception exc) {
                    EASJiuqiOrgMappingEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initTreeF7() throws Exception {
        String userID = this.getUserPk().toString();
        OrgTreeCollection trees = CslRptUtil.getAllUnionTrees(null, (String)userID, null);
        HashSet<String> numbers = new HashSet<String>();
        String treeNumber = null;
        for (int i = 0; i < trees.size(); ++i) {
            treeNumber = trees.get(i).getNumber();
            if (numbers.contains(treeNumber)) continue;
            numbers.add(treeNumber);
        }
        UnionVersion2F7 f7 = new UnionVersion2F7();
        String title = EASResource.getString((String)this.resPatch, (String)"orgTreeSelect");
        f7.setTitile(title);
        FilterInfo treeFilter = new FilterInfo();
        if (numbers != null && numbers.size() > 0) {
            FilterItemInfo filterItem = new FilterItemInfo("number", numbers, CompareType.INCLUDE);
            treeFilter.getFilterItems().add(filterItem);
            f7.setTreeFilter(treeFilter);
        }
        this.orgTreeF7.setSelector((KDPromptSelector)f7);
        this.orgTreeF7.setEditable(false);
        this.orgTreeF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    if (eventObj.getNewValue() != null) {
                        EASJiuqiOrgMappingEditUI.this.fillTable(((OrgTreeInfo)eventObj.getNewValue()).getId().toString());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"treeF7 error", (Throwable)e);
                }
            }
        });
    }

    private void expandNode(int rowIndex) {
        Object treeNode = this.tblOrgMapping.getCell(rowIndex, "easOrgNumber").getValue();
        if (treeNode != null && treeNode instanceof OrgStructureInfo) {
            OrgStructureInfo parentNode;
            Boolean isExpand = (Boolean)(parentNode = (OrgStructureInfo)treeNode).get("isExpand");
            parentNode.put("isExpand", (Object)(isExpand == false ? 1 : 0));
            this.hideChildRow(parentNode, rowIndex, isExpand);
        }
    }

    private void hideChildRow(OrgStructureInfo parentNode, int parentRowIndex, boolean hided) {
        if (parentNode != null) {
            String parentId = parentNode.getId().toString();
            Object curNode = null;
            while (parentRowIndex < this.tblOrgMapping.getRowCount() - 1) {
                OrgStructureInfo childNode;
                if ((curNode = this.tblOrgMapping.getCell(++parentRowIndex, "easOrgNumber").getValue()) == null || !(curNode instanceof OrgStructureInfo) || !(childNode = (OrgStructureInfo)curNode).getParent().getId().toString().equals(parentId)) continue;
                this.tblOrgMapping.getRow(parentRowIndex).getStyleAttributes().setHided(hided);
                if (childNode.isIsLeaf()) continue;
                if (hided) {
                    this.hideChildRow(childNode, parentRowIndex, hided);
                    continue;
                }
                if (!((Boolean)childNode.get("isExpand")).booleanValue()) continue;
                this.hideChildRow(childNode, parentRowIndex, false);
            }
        }
    }

    private void fillTable(String treeId) throws Exception {
        Map<String, Object> tableRowMap = this.getTableRowUserObject();
        this.tblOrgMapping.removeRows(false);
        OrgStructureCollection targetOrgStructures = this.getTargetOrgUnit(treeId);
        if (targetOrgStructures != null) {
            OrgStructureInfo info = null;
            for (int i = 0; i < targetOrgStructures.size(); ++i) {
                info = targetOrgStructures.get(i);
                IRow row = this.tblOrgMapping.addRow();
                info.put("isExpand", (Object)Boolean.TRUE);
                row.getCell("easOrgName").setValue((Object)info.getUnit());
                row.getCell("easOrgNumber").setValue((Object)info);
                if (tableRowMap.get(info.getUnit().getNumber()) == null) continue;
                row.setUserObject(tableRowMap.get(info.getUnit().getNumber()));
            }
        }
    }

    private Map<String, Object> getTableRowUserObject() {
        HashMap<String, Object> tableRowMap = new HashMap<String, Object>();
        IRow row = null;
        String unitNumber = null;
        for (int i = 0; i < this.tblOrgMapping.getRowCount(); ++i) {
            row = this.tblOrgMapping.getRow(i);
            unitNumber = ((OrgStructureInfo)row.getCell("easOrgNumber").getValue()).getUnit().getNumber();
            tableRowMap.put(unitNumber, row.getUserObject());
        }
        return tableRowMap;
    }

    private OrgStructureCollection getTargetOrgUnit(String targetOrgTreeId) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("select id,level,isLeaf,unit.name,unit.number,unit.id,tree.number,");
        builder.append("unit.isunion,parent.id where tree.id='").append(targetOrgTreeId).append("'");
        builder.append(" order by longnumber asc");
        OrgStructureCollection orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(builder.toString());
        OrgStructureInfo curOrgStrInfo = null;
        HashMap parentMap = new HashMap();
        for (int i = orgStructureColl.size() - 1; i >= 0; --i) {
            curOrgStrInfo = orgStructureColl.get(i);
            if (curOrgStrInfo.getParent() != null && curOrgStrInfo.getParent().getId() != null) {
                parentMap.put(curOrgStrInfo.getParent().getId().toString(), null);
            }
            if (parentMap.containsKey(curOrgStrInfo.getId().toString())) {
                curOrgStrInfo.setIsLeaf(false);
                continue;
            }
            curOrgStrInfo.setIsLeaf(true);
        }
        return orgStructureColl;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        CoreBaseCollection saveColl = new CoreBaseCollection();
        StringBuffer numberTips = new StringBuffer();
        StringBuffer nameTips = new StringBuffer();
        StringBuffer reportTypeTips = new StringBuffer();
        int seq = 1;
        for (int i = 0; i < this.tblOrgMapping.getRowCount(); ++i) {
            EASJiuqiOrgMappingInfo mappingInfo;
            IRow row = this.tblOrgMapping.getRow(i);
            String jiuqiOrgNumber = (String)row.getCell("jiuqiOrgNumber").getValue();
            String jiuqName = (String)row.getCell("jiuqiOrgName").getValue();
            JiuqiReportTypeEnum jiuqiReportType = (JiuqiReportTypeEnum)((Object)row.getCell("jiuqiReportType").getValue());
            if (StringUtils.isEmpty((String)jiuqiOrgNumber) && StringUtils.isEmpty((String)jiuqName) && jiuqiReportType == null) continue;
            if (StringUtils.isEmpty((String)jiuqiOrgNumber)) {
                numberTips.append(i + 1).append(",");
            }
            if (StringUtils.isEmpty((String)jiuqName)) {
                nameTips.append(i + 1).append(",");
            }
            if (jiuqiReportType == null) {
                reportTypeTips.append(i + 1).append(",");
            }
            if ((mappingInfo = (EASJiuqiOrgMappingInfo)row.getUserObject()) == null) {
                mappingInfo = new EASJiuqiOrgMappingInfo();
            }
            mappingInfo.setOrgTree((OrgTreeInfo)this.orgTreeF7.getData());
            mappingInfo.setOrgUnit(((OrgStructureInfo)row.getCell("easOrgNumber").getValue()).getUnit());
            mappingInfo.setTreeNumber(((OrgTreeInfo)this.orgTreeF7.getData()).getNumber());
            mappingInfo.setOrgNumber(((OrgStructureInfo)row.getCell("easOrgNumber").getValue()).getUnit().getNumber());
            mappingInfo.setJiuqiOrgNumber(jiuqiOrgNumber);
            mappingInfo.setJiuqiOrgName((String)row.getCell("jiuqiOrgName").getValue());
            mappingInfo.setJiuqiRptType((JiuqiReportTypeEnum)((Object)row.getCell("jiuqiReportType").getValue()));
            mappingInfo.setSeq(++seq);
            saveColl.add((CoreBaseInfo)mappingInfo);
        }
        if (reportTypeTips.length() > 0 || nameTips.length() > 0 || numberTips.length() > 0) {
            String msg = EASResource.getString((String)this.resPatch, (String)"32_jiuqiOrgInfoNull");
            String detail = "";
            if (numberTips.length() > 0) {
                detail = detail + MessageFormat.format(EASResource.getString((String)this.resPatch, (String)"61_jiuqiNumNullRow"), numberTips.deleteCharAt(numberTips.length() - 1).toString()) + "\n";
            }
            if (nameTips.length() > 0) {
                detail = detail + MessageFormat.format(EASResource.getString((String)this.resPatch, (String)"nameNullRow"), nameTips.deleteCharAt(nameTips.length() - 1).toString()) + "\n";
            }
            if (reportTypeTips.length() > 0) {
                detail = detail + MessageFormat.format(EASResource.getString((String)this.resPatch, (String)"reportTypeNullRow"), reportTypeTips.deleteCharAt(reportTypeTips.length() - 1).toString()) + "\n";
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)detail, (int)1);
            SysUtil.abort();
        }
        if (saveColl.size() == 0) {
            String msg = EASResource.getString((String)this.resPatch, (String)"39_mappingNoSaveData");
            MsgBox.showConfirm2((String)msg);
            SysUtil.abort();
        }
        EASJiuqiOrgMappingFactory.getRemoteInstance().save(saveColl);
        this.deleteData(this.deleteMappingColl);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"saveSucce"));
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.showMessage();
        this.initEditData();
        this.setOprtState(STATUS_EDIT);
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTreeF7.getData();
        if (orgTreeInfo != null) {
            this.getUIContext().put("orgTreeNumber", orgTreeInfo.getNumber());
        }
    }

    private void deleteData(CoreBaseCollection coll) throws EASBizException, BOSException {
        IObjectPK[] pkArray = new IObjectPK[coll.size()];
        for (int i = 0; i < pkArray.length; ++i) {
            pkArray[i] = new ObjectUuidPK(coll.get(i).getId());
        }
        if (pkArray.length > 0) {
            EASJiuqiOrgMappingFactory.getRemoteInstance().deleteBatchData(pkArray);
        }
    }

    public boolean isRefreshParent() {
        return true;
    }

    public boolean destroyWindow() {
        if (this.verifyDataChange()) {
            int flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)this.resPatch, (String)"60_dataChange"));
            if (0 == flag) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (2 == flag) {
                SysUtil.abort();
            }
        }
        this.getUIContext().put("orgTreeNumber", null);
        this.getUIContext().put("orgTreeid", null);
        return super.destroyWindow();
    }

    private boolean verifyDataChange() {
        boolean isChange = false;
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.orgTreeF7.getData();
        if (STATUS_ADDNEW.equals(this.oprtState) && orgTreeInfo != null) {
            isChange = orgTreeInfo != null;
        } else if (STATUS_EDIT.equals(this.oprtState) && !(isChange = this.editVerifyTreeChange(orgTreeInfo))) {
            isChange = this.editVerifyTableDataChange();
        }
        return isChange || this.isRowDataChange;
    }

    private boolean editVerifyTableDataChange() {
        boolean isChange = false;
        int rowCount = this.tblOrgMapping.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblOrgMapping.getRow(i);
            String jiuqiOrgNum = (String)row.getCell("jiuqiOrgNumber").getValue();
            String jiuqiOrgName = (String)row.getCell("jiuqiOrgName").getValue();
            JiuqiReportTypeEnum jiuqiRptType = (JiuqiReportTypeEnum)((Object)row.getCell("jiuqiReportType").getValue());
            EASJiuqiOrgMappingInfo mappingInfo = (EASJiuqiOrgMappingInfo)row.getUserObject();
            if (mappingInfo != null) {
                EASJiuqiOrgMappingInfo mappingInfoTemp = this.easJiuqiOrgMappingInfoTemp.get(mappingInfo.getId());
                if (mappingInfoTemp != null) {
                    isChange = mappingInfoTemp.getJiuqiOrgNumber() != null ? !mappingInfoTemp.getJiuqiOrgNumber().equals(jiuqiOrgNum) : StringUtils.isEmpty((String)jiuqiOrgNum);
                    if (mappingInfoTemp.getJiuqiOrgName() != null) {
                        isChange = isChange || !mappingInfoTemp.getJiuqiOrgName().equals(jiuqiOrgName);
                    } else {
                        boolean bl = isChange = isChange || StringUtils.isEmpty((String)jiuqiOrgNum);
                    }
                    isChange = mappingInfoTemp.getJiuqiRptType() != null ? isChange || !mappingInfoTemp.getJiuqiRptType().equals((Object)jiuqiRptType) : isChange || jiuqiRptType != null;
                } else {
                    isChange = true;
                }
            } else {
                isChange = StringUtils.isEmpty((String)jiuqiOrgNum);
                isChange = isChange || StringUtils.isEmpty((String)jiuqiOrgNum);
                boolean bl = isChange = isChange || jiuqiRptType != null;
            }
            if (isChange) break;
        }
        return isChange;
    }

    private boolean editVerifyTreeChange(OrgTreeInfo orgTreeInfo) {
        boolean flag = true;
        try {
            String orgTreeNumber = (String)this.getUIContext().get("orgTreeNumber");
            if (orgTreeInfo != null && orgTreeNumber.equals(orgTreeInfo.getNumber())) {
                flag = false;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        int flag;
        int[] selectRowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblOrgMapping);
        if (selectRowIndex == null || selectRowIndex.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resPatch, (String)"58_selectRow"));
            SysUtil.abort();
        }
        if ((flag = MsgBox.showConfirm2((String)EASResource.getString((String)this.resPatch, (String)"57_isDelete"))) == 0) {
            for (int i = 0; i < selectRowIndex.length; ++i) {
                EASJiuqiOrgMappingInfo mappingInfoTemp;
                IRow row = this.tblOrgMapping.getRow(selectRowIndex[i]);
                row.getCell("jiuqiOrgNumber").setValue(null);
                row.getCell("jiuqiOrgName").setValue(null);
                row.getCell("jiuqiReportType").setValue(null);
                EASJiuqiOrgMappingInfo mappingInfo = (EASJiuqiOrgMappingInfo)row.getUserObject();
                if (mappingInfo == null || (mappingInfoTemp = this.easJiuqiOrgMappingInfoTemp.get(mappingInfo.getId())) == null) continue;
                this.deleteMappingColl.add((CoreBaseInfo)mappingInfo);
                this.isRowDataChange = mappingInfoTemp != null;
            }
        }
    }

    public class TreeRenderer
    implements IBasicRender {
        private Icon cbIcon;
        private SimpleTextRender simpleRender;
        private Map<String, Rectangle> iconRect = new HashMap<String, Rectangle>();

        public TreeRenderer() {
            this.cbIcon = new TreeIcon();
            this.simpleRender = new SimpleTextRender();
        }

        public void draw(Graphics graphics, Shape clip, Object value, Style cellStyle) {
            if (value == null || !(value instanceof OrgStructureInfo)) {
                return;
            }
            OrgStructureInfo orgStructureInfo = (OrgStructureInfo)value;
            int ident = orgStructureInfo.getLevel() * 8;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
            int v = orgStructureInfo.isIsLeaf() ? 0 : (orgStructureInfo.get("isExpand") == Boolean.TRUE ? 2 : (orgStructureInfo.get("isExpand") == Boolean.FALSE ? 1 : 2));
            Color color = cellStyle.getFontColor();
            graphics.setColor(color);
            int xx = x + this.cbIcon.getWidth() + 8;
            Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
            this.simpleRender.draw(graphics, (Shape)newRec, orgStructureInfo.getUnit().getNumber(), cellStyle);
            if (!orgStructureInfo.isIsLeaf()) {
                this.cbIcon.paint((Object)new Integer(v), graphics, x, y);
                this.iconRect.put(orgStructureInfo.getId().toString(), new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getHeight()));
            }
        }

        public boolean isInRect(String id, int x, int y) {
            Rectangle rectangle = this.iconRect.get(id);
            return rectangle != null && rectangle.x < x && (double)rectangle.x + rectangle.getWidth() > (double)x;
        }
    }
}

