/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqirpa.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.designer.ItemDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.RptItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.jiuqirpa.MathSymbols;
import com.kingdee.eas.fi.newrpt.jiuqirpa.client.AbstractInteRptItemMappingUI;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class InteRptItemMappingUI
extends AbstractInteRptItemMappingUI {
    private static final Logger logger = CoreUIObject.getLogger(InteRptItemMappingUI.class);
    private CoreBaseCollection deletenteRptItemMappingCollection = new CoreBaseCollection();
    protected SpreadContext sourceSpreedContainer = null;
    protected SpreadContext targetSpreedContainer = null;
    protected Map<String, String> rptItemCollection = null;
    protected Map<String, String> dataElementCollection = null;
    protected List<Cell> setStyleRang = new ArrayList<Cell>();
    protected boolean hasNoSave = false;

    protected void initTable() throws Exception {
        this.initTableCell();
        this.fillTable();
    }

    private void fillTable() throws BOSException {
        String templateMappingSoluId = this.getUIContext().get("templateMappingSoluId").toString();
    }

    private boolean isExistMapping(String sourceRptItemNum, String sourceDataElementNum, String targetRptItemNum, String targetDataElementNum) {
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            if (!this.getRptItemName("sourceRptItemNum", row, true).equals(sourceRptItemNum) || !this.getRptItemName("targetRptItemNum", row, true).equals(targetRptItemNum) || !this.getDataElementNum("sourceDataElementName", row).equals(sourceDataElementNum) || !this.getDataElementNum("targetDataElementNum", row).equals(targetDataElementNum)) continue;
            return true;
        }
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mappingTable.checkParsed();
        this.sourceTemplateSheets.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.targetTemplateSheets.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.initTemplateF7(this.sourceTemplateF7);
        this.initTemplateF7(this.targetTemplateF7);
        this.sourceSpreedContainer = this.createSpreadContextAddToPanel(this.sourceSpreedContainer, this.sourceTemplateSheets, false);
        this.targetSpreedContainer = this.createSpreadContextAddToPanel(this.targetSpreedContainer, this.targetTemplateSheets, true);
        this.addF7Listener(this.targetTemplateF7);
        this.addF7Listener(this.sourceTemplateF7);
        this.initTable();
    }

    protected void initTableCell() throws Exception {
        KDComboBox cmbPlusMinus = new KDComboBox();
        cmbPlusMinus.addItems(MathSymbols.getEnumList().toArray());
        this.mappingTable.getColumn("plusMinus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbPlusMinus));
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$name$");
        bizBoxItem.setDisplayFormat("$name$");
        bizBoxItem.setCommitFormat("$name$");
        bizBoxItem.setEditable(true);
        CslGradeManageUtil.setRptItemF7GMFilter(bizBoxItem, null);
        this.mappingTable.getColumn("sourceRptItemNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxItem));
        this.mappingTable.getColumn("targetRptItemNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxItem));
        KDComboBox cmbDataElement = new KDComboBox();
        CslClientHelper.initDataElementCombox((KDComboBox)cmbDataElement, (boolean)false, (boolean)true, (boolean)false);
        this.mappingTable.getColumn("sourceDataElementName").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.mappingTable.getColumn("targetDataElementName").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.mappingTable.getColumn("sourceRptItemName").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("targetRptItemName").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("sourceDataElementNum").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("targetDataElementNum").getStyleAttributes().setLocked(true);
        this.mappingTable.getSelectManager().setSelectMode(10);
        this.mappingTable.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                int selectRow = e.getRowIndex();
                IRow row = InteRptItemMappingUI.this.mappingTable.getRow(selectRow);
                if (e.getColIndex() == row.getCell("sourceRptItemNum").getColumnIndex()) {
                    row.getCell("sourceRptItemName").setValue((Object)InteRptItemMappingUI.this.getRptItemName("sourceRptItemNum", row, false));
                }
                if (e.getColIndex() == row.getCell("targetRptItemNum").getColumnIndex()) {
                    row.getCell("targetRptItemName").setValue((Object)InteRptItemMappingUI.this.getRptItemName("targetRptItemNum", row, false));
                }
                if (e.getColIndex() == row.getCell("sourceDataElementName").getColumnIndex()) {
                    row.getCell("sourceDataElementNum").setValue((Object)InteRptItemMappingUI.this.getDataElementNum("sourceDataElementName", row));
                }
                if (e.getColIndex() == row.getCell("targetDataElementName").getColumnIndex()) {
                    row.getCell("targetDataElementNum").setValue((Object)InteRptItemMappingUI.this.getDataElementNum("targetDataElementName", row));
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    protected String getRptItemName(String colName, IRow row, boolean NameOrNum) {
        String name = "";
        if (row.getCell(colName).getValue() != null) {
            name = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof RPTItemInfo) {
                name = ((RPTItemInfo)row.getCell(colName).getValue()).getName();
                if (NameOrNum) {
                    name = ((RPTItemInfo)row.getCell(colName).getValue()).getNumber();
                }
            }
        }
        return name;
    }

    protected String getDataElementNum(String colName, IRow row) {
        String number = null;
        if (row.getCell(colName).getValue() != null) {
            number = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof DataElementInfo) {
                number = ((DataElementInfo)row.getCell(colName).getValue()).getNumber();
            }
        }
        return number;
    }

    private void initTemplateF7(KDBizPromptBox templateF7) {
        templateF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.CSLReportTemplateQuery");
        templateF7.setEditFormat("$name$");
        templateF7.setDisplayFormat("$name$");
        templateF7.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dynaRptType", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        templateF7.setEntityViewInfo(evi);
    }

    private SpreadContext createSpreadContextAddToPanel(SpreadContext spreadContext, KDPanel sheetsPanel, boolean istargetTemplate) {
        if (spreadContext == null) {
            spreadContext = new SpreadContext();
            SpreadManager.registerRenderProvider(new DefaultItemRenderProvider());
            final ItemFormulaPanel itemFormulaPanel = new ItemFormulaPanel(spreadContext);
            spreadContext.getFacadeManager().getPromptPanel().setRightComponent((JComponent)((Object)itemFormulaPanel));
            itemFormulaPanel.setFormulaProvider(new RptItemFormulaProvider());
            spreadContext.addSheetChangeListener(new SheetChangeListener(){

                public void changed(SheetChangeEvent e) {
                    itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), 10);
                }
            });
            if (!istargetTemplate) {
                spreadContext.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(spreadContext));
            }
            UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
            ItemDisplayProvider itemDisplayProvider = new ItemDisplayProvider();
            userCellDisplayProvider.setDisplayValueProvider(itemDisplayProvider);
            spreadContext.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)userCellDisplayProvider);
            sheetsPanel.add((Component)spreadContext, (Object)"North");
        } else {
            spreadContext.setPreferredSize(new Dimension(sheetsPanel.getWidth(), sheetsPanel.getHeight()));
        }
        return spreadContext;
    }

    protected void preTemplateF7DataChange(TemplateInfo template, boolean istargetTemplate) {
        if (template != null) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("data"));
            ev.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo fileter = new FilterInfo();
            ev.setFilter(fileter);
            ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)template.getId().toString()));
            try {
                TemplateCollection c = TemplateFactory.getRemoteInstance().getTemplateCollection(ev);
                if (c != null && c.size() > 0) {
                    TemplateInfo tp = c.get(0);
                    Book book = tp.getBook();
                    if (book == null) {
                        return;
                    }
                    book.setAutoCalculate(false);
                    SpreadContext spreadContext = this.createSpreadContextAddToPanel(istargetTemplate ? this.targetSpreedContainer : this.sourceSpreedContainer, istargetTemplate ? this.targetTemplateSheets : this.sourceTemplateSheets, istargetTemplate);
                    for (int i = 0; i < book.getSheetCount(); ++i) {
                        SheetOption so = book.getSheet(i).getSheetOption();
                        so.setCellDisplayMode(0);
                    }
                    book.setAutoCalculate(false);
                    this.addBookListener(spreadContext, istargetTemplate);
                    spreadContext.setBook(book);
                    (istargetTemplate ? this.targetTemplateSheets : this.sourceTemplateSheets).invalidate();
                    spreadContext.repaint();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private void addBookListener(SpreadContext spreadContext, final boolean istargetBook) {
        spreadContext.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    InteRptItemMappingUI.this.onSheetActive(InteRptItemMappingUI.this.sourceSpreedContainer.getBook().getActiveSheet(), InteRptItemMappingUI.this.targetSpreedContainer.getBook().getActiveSheet(), istargetBook);
                }
            }
        });
    }

    protected void onSheetActive(Sheet sourceSheet, Sheet targetSheet, boolean istargetBook) {
    }

    private void addF7Listener(KDBizPromptBox templateF7) {
        templateF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDBizPromptBox templateF7 = (KDBizPromptBox)eventObj.getSource();
                boolean istargetTemplate = "targetTemplateF7".equals(templateF7.getName());
                InteRptItemMappingUI.this.preTemplateF7DataChange((TemplateInfo)eventObj.getNewValue(), istargetTemplate);
            }
        });
    }

    protected void checkSelect(List sourceItemFormulas, List targetItemFormulas) {
        if (sourceItemFormulas.size() == 0 || targetItemFormulas.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqirpa.MappingResource", (String)"10_RLCellMustHasItemFormula"));
            SysUtil.abort();
        }
        if (targetItemFormulas.size() != 1 && sourceItemFormulas.size() != targetItemFormulas.size()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqirpa.MappingResource", (String)"11_RLFormulasMustEqual"));
            SysUtil.abort();
        }
    }

    protected void preFormulaMapping() {
    }

    protected List<ItemFormula> getSelectItemFormulasBySpreadContext(SpreadContext spreedContainer, boolean setSSA) {
        return (List)this.getSelectValueOrItemFormulasBySpreadContext(spreedContainer, false, setSSA).get("itemFormulas");
    }

    protected List<Object> getSelectValueBySpreadContext(SpreadContext spreedContainer, boolean setSSA) {
        return (List)this.getSelectValueOrItemFormulasBySpreadContext(spreedContainer, true, setSSA).get("values");
    }

    private Map<String, Object> getSelectValueOrItemFormulasBySpreadContext(SpreadContext spreedContainer, boolean isValue, boolean setSSA) {
        ArrayList<ItemFormula> itemFormulas = new ArrayList<ItemFormula>();
        ArrayList jiuQiIndex = new ArrayList();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> jiuQiIndexName = new ArrayList<String>();
        Book book = spreedContainer.getBook();
        Sheet sheet = book.getActiveSheet();
        Range selectRange = sheet.getSelectionRange();
        CellBlock cellBlock = selectRange.getBlock(0);
        int startRow = cellBlock.getRow();
        int endRow = cellBlock.getRow2();
        int startCol = cellBlock.getCol();
        int endCol = cellBlock.getCol2();
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                if (!this.setStyleRang.contains(sheet.getCell(i, j, false))) {
                    this.setStyleRang.add(sheet.getCell(i, j, false));
                }
                if (isValue) {
                    String value = (String)sheet.getRange(i, j).getValue().getValue();
                    if (value == null || value.toString().trim().length() <= 0 || !this.regOk("^[a-zA-Z]+([\\s\\S]*)$", value.toString().trim())) continue;
                    values.add(value.toString().trim());
                    jiuQiIndexName.add(this.getJiuQiIndexName(sheet, i, j).trim());
                    continue;
                }
                ItemFormula rptF = (ItemFormula)sheet.getRange(i, j).getUserObject("ITEM");
                if (rptF == null || rptF.toString().trim().length() <= 0) continue;
                itemFormulas.add(rptF);
            }
        }
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("itemFormulas", itemFormulas);
        jiuQiIndex.add(values);
        jiuQiIndex.add(jiuQiIndexName);
        objects.put("values", jiuQiIndex);
        return objects;
    }

    private String getJiuQiIndexName(Sheet sheet, int row, int col) {
        String jiuQiIndexName = "";
        for (int i = col - 1; i >= 0; --i) {
            if (sheet.getRange(row, i).getValue().getValue() != null) {
                jiuQiIndexName = sheet.getRange(row, i).getValue().getValue().toString();
                jiuQiIndexName.trim();
            }
            if (this.regOk("[\u4e00-\u9fa5]", jiuQiIndexName)) break;
        }
        return jiuQiIndexName;
    }

    private boolean regOk(String pattern, String str) {
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(str);
        return matcher.find();
    }

    protected boolean selectRangIsSingleCell(SpreadContext spreedContainer) {
        Book activiBook = spreedContainer.getBook();
        Sheet sheet = activiBook.getSheet(0);
        Range selectRang = sheet.getSelectionRange();
        return selectRang.isSingleCell();
    }

    protected void saveData() throws Exception {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveData();
    }

    private void deleteData() throws EASBizException, BOSException {
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.mappingTable.getSelectManager().select(0, 0, this.mappingTable.getRowCount(), this.mappingTable.getColumnCount());
    }

    @Override
    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.mappingTable);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            IRow row = this.mappingTable.getRow(selectRows[i]);
            this.afterRemoveRow(row);
            this.mappingTable.removeRow(selectRows[i]);
        }
    }

    protected void afterRemoveRow(IRow row) {
        if (row.getUserObject() != null) {
            this.deletenteRptItemMappingCollection.add((CoreBaseInfo)row.getUserObject());
        }
    }

    @Override
    public void actionShowItemMapping_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"table", (Object)this.mappingTable);
        uiContext.put((Object)"deletenteRptItemMappingCollection", (Object)this.deletenteRptItemMappingCollection);
        int winStyle = 95;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.newrpt.jiuqirpa.client.ShowItemMappingUI", (Map)uiContext, null, OprtState.EDIT, winStyle);
        uiWindow.show();
    }

    public void onShow() throws Exception {
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
        super.onShow();
    }

    public boolean destroyWindow() {
        if (this.hasNoSaveData() && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.jiuqirpa.MappingResource", (String)"hasNoSaveData")) == 0) {
            try {
                this.saveData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.destroyWindow();
    }

    protected boolean hasNoSaveData() {
        return false;
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isAltDown()) {
                InteRptItemMappingUI.this.preFormulaMapping();
            }
        }
    }
}

