/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.mapping.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.client.CslClientHelper;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.client.designer.ItemDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.RptItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.DefaultItemRenderProvider;
import com.kingdee.eas.fi.newrpt.mapping.InteRptItemMappingCollection;
import com.kingdee.eas.fi.newrpt.mapping.InteRptItemMappingFactory;
import com.kingdee.eas.fi.newrpt.mapping.InteRptItemMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.MathSymbols;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.client.AbstractInteRptItemMappingUI;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class InteRptItemMappingUI
extends AbstractInteRptItemMappingUI {
    private static final Logger logger = CoreUIObject.getLogger(InteRptItemMappingUI.class);
    private CoreBaseCollection deletenteRptItemMappingCollection = new CoreBaseCollection();
    protected SpreadContext sourceSpreedContainer = null;
    protected SpreadContext targetSpreedContainer = null;
    protected Map<String, String> rptItemCollection = null;
    protected Map<String, DataElementInfo> dataElementCollection = new HashMap<String, DataElementInfo>();
    protected List<Cell> setStyleRang = new ArrayList<Cell>();
    private boolean hasNoSave = false;
    protected Map<String, Range> indexRangMap = new HashMap<String, Range>();

    protected void initTable() throws Exception {
        this.initTableCell();
        this.fillTable();
    }

    private void fillTable() throws BOSException {
        String templateMappingSoluId = this.getUIContext().get("templateMappingSoluId").toString();
        InteRptItemMappingCollection coll = InteRptItemMappingFactory.getRemoteInstance().getInteRptItemMappingCollection("select * where templateMappingSolu.id='" + templateMappingSoluId + "' order by targetRptItemNum desc ");
        for (int i = 0; i < coll.size(); ++i) {
            InteRptItemMappingInfo info = coll.get(i);
            this.addRowFillData(info, info.getSourceRptItemNum(), info.getSourceDataElementNum(), info.getTargetRptItemNum(), info.getTargetDataElementNum(), info.getPlusMinus());
        }
    }

    private void addRowFillData(InteRptItemMappingInfo info, String sourceRptItemNum, String sourceDataElementNum, String targetRptItemNum, String targetDataElementNum, MathSymbols mathSymbols) {
        if (this.isExistMapping(sourceRptItemNum, sourceDataElementNum, targetRptItemNum, targetDataElementNum)) {
            return;
        }
        IRow row = this.mappingTable.addRow(0);
        row.setUserObject((Object)info);
        row.getCell("sourceRptItemNum").setValue((Object)sourceRptItemNum);
        row.getCell("sourceRptItemName").setValue((Object)this.rptItemCollection.get(sourceRptItemNum));
        row.getCell("sourceDataElementNum").setValue((Object)sourceDataElementNum);
        row.getCell("sourceDataElementName").setValue((Object)this.dataElementCollection.get(sourceDataElementNum));
        row.getCell("targetRptItemNum").setValue((Object)targetRptItemNum);
        row.getCell("targetRptItemName").setValue((Object)this.rptItemCollection.get(targetRptItemNum));
        row.getCell("targetDataElementNum").setValue((Object)targetDataElementNum);
        row.getCell("targetDataElementName").setValue((Object)this.dataElementCollection.get(targetDataElementNum));
        row.getCell("plusMinus").setValue((Object)mathSymbols);
    }

    private boolean isExistMapping(String sourceRptItemNum, String sourceDataElementNum, String targetRptItemNum, String targetDataElementNum) {
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            if (!this.getRptItemNumber("sourceRptItemNum", row).equals(sourceRptItemNum) || !this.getRptItemNumber("targetRptItemNum", row).equals(targetRptItemNum) || !this.getDataElementNum("sourceDataElementName", row).equals(sourceDataElementNum) || !this.getDataElementNum("targetDataElementName", row).equals(targetDataElementNum)) continue;
            return true;
        }
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.mappingTable.checkParsed();
        this.initTemplateF7(this.sourceTemplateF7);
        this.initTemplateF7(this.targetTemplateF7);
        this.sourceSpreedContainer = this.createSpreadContextAddToPanel(this.sourceSpreedContainer, this.sourceTemplateSheets, false);
        this.targetSpreedContainer = this.createSpreadContextAddToPanel(this.targetSpreedContainer, this.targetTemplateSheets, true);
        this.addF7Listener(this.targetTemplateF7);
        this.addF7Listener(this.sourceTemplateF7);
        List list = InteRptItemMappingFactory.getRemoteInstance().getAllRptItemAndDataElement();
        this.rptItemCollection = (Map)list.get(0);
        this.initTable();
    }

    private void setDataElementColl(KDComboBox cmbDataElement) {
        int count = cmbDataElement.getItemCount();
        for (int i = 0; i < count; ++i) {
            DataElementInfo info = (DataElementInfo)cmbDataElement.getItemAt(i);
            this.dataElementCollection.put(info.getNumber(), info);
        }
    }

    private void initTableCell() throws Exception {
        KDComboBox cmbPlusMinus = new KDComboBox();
        cmbPlusMinus.addItems(MathSymbols.getEnumList().toArray());
        this.mappingTable.getColumn("plusMinus").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbPlusMinus));
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery_UnFreezed");
        bizBoxItem.setEditFormat("$number$");
        bizBoxItem.setDisplayFormat("$number$");
        bizBoxItem.setCommitFormat("$number$");
        bizBoxItem.setEditable(false);
        CslGradeManageUtil.setRptItemF7GMFilter(bizBoxItem, null);
        this.mappingTable.getColumn("sourceRptItemNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxItem));
        this.mappingTable.getColumn("targetRptItemNum").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBoxItem));
        KDComboBox cmbDataElement = new KDComboBox();
        CslClientHelper.initDataElementCombox((KDComboBox)cmbDataElement, (boolean)false, (boolean)true, (boolean)false);
        this.setDataElementColl(cmbDataElement);
        this.mappingTable.getColumn("sourceDataElementName").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.mappingTable.getColumn("targetDataElementName").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        this.mappingTable.getColumn("sourceRptItemName").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("targetRptItemName").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("sourceDataElementNum").getStyleAttributes().setLocked(true);
        this.mappingTable.getColumn("targetDataElementNum").getStyleAttributes().setLocked(true);
        this.mappingTable.getSelectManager().setSelectMode(10);
        this.mappingTable.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                String name;
                int selectRow = e.getRowIndex();
                IRow row = InteRptItemMappingUI.this.mappingTable.getRow(selectRow);
                InteRptItemMappingUI.this.hasNoSave = InteRptItemMappingUI.this.hasNoSave || (e.getOldValue() == null ? e.getValue() != null : !e.getOldValue().equals(e.getValue()));
                if (e.getColIndex() == row.getCell("sourceRptItemNum").getColumnIndex() && row.getCell("sourceRptItemNum").getValue() instanceof RPTItemInfo) {
                    name = ((RPTItemInfo)row.getCell("sourceRptItemNum").getValue()).getName();
                    row.getCell("sourceRptItemName").setValue((Object)name);
                }
                if (e.getColIndex() == row.getCell("targetRptItemNum").getColumnIndex() && row.getCell("targetRptItemNum").getValue() instanceof RPTItemInfo) {
                    name = ((RPTItemInfo)row.getCell("targetRptItemNum").getValue()).getName();
                    row.getCell("targetRptItemName").setValue((Object)name);
                }
                if (e.getColIndex() == row.getCell("sourceDataElementName").getColumnIndex()) {
                    row.getCell("sourceDataElementNum").setValue((Object)InteRptItemMappingUI.this.getDataElementNum("sourceDataElementName", row));
                }
                if (e.getColIndex() == row.getCell("targetDataElementName").getColumnIndex()) {
                    row.getCell("targetDataElementNum").setValue((Object)InteRptItemMappingUI.this.getDataElementNum("targetDataElementName", row));
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    protected String getRptItemNumber(String colName, IRow row) {
        String number = "";
        if (row.getCell(colName).getValue() != null) {
            number = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof RPTItemInfo) {
                number = ((RPTItemInfo)row.getCell(colName).getValue()).getNumber();
            }
        }
        return number;
    }

    protected String getDataElementNum(String colName, IRow row) {
        String number = null;
        if (row.getCell(colName).getValue() != null) {
            number = row.getCell(colName).getValue().toString();
            if (row.getCell(colName).getValue() instanceof DataElementInfo) {
                number = ((DataElementInfo)row.getCell(colName).getValue()).getNumber();
            }
        }
        return number;
    }

    protected void initTemplateF7(KDBizPromptBox templateF7) {
        templateF7.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.CSLReportTemplateQuery");
        templateF7.setEditFormat("$number$");
        templateF7.setDisplayFormat("$name$");
        templateF7.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("versionStatus", (Object)1, CompareType.EQUALS));
        HashSet<Integer> rptTypeFilter = new HashSet<Integer>();
        rptTypeFilter.add(3);
        rptTypeFilter.add(5);
        rptTypeFilter.add(6);
        rptTypeFilter.add(10);
        rptTypeFilter.add(11);
        rptTypeFilter.add(13);
        filter.getFilterItems().add(new FilterItemInfo("templateType", rptTypeFilter, CompareType.INCLUDE));
        evi.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("templateType");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sort.add(sorterItemInfo);
        evi.setSorter(sort);
        templateF7.setEntityViewInfo(evi);
    }

    private SpreadContext createSpreadContextAddToPanel(SpreadContext spreadContext, KDPanel sheetsPanel, boolean istargetTemplate) {
        if (spreadContext == null) {
            spreadContext = new SpreadContext();
            SpreadManager.registerRenderProvider(new DefaultItemRenderProvider());
            final ItemFormulaPanel itemFormulaPanel = new ItemFormulaPanel(spreadContext, false);
            itemFormulaPanel.setEnabled(false);
            itemFormulaPanel.setPanelVisible(false);
            spreadContext.getFacadeManager().getPromptPanel().setRightComponent((JComponent)((Object)itemFormulaPanel));
            itemFormulaPanel.setFormulaProvider(new RptItemFormulaProvider());
            spreadContext.addSheetChangeListener(new SheetChangeListener(){

                public void changed(SheetChangeEvent e) {
                    itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), 10);
                }
            });
            if (!istargetTemplate) {
                spreadContext.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(spreadContext));
            }
            UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
            ItemDisplayProvider itemDisplayProvider = new ItemDisplayProvider();
            userCellDisplayProvider.setDisplayValueProvider(itemDisplayProvider);
            spreadContext.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)userCellDisplayProvider);
            sheetsPanel.add((Component)spreadContext, (Object)"North");
            sheetsPanel.setLayout((LayoutManager)new KDLayout());
            sheetsPanel.add((Component)spreadContext, (Object)new KDLayout.Constraints(0, 0, 485, 450, 325));
        }
        return spreadContext;
    }

    protected void preTemplateF7DataChange(TemplateInfo template, boolean istargetTemplate) {
        if (template != null) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("data"));
            ev.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo fileter = new FilterInfo();
            ev.setFilter(fileter);
            ev.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)template.getId().toString()));
            try {
                TemplateCollection c = TemplateFactory.getRemoteInstance().getTemplateCollection(ev);
                if (c != null && c.size() > 0) {
                    TemplateInfo tp = c.get(0);
                    Book book = tp.getBook();
                    if (book == null) {
                        return;
                    }
                    book.setAutoCalculate(false);
                    SpreadContext spreadContext = this.createSpreadContextAddToPanel(istargetTemplate ? this.targetSpreedContainer : this.sourceSpreedContainer, istargetTemplate ? this.targetTemplateSheets : this.sourceTemplateSheets, istargetTemplate);
                    for (int i = 0; i < book.getSheetCount(); ++i) {
                        SheetOption so = book.getSheet(i).getSheetOption();
                        so.setCellDisplayMode(0);
                    }
                    book.setAutoCalculate(false);
                    this.addBookListener(spreadContext, istargetTemplate);
                    spreadContext.setBook(book);
                    (istargetTemplate ? this.targetTemplateSheets : this.sourceTemplateSheets).invalidate();
                    spreadContext.repaint();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private void addBookListener(SpreadContext spreadContext, final boolean istargetBook) {
        spreadContext.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    InteRptItemMappingUI.this.onSheetActive(InteRptItemMappingUI.this.sourceSpreedContainer.getBook().getActiveSheet(), InteRptItemMappingUI.this.targetSpreedContainer.getBook().getActiveSheet(), istargetBook);
                }
            }
        });
    }

    protected void onSheetActive(Sheet sourceSheet, Sheet targetSheet, boolean istargetBook) {
    }

    private void addF7Listener(KDBizPromptBox templateF7) {
        templateF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                KDBizPromptBox templateF7 = (KDBizPromptBox)eventObj.getSource();
                boolean istargetTemplate = "targetTemplateF7".equals(templateF7.getName());
                InteRptItemMappingUI.this.preTemplateF7DataChange((TemplateInfo)eventObj.getNewValue(), istargetTemplate);
            }
        });
    }

    protected void checkSelect(List sourceItemFormulas, List targetItemFormulas) {
        if (sourceItemFormulas.size() == 0 || targetItemFormulas.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"10_RLCellMustHasItemFormula"));
            this.setStyleRang = new ArrayList<Cell>();
            SysUtil.abort();
        }
        if (targetItemFormulas.size() != 1 && sourceItemFormulas.size() != targetItemFormulas.size()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"11_RLFormulasMustEqual"));
            this.setStyleRang = new ArrayList<Cell>();
            SysUtil.abort();
        }
    }

    protected void preFormulaMapping() {
        List<ItemFormula> sourceItemFormulas = this.getSelectItemFormulasBySpreadContext(this.sourceSpreedContainer, false);
        List<ItemFormula> targetItemFormulas = this.getSelectItemFormulasBySpreadContext(this.targetSpreedContainer, true);
        this.checkSelect(sourceItemFormulas, targetItemFormulas);
        boolean isSingCell = this.selectRangIsSingleCell(targetItemFormulas);
        for (int i = 0; i < sourceItemFormulas.size(); ++i) {
            String sourceRptItemNum = sourceItemFormulas.get(i).getItemNumber();
            String sourceDataElementNum = sourceItemFormulas.get(i).getDataElementNumber();
            int targetIndex = isSingCell ? 0 : i;
            String targetRptItemNum = targetItemFormulas.get(targetIndex).getItemNumber();
            String targetDataElementNum = targetItemFormulas.get(targetIndex).getDataElementNumber();
            this.addRowFillData(null, sourceRptItemNum, sourceDataElementNum, targetRptItemNum, targetDataElementNum, MathSymbols.plus);
        }
        if (this.setStyleRang.size() > 0) {
            for (int k = 0; k < this.setStyleRang.size(); ++k) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setBackground(Color.green);
                ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                this.setStyleRang.get(k).setSSA(ssa);
            }
            this.targetSpreedContainer.repaint();
            this.sourceSpreedContainer.repaint();
        }
        this.setStyleRang = new ArrayList<Cell>();
    }

    protected void preDynaFormulaMapping() {
    }

    protected List<ItemFormula> getSelectItemFormulasBySpreadContext(SpreadContext spreedContainer, boolean setSSA) {
        return (List)this.getSelectValueOrItemFormulasBySpreadContext(spreedContainer, false, setSSA).get("itemFormulas");
    }

    protected List<Object> getSelectValueBySpreadContext(SpreadContext spreedContainer, boolean setSSA) {
        return (List)this.getSelectValueOrItemFormulasBySpreadContext(spreedContainer, true, setSSA).get("values");
    }

    private Map<String, Object> getSelectValueOrItemFormulasBySpreadContext(SpreadContext spreedContainer, boolean isValue, boolean setSSA) {
        ArrayList<ItemFormula> itemFormulas = new ArrayList<ItemFormula>();
        ArrayList jiuQiIndex = new ArrayList();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> jiuQiIndexName = new ArrayList<String>();
        Book book = spreedContainer.getBook();
        Sheet sheet = book.getActiveSheet();
        Range selectRange = sheet.getSelectionRange();
        CellBlock cellBlock = selectRange.getBlock(0);
        int startRow = cellBlock.getRow();
        int endRow = cellBlock.getRow2();
        int startCol = cellBlock.getCol();
        int endCol = cellBlock.getCol2();
        boolean isDyna = DynamicTemplateUtility.getBasePointList((Sheet)sheet).size() > 0;
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startCol; j <= endCol; ++j) {
                if (!this.setStyleRang.contains(sheet.getCell(i, j, false))) {
                    this.setStyleRang.add(sheet.getCell(i, j, false));
                }
                if (isValue) {
                    String value = (String)sheet.getRange(i, j).getValue().getValue();
                    if (value == null || value.toString().trim().length() <= 0 || !this.regOk("^[a-zA-Z]+([\\s\\S]*)$", value.toString().trim())) continue;
                    values.add(value.toString().trim());
                    jiuQiIndexName.add(this.getJiuQiIndexName(sheet, i, j, isDyna).trim());
                    this.indexRangMap.put(value.toString().trim(), sheet.getRange(i, j));
                    continue;
                }
                ItemFormula rptF = (ItemFormula)sheet.getRange(i, j).getUserObject("ITEM");
                if (rptF == null || rptF.toString().trim().length() <= 0) continue;
                itemFormulas.add(rptF);
            }
        }
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("itemFormulas", itemFormulas);
        jiuQiIndex.add(values);
        jiuQiIndex.add(jiuQiIndexName);
        objects.put("values", jiuQiIndex);
        return objects;
    }

    private String getJiuQiIndexName(Sheet sheet, int row, int col, boolean isDyna) {
        String jiuQiIndexName = "";
        if (isDyna) {
            for (int i = row - 1; i >= 0; --i) {
                if (sheet.getRange(i, col).getValue().getValue() != null) {
                    jiuQiIndexName = sheet.getRange(row, i).getValue().getValue().toString();
                    jiuQiIndexName.trim();
                }
                if (!this.regOk("[\u4e00-\u9fa5]", jiuQiIndexName)) {
                    jiuQiIndexName = "";
                    continue;
                }
                break;
            }
        } else {
            for (int i = col - 1; i >= 0; --i) {
                if (sheet.getRange(row, i).getValue().getValue() != null) {
                    jiuQiIndexName = sheet.getRange(row, i).getValue().getValue().toString();
                    jiuQiIndexName.trim();
                }
                if (!this.regOk("[\u4e00-\u9fa5]", jiuQiIndexName)) {
                    jiuQiIndexName = "";
                    continue;
                }
                break;
            }
        }
        return jiuQiIndexName;
    }

    private boolean regOk(String pattern, String str) {
        Pattern patt = Pattern.compile(pattern);
        Matcher matcher = patt.matcher(str);
        return matcher.find();
    }

    protected boolean selectRangIsSingleCell(List<ItemFormula> targetItemFormulas) {
        return targetItemFormulas.size() == 1;
    }

    protected void saveData() throws Exception {
        CoreBaseCollection inteRptItemMappingCollection = new CoreBaseCollection();
        String templateMappingSoluId = this.getUIContext().get("templateMappingSoluId").toString();
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            InteRptItemMappingInfo mappingInfo = (InteRptItemMappingInfo)row.getUserObject();
            if (mappingInfo == null) {
                mappingInfo = new InteRptItemMappingInfo();
            }
            String sourceRptItemNum = this.getRptItemNumber("sourceRptItemNum", row);
            String sourceDataElementNum = row.getCell("sourceDataElementNum").getValue().toString();
            String targetRptItemNumber = this.getRptItemNumber("targetRptItemNum", row);
            String targetDataElementNum = row.getCell("targetDataElementNum").getValue().toString();
            MathSymbols plusMinus = (MathSymbols)((Object)row.getCell("plusMinus").getValue());
            mappingInfo.setSourceRptItemNum(sourceRptItemNum);
            mappingInfo.setSourceDataElementNum(sourceDataElementNum);
            mappingInfo.setTargetRptItemNum(targetRptItemNumber);
            mappingInfo.setTargetDataElementNum(targetDataElementNum);
            mappingInfo.setPlusMinus(plusMinus);
            TemplateMappingInfo templateMappingInfo = new TemplateMappingInfo();
            templateMappingInfo.setId(BOSUuid.read((String)templateMappingSoluId));
            mappingInfo.setTemplateMappingSolu(templateMappingInfo);
            inteRptItemMappingCollection.add((CoreBaseInfo)mappingInfo);
        }
        InteRptItemMappingFactory.getRemoteInstance().save(inteRptItemMappingCollection);
        this.deleteData();
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"saveSucce"));
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.showMessage();
        this.mappingTable.removeRows(false);
        this.fillTable();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveData();
        this.hasNoSave = false;
    }

    private void deleteData() throws EASBizException, BOSException {
        IObjectPK[] pkArray = new IObjectPK[this.deletenteRptItemMappingCollection.size()];
        for (int i = 0; i < pkArray.length; ++i) {
            pkArray[i] = new ObjectUuidPK(this.deletenteRptItemMappingCollection.get(i).getId());
        }
        if (pkArray.length > 0) {
            InteRptItemMappingFactory.getRemoteInstance().deleteBatchData(pkArray);
            this.deletenteRptItemMappingCollection = new CoreBaseCollection();
        }
    }

    @Override
    public void actionRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.mappingTable);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            IRow row = this.mappingTable.getRow(selectRows[i]);
            this.afterRemoveRow(row);
            this.mappingTable.removeRow(selectRows[i]);
        }
    }

    protected void afterRemoveRow(IRow row) {
        if (row.getUserObject() != null) {
            this.deletenteRptItemMappingCollection.add((CoreBaseInfo)row.getUserObject());
        }
    }

    @Override
    public void actionShowItemMapping_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"table", (Object)this.mappingTable);
        uiContext.put((Object)"deletenteRptItemMappingCollection", (Object)this.deletenteRptItemMappingCollection);
        uiContext.put((Object)"rptItemCollection", this.rptItemCollection);
        uiContext.put((Object)"rptItemCollection", this.rptItemCollection);
        int winStyle = 95;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.newrpt.mapping.client.ShowItemMappingUI", (Map)uiContext, null, OprtState.EDIT, winStyle);
        uiWindow.show();
    }

    public void onShow() throws Exception {
        if (this.getUIWindow() instanceof KDFrame) {
            ((KDFrame)this.getUIWindow()).setExtendedState(6);
        }
        super.onShow();
    }

    public boolean destroyWindow() {
        if ((this.hasNoSave || this.hasNoSaveData()) && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"hasNoSaveData")) == 0) {
            try {
                this.saveData();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.destroyWindow();
    }

    protected boolean hasNoSaveData() {
        if (this.deletenteRptItemMappingCollection.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.mappingTable.getRowCount(); ++i) {
            IRow row = this.mappingTable.getRow(i);
            if (row.getUserObject() != null) continue;
            return true;
        }
        return false;
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isAltDown()) {
                InteRptItemMappingUI.this.preFormulaMapping();
            }
            if (e.isControlDown()) {
                InteRptItemMappingUI.this.preDynaFormulaMapping();
            }
        }
    }
}

