/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.mapping.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.mapping.ITemplateMapping;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingCollection;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingEntryCollection;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingEntryInfo;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingFactory;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.client.AbstractTemplateMapListUI;
import com.kingdee.eas.fi.newrpt.mapping.client.OrgMappingEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class TemplateMapListUI
extends AbstractTemplateMapListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(TemplateMapListUI.class);
    public final String RESOURCE_PATH = "com.kingdee.eas.fi.newrpt.mapping.MappingResource";
    List<String> selectIdsTemp = new ArrayList<String>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.setMergeColumn();
        this.setUiStyle();
        this.refreshList();
    }

    private void setUiStyle() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.btnAddNew.setVisible(true);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnSave.setVisible(false);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                if (this.tblMain.getColumn(mergeColumnKeys[i]) == null) continue;
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    private String[] getMergeColumnKeys() {
        String[] strMergeColKeys = new String[]{"id", "name", "number", "targetOrgBound"};
        return strMergeColKeys;
    }

    private void fillTable() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("trackRecordCreator.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("trackRecordCreator.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("trackRecordCreator.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrgBound.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrgBound.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrgBound.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrgBound.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrgBound.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrgBound.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrg.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrg.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.srcOrg.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrg.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrg.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("entry.targetOrg.name"));
        viewInfo.getSorter().add(new SorterItemInfo("entry.targetOrgBound.number"));
        FilterInfo FilterInfo2 = this.getGradeSettingFilter();
        viewInfo.setFilter(FilterInfo2);
        TemplateMappingCollection templateMapcol = ((ITemplateMapping)this.getBizInterface()).getTemplateMappingCollection(viewInfo);
        if (templateMapcol != null && templateMapcol.size() > 0) {
            this.fillTable(templateMapcol);
        }
    }

    private void fillTable(TemplateMappingCollection templateMapcol) throws Exception {
        TemplateMappingInfo mapInfo = null;
        int mappingCount = templateMapcol.size();
        this.tblMain.enableRepaint(false);
        this.tblMain.removeRows();
        this.tblMain.enableRepaint(true);
        for (int i = 0; i < mappingCount; ++i) {
            mapInfo = templateMapcol.get(i);
            IRow row = null;
            if (mapInfo.getEntry() != null && mapInfo.getEntry().size() > 0) {
                TemplateMappingEntryCollection entryCol = mapInfo.getEntry();
                TemplateMappingEntryInfo entryInfo = null;
                HashMap entryMap = new HashMap();
                HashMap unitmap = new HashMap();
                HashSet<String> orgTreeSet = new HashSet<String>();
                for (int j = 0; j < entryCol.size(); ++j) {
                    entryInfo = entryCol.get(j);
                    if (orgTreeSet.contains(entryInfo.getTargetOrgBound().getId().toString())) continue;
                    ArrayList<FullOrgUnitInfo> unitList = new ArrayList<FullOrgUnitInfo>();
                    ArrayList<TemplateMappingEntryInfo> entrylist = new ArrayList<TemplateMappingEntryInfo>();
                    orgTreeSet.add(entryInfo.getTargetOrgBound().getId().toString());
                    unitList.add(entryInfo.getTargetOrg());
                    entrylist.add(entryInfo);
                    for (int t = j + 1; t < entryCol.size(); ++t) {
                        if (!entryInfo.getTargetOrgBound().getId().toString().equals(entryCol.get(t).getTargetOrgBound().getId().toString())) continue;
                        unitList.add(entryCol.get(t).getTargetOrg());
                        entrylist.add(entryCol.get(t));
                    }
                    unitmap.put(entryInfo.getTargetOrgBound().getId().toString(), unitList);
                    entryMap.put(entryInfo.getTargetOrgBound().getId().toString(), entrylist);
                }
                for (String treeset : orgTreeSet) {
                    TemplateMappingEntryInfo info = null;
                    List list = (List)entryMap.get(treeset);
                    List<TemplateMappingEntryInfo> afterList = this.sortByStructureLongNumber(list, treeset);
                    for (int j = 0; j < afterList.size(); ++j) {
                        info = afterList.get(j);
                        row = this.tblMain.addRow();
                        row.getCell("targetOrgBound").setValue((Object)info.getTargetOrgBound());
                        row.getCell("srcOrgBound").setValue((Object)info.getSrcOrgBound());
                        row.getCell("targetOrgUnit").setValue((Object)info.getTargetOrg());
                        row.getCell("srcOrgUnit").setValue((Object)info.getSrcOrg());
                        row.getCell("number").setValue((Object)mapInfo.getNumber());
                        row.getCell("name").setValue((Object)mapInfo.getName());
                        row.getCell("id").setValue((Object)mapInfo.getId().toString());
                        row.getCell("entry").setValue((Object)info.getId().toString());
                        row.getCell("trackRecordCreator").setValue((Object)mapInfo.getTrackRecordCreator());
                        row.getCell("units").setValue(unitmap.get(info.getTargetOrgBound().getId().toString()));
                    }
                }
                continue;
            }
            row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)mapInfo.getId().toString());
            row.getCell("number").setValue((Object)mapInfo.getNumber());
            row.getCell("name").setValue((Object)mapInfo.getName());
            row.getCell("trackRecordCreator").setValue((Object)mapInfo.getTrackRecordCreator());
        }
    }

    private List<TemplateMappingEntryInfo> sortByStructureLongNumber(List<TemplateMappingEntryInfo> beforeSortlist, String treeId) throws Exception {
        ArrayList<TemplateMappingEntryInfo> afterSortList = new ArrayList<TemplateMappingEntryInfo>();
        if (beforeSortlist == null || beforeSortlist.size() == 0) {
            return beforeSortlist;
        }
        HashMap<String, TemplateMappingEntryInfo> beforeSortMap = new HashMap<String, TemplateMappingEntryInfo>();
        OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[beforeSortlist.size()];
        TemplateMappingEntryInfo entryInfo = null;
        FullOrgUnitInfo tarOrgInfo = null;
        for (int i = 0; i < orgUnitInfos.length; ++i) {
            entryInfo = beforeSortlist.get(i);
            tarOrgInfo = entryInfo.getTargetOrg();
            orgUnitInfos[i] = tarOrgInfo;
            beforeSortMap.put(tarOrgInfo.getNumber(), entryInfo);
        }
        OrgStructureCollection targetOrgStructures = this.getTargetOrgUnit(treeId, orgUnitInfos);
        FullOrgUnitInfo tempOrgInfo = null;
        for (int i = 0; i < targetOrgStructures.size(); ++i) {
            tempOrgInfo = targetOrgStructures.get(i).getUnit();
            entryInfo = (TemplateMappingEntryInfo)beforeSortMap.get(tempOrgInfo.getNumber());
            if (entryInfo == null) continue;
            afterSortList.add(entryInfo);
        }
        return afterSortList;
    }

    public String getSqlIdsStrForColl(OrgUnitInfo[] OrgUnitInfos) {
        StringBuffer str = new StringBuffer();
        String id = null;
        for (int i = 0; i < OrgUnitInfos.length; ++i) {
            id = OrgUnitInfos[i].getId().toString();
            str.append("'" + id + "'");
            if (i == OrgUnitInfos.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    private OrgStructureCollection getTargetOrgUnit(String treeId, OrgUnitInfo[] orgUnitInfos) throws Exception {
        OrgStructureCollection orgStructureColl = null;
        if (treeId != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("select id,level,isLeaf,unit.name,unit.number,unit.id,tree.number,");
            builder.append("unit.isunion,parent.id where tree.id='").append(treeId).append("'");
            if (orgUnitInfos.length > 0) {
                builder.append(" and unit.id in (").append(this.getSqlIdsStrForColl(orgUnitInfos)).append(") ");
            }
            builder.append(" order by longnumber asc");
            orgStructureColl = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(builder.toString());
        }
        return orgStructureColl;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.showRptItemMappingUI();
        }
    }

    private void showRptItemMappingUI() throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        if (row.getCell("id").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"mapping_first_save"));
            SysUtil.abort();
        }
        String templateMappingSoluId = row.getCell("id").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"templateMappingSoluId", (Object)templateMappingSoluId);
        int winStyle = 95;
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.newrpt.mapping.client.InteRptItemMappingUI", (Map)uiContext, null, OprtState.EDIT, winStyle);
        uiWindow.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<ObjectUuidPK> mappingDeletePKs = new ArrayList<ObjectUuidPK>();
        if (this.confirmRemove()) {
            int i;
            for (i = selectRows.length - 1; i >= 0; --i) {
                row = this.tblMain.getRow(selectRows[i]);
                String mappingInfo = null;
                if (row.getCell("id").getValue() == null || (mappingInfo = (String)row.getCell("id").getValue()) == null) continue;
                mappingDeletePKs.add(new ObjectUuidPK(mappingInfo));
            }
            for (i = selectRows.length - 1; i >= 0; --i) {
                if (row.getCell("id").getValue() != null) continue;
                this.tblMain.removeRow(selectRows[i]);
                SysUtil.abort();
            }
        }
        if (mappingDeletePKs.size() > 0) {
            this.getBizInterface().deleteBatchData(mappingDeletePKs.toArray(new IObjectPK[mappingDeletePKs.size()]));
        }
        super.refresh(e);
    }

    private IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    @Override
    public void actionShowRptItemMappingUI_actionPerformed(ActionEvent e) throws Exception {
        this.showRptItemMappingUI();
    }

    protected void execQuery() {
        try {
            this.tblMain.removeRows();
            this.fillTable();
            if (!this.tblMain.isRefresh()) {
                this.tblMain.setRefresh(true);
            }
            this.tblMain.reLayoutAndPaint();
            this.setTableSelectRow(this.selectIdsTemp);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionMergeMap_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"mapping_select"));
            SysUtil.abort();
        }
        String mappingSoluInfoId = null;
        if (row.getCell("id").getValue() != null) {
            mappingSoluInfoId = (String)row.getCell("id").getValue();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.mapping.MappingResource", (String)"mapping_save_not_success"));
            SysUtil.abort();
        }
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)row.getCell("targetOrgBound").getValue();
        FullOrgUnitInfo[] orgUnitInfos = null;
        if (row.getCell("units").getValue() != null) {
            List unitList = (List)row.getCell("units").getValue();
            orgUnitInfos = new FullOrgUnitInfo[unitList.size()];
            for (int i = 0; i < unitList.size(); ++i) {
                orgUnitInfos[i] = (FullOrgUnitInfo)unitList.get(i);
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"mappingSoluInfoId", (Object)mappingSoluInfoId);
        uiContext.put((Object)"orgTreeInfo", (Object)orgTreeInfo);
        uiContext.put((Object)"orgUnitInfos", (Object)orgUnitInfos);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        IUIWindow window = uiFactory.create(OrgMappingEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
        this.selectIdsTemp = new ArrayList<String>();
        this.selectIdsTemp.add(mappingSoluInfoId);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuFile.remove((JMenuItem)this.menuItemAddNew);
        this.menuEdit.remove((JMenuItem)this.menuItemEdit);
        this.menuView.remove((JMenuItem)this.menuItemView);
        this.menuView.remove((JMenuItem)this.menuItemQuery);
        this.menuFile.remove((JMenuItem)this.menuItemPrint);
        this.menuFile.remove((JMenuItem)this.menuItemPrintPreview);
        this.btnView.setVisible(false);
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.newrpt.mapping.client.SoluEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TemplateMappingFactory.getRemoteInstance();
    }

    private void setTableSelectRow(List ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell("id").getValue().toString();
            if (!ids.contains(id)) continue;
            this.tblMain.getSelectManager().select(i, 0);
        }
    }

    private FilterInfo getGradeSettingFilter() {
        FilterInfo filterInfo = new FilterInfo();
        try {
            CslGradeManageUtil.filteData(filterInfo, "trackRecordCreator.id", ((Object)((Object)this)).getClass().getName(), null);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getGradeSettingFilter();
    }
}

